<?php
include "db_config.php";
include "auth.php"; // your database connection
require "smtp_config.php";
include "school_settings.php";

error_reporting(E_ALL);
ini_set('display_errors', 1);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'includes/PHPMailer/src/Exception.php';
require 'includes/PHPMailer/src/PHPMailer.php';
require 'includes/PHPMailer/src/SMTP.php';

function send_email($to, $subject, $htmlMessage, $attachmentPath = null) {
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host = 'mail.jobastech.com.ng';
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USER;
        $mail->Password = SMTP_PASS;
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->CharSet = 'UTF-8';
        $mail->Encoding = 'base64';
        $mail->isHTML(true);

        $mail->setFrom('noreply@jobastech.com.ng', 'Graceway School');
        $mail->addAddress($to);

        $mail->Subject = $subject;
        $mail->Body    = $htmlMessage;

        // ✅ Attach assignment file if provided
        if ($attachmentPath && file_exists($attachmentPath)) {
            $mail->addAttachment($attachmentPath);
        }

        $mail->send();
    } catch (Exception $e) {
        echo "❌ Email error: {$mail->ErrorInfo}";
    }
}




$title = htmlspecialchars(trim($_POST['title']));
$description = trim($_POST['description']);
$class_id = $_POST['class_id'];
$subject_id = $_POST['subject_id'];
$session = $_POST['session'];
$term = $_POST['term'];
$due_date = $_POST['due_date'];
$teacher_id = 1; // (replace with session or logged-in teacher ID)

// Select Subject
$stmt = $conn->prepare("SELECT * FROM school_subject WHERE subject_id = ?");
$stmt->bind_param("i", $subject_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$subject_name = $row['subject_name'];

$file_path = null;

if (isset($_FILES['assignment_file']) && $_FILES['assignment_file']['error'] == 0) {
    $targetDir = "uploads/homework/";
    if (!file_exists($targetDir)) mkdir($targetDir, 0777, true);
    
    $file_name = time() . "_" . basename($_FILES["assignment_file"]["name"]);
    $file_path = $targetDir . $file_name;

    if (!move_uploaded_file($_FILES["assignment_file"]["tmp_name"], $file_path)) {
        die("File upload failed.");
    }
}

// Insert into database
$stmt = $conn->prepare("INSERT INTO homework_tbl 
(title, description, file_path, class_id, subject_id, teacher_id, session, term, due_date) 
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->bind_param("sssiiisss", $title, $description, $file_path, $class_id, $subject_id, $teacher_id, $session, $term, $due_date);

if ($stmt->execute()) {
    echo "
    <div style='background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin-top: 20px; font-family: Arial, sans-serif;'>
        ✅ Homework sent successfully to parent email.
        <br><br>
        <a href='homework.php' style='color: #0c5460; text-decoration: underline; margin-right: 15px;'>Back to Home Work</a>
        <a href='index.php' style='color: #0c5460; text-decoration: underline;'>Back to Dashboard</a>
    </div>";

    // Notify parents via phone/email
    $homework_id = $stmt->insert_id;
    $query = "SELECT fatheremail, motheremail FROM student_tbl WHERE class_name = ?";
    $notify = $conn->prepare($query);
    $notify->bind_param("i", $class_id);
    $notify->execute();
    $result = $notify->get_result();

    $clean_description = trim($description);
    $final_description = !empty($clean_description) ? nl2br($clean_description) : "Check the portal for details.";

    // Build HTML message
    $message = "
    <html>
      <head>
        <style>
          body { font-family: Arial, sans-serif; color: #333; }
          .container { padding: 20px; border: 1px solid #ddd; max-width: 600px; margin: auto; background: #f9f9f9; }
          .header { text-align: center; }
          .header img { max-height: 80px; margin-bottom: 10px; }
          .content { padding: 10px 0; }
          .content h2 { color: #0056b3; }
          .footer { font-size: 12px; color: #999; text-align: center; padding-top: 20px; }
        </style>
      </head>
      <body>
        <div class='container'>
          <div class='header'>
        		<img src='". $school_logo. "' alt='School Logo' style='width:100px; height:auto; margin-bottom:10px;'>
			      <h4>" . htmlspecialchars($school_name). "</h4>
            <h2>New Homework Notification</h2>
          </div>
          <div class='content'>
            <p><strong>Subject:</strong> $subject_name</p>
            <p><strong>Title:</strong> $title</p>
            <p><strong>Submission Date:</strong> $due_date</p>
            <p><strong>Home Work:</strong><br>$final_description</p>
          </div>
          <div class='footer'>
            &copy; " . date('Y') . " JSMS. All rights reserved.
          </div>
        </div>
      </body>
    </html>
    ";

    while ($row = $result->fetch_assoc()) {
        //$phone = $row['parent_phone'];
        $father_email = trim($row['fatheremail']);
        $mother_email = trim($row['motheremail']);

        //Array to hold both emails
        $parent_emails = [];

        if (filter_var($father_email, FILTER_VALIDATE_EMAIL)) {
            $parent_emails[] = $father_email;
        }
        if (filter_var($mother_email, FILTER_VALIDATE_EMAIL)) {
            $parent_emails[] = $mother_email;
        }

        foreach ($parent_emails as $email) {
            // 🟢 Send SMS (Termii/Twilio/etc.)
        //send_sms($phone, $message); // You’ll create this function

        // 🟢 Send Email (optional)
        send_email($email, "New Homework Assigned", $message, $file_path ?: null); // You’ll create this function
        }
    }
} else {
    echo "❌ Error: " . $stmt->error;
}
?>
