<?php
include "db_config.php";
include "auth.php"; // if you track the admin or staff submitting

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $session_id = $_POST['session_id'];
    $term_id = $_POST['term_id'];
    $class_id = $_POST['class_id'];
    $attendance_date = $_POST['attendance_date'];
    $submitted_by = $admin_name ?? 'System'; // Or replace with staff ID if needed

    $students = $_POST['students'] ?? [];

    $saved = 0;
    $skipped = 0;

    foreach ($students as $std_id => $data) {
        $status = isset($data['present']) ? 'Present' : 'Absent';

        // Check if attendance already exists for this student on the given day
        $check = $conn->prepare("SELECT id FROM attendance_tbl WHERE student_id = ? AND class_id = ? AND session_id = ? AND term_id = ? AND attendance_date = ?");
        $check->bind_param("iiiss", $std_id, $class_id, $session_id, $term_id, $attendance_date);
        $check->execute();
        $check_result = $check->get_result();

        if ($check_result->num_rows == 0) {
            // Insert new attendance record
            $insert = $conn->prepare("INSERT INTO attendance_tbl (student_id, class_id, session_id, term_id, attendance_date, status, submitted_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $insert->bind_param("iiissss", $std_id, $class_id, $session_id, $term_id, $attendance_date, $status, $submitted_by);
            $insert->execute();
            $saved++;
        } else {
            $skipped++;
        }
    }

   echo "
    <div class='container mt-5'>
      <div class='alert alert-success shadow p-4 rounded'>
        <h4 class='alert-heading'>✅ Attendance Recorded</h4>
        <p>Attendance saved for <strong>$saved</strong> student(s).</p>
        <p class='mb-4'>Skipped <strong>$skipped</strong> duplicate(s).</p>
        <a href='attendance.php' class='btn btn-success me-2'>📝 Take Another Attendance</a>
        <a href='index.php' class='btn btn-outline-primary'>🏠 Back to Dashboard</a>
      </div>
    </div>
    ";
} else {
    header("Location: attendance.php");
    exit;
}
?>
