<?php 
include "db_config.php";
include "auth.php";

$teacher_id = $_SESSION['teacher_id'];
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset='utf-8'>
  <meta http-equiv='X-UA-Compatible' content='IE=edge'>
  <title>Home Work</title>
  <meta name='viewport' content='width=device-width, initial-scale=1'>
  <link rel='stylesheet' type='text/css' media='screen' href='main.css'>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
</head>
<body>


<div class="container my-5">
  <a href ="teacher_dashboard.php" style="text-decoration:none;">Dashboard</a>
  <div class="card shadow-lg">
    <div class="card-header bg-primary text-white">
      <h4 class="mb-0">Submit Homework / Assignment</h4>
    </div>
    <div class="card-body">
      <form action="submit_homework.php" method="POST" enctype="multipart/form-data">
        
        <div class="mb-3">
          <label for="title" class="form-label">Assignment Title</label>
          <input type="text" name="title" class="form-control" id="title" placeholder="Enter assignment title" required>
        </div>

        <div class="mb-3">
          <label for="description" class="form-label">Assignment Description</label>
          <textarea name="description" class="form-control" id="description" rows="4" placeholder="Type the assignment here..."></textarea>
        </div>

        <div class="mb-3">
          <label for="assignment_file" class="form-label">Attach File (PDF/DOC)</label>
          <input type="file" name="assignment_file" class="form-control" id="assignment_file" accept=".pdf,.doc,.docx">
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label for="class_id" class="form-label">Class</label>
            <select name="class_id" id="class_id" class="form-select" required>
              <option value="">Select Class</option>
              <!-- Dynamically populate -->
               <?php
              $cg_result = $conn->query("SELECT * FROM class_tbl WHERE teacher_id = $teacher_id AND status='active'");
              while ($cg = $cg_result->fetch_assoc()) {
                  echo "<option value='{$cg['c_id']}'>{$cg['class_name']}</option>";
              }
              ?>
            </select>
          </div>

          <div class="col-md-6 mb-3">
            <label for="subject_id" class="form-label">Subject</label>
            <select name="subject_id" id="subject_id" class="form-select" required>
              <option value="">Select Subject</option>
               <?php
              $cg_result = $conn->query("SELECT * FROM school_subject WHERE status='active'");
              while ($cg = $cg_result->fetch_assoc()) {
                  echo "<option value='{$cg['subject_id']}'>{$cg['subject_name']}</option>";
              }
              ?>
            </select>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label for="session_id" class="form-label">Session</label>
            <select name="session" id="session_id" class="form-select" required>
              <option value="">Select Session</option>
              <!-- Dynamically populate -->
               <?php
              $cg_result = $conn->query("SELECT * FROM session_tbl WHERE status='active'");
              while ($cg = $cg_result->fetch_assoc()) {
                  echo "<option value='{$cg['se_id']}'>{$cg['sch_session']}</option>";
              }
              ?>
            </select>
          </div>

          <div class="col-md-6 mb-3">
            <label for="term_id" class="form-label">Term</label>
            <select name="term" id="term_id" class="form-select" required>
              <option value="">Select Term</option>
              <!-- Dynamically populate -->
               <?php
              $cg_result = $conn->query("SELECT * FROM term_tbl WHERE status='active'");
              while ($cg = $cg_result->fetch_assoc()) {
                  echo "<option value='{$cg['t_id']}'>{$cg['sch_term']}</option>";
              }
              ?>
            </select>
          </div>
        </div>

        <div class="mb-4">
          <label for="due_date" class="form-label">Due Date</label>
          <input type="date" name="due_date" class="form-control" id="due_date" required>
        </div>
        <button type="submit" class="btn btn-success w-100">Send Assignment</button>
      </form>
    </div>
  </div>
</div>
<!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
  $('#classgroup_select').change(function () {
    var cg_id = $(this).val();
    if (cg_id) {
      $.ajax({
        url: 'fetch_subjects.php',
        type: 'POST',
        data: { cg_id: cg_id },
        success: function (data) {
          $('#subject_select').html(data);
        }
      });
    } else {
      $('#subject_select').html('<option value="">Select Subject</option>');
    }
  });
</script> -->
</body>

