<?php

include "db_config.php";
include "auth.php";

$teacher_id = $_SESSION['teacher_id'];

$today = date('Y-m-d');

?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<div class="container mt-5">
    <h4 class="mb-4"><a href='teacher_dashboard.php' class='btn btn-primary'>Dashboard</a> / Record Attendance</h4>
    <form action="submit_attendance.php" method="post" class="card p-4 shadow-sm">

        <div class="row mb-3">
            <div class="col-md-3">
                <label for="session" class="form-label">Session</label>
                <select name="session_id" id="session" class="form-select" required>
                    <option value="">-- Select Session --</option>
                    <?php
                    $sessions = $conn->query("SELECT se_id, sch_session FROM session_tbl WHERE status='active'");
                    while ($row = $sessions->fetch_assoc()) {
                        echo "<option value='{$row['se_id']}'>{$row['sch_session']}</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="col-md-3">
                <label for="term" class="form-label">Term</label>
                <select name="term_id" id="term" class="form-select" required>
                    <option value="">-- Select Term --</option>
                    <?php
                    $terms = $conn->query("SELECT t_id, sch_term FROM term_tbl WHERE status='active'");
                    while ($row = $terms->fetch_assoc()) {
                        echo "<option value='{$row['t_id']}'>{$row['sch_term']}</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="col-md-3">
                <label for="class_id" class="form-label">Class</label>
                <select name="class_id" id="class_id" class="form-select" required>
                    <option value="">-- Select Class --</option>
                    <?php
                    $classes = $conn->query("SELECT c_id, class_name FROM class_tbl WHERE teacher_id = $teacher_id AND status='active'");
                    while ($row = $classes->fetch_assoc()) {
                        echo "<option value='{$row['c_id']}'>{$row['class_name']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-3">
                <label for="attendance_date" class="form-label">Date</label>
                <input type="date" name="attendance_date" id="attendance_date" class="form-control" max='<?php echo $today;?>' required>
            </div>
        </div>

        

        <button type="submit" name="submit" class="btn btn-primary">Proceed to Mark Attendance</button>
    </form>
</div>
<script>
  document.getElementById("attendance_date").addEventListener("input", function () {
    const selectedDate = new Date(this.value);
    const day = selectedDate.getUTCDay(); // Sunday = 0, Saturday = 6

    if (day === 0 || day === 6) {
      alert("Please select a weekday (Monday to Friday).");
      this.value = ""; // Reset the date
    }
  });
</script>