<?php
include "db_config.php";
include "auth.php";

$sch_session = $_SESSION['sch_session'];
$session_id = $_SESSION['session_id'];
$sch_term = $_SESSION['sch_term'];
$term_id = $_SESSION['term_id'];

if (isset($_GET['school'])) {
  $school = $_GET['school'];
}

if (isset($_GET['sid'])) {
  $sid = $_GET['sid'];
}



$stdquery = mysqli_query($conn, "SELECT s.*, s.class_group as classgroup_id, s.class_name as classname_id, cg.class_group, c.class_name 
  FROM student_tbl s 
  JOIN classgroup_tbl cg ON cg.cg_id = s.class_group
  JOIN class_tbl c ON c.c_id = s.class_name 
  WHERE std_id='$sid'");

$stddata = mysqli_fetch_assoc($stdquery);
$fullname = $stddata['surname'] . " " . $stddata['firstname'] . " " . $stddata['othername'];
$classgroup = $stddata['class_group'];
$classgroup_id = $stddata['classgroup_id'];
$classname = $stddata['class_name'];
$classname_id = $stddata['classname_id'];

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>JSMS - Add Test | Exam Scores</title>
  <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
<div class="main-wrapper">
  <?php include "hrm.php";?>
	<?php include "teacher_navigation.php";?>

  <div class="page-wrapper">
    <div class="content container-fluid">
      <div class="page-header">
        <p><a href="index.php">Back to Dashboard</a></p>
        <h3 class="page-title">Add/Edit Test & Exam Scores</h3>
      </div>

      <p>Student Name: <?= htmlspecialchars($fullname) ?></p>
      <p>Class Group: <?= htmlspecialchars($classgroup) ?></p>
      <p>Class Name: <?= htmlspecialchars($classname) ?></p>

      <div class="row">
        <div class="col-12">
          <form method="POST" action="student_score.php">
            <div class="table-responsive">
              <table class="table table-bordered">
                <thead class="table-light">
                  <tr>
                    <th>S/N</th>
                    <th>Subject</th>
                    <th>Test Score /40</th>
                    <th>Exam Score /60</th>
                  </tr>
                </thead>
                <tbody>
                <?php
                $i = 1;
                $approval_status = 'pending';
                
                $subsql = "SELECT s.*, s.subject_id AS s_id, ss.subject_name FROM subject_tbl s 
                          JOIN school_subject ss ON ss.subject_id = s.subject_id 
                          WHERE school='$school' AND class_group='$classgroup_id'";
                $qres = mysqli_query($conn, $subsql);

                if (mysqli_num_rows($qres) == 0) {
                    echo "<div class='alert alert-warning'>No subjects found for this class group. Please add subjects first.</div>";
                }


                while ($subjectdata = mysqli_fetch_assoc($qres)) {
                  $subname = $subjectdata['subject_name'];
                  $sub_id = $subjectdata['s_id'];

                  $tesql = "SELECT test_score, exam_score, approval_status FROM test_exam_tbl 
                            WHERE subject_id='$sub_id' AND std_id='$sid' AND session='$session_id' AND term='$term_id'";
                  $teres = mysqli_query($conn, $tesql);
                  $tedata = mysqli_fetch_assoc($teres);

                  $testscore = $tedata['test_score'] ?? '';
                  $examscore = $tedata['exam_score'] ?? '';
                  $approval_status = $tedata['approval_status'] ?? 'pending';

                  $disabled = ($approval_status === 'approved') ? 'readonly' : '';
                  ?>
                  <tr>
                    <td><?= $i++ ?></td>
                    <td><?= htmlspecialchars($subname) ?>
                      <input type="hidden" name="subjectname[]" value="<?= htmlspecialchars($sub_id) ?>">
                    </td>
                    <td><input type="number" name="testscore[]" value="<?= htmlspecialchars($testscore) ?>" class="form-control form-control-sm" min="0" max="40" <?= $disabled ?> required></td>
                    <td><input type="number" name="examscore[]" value="<?= htmlspecialchars($examscore) ?>" class="form-control form-control-sm" min="0" max="60" <?= $disabled ?> required></td>
                  </tr>
                <?php } ?>
                </tbody>
              </table>
            </div>

            <input type="hidden" name="std_id" value="<?= $sid ?>">
            <input type="hidden" name="classgroup_id" value="<?= $classgroup_id ?>">
            <input type="hidden" name="classname_id" value="<?= $classname_id ?>">
            <input type="hidden" name="session" value="<?= $session_id ?>">
            <input type="hidden" name="term_id" value="<?= $term_id ?>">

            <div class="text-end mt-3 mb-5">
              <?php if ($approval_status !== 'approved') { ?>
                <button type="submit" name="submittestexam" class="btn btn-success">Save Test | Exam Scores</button>
              <?php } else { ?>
                <button class="btn btn-secondary" disabled>Scores Already Approved</button>
              <?php } ?>
            </div>

          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<script src="assets/js/jquery-3.5.1.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>
