<?php
include "db_config.php";
include "auth.php";

$sch_session = $_SESSION['sch_session'];
$session_id = $_SESSION['session_id'];
$sch_term = $_SESSION['sch_term'];
$term_id = $_SESSION['term_id'];

$teacher_id = $_SESSION['teacher_id'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>JSMS - Test | Exam Score</title>
  <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
</head>
<body>
<div class="main-wrapper">
      <?php include "hrm.php";?>
			<?php include "teacher_navigation.php";?>

  <div class="page-wrapper">
    <div class="content container-fluid">
      <div class="page-header">
      	<p><a href="teacher_dashboard.php">Back to Dashboard</a></p>
        <h3 class="page-title">Test | Exam Score</h3>
      </div>
      <div class="row">
        <div class="col-sm-12">
          <form method="POST" action="">
            <div class="row mb-3">
              <div class="col-md-6">
                <label>Select Class</label>
                <select name="classname" class="form-control" required>
                  <option value="">-- Select Class --</option>
                  <?php
                  $sql = "SELECT * FROM class_tbl WHERE teacher_id = $teacher_id AND status='active'";
                  $result = mysqli_query($conn, $sql);
                  while ($row = mysqli_fetch_assoc($result)) {
                    echo "<option value='{$row['c_id']}'>{$row['class_name']}</option>";
                  }
                  ?>
                </select>
              </div>
              <div class="col-md-3 mt-4">
                <button type="submit" name="submit" class="btn btn-primary">View Students</button>
              </div>
            </div>
          </form>

          <?php if (isset($_POST['submit'])) {
            $classname = $_POST['classname'];
            $query = mysqli_query($conn, "SELECT * FROM student_tbl WHERE class_name='$classname' ORDER BY surname ASC");
            if (mysqli_num_rows($query) > 0) {
          ?>
          <div class="card">
            <div class="card-body">
              <table id="example" class="table table-bordered">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $i = 1;
                  while ($row = mysqli_fetch_assoc($query)) {
                    $stdid = $row['std_id'];
                    $fullname = $row['surname'] . " " . $row['firstname'];
                    $school = $row['school'];
                    $check = mysqli_query($conn, "SELECT approval_status FROM test_exam_tbl WHERE std_id='$stdid' AND session='$session_id' AND term='$term_id' LIMIT 1");

                    $has_record = mysqli_num_rows($check) > 0;
                    $approval_status = $has_record ? mysqli_fetch_assoc($check)['approval_status'] : null;
                    ?>
                    <tr>
                      <td><?= $i++; ?></td>
                      <td><?= htmlspecialchars($fullname) ?></td>
                      <td>
                        <?php if (!$has_record): ?>
                          <a href="add_test_exam_scores.php?school=<?= $school ?>&sid=<?= $stdid ?>&session=<?= $session_id ?>&term=<?= $term_id ?>">
                            <button class="btn btn-sm btn-primary">Input Test & Exam Score</button>
                          </a>
                        <?php elseif ($approval_status === 'pending'): ?>
                          <a href="add_test_exam_scores.php?school=<?= $school ?>&sid=<?= $stdid ?>&session=<?= $session_id ?>&term=<?= $term_id ?>">
                            <button class="btn btn-sm btn-warning">Edit Test & Exam Score</button>
                          </a>
                        <?php else: ?>
                          <button class="btn btn-sm btn-secondary" disabled>Approved</button>
                        <?php endif; ?>
                      </td>
                    </tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
          <?php } else {
            echo "<div class='alert alert-warning'>No students found in selected class.</div>";
          } } ?>
        </div>
      </div>
    </div>
  </div>
</div>
<script src="assets/js/jquery-3.5.1.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="../admin/assets/js/jquery.dataTables.min.js"></script>
<script>
  $(document).ready(function () {
    $('#example').DataTable();
  });
</script>
</body>
</html>
