<?php
include "db_config.php";
include "auth.php";

?>

<!DOCTYPE html>
<html lang="en">
    

<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Dashboard</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
    	<!-- Preloader -->
	<?php include "loader_include.php"; ?>

    	<div id="network-warning" style="
	    display: none;
	    position: fixed;
	    top: 0;
	    left: 0;
	    right: 0;
	    z-index: 9999;
	    background: #ffcccc;
	    padding: 10px;
	    color: #990000;
	    font-weight: bold;
	    text-align: center;
	">
	    ⚠️ Your network is slow
	</div>

	
		<!-- Main Wrapper -->
			<?php include "hrm.php";?>
			<?php include "student_navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
			
                <div class="content container-fluid">
					<!-- Page Header -->
					<div class="page-header">
						<div class="row">
							<div class="col-sm-12">
								<h5>Welcome <?php echo ucwords($student_fullname);?>!</h5>
								<ul class="breadcrumb">
									<li class="breadcrumb-item active">Dashboard</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<!-- Overview Section -->
					<div class="row">
						
						<div class="col-xl-3 col-sm-6 col-12" href="go.html">
							<!-- <a href="allstudents.php"> -->
							<div class="card bg-one">
								<a href="homework_report.php">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-user-graduate"></i>
										</div>
										<div class="db-info" style="color: #000;">
											<h3><?php //echo $total_students;?></h3>
											<h6>Assignment</h6>
										</div>										
									</div>
								</div>
								</a>
							</div>

							<!-- </a> -->
						</div>

						

						<div class="col-xl-3 col-sm-6 col-12">
							<div class="card bg-two">
								<a href="attendance_report_new.php">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-building"></i>
										</div>
										<div class="db-info">
											<h3><?php //echo $total_class;?></h3>
											<h6>Attendance Summary</h6>
										</div>										
									</div>
								</div>
							</div>
						</div>

						<div hidden class="col-xl-3 col-sm-6 col-12">
							<div class="card bg-three">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-building"></i>
										</div>
										<div class="db-info">
											<h3><?php //echo $totalclass;?></h3>
											<h6>Attendance Summary</h6>
										</div>										
									</div>
								</div>
							</div>
						</div>

						<div hidden class="col-xl-3 col-sm-6 col-12">
							<div class="card bg-four">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-building"></i>
										</div>
										<div class="db-info">
											<h3><span>&#8358;</span><?php 
											if(isset($totalcollection)){
											//echo number_format($totalcollection);
											}
											else{
												//$totalcollection = 0;
											}
											?></h3>
											<h6>Total Collection Today</h6>
										</div>										
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- /Overview Section -->				
					
					
				</div>
				
				<!-- Footer -->
				<footer style="margin-top: 50%;">
					<p>Copyright © <?php echo date('Y');?> Jobastech.</p>					
				</footer>
				<!-- /Footer -->

			</div>
			<!-- /Page Wrapper -->

			
		
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
		<script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Chart JS -->
		<script src="assets/plugins/apexchart/apexcharts.min.js"></script>
		<script src="assets/plugins/apexchart/chart-data.js"></script>
		
		<!-- Custom JS -->
		<script  src="assets/js/script.js"></script>
		
		<script>
    async function checkNetworkSpeed() {
        const startTime = Date.now();
        console.log("Network check started...");

        try {
            const response = await fetch("ping.php?rand=" + Math.random(), {
                method: "GET",
                cache: "no-store"
            });
            const endTime = Date.now();
            const duration = endTime - startTime;

            console.log("Ping duration: " + duration + "ms");

            if (duration > 2000) { // Show warning if > 2 seconds
                const warningBox = document.getElementById('network-warning');
                warningBox.innerText = "⚠️ Your network is slow (" + duration + "ms)";
                warningBox.style.display = "block";

                fetch("log_speed.php?duration=" + duration);
            }
        } catch (e) {
            console.error("Error checking network speed:", e);
            const warningBox = document.getElementById('network-warning');
            warningBox.innerText = "⚠️ Unable to check your network speed. You may have a poor connection.";
            warningBox.style.display = "block";
        }
    }

    window.onload = checkNetworkSpeed;
</script>



    </body>

</html>