<?php
include "db_config.php";
include "auth.php"; // track admin or staff submitting

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $session_id = $_POST['session_id'];
    $term_id = $_POST['term_id'];
    $class_id = $_POST['class_id'];
    $attendance_date = $_POST['attendance_date'];
    $submitted_by = $admin_name ?? 'System'; // Or replace with staff ID if needed

    $isHoliday = isset($_POST['holiday']) ? 1 : 0;
    $students = $_POST['students'] ?? [];

    if ($isHoliday) {
        // Fetch all active students in the class
        $stmt = $conn->prepare("SELECT std_id FROM student_tbl WHERE class_name = ? AND status = 'active'");
        $stmt->bind_param("i", $class_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $studentsInClass = $result->fetch_all(MYSQLI_ASSOC);

        $saved = 0;
        $skipped = 0;

        foreach ($studentsInClass as $row) {
            $std_id = $row['std_id'];

            // Check if attendance already exists for this student on this date
            $check = $conn->prepare("SELECT id FROM attendance_tbl 
                                     WHERE student_id = ? AND class_id = ? 
                                     AND session_id = ? AND term_id = ? 
                                     AND attendance_date = ?");
            $check->bind_param("iiiss", $std_id, $class_id, $session_id, $term_id, $attendance_date);
            $check->execute();
            $check_result = $check->get_result();

            if ($check_result->num_rows == 0) {
                // Insert holiday record for each student
                $insert = $conn->prepare("INSERT INTO attendance_tbl 
                    (student_id, class_id, session_id, term_id, attendance_date, status, submitted_by) 
                    VALUES (?, ?, ?, ?, ?, 'Holiday', ?)");
                $insert->bind_param("iiisss", $std_id, $class_id, $session_id, $term_id, $attendance_date, $submitted_by);
                $insert->execute();
                $saved++;
            } else {
                $skipped++;
            }
        }

        echo "
        <div class='container mt-5'>
          <div class='alert alert-info shadow p-4 rounded'>
            <h4 class='alert-heading'>📅 Holiday Marked</h4>
            <p>Holiday recorded for <strong>$saved</strong> student(s).</p>
            <p class='mb-4'>Skipped <strong>$skipped</strong> duplicate(s).</p>
            <a href='attendance.php' class='btn btn-success me-2'>📝 Take Another Attendance</a>
            <a href='teacher_dashboard.php' class='btn btn-outline-primary'>🏠 Back to Dashboard</a>
          </div>
        </div>
        ";
    } else {
        // Normal student attendance saving
        $saved = 0;
        $skipped = 0;

        foreach ($students as $std_id => $data) {
            $status = isset($data['present']) ? 'Present' : 'Absent';

            // Check if attendance already exists for this student on the given day
            $check = $conn->prepare("SELECT id FROM attendance_tbl 
                                     WHERE student_id = ? AND class_id = ? 
                                     AND session_id = ? AND term_id = ? 
                                     AND attendance_date = ?");
            $check->bind_param("iiiss", $std_id, $class_id, $session_id, $term_id, $attendance_date);
            $check->execute();
            $check_result = $check->get_result();

            if ($check_result->num_rows == 0) {
                // Insert new attendance record
                $insert = $conn->prepare("INSERT INTO attendance_tbl 
                    (student_id, class_id, session_id, term_id, attendance_date, status, submitted_by) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)");
                $insert->bind_param("iiissss", $std_id, $class_id, $session_id, $term_id, $attendance_date, $status, $submitted_by);
                $insert->execute();
                $saved++;
            } else {
                $skipped++;
            }
        }

        echo "
        <div class='container mt-5'>
          <div class='alert alert-success shadow p-4 rounded'>
            <h4 class='alert-heading'>✅ Attendance Recorded</h4>
            <p>Attendance saved for <strong>$saved</strong> student(s).</p>
            <p class='mb-4'>Skipped <strong>$skipped</strong> duplicate(s).</p>
            <a href='attendance.php' class='btn btn-success me-2'>📝 Take Another Attendance</a>
            <a href='teacher_dashboard.php' class='btn btn-outline-primary'>🏠 Back to Dashboard</a>
          </div>
        </div>
        ";
    }
} else {
    header("Location: attendance.php");
    exit;
}
?>
