<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Function to sanitize input
function test_input($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

if (isset($_POST['submit'])) {
    // Connect to main database
    $connection = mysqli_connect("localhost","momcscom_jobastech","qofP~6VSYk~T6d*h","momcscom_school_mgmt_db");
    if (!$connection) {
        $msg = "Unable to connect to main school database.";
        $alerttype = "danger";
    } else {
        $schoolcode = test_input($_POST['schoolcode']);

        // Check if school exists
        $sql_schcode = "SELECT * FROM school_settings_tbl WHERE school_code = ?";
        $stmt = $connection->prepare($sql_schcode);
        $stmt->bind_param('s', $schoolcode);
        $stmt->execute();
        $school_result = $stmt->get_result();

        if ($school_result->num_rows === 1) {
            $school_data = $school_result->fetch_assoc();
            $school_db_name = $school_data['school_db_name'];

            // Store school info in session
            $_SESSION['school_code']    = $school_data['school_code'];
            $_SESSION['school_name']    = $school_data['school_name'];
            $_SESSION['school_db_name'] = $school_data['school_db_name'];
            $_SESSION['school_address'] = $school_data['school_address'];
            $_SESSION['school_email']   = $school_data['school_email'];
            $_SESSION['school_phone']   = $school_data['school_phone'];
            $_SESSION['school_website'] = $school_data['school_website'];
            $_SESSION['school_logo']    = $school_data['school_logo'];
            $_SESSION['motto']          = $school_data['motto'];

            // Connect to that specific school's database
            $conn = mysqli_connect("localhost","momcscom_jobastech","qofP~6VSYk~T6d*h", $school_db_name);
            if (!$conn) {
                $msg = "Unable to connect to selected school database.";
                $alerttype = "danger";
            } else {
                $username = test_input($_POST['username']); // student_id
                $pswd = test_input($_POST['password']);     // surname

                // Check student record
                $sql = "SELECT * FROM student_tbl WHERE student_id = ? LIMIT 1";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("s", $username);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows === 1) {
                    $row = $result->fetch_assoc();
                   
                    // Compare password with surname
                    if (strcasecmp($pswd, $row['surname']) == 0) {
                        // Login success
                        $_SESSION['std_id'] = $row['std_id'];
                        $_SESSION['student_id'] = $row['student_id'];
                        $_SESSION['username']   = $row['student_id'];
                        $_SESSION['password']    = $row['surname'];
                        $_SESSION['class_name'] = $row['class_name'];
                        $_SESSION['role']       = "student";

                        header("Location: student_dashboard.php");
                        exit();
                    } else {
                        $msg = "Invalid password.";
                        $alerttype = "danger";
                    }
                } else {
                    $msg = "Student record not found.";
                    $alerttype = "danger";
                }
            }
        } else {
            $msg = "Invalid school code.";
            $alerttype = "danger";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>SMS - Login</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">

		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
	
		<!-- Main Wrapper -->
        <div class="main-wrapper login-body">
            <div class="login-wrapper">
            	<div class="container">
                	<div class="loginbox">
                    	<div class="login-left">
                    		<h4 style="text-align: center; color: #fff;font-weight:bold;">JOBASTECH SCHOOL MGT. SYSTEM(JSMS V.1.0)</h4>

                    		<h6 style="margin-top: 40px; color: white;">Copyright &copy Jobastech <?php  echo date('Y');?></h6>
							<!-- <img class="img-fluid" src="assets/img/logo-white.png" alt="Logo"> -->
                        </div>
                        <div class="login-right">
							<div class="login-right-wrap">
								<h1>Login</h1>
                             
								<p class="account-subtitle">Access to your dashboard</p>
								<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>
								
								<!-- Form -->
								<form method="POST" action="login.php">
									<div class="form-group">
										<input class="form-control" name="schoolcode" type="text" placeholder="Enter School Code">
									</div>
                                    <div class="form-group">
										<input class="form-control" name="username" type="text" placeholder="Enter Username">
									</div>
									<div class="form-group">
										<input class="form-control" name="password" type="password" placeholder="Password">
									</div>
									<div class="form-group">
										<button class="btn btn-primary btn-block" name="submit" type="submit">Login</button>
									</div>
								</form>
								<!-- /Form -->
								
								<!--<div class="text-center forgotpass"><a href="forgot-password.php">Forgot Password?</a></div>-->
								<!-- <div class="login-or">
									<span class="or-line"></span>
									<span class="span-or">or</span>
								</div>
								  
								<!-- Social Login -->
								<!-- <div class="social-login">
									<span>Login with</span>
									<a href="#" class="facebook"><i class="fab fa-facebook-f"></i></a><a href="#" class="google"><i class="fab fa-google"></i></a>
								</div> --> 
								<!-- /Social Login -->
								
								<!-- <div class="text-center dont-have">Don’t have an account? <a href="register.html">Register</a></div> -->
							</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
		
    </body>


</html>