<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


require_once 'dompdf/autoload.inc.php';
use Dompdf\Dompdf;
include "db_config.php";
$html = "<h3>Homework Report</h3><table border='1' cellpadding='5' cellspacing='0'>
<tr><th>Title</th><th>Description</th><th>Class</th><th>Subject</th><th>Session</th><th>Term</th><th>Due Date</th><th>Teacher</th><th>Date Sent</th></tr>";
$sql = "SELECT h.*, c.class_name, s.subject_name, se.sch_session, tm.sch_term, te.teacher_name
        FROM homework_tbl h
        LEFT JOIN class_tbl c ON h.class_id = c.c_id
        LEFT JOIN school_subject s ON h.subject_id = s.subject_id
        LEFT JOIN session_tbl se ON h.session = se.se_id
        LEFT JOIN term_tbl tm ON h.term = tm.t_id
        LEFT JOIN teacher_tbl te ON h.teacher_id = te.t_id
        ORDER BY h.created_at DESC";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $html .= "<tr>
        <td>{$row['title']}</td><td>{$row['description']}</td><td>{$row['class_name']}</td><td>{$row['subject_name']}</td>
        <td>{$row['sch_session']}</td><td>{$row['sch_term']}</td><td>{$row['due_date']}</td><td>{$row['teacher_name']}</td><td>{$row['created_at']}</td>
    </tr>";
}
$html .= "</table>";
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream("homework_report.pdf", array("Attachment" => 1));
?>
