<?php
session_start();
include "db_config.php";  // Ensure $conn is available


// Redirect if no logged-in user
if (!isset($_SESSION["username"]) || !isset($_SESSION["password"])) {
    header("Location: login.php");
    exit();
}


$username = $_SESSION['username'];
$password = $_SESSION['password'];

// Prepare statement to avoid SQL injection
$sql = "SELECT * FROM student_tbl WHERE student_id = ? AND surname = ?";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Prepare failed: " . htmlspecialchars($conn->error));
}

$stmt->bind_param("ss", $username, $password);

if (!$stmt->execute()) {
    die("Execute failed: " . htmlspecialchars($stmt->error));
}

$result = $stmt->get_result();
$row = $result->fetch_assoc();

if (!$row) {
    // No matching user found, logout or redirect to login
    session_destroy();
    header("Location: login.php");
    exit();
}

$student_fullname = $row['surname']. " ". $row['firstname']. " ". $row['othername'];
$std_id = $row['std_id'];

// Fetch active session
$sessionsql = "SELECT * FROM session_tbl WHERE status= 'active' LIMIT 1";
$sessionresult = $conn->query($sessionsql);
if ($sessionresult && $sessionresult->num_rows > 0) {
    $sessionrow = $sessionresult->fetch_assoc();
    $_SESSION['sch_session'] = $sessionrow['sch_session'];
    $_SESSION['session_id'] = $sessionrow['se_id'];
} else {
    // Handle missing active session if necessary
    $_SESSION['sch_session'] = null;
    $_SESSION['session_id'] = null;
}

// Fetch active term
$termsql = "SELECT * FROM term_tbl WHERE status= 'active' LIMIT 1";
$termresult = $conn->query($termsql);
if ($termresult && $termresult->num_rows > 0) {
    $termrow = $termresult->fetch_assoc();
    $_SESSION['sch_term'] = $termrow['sch_term'];
    $_SESSION['term_id'] = $termrow['t_id'];
} else {
    // Handle missing active term if necessary
    $_SESSION['sch_term'] = null;
    $_SESSION['term_id'] = null;
}
?>
