<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "db_config.php";
include "auth.php";

$parent_phone = $_SESSION['parentusername'];

// Fetch student ID from GET
$student_id = $_GET['sid'] ?? null;
if (!$student_id) {
    die("No student selected.");
}

// Validate student belongs to this parent
$check = $conn->prepare("SELECT * FROM student_tbl WHERE std_id = ? AND (fathernumber = ? OR mothernumber = ?)");
$check->bind_param("iss", $student_id, $parent_phone, $parent_phone);
$check->execute();
$res = $check->get_result();
if ($res->num_rows === 0) {
    die("Unauthorized access.");
}
$student = $res->fetch_assoc();

// Optional: fetch sessions and terms
$sessions = $conn->query("SELECT se_id, sch_session FROM session_tbl WHERE status='active'");
$terms = $conn->query("SELECT t_id, sch_term FROM term_tbl WHERE status='active'");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Student Info - <?= $student['surname'] . " " . $student['firstname']; ?></title>
    <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
</head>
<body>

<div class="container mt-4">
    <h4>Student Dashboard: <?= $student['surname'] . " " . $student['firstname']; ?></h4>

    <!-- Tab Menu -->
    <ul class="nav nav-tabs mt-4" id="parentTabs" role="tablist">
        <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#balanceTab">Balance</a></li>
        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#attendanceTab">Attendance</a></li>
        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#homeworkTab">Homework</a></li>
        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#reportTab">Report Card</a></li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content mt-3">
        <!-- Balance Tab -->
        <div class="tab-pane fade show active" id="balanceTab">
            <?php
            $bal_q = mysqli_query($conn, "SELECT SUM(credit) AS paid FROM payment_tbl WHERE student_id = $student_id AND trans_type=15");
            $paid = mysqli_fetch_assoc($bal_q)['paid'] ?? 0;
            echo "<h5>Current Balance: ₦" . number_format($paid, 2) . "</h5>";
            ?>
        </div>

        <!-- Add inside student_info.php inside Attendance tab -->
        <div class="tab-pane fade" id="attendanceTab">
            <form method="GET" class="mb-3">
                <input type="hidden" name="sid" value="<?= $student_id ?>">
                <div class="row">
                    <div class="col-md-4">
                        <label>Session</label>
                        <select name="session_id" class="form-control" required>
                            <option value="">Select Session</option>
                            <?php while ($row = $sessions->fetch_assoc()) {
                                $selected = ($_GET['session_id'] ?? '') == $row['se_id'] ? 'selected' : '';
                                echo "<option value='{$row['se_id']}' $selected>{$row['sch_session']}</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label>Term</label>
                        <select name="term_id" class="form-control" required>
                            <option value="">Select Term</option>
                            <?php while ($row = $terms->fetch_assoc()) {
                                $selected = ($_GET['term_id'] ?? '') == $row['t_id'] ? 'selected' : '';
                                echo "<option value='{$row['t_id']}' $selected>{$row['sch_term']}</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label>Date (Optional)</label>
                        <input type="date" name="attendance_date" class="form-control" value="<?= $_GET['attendance_date'] ?? '' ?>">
                    </div>
                    <div class="col-md-1 d-flex align-items-end">
                        <button class="btn btn-primary w-100">View</button>
                    </div>
                </div>
            </form>

            <?php
            if (isset($_GET['session_id'], $_GET['term_id'])) {
                $session_id = $_GET['session_id'];
                $term_id = $_GET['term_id'];
                $attendance_date = $_GET['attendance_date'] ?? null;

                $sql = "SELECT attendance_date, status FROM attendance_tbl 
                        WHERE session_id = ? AND term_id = ? AND student_id = ?";
                if ($attendance_date) {
                    $sql .= " AND attendance_date = ?";
                }

                $stmt = $conn->prepare($sql);
                if ($attendance_date) {
                    $stmt->bind_param("iiis", $session_id, $term_id, $student_id, $attendance_date);
                } else {
                    $stmt->bind_param("iii", $session_id, $term_id, $student_id);
                }
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows > 0) {
                    echo "<div class='table-responsive'><table class='table table-bordered'>
                          <thead><tr><th>#</th><th>Status</th><th>Date</th></tr></thead><tbody>";
                    $i = 1;
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr><td>$i</td><td>{$row['status']}</td><td>{$row['attendance_date']}</td></tr>";
                        $i++;
                    }
                    echo "</tbody></table></div>";
                } else {
                    echo "<div class='alert alert-warning'>No attendance record found.</div>";
                }
            }
            ?>
        </div>

        <!-- Homework Tab -->
        <div class="tab-pane fade" id="homeworkTab">
            <form method="GET" class="mb-3">
                <input type="hidden" name="sid" value="<?= $student_id ?>">
                <div class="row">
                    <div class="col-md-5">
                        <label>Session</label>
                        <select name="hw_session" class="form-control">
                            <?php mysqli_data_seek($sessions, 0); // rewind
                            while ($row = mysqli_fetch_assoc($sessions)) {
                                echo "<option value='{$row['sch_session']}'>{$row['sch_session']}</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label>Term</label>
                        <select name="hw_term" class="form-control">
                            <?php foreach ($terms as $term) {
                                echo "<option value='$term'>$term</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button class="btn btn-primary w-100">View</button>
                    </div>
                </div>
            </form>
            <?php
            if (isset($_GET['hw_session'], $_GET['hw_term'])) {
                $sess = $_GET['hw_session'];
                $term = $_GET['hw_term'];
                // Homework joined by class group
                $classgroup_id = $student['class_group'];
                $hw = mysqli_query($conn, "SELECT * FROM homework_tbl WHERE classgroup_id = $classgroup_id AND session = '$sess' AND term = '$term'");
                echo "<ul>";
                while ($h = mysqli_fetch_assoc($hw)) {
                    echo "<li><strong>{$h['subject']}</strong>: {$h['description']}</li>";
                }
                echo "</ul>";
            }
            ?>
        </div>

        <!-- Report Card Tab -->
        <div class="tab-pane fade" id="reportTab">
            <form method="GET" class="mb-3">
                <input type="hidden" name="sid" value="<?= $student_id ?>">
                <div class="row">
                    <div class="col-md-5">
                        <label>Session</label>
                        <select name="rep_session" class="form-control">
                            <?php mysqli_data_seek($sessions, 0);
                            while ($row = mysqli_fetch_assoc($sessions)) {
                                echo "<option value='{$row['session_name']}'>{$row['session_name']}</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label>Term</label>
                        <select name="rep_term" class="form-control">
                            <?php foreach ($terms as $term) {
                                echo "<option value='$term'>$term</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button class="btn btn-primary w-100">View</button>
                    </div>
                </div>
            </form>
            <?php
            if (isset($_GET['rep_session'], $_GET['rep_term'])) {
                $sess = $_GET['rep_session'];
                $term = $_GET['rep_term'];
                echo "<p><a href='reportcard.php?sid=$student_id&session=$sess&term=$term' target='_blank' class='btn btn-success'>View Report Card</a></p>";
            }
            ?>
        </div>
    </div>
</div>

<script src="assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

<!-- jQuery (optional if needed elsewhere) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Bootstrap 5 Bundle JS (includes Popper) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

</body>
</html>
