<?php
include  "db_config.php";
include "auth.php";


?>

<!DOCTYPE html>
<html lang="en">
    

<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Result Checker</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
	
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			
			<?php include "parentheader.php"?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
			
                <div class="content container-fluid">
					<!-- Page Header -->
					<div class="page-header">
						<div class="row">
							<div class="col-sm-12">
								<h3 class="page-title">Welcome <?php echo ucfirst($parent_name);?>!</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item active">Dashboard</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<!-- Overview Section -->
					<div class="row">
						<div class="col-xl-3 col-sm-6 col-12">
							<div class="card bg-one">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-user-graduate"></i>
										</div>
										<div class="db-info">
											<?php 
											$stdnum = mysqli_query($conn,"SELECT * FROM `student_tbl` WHERE student_id IN ('$std1','$std2','$std3','$std4','$std5') ORDER BY surname") or die(mysqli_error($conn));
													$numstudent = mysqli_num_rows($stdnum); ?>
											<h3><?php echo $numstudent;?></h3>
											<h6>Students</h6>
										</div>										
									</div>
								</div>
							</div>
						</div>

						<!-- <div class="col-xl-3 col-sm-6 col-12">
							<div class="card bg-two">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-crown"></i>
										</div>
										<div class="db-info">
											<h3>50+</h3>
											<h6>Awards</h6>
										</div>										
									</div>
								</div>
							</div>
						</div>

						<div class="col-xl-3 col-sm-6 col-12">
							<div class="card bg-three">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-building"></i>
										</div>
										<div class="db-info">
											<h3>30+</h3>
											<h6>Department</h6>
										</div>										
									</div>
								</div>
							</div>
						</div>

						<div class="col-xl-3 col-sm-6 col-12">
							<div class="card bg-four">
								<div class="card-body">
									<div class="db-widgets d-flex justify-content-between align-items-center">
										<div class="db-icon">
											<i class="fas fa-file-invoice-dollar"></i>
										</div>
										<div class="db-info">
											<h3>$505</h3>
											<h6>Revenue</h6>
										</div>										
									</div>
								</div>
							</div>
						</div> -->
					</div>
					<!-- /Overview Section -->				
					
					<div class="row">
						<div class="col-md-12 d-flex">						
							<!-- Star Students -->
							<div class="card flex-fill">
								<div class="card-header">
									<h5 class="card-title">Students List</h5>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table class="table table-hover table-center">
											<thead class="thead-light">
												<tr>
													<th>Student ID</th>
													<th>Full Name</th>
													<th class="text-center">Class</th>
													<th class="text-center">Action</th>
												</tr>
											</thead>
											<tbody>
												<?php 
													$stdquery = mysqli_query($conn,"SELECT * FROM `student_tbl` WHERE student_id IN ('$std1','$std2','$std3','$std4','$std5') ORDER BY surname") or die(mysqli_error($conn));
													while($stdres = mysqli_fetch_assoc($stdquery)){
														$stdid  = $stdres['std_id'];
														$appnumber = $stdres['student_id'];
														$firstname = $stdres['firstname'];
														$surname = $stdres['surname'];
														$fullname= $surname." ". $firstname;
														$class = $stdres['class_name'];
												?>
												<tr>
													<td class="text-nowrap">
														<div><?php echo $appnumber;?></div>
													</td>
													<td class="text-nowrap"><?php echo $fullname;?></td>
													<td class="text-center"><?php echo $class;?></td>
													<td class="text-center"><a href="reportcardprocessing.php?sid=<?php echo $stdid;?>" class="btn btn-sm bg-success-light mr-2">
															</i>Process Result
															</a></td>
												</tr>
											<?php }?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<!-- /Star Students -->							
						</div>
					</div>

					
				</div>
				
				<!-- Footer -->
				<footer>
					<p>Copyright © <?php echo date("Y"); ?> Jobastech.</p>					
				</footer>
				<!-- /Footer -->

			</div>
			<!-- /Page Wrapper -->

			
		
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
		<script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Chart JS -->
		<script src="assets/plugins/apexchart/apexcharts.min.js"></script>
		<script src="assets/plugins/apexchart/chart-data.js"></script>
		
		<!-- Custom JS -->
		<script  src="assets/js/script.js"></script>
		
    </body>


</html>