<?php
include "db_config.php";
include "auth.php";

$parent_phone = $_SESSION['parentusername'];

// Fetch student ID from GET
$student_id = $_GET['sid'] ?? null;
if (!$student_id) {
    die("No student selected.");
}

// Validate student belongs to this parent
$check = $conn->prepare("SELECT * FROM student_tbl WHERE std_id = ? AND (fathernumber = ? OR mothernumber = ?)");
$check->bind_param("iss", $student_id, $parent_phone, $parent_phone);
$check->execute();
$res = $check->get_result();
if ($res->num_rows === 0) {
    die("Unauthorized access.");
}
$student = $res->fetch_assoc();

// Optional: fetch sessions and terms
$sessions = mysqli_query($conn, "SELECT DISTINCT session_name FROM session_tbl ORDER BY session_name DESC");
$terms = ["First Term", "Second Term", "Third Term"];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Student Info - <?= $student['surname'] . " " . $student['firstname']; ?></title>
    <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
</head>
<body>

<div class="container mt-4">
    <h4>Student Dashboard: <?= $student['surname'] . " " . $student['firstname']; ?></h4>

    <!-- Tab Menu -->
    <ul class="nav nav-tabs mt-4" id="parentTabs" role="tablist">
        <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#balanceTab">Balance</a></li>
        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#attendanceTab">Attendance</a></li>
        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#homeworkTab">Homework</a></li>
        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#reportTab">Report Card</a></li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content mt-3">
        <!-- Balance Tab -->
        <div class="tab-pane fade show active" id="balanceTab">
            <?php
            $bal_q = mysqli_query($conn, "SELECT SUM(amount) AS paid FROM payments_tbl WHERE student_id = $student_id");
            $paid = mysqli_fetch_assoc($bal_q)['paid'] ?? 0;
            echo "<h5>Current Balance: ₦" . number_format($paid, 2) . "</h5>";
            ?>
        </div>

        <!-- Attendance Tab -->
        <div class="tab-pane fade" id="attendanceTab">
            <form method="GET" class="mb-3">
                <input type="hidden" name="sid" value="<?= $student_id ?>">
                <div class="row">
                    <div class="col-md-5">
                        <label>Session</label>
                        <select name="att_session" class="form-control">
                            <?php while ($row = mysqli_fetch_assoc($sessions)) {
                                echo "<option value='{$row['session_name']}'>{$row['session_name']}</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label>Term</label>
                        <select name="att_term" class="form-control">
                            <?php foreach ($terms as $term) {
                                echo "<option value='$term'>$term</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button class="btn btn-primary w-100">View</button>
                    </div>
                </div>
            </form>
            <?php
            if (isset($_GET['att_session'], $_GET['att_term'])) {
                $sess = $_GET['att_session'];
                $term = $_GET['att_term'];
                $att = mysqli_query($conn, "SELECT * FROM attendance_tbl WHERE student_id = $student_id AND session = '$sess' AND term = '$term'");
                echo "<ul>";
                while ($a = mysqli_fetch_assoc($att)) {
                    echo "<li>" . $a['date'] . " - " . $a['status'] . "</li>";
                }
                echo "</ul>";
            }
            ?>
        </div>

        <!-- Homework Tab -->
        <div class="tab-pane fade" id="homeworkTab">
            <form method="GET" class="mb-3">
                <input type="hidden" name="sid" value="<?= $student_id ?>">
                <div class="row">
                    <div class="col-md-5">
                        <label>Session</label>
                        <select name="hw_session" class="form-control">
                            <?php mysqli_data_seek($sessions, 0); // rewind
                            while ($row = mysqli_fetch_assoc($sessions)) {
                                echo "<option value='{$row['session_name']}'>{$row['session_name']}</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label>Term</label>
                        <select name="hw_term" class="form-control">
                            <?php foreach ($terms as $term) {
                                echo "<option value='$term'>$term</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button class="btn btn-primary w-100">View</button>
                    </div>
                </div>
            </form>
            <?php
            if (isset($_GET['hw_session'], $_GET['hw_term'])) {
                $sess = $_GET['hw_session'];
                $term = $_GET['hw_term'];
                // Homework joined by class group
                $classgroup_id = $student['class_group'];
                $hw = mysqli_query($conn, "SELECT * FROM homework_tbl WHERE classgroup_id = $classgroup_id AND session = '$sess' AND term = '$term'");
                echo "<ul>";
                while ($h = mysqli_fetch_assoc($hw)) {
                    echo "<li><strong>{$h['subject']}</strong>: {$h['description']}</li>";
                }
                echo "</ul>";
            }
            ?>
        </div>

        <!-- Report Card Tab -->
        <div class="tab-pane fade" id="reportTab">
            <form method="GET" class="mb-3">
                <input type="hidden" name="sid" value="<?= $student_id ?>">
                <div class="row">
                    <div class="col-md-5">
                        <label>Session</label>
                        <select name="rep_session" class="form-control">
                            <?php mysqli_data_seek($sessions, 0);
                            while ($row = mysqli_fetch_assoc($sessions)) {
                                echo "<option value='{$row['session_name']}'>{$row['session_name']}</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label>Term</label>
                        <select name="rep_term" class="form-control">
                            <?php foreach ($terms as $term) {
                                echo "<option value='$term'>$term</option>";
                            } ?>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button class="btn btn-primary w-100">View</button>
                    </div>
                </div>
            </form>
            <?php
            if (isset($_GET['rep_session'], $_GET['rep_term'])) {
                $sess = $_GET['rep_session'];
                $term = $_GET['rep_term'];
                echo "<p><a href='reportcard.php?sid=$student_id&session=$sess&term=$term' target='_blank' class='btn btn-success'>View Report Card</a></p>";
            }
            ?>
        </div>
    </div>
</div>

<script src="assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
