<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "db_config.php";
include "auth.php"; // sets $_SESSION['parentusername']

$parent_username = $_SESSION['parentusername'];

// Fetch all wards (students) linked to this parent
$student_sql = "SELECT * FROM student_tbl 
                WHERE fathernumber = ? OR mothernumber = ? 
                ORDER BY surname ASC";

$stmt = $conn->prepare($student_sql);
$stmt->bind_param("ss", $parent_username, $parent_username);
$stmt->execute();
$result = $stmt->get_result();

$students = [];
$parent_name = "Parent";

while ($row = $result->fetch_assoc()) {
    $students[] = $row;
    // Optional: Get parent name from first child's surname
    if (count($students) === 1) {
        $parent_name = $row['surname'] . " Family";
    }
}

// Fetch student(s) using parent's phone number
$parent_phone = $parent_username; // from session

$student_query = mysqli_query($conn, "
    SELECT s.*, c.class_group 
    FROM student_tbl s 
    LEFT JOIN classgroup_tbl c ON s.class_group = c.cg_id 
    WHERE s.fathernumber = '$parent_phone' OR s.mothernumber = '$parent_phone' 
    ORDER BY s.surname ASC
") or die(mysqli_error($conn));

?>


<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Dashboard</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

        <style>
        /* Hover-triggered dropdown */
        .dropdown-hover:hover .dropdown-menu {
          display: block;
          margin-top: 0; /* optional: removes delay */
        }
        
    .link-buttons {
      display: flex; /* makes buttons appear in a straight line */
      gap: 10px; /* spacing between buttons */
    }

    .link-buttons a {
      text-decoration: none; /* remove underline */
      background-color: #007bff; /* button color */
      color: white;
      padding: 5px 10px;
      border-radius: 5px;
      font-size: 14px;
      transition: background-color 0.3s;
    }

    .link-buttons a:hover {
      background-color: #0056b3; /* hover effect */
    }
        </style>

    </head>
    <body>
	
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			
			<?php include "parentheader.php"?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
           <div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <h3 class="page-title">Welcome <?= ucfirst($parent_name); ?>!</h3>
            <ul class="breadcrumb"><li class="breadcrumb-item active">Dashboard</li></ul>
        </div>

        <!-- Students Count -->
        <div class="row">
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card bg-one">
                    <div class="card-body">
                        <div class="db-widgets d-flex justify-content-between align-items-center">
                            <div class="db-icon"><i class="fas fa-user-graduate"></i></div>
                            <div class="db-info">
                                <h3><?= mysqli_num_rows($student_query); ?></h3>
                                <h6>Students</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Students List -->
        <div class="row">
            <div class="col-md-12">
                <div class="card flex-fill">
                    <div class="card-header"><h5 class="card-title">Students List</h5></div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-center">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Student ID</th>
                                        <th>Full Name</th>
                                        <th class="text-center">Class</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($row = mysqli_fetch_assoc($student_query)) {
                                      $fullname = $row['surname'] . " " . $row['firstname']; 
                                      $stdid = $row['std_id'];
                                      $classgroup = $row['class_group'];
                                      $class_id = $row['class_name'];
                                      ?>
                                      <tr>
                                        <td><?= $row['student_id'] ?></td>
                                        <td><?= $fullname ?></td>
                                        <td class="text-center"><?= $row['class_group'] ?></td>
                                        <td>
                                          <div class="btn-group" role="group">
                                              <a href="fee_status2.php?id=<?php echo $stdid;?>&cg=<?php echo $classgroup;?>" class="btn btn-primary btn-sm">Payment History</a>
                                              <a href="attendance_report_new.php?cid=<?php echo $class_id;?>" class="btn btn-info btn-sm">Attendance</a>
                                              <a href="homework_report.php?id=<?php echo $stdid;?>&cid=<?php echo $class_id;?>" class="btn btn-warning btn-sm">Home Work</a>
                                              <a href="#contact" class="btn btn-primary btn-sm">Reportcard</a>
                                            </div>
                                        </td>
                                      </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
      <footer style="margin-top: 50%;">
        <p>Copyright © <?php echo date('Y');?> Jobastech.</p>                   
    </footer>          
    <!-- /Footer -->
</div>


			
		
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
		<script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Chart JS -->
		<script src="assets/plugins/apexchart/apexcharts.min.js"></script>
		<script src="assets/plugins/apexchart/chart-data.js"></script>
		
		<!-- Custom JS -->
		<script  src="assets/js/script.js"></script>
		
    </body>


</html>