<?php
include "db_config.php";
include "auth.php";

if(isset($_GET['id'])){
    $studentid = $_GET['id'];    
}

if(isset($_GET['cid'])){
    $studentclass = $_GET['cid'];    
}

$std_id = $_GET['studentid'];   
$class_id = $_GET['studentclass'] ?? '';

$subject_id = $_GET['subject_id'] ?? '';
$session = $_GET['session'] ?? '';
$term = $_GET['term'] ?? '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

// Total records count
$count_sql = "SELECT COUNT(*) as total FROM homework_tbl WHERE 1";
$count_result = $conn->query($count_sql);
$total_rows = $count_result->fetch_assoc()['total'];
$total_pages = ceil($total_rows / $limit);

// Main query
$sql = "SELECT h.*, c.class_name, s.subject_name, se.sch_session, tm.sch_term
        FROM homework_tbl h
        LEFT JOIN class_tbl c ON h.class_id = c.c_id
        LEFT JOIN school_subject s ON h.subject_id = s.subject_id
        LEFT JOIN session_tbl se ON h.session = se.se_id
        LEFT JOIN term_tbl tm ON h.term = tm.t_id
        LEFT JOIN student_tbl st ON h.class_id = st.class_name
        WHERE h.class_id = '$class_id'";

if (!isset($class_id)) $sql .= " AND h.class_id = '$class_id'";
if (!empty($subject_id)) $sql .= " AND h.subject_id = '$subject_id'";
if (!empty($session)) $sql .= " AND h.session = '$session'";
if (!empty($term)) $sql .= " AND h.term = '$term'";

$sql .= " ORDER BY h.created_at DESC LIMIT $limit OFFSET $offset";
$result = $conn->query($sql);


?>

<!DOCTYPE html>
<html>
<head>
  <title>Homework Report</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
  <?php include "reportheader.php"; ?>
  <h3>Homework Submission History</h3>
  <!-- Filter Form -->
  <form method="GET" class="row g-3 mb-4">
    
    <div class="col-md-3">
      <select name="subject_id" class="form-select">
        <option value="">All Subjects</option>
        <?php
        $subj = $conn->query("SELECT * FROM school_subject WHERE status='active'");
        while ($row = $subj->fetch_assoc()) {
          $sel = ($subject_id == $row['subject_id']) ? "selected" : "";
          echo "<option value='{$row['subject_id']}' $sel>{$row['subject_name']}</option>";
        }
        ?>
      </select>
    </div>
    <div class="col-md-2">
      <select name="session" class="form-select">
        <option value="">All Sessions</option>
        <?php
        $ses = $conn->query("SELECT * FROM session_tbl WHERE status='active'");
        while ($row = $ses->fetch_assoc()) {
          $sel = ($session == $row['se_id']) ? "selected" : "";
          echo "<option value='{$row['se_id']}' $sel>{$row['sch_session']}</option>";
        }
        ?>
      </select>
    </div>
    <input hidden name="studentid" value="<?php echo $studentid; ?>">
    <input hidden name="studentclass" value="<?php echo $studentclass; ?>">
    <div class="col-md-2">
      <select name="term" class="form-select">
        <option value="">All Terms</option>
        <?php
        $ter = $conn->query("SELECT * FROM term_tbl WHERE status='active'");
        while ($row = $ter->fetch_assoc()) {
          $sel = ($term == $row['t_id']) ? "selected" : "";
          echo "<option value='{$row['t_id']}' $sel>{$row['sch_term']}</option>";
        }
        ?>
      </select>
    </div>
    <div class="col-md-2">
      <button name="submit" type="submit" class="btn btn-primary w-100">Filter</button>
    </div>
  </form>
  <div class="mb-3">
    <a href="export_homework_excel.php" class="btn btn-success">Export to Excel</a>
    <a href="export_homework_pdf.php" class="btn btn-danger">Export to PDF</a>
  </div>

  <div class="table-responsive">
    <table class="table table-bordered">
      <thead class="table-dark">
        <tr>
          <th>S/N</th>
          <th>Title</th>
          <th>Description</th>
          <th>Class</th>
          <th>Subject</th>
          <th>Session</th>
          <th>Term</th>
          <th>Due Date</th>
         
          <th>File</th>
          <th>Date Sent</th>
        </tr>
      </thead>
      <tbody>
        <?php $sn = $offset + 1;
        if ($result->num_rows > 0) {
          while ($row = $result->fetch_assoc()) {
            echo "<tr>
              <td>{$sn}</td>
              <td>{$row['title']}</td>
              <td>{$row['description']}</td>
              <td>{$row['class_name']}</td>
              <td>{$row['subject_name']}</td>
              <td>{$row['sch_session']}</td>
              <td>{$row['sch_term']}</td>
              <td>{$row['due_date']}</td>
              
              <td><a href='{$row['file_path']}' target='_blank'>Download</a></td>
              <td>{$row['created_at']}</td>
            </tr>";
            $sn++;
          }
        } else {
          echo "<tr><td colspan='10' class='text-center'>No records found.</td></tr>";
        }
        ?>
      </tbody>
    </table>
  </div>

  <nav>
    <ul class="pagination justify-content-center">
      <?php for ($i = 1; $i <= $total_pages; $i++): ?>
        <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
          <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
        </li>
      <?php endfor; ?>
    </ul>
  </nav>
</div>

</body>
</html>
