<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "db_config.php";
include "auth.php"; // sets $_SESSION['parentusername']

$parent_username = $_SESSION['parentusername'];

// Fetch all wards (students) linked to this parent
$student_sql = "SELECT * FROM student_tbl 
                WHERE fathernumber = ? OR mothernumber = ? 
                ORDER BY surname ASC";

$stmt = $conn->prepare($student_sql);
$stmt->bind_param("ss", $parent_username, $parent_username);
$stmt->execute();
$result = $stmt->get_result();

$students = [];
$parent_name = "Parent";

while ($row = $result->fetch_assoc()) {
    $students[] = $row;
    // Optional: Get parent name from first child's surname
    if (count($students) === 1) {
        $parent_name = $row['surname'] . " Family";
    }
}

// Fetch student(s) using parent's phone number
$parent_phone = $parent_username; // from session

$student_query = mysqli_query($conn, "
    SELECT s.*, c.class_group 
    FROM student_tbl s 
    LEFT JOIN classgroup_tbl c ON s.class_group = c.cg_id 
    WHERE s.fathernumber = '$parent_phone' OR s.mothernumber = '$parent_phone' 
    ORDER BY s.surname ASC
") or die(mysqli_error($conn));

?>
<!DOCTYPE html>
<html lang="en">
    

<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Student Fee Status</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

		<!-- Datatables CSS -->
		<link rel="stylesheet" href="assets/plugins/datatables/datatables.min.css">

		<!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<?php include "parentheader.php"?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Payment History/Statement of Account</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
									<li class="breadcrumb-item active">Payment History</li>
								</ul><br/>
								<?php
							
								if(isset($_GET['id'])){
									$std_id = $_GET['id'];
								}
									$sql = "SELECT s.*, sc.sch_name, cg.class_group, cl.class_name 
									FROM student_tbl s 
									JOIN school_tbl sc ON sc.sch_id = s.school 
									JOIN class_tbl cl ON s.class_name = cl.c_id 
									JOIN classgroup_tbl cg ON s.class_group = cg.cg_id 
									WHERE s.std_id = $std_id ORDER BY s.surname";
									$q =mysqli_query($conn,$sql);
									$row = mysqli_fetch_assoc($q);
									$surname = $row['surname'];
									$firstname = $row['firstname'];
									$fullname = $surname." ". $firstname;
									$classgroup = $row['class_group'];
									$classname = $row['class_name'];
								?>
								<label>Name: <?php echo $fullname;?></label><br/>
								<label>Class: <?php echo $classgroup;?></label>
							</div>

							<!--
							<div class="col-auto text-right float-right ml-auto">
								<a href="#" class="btn btn-outline-primary mr-2"><i class="fas fa-download"></i> Download</a>
								<a href="add_fee.php" class="btn btn-primary"><i class="fas fa-plus"> Add </i></a>
							</div>-->
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
						
							<div class="card card-table">
								<div class="card-body">
									<div class="table-responsive">
										<table id="example" class="display" style="width:100%">
											<thead>
												<tr>
													<th>Trans Date</th>
													<th>Narration</th>
													<th>Debit</th>
													<th>Credit</th>
													<th>Balance</th>
												</tr>
											</thead>
											<tbody>
												<?php
													$i =1;
													if(isset($_GET['id'])){
														$std_id = $_GET['id'];
													}
													if(isset($_GET['cg'])){
														$cg = $_GET['cg'];
													}
													$balance = 0;
													$sql = "SELECT * FROM payment_tbl WHERE student_id = $std_id ORDER BY trans_date DESC";													
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														$date = $row['trans_date'];
														$narration = $row['narration'];
														$debit = $row['debit'];
														$credit = $row['credit'];
														$datetime = $row['date_time'];
														// $amount_rev = $row['amount_rev'];
														$balance = $balance-$debit+$credit;
														//$totaldebit = $row['totaldebit'];
												 ?>
												<tr>
													<td><?php echo $datetime;?></td>
													<td><?php echo $narration;?></td>
													<td><?php echo number_format($debit);?></td>
													<td><?php echo number_format($credit);?></td>
													<td><?php echo number_format($balance);?></td>

													
												</tr><?php $i++; }?>
											</tbody>
											<tfoot>
												<tr>
													<!-- <td colspan="2">Total</td> -->
													<!--<td colspan="3"><?php echo number_format($totaldebit,2);?></td>-->

												</tr>
											</tfoot>
										</table>
									</div>
								</div>
							</div>							
						</div>					
					</div>					
				</div>

				<!-- Footer -->
				<footer>
					<p>Copyright © 2021 Jobastech.</p>					
				</footer>
				<!-- /Footer -->
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
		<script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Datatables JS -->
		<script src="assets/plugins/datatables/datatables.min.js"></script>
		
		<!-- Datatables JS -->
		<script src="assets/plugins/datatables/datatables.min.js"></script>
		<script src="../assets/js/jquery-3.5.1.js"></script>
		<script src="../admin/assets/js/jquery.dataTables.min.js"></script>
		<script src="../admin/assets/js/dataTables.buttons.min.js"></script>
		<script src="../admin/assets/js/jszip.min.js"></script> 
		<script src="../admin/assets/js/pdfmake.min.js"></script>
		<script src="../admin/assets/js/vfs_fonts.js"></script>
		<script src="../admin/assets/js/buttons.html5.min.js"></script>
		<script src="../admin/assets/js/buttons.print.min.js"></script>
        
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>

		<script>
		$(document).ready(function() {
		    $('#example').DataTable( {
		        dom: 'Bfrtip',
		        buttons: [
		            'copy', 'csv', 'excel', 'pdf', 'print'
		        ]
		    } );
		} );
		</script>

		<script>
			function deletepayment(id){
				if (confirm("Are you sure you want to delete this payment")) {
					window.location.href='delete_payment.php?pid='+id;
				}
			}
		</script>
    </body>


</html>