<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "db_config.php";
include "auth.php";

if(isset($_GET['cid'])){
    $cid = $_GET['cid'];
}

?>

<!DOCTYPE html>
<html>
<head>
	<title>Attendance Report</title>

	<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

	<!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="../admin/assets/css/buttons.dataTables.min.css">
</head>
<body>
<div class="container">
	<?php include "reportheader.php"; ?>
	<h4 style="margin-top: 15px;">ATTENDANCE REPORT</h4>
	<form method="GET">

	<div class="row" style="margin-top: 15px;">
        <!--Session-->
	    <div class="col-md-3">
            <label for="session" class="form-label">Session</label>
            <select name="session_id" id="session" class="form-control" required>
                <option value="">Select Session</option>
                <?php
                $sess = $conn->query("SELECT se_id, sch_session FROM session_tbl WHERE status='active'");
                while ($row = $sess->fetch_assoc()) {
                    $selected = (isset($_GET['session_id']) && $_GET['session_id'] == $row['se_id']) ? 'selected' : '';
                    echo "<option value='{$row['se_id']}' $selected>{$row['sch_session']}</option>";
                }
                ?>
            </select>
        </div>
        <!--Term-->
        <div class="col-md-3">
            <label for="term" class="form-label">Term</label>
            <select name="term_id" id="term" class="form-control" required>
            <option value="">Select Term</option>
            <?php
            $terms = $conn->query("SELECT t_id, sch_term FROM term_tbl WHERE status='active'");
            while ($row = $terms->fetch_assoc()) {
                $selected = (isset($_GET['term_id']) && $_GET['term_id'] == $row['t_id']) ? 'selected' : '';
                echo "<option value='{$row['t_id']}' $selected>{$row['sch_term']}</option>";
            }
            ?>
            </select>
        </div>
         
         <!-- Class -->
        <div class="col-md-3">
            <label for="class" class="form-label">Class</label>
            <select name="class_id" id="class" class="form-control" required>
            <option value="">Select Class</option>
            <?php
            $classes = $conn->query("SELECT c_id, class_name FROM class_tbl WHERE c_id = '$cid'");
            while ($row = $classes->fetch_assoc()) {
                $selected = (isset($_GET['class_id']) && $_GET['class_id'] == $row['c_id']) ? 'selected' : '';
                echo "<option value='{$row['c_id']}' $selected>{$row['class_name']}</option>";
            }
            ?>
            </select>
        </div>

		<!-- Date -->
        <div class="col-md-3">
            <label for="date" class="form-label">Date</label>
            <input type="date" name="attendance_date" id="date" class="form-control"
            value="<?= $_GET['attendance_date'] ?? '' ?>" max="<?= date('Y-m-d') ?>" required>
        </div>
        <!-- Submit -->
        <div class="col-md-3" style="margin-top: 30px;">
			<div class="form-group">
				<label></label>
				    <button type="submit" name="submit" class="btn btn-primary">View Report</button>
			</div>
		</div>
	</div>
		
		        	<?php
					if (isset($_GET['submit'], $_GET['session_id'], $_GET['term_id'], $_GET['class_id'])) {
                    $session_id = $_GET['session_id'];
                    $term_id = $_GET['term_id'];
                    $class_id = $_GET['class_id'];
                    $attendance_date = $_GET['attendance_date'] ?? null;

                    $sql = "SELECT a.id, s.student_id, CONCAT(s.surname, ' ', s.firstname, ' ', s.othername) AS fullname,
                                a.status, a.attendance_date
                            FROM attendance_tbl a
                            JOIN student_tbl s ON a.student_id = s.std_id
                            WHERE a.session_id = ? AND a.term_id = ? AND s.class_name = ?";

                    if ($attendance_date) {
                        $sql .= " AND a.attendance_date = ?";
                    }

                    $stmt = $conn->prepare($sql);

                    if ($attendance_date) {
                        $stmt->bind_param("iiis", $session_id, $term_id, $class_id, $attendance_date);
                    } else {
                        $stmt->bind_param("iii", $session_id, $term_id, $class_id);
                    }

                    $stmt->execute();
                    $result = $stmt->get_result();

                    if (isset($result)) {
                    if ($result->num_rows > 0) {
                        echo "<div class='table-responsive'><table id='example' class='table table-bordered table-striped'>";
                        echo "<thead class='table-dark'>
                                <tr>
                                <th>#</th>
                                <th>Student ID</th>
                                <th>Full Name</th>
                                <th>Status</th>
                                <th>Date</th>
                                </tr>
                            </thead><tbody>";
                        $i = 1;
                        while ($row = $result->fetch_assoc()) {
                            echo "<tr>
                                    <td>{$i}</td>
                                    <td>{$row['student_id']}</td>
                                    <td>" . ucwords(strtolower($row['fullname'])) . "</td>
                                    <td>" . ucfirst($row['status']) . "</td>
                                    <td>{$row['attendance_date']}</td>
                                </tr>";
                            $i++;
                        }
                        echo "</tbody></table></div>";
                    } else {
                        echo "<div class='alert alert-warning'>No attendance records found.</div>";
                    }
                }

                }
                ?>
		   </div>
		</form>
</div>
<!-- jQuery -->
<script src="assets/js/jquery-3.5.1.min.js"></script>

<!-- Datatables JS -->
<script src="assets/plugins/datatables/datatables.min.js"></script>
<script src="../assets/js/jquery-3.5.1.js"></script>
<script src="../admin/assets/js/jquery.dataTables.min.js"></script>
<script src="../admin/assets/js/dataTables.buttons.min.js"></script>
<script src="../admin/assets/js/jszip.min.js"></script> 
<script src="../admin/assets/js/pdfmake.min.js"></script>
<script src="../admin/assets/js/vfs_fonts.js"></script>
<script src="../admin/assets/js/buttons.html5.min.js"></script>
<script src="../admin/assets/js/buttons.print.min.js"></script>

<!-- Datatable init js -->
<script src="../admin/assets/js/datatables.init.js"></script>
        
		
<!-- Custom JS -->
<script src="assets/js/script.js"></script>

<script>
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
} );
</script>
</body>
</html>