<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

include "db_config.php";

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Password Reset Status</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Bootstrap 4 CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    
    <style>
        body {
            background: #003366;
            color: #fff;
            font-family: 'Segoe UI', sans-serif;
        }
        .message-box {
            margin-top: 100px;
            background: #fff;
            color: #333;
            border-radius: 8px;
            padding: 40px;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
            text-align: center;
            box-shadow: 0 0 10px rgba(0,0,0,0.3);
        }
        .message-box h3 {
            color: #003366;
            font-weight: bold;
        }
        .btn-primary {
            background-color: #003366;
            border: none;
        }
        .footer {
            text-align: center;
            margin-top: 60px;
            color: #ccc;
        }
    </style>
</head>
<body>

<div class="message-box">
    <?php
    if (!isset($_SESSION['reset_email'])) {
        echo "<h3>Session Expired</h3>";
        echo "<p>Please <a href='forgot-password.php' class='btn btn-warning mt-3'>Try Again</a></p>";
    } else {
        $email = $_SESSION['reset_email'];
        $new_password = $_POST['new_password'] ?? '';
        $confirm_password = $_POST['confirm_password'] ?? '';

        if ($new_password !== $confirm_password) {
            echo "<h3>Passwords Do Not Match</h3>";
            echo "<a href='reset_password.php' class='btn btn-danger mt-3'>Try Again</a>";
        } else {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $sql = "UPDATE teacher_tbl SET pwd = ? WHERE email = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $hashed_password, $email);

            if ($stmt->execute()) {
                echo "<h3>Password Reset Successful!</h3>";
                echo "<a href='login.php' class='btn btn-primary mt-3'>Go to Login</a>";
                session_destroy();
            } else {
                echo "<h3>Something Went Wrong</h3>";
                echo "<p class='text-danger'>Could not update your password.</p>";
                echo "<a href='reset_password.php' class='btn btn-danger mt-3'>Try Again</a>";
            }
        }
    }
    ?>
</div>

<div class="footer">
    &copy; <?= date("Y") ?> JOBASTECH SCHOOL MGT. SYSTEM (JSMS V.1.0)
</div>

</body>
</html>
