<?php
include "db_config.php";
include "auth.php"; // your database connection

function send_email($to, $subject, $message) {
    $from_name = "JobasTech School";
    $from_email = "jobastech@gmail.com"; // Make sure this email exists and is allowed to send
    
    $headers = "From: $from_name <$from_email>\r\n";
    $headers .= "Reply-To: $from_email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8";

    mail($to, $subject, $message, $headers);
}



$title = $_POST['title'];
$description = $_POST['description'];
$classgroup_id = $_POST['classgroup_id'];
$subject_id = $_POST['subject_id'];
$session = $_POST['session'];
$term = $_POST['term'];
$due_date = $_POST['due_date'];
$teacher_id = 1; // (replace with session or logged-in teacher ID)

// Select Subject
$stmt = $conn->prepare("SELECT * FROM school_subject WHERE subject_id = ?");
$stmt->bind_param("i", $subject_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$subject_name = $row['subject_name'];

$file_path = null;

if (isset($_FILES['assignment_file']) && $_FILES['assignment_file']['error'] == 0) {
    $targetDir = "uploads/homework/";
    if (!file_exists($targetDir)) mkdir($targetDir, 0777, true);
    
    $file_name = time() . "_" . basename($_FILES["assignment_file"]["name"]);
    $file_path = $targetDir . $file_name;

    if (!move_uploaded_file($_FILES["assignment_file"]["tmp_name"], $file_path)) {
        die("File upload failed.");
    }
}

// Insert into database
$stmt = $conn->prepare("INSERT INTO homework_tbl 
(title, description, file_path, classgroup_id, subject_id, teacher_id, session, term, due_date) 
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->bind_param("sssiiisss", $title, $description, $file_path, $classgroup_id, $subject_id, $teacher_id, $session, $term, $due_date);

if ($stmt->execute()) {
    echo "✅ Assignment sent successfully. <a href='homework.php'>Back to Home Work</a> or <a href='index.php'>Back to Dashboard</a>";

    // Notify parents via phone/email
    $homework_id = $stmt->insert_id;
    $query = "SELECT fatheremail FROM student_tbl WHERE class_group = ?";
    $notify = $conn->prepare($query);
    $notify->bind_param("i", $classgroup_id);
    $notify->execute();
    $result = $notify->get_result();

    // Build message with description
    $message = "📚 New Homework Assigned\n";
    $message .= "Subject: $subject_name\n";
    $message .= "Title: $title\n";
    $message .= "Due: $due_date\n";
    $message .= "Description: " . (strlen($description) > 0 ? $description : "Check the portal for details.") . "\n";

    while ($row = $result->fetch_assoc()) {
        //$phone = $row['parent_phone'];
        $email = $row['fatheremail'];

        // 🟢 Send SMS (Termii/Twilio/etc.)
        //send_sms($phone, $message); // You’ll create this function

        // 🟢 Send Email (optional)
        send_email($email, "New Homework Assigned", $message); // You’ll create this function
    }
} else {
    echo "❌ Error: " . $stmt->error;
}
?>
