<?php

include "db_config.php";
include "auth.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $session_id = $_POST['session_id'];
    $term_id = $_POST['term_id'];
    $class_id = $_POST['class_id'];
    $attendance_date = $_POST['attendance_date'];

    
    $dayOfWeek = date('w', strtotime($attendance_date)); // 0 (Sunday) to 6 (Saturday)

    if ($dayOfWeek == 0 || $dayOfWeek == 6) {
        die("Invalid attendance date. Only weekdays are allowed.");
    }


    // Fetch students in the selected class
    $stmt = $conn->prepare("SELECT std_id, student_id, TRIM(CONCAT_WS(' ', surname, firstname,othername)) as fullname FROM student_tbl WHERE class_name = ? AND status = 'active'");
    $stmt->bind_param("i", $class_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $students = $result->fetch_all(MYSQLI_ASSOC);
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<div class="container mt-5">
    <h4 class="mb-4">Mark Attendance</h4>

    <form action="save_attendance.php" method="post" class="card p-4 shadow-sm">

        <!-- Hidden Inputs -->
        <input type="hidden" name="session_id" value="<?= $session_id ?>">
        <input type="hidden" name="term_id" value="<?= $term_id ?>">
        <input type="hidden" name="class_id" value="<?= $class_id ?>">
        <input type="hidden" name="attendance_date" value="<?= $attendance_date ?>">

        <?php if (count($students) > 0): ?>
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Student ID</th>
                        <th>Full Name</th>
                        <th>Present</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($students as $index => $student): ?>
                    <tr>
                        <td><?= $index + 1 ?></td>
                        <td><?= $student['student_id'] ?></td>
                        <td><?= $student['fullname'] ?></td>
                        <td>
                            <input type="hidden" name="students[<?= $student['std_id'] ?>][id]" value="<?= $student['std_id'] ?>">
                            <input type="checkbox" name="students[<?= $student['std_id'] ?>][present]" value="1" checked>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <button type="submit" class="btn btn-success mt-3">Save Attendance</button>

        <?php else: ?>
            <p class="alert alert-warning">No students found in this class.
            <a href='attendance.php' class='btn btn-primary'>Take Another Attendance</a></p>
        <?php endif; ?>
    </form>
</div>