

CREATE TABLE `batchfee` (
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) DEFAULT NULL,
  `student_name` varchar(200) DEFAULT NULL,
  `pay_ref` varchar(255) DEFAULT NULL,
  `session` varchar(50) NOT NULL,
  `term` varchar(50) NOT NULL,
  `mop` varchar(100) DEFAULT NULL,
  `fee_code` varchar(11) DEFAULT NULL,
  `debit` double(10,2) NOT NULL,
  `credit` double(10,2) NOT NULL DEFAULT '0.00',
  `payment_category` varchar(100) DEFAULT NULL,
  `class_group` varchar(50) NOT NULL,
  `class_name` varchar(50) DEFAULT NULL,
  `creation_date` date DEFAULT NULL,
  `date_time` varchar(255) DEFAULT NULL,
  `narration` varchar(255) DEFAULT NULL,
  `status1` varchar(20) DEFAULT NULL,
  `status2` varchar(20) DEFAULT NULL,
  `create_by` varchar(50) DEFAULT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`p_id`)
) ENGINE=MyISAM AUTO_INCREMENT=625 DEFAULT CHARSET=latin1;




CREATE TABLE `class_tbl` (
  `c_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_group` varchar(50) NOT NULL,
  `class_name` varchar(50) NOT NULL,
  `status` varchar(50) DEFAULT NULL,
  `create_by` varchar(50) DEFAULT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`c_id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;

INSERT INTO class_tbl VALUES("1","JSS1","JSS1A","active","JOSHUA","2021-08-22","2021-08-22 06:05:34pm","","");
INSERT INTO class_tbl VALUES("2","JSS1","JSS1B","inactive","JOSHUA","2021-08-22","2021-08-22 06:06:39pm","","");
INSERT INTO class_tbl VALUES("3","JSS1","JSS1C","inactive","JOSHUA","2021-08-22","2021-08-22 06:17:53pm","","");
INSERT INTO class_tbl VALUES("4","JSS1","JSS1D","inactive","JOSHUA","2021-08-22","2021-08-22 06:24:07pm","","");
INSERT INTO class_tbl VALUES("5","JSS1","JSS1E","inactive","JOSHUA","2021-08-22","2021-08-22 06:26:12pm","","");
INSERT INTO class_tbl VALUES("6","JSS1","JSS1F","inactive","JOSHUA","2021-08-22","2021-08-22 06:33:53pm","","");
INSERT INTO class_tbl VALUES("7","JSS1","JSS1G","inactive","JOSHUA","2021-08-22","2021-08-22 06:36:28pm","","");
INSERT INTO class_tbl VALUES("8","JSS1","JSS1H","inactive","JOSHUA","2021-08-22","2021-08-22 06:39:16pm","","");
INSERT INTO class_tbl VALUES("9","JSS2","JSS2A","active","JOSHUA","2021-08-24","2021-08-24 05:28:11am","","");
INSERT INTO class_tbl VALUES("10","Basic","Basic 1","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:19pm","","");
INSERT INTO class_tbl VALUES("11","Basic","Basic 2","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:32pm","","");
INSERT INTO class_tbl VALUES("12","Basic","Basic 3","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:44pm","","");
INSERT INTO class_tbl VALUES("13","Basic","Basic 4","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:54pm","","");
INSERT INTO class_tbl VALUES("14","Basic","Basic 5","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:56:05pm","","");
INSERT INTO class_tbl VALUES("15","Basic","Basic 6","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:56:14pm","","");
INSERT INTO class_tbl VALUES("16","Nursery","Nursery 1","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:09:16pm","","");
INSERT INTO class_tbl VALUES("17","Nursery","Nursery 2","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:09:27pm","","");
INSERT INTO class_tbl VALUES("18","Creche/Kindergarten","Creche/Kindergarten","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:13:17pm","","");
INSERT INTO class_tbl VALUES("20","SSS2","SSS2B","inactive","ATANSUYI EMMANUEL SEUN","2022-04-21","2022-04-21 10:32:03am","","");
INSERT INTO class_tbl VALUES("19","SSS1","SSS1A","active","ATANSUYI EMMANUEL SEUN","2021-10-11","2021-10-11 07:24:44pm","","");
INSERT INTO class_tbl VALUES("21","SS3","SS3A","inactive","ATANSUYI EMMANUEL SEUN","2022-04-21","2022-04-21 10:49:58am","","");
INSERT INTO class_tbl VALUES("22","SS3","SS3B","inactive","ATANSUYI EMMANUEL SEUN","2022-04-21","2022-04-21 11:42:06am","","");
INSERT INTO class_tbl VALUES("23","JSS3","SS3C","inactive","ATANSUYI EMMANUEL SEUN","2022-04-21","2022-04-21 11:42:17am","","");
INSERT INTO class_tbl VALUES("24","JSS3","JSS3A","active","ATANSUYI EMMANUEL SEUN","2022-04-26","2022-04-26 07:50:44am","","");
INSERT INTO class_tbl VALUES("25","SSS2","SSS2A","active","ATANSUYI EMMANUEL SEUN","2022-04-26","2022-04-26 07:59:56am","","");
INSERT INTO class_tbl VALUES("26","JSS2","JSS2B","inactive","ATANSUYI EMMANUEL SEUN","2022-04-26","2022-04-26 12:17:42pm","","");
INSERT INTO class_tbl VALUES("27","JSS3","JSS3B","inactive","ATANSUYI EMMANUEL SEUN","2022-04-26","2022-04-26 12:17:55pm","","");
INSERT INTO class_tbl VALUES("28","SSS1","SSS1B","inactive","ATANSUYI EMMANUEL SEUN","2022-04-26","2022-04-26 01:03:42pm","","");
INSERT INTO class_tbl VALUES("29","JSS2","JSS2C","inactive","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:05:05am","","");
INSERT INTO class_tbl VALUES("30","JSS3","JSS3C","inactive","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:05:38am","","");
INSERT INTO class_tbl VALUES("31","SSS1","SSS1C","inactive","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:10:43am","","");
INSERT INTO class_tbl VALUES("32","SSS2","SSS2C","inactive","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:11:07am","","");
INSERT INTO class_tbl VALUES("33","BASIC1-BASIC4","BASIC1","active","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:11:54am","ATANSUYI JOSHUA","2022-07-05 01:04:57pm");
INSERT INTO class_tbl VALUES("34","BASIC1-BASIC4","BASIC2","active","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:12:03am","ATANSUYI JOSHUA","2022-07-05 01:05:11pm");
INSERT INTO class_tbl VALUES("35","BASIC1-BASIC4","BASIC3","active","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:12:14am","ATANSUYI JOSHUA","2022-07-05 01:05:23pm");
INSERT INTO class_tbl VALUES("36","BASIC1-BASIC4","BASIC4","active","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:12:24am","ATANSUYI JOSHUA","2022-07-05 01:05:37pm");
INSERT INTO class_tbl VALUES("37","BASIC5","BASIC5","active","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:12:33am","","");
INSERT INTO class_tbl VALUES("38","NUR1-NUR2","NURSERY1","active","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:12:45am","ATANSUYI JOSHUA","2022-07-05 01:05:59pm");
INSERT INTO class_tbl VALUES("39","NUR1-NUR2","NURSERY2","active","ATANSUYI EMMANUEL SEUN","2022-04-29","2022-04-29 09:12:55am","ATANSUYI JOSHUA","2022-07-05 01:06:11pm");
INSERT INTO class_tbl VALUES("40","Kindergarten","KG1","active","ATANSUYI EMMANUEL SEUN","2022-07-01","2022-07-01 01:07:12pm","ATANSUYI JOSHUA","2022-07-05 01:06:23pm");
INSERT INTO class_tbl VALUES("41","Kindergarten","KG2","active","ATANSUYI EMMANUEL SEUN","2022-07-01","2022-07-01 01:07:21pm","ATANSUYI JOSHUA","2022-07-05 01:06:36pm");
INSERT INTO class_tbl VALUES("42","Creche","Creche","active","ATANSUYI EMMANUEL SEUN","2022-07-01","2022-07-01 01:07:33pm","ATANSUYI JOSHUA","2022-07-05 01:06:48pm");



CREATE TABLE `classgroup_tbl` (
  `cg_id` int(11) NOT NULL AUTO_INCREMENT,
  `school` varchar(50) NOT NULL,
  `class_group` varchar(25) NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `position` int(3) NOT NULL,
  `create_by` varchar(255) DEFAULT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cg_id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

INSERT INTO classgroup_tbl VALUES("1","","JSS1-3","inactive","0","JOSHUA","2021-08-19","2021-08-19 09:04:58pm","ATANSUYI EMMANUEL SEUN","2021-10-09 05:08:13pm");
INSERT INTO classgroup_tbl VALUES("2","Secondary","JSS2","active","12","JOSHUA","2021-08-19","2021-08-19 09:09:34pm","","");
INSERT INTO classgroup_tbl VALUES("3","Secondary","JSS3","active","13","JOSHUA","2021-08-19","2021-08-19 09:10:13pm","","");
INSERT INTO classgroup_tbl VALUES("4","","SS1-3","inactive","0","JOSHUA","2021-08-19","2021-08-19 09:17:39pm","ATANSUYI EMMANUEL SEUN","2021-10-09 05:08:01pm");
INSERT INTO classgroup_tbl VALUES("5","Secondary","SSS2","active","15","JOSHUA","2021-08-21","2021-08-21 10:06:14am","","");
INSERT INTO classgroup_tbl VALUES("6","Secondary","SSS3","active","16","JOSHUA","2021-08-21","2021-08-21 02:20:48pm","","");
INSERT INTO classgroup_tbl VALUES("7","","ss10","inactive","0","JOSHUA","2021-08-21","2021-08-21 08:37:42pm","ATANSUYI EMMANUEL SEUN","2021-09-17 07:45:06pm");
INSERT INTO classgroup_tbl VALUES("8","","ss4","inactive","0","JOSHUA","2021-08-21","2021-08-21 08:42:49pm","","");
INSERT INTO classgroup_tbl VALUES("9","","ss5","inactive","0","JOSHUA","2021-08-22","2021-08-22 07:33:34am","","");
INSERT INTO classgroup_tbl VALUES("10","","ss6","inactive","0","JOSHUA","2021-08-22","2021-08-22 05:15:52pm","","");
INSERT INTO classgroup_tbl VALUES("11","","Primary","inactive","0","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:44:45pm","","");
INSERT INTO classgroup_tbl VALUES("12","","Nursery","inactive","0","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:53:50pm","","");
INSERT INTO classgroup_tbl VALUES("13","Nursery/Primary","Creche","active","1","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:12:05pm","ATANSUYI JOSHUA","2022-07-17 06:33:20pm");
INSERT INTO classgroup_tbl VALUES("17","Secondary","SSS1","active","14","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:29:26pm","","");
INSERT INTO classgroup_tbl VALUES("14","","JSS1-2","inactive","0","ATANSUYI EMMANUEL SEUN","2022-04-10","2022-04-10 07:16:37pm","ATANSUYI EMMANUEL SEUN","2022-04-10 07:23:10pm");
INSERT INTO classgroup_tbl VALUES("15","","SS1-2","inactive","0","ATANSUYI EMMANUEL SEUN","2022-04-10","2022-04-10 09:34:40pm","","");
INSERT INTO classgroup_tbl VALUES("16","Secondary","JSS1","active","11","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:27:10pm","","");
INSERT INTO classgroup_tbl VALUES("18","Nursery/Primary","BASIC1","active","6","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:37:22pm","","");
INSERT INTO classgroup_tbl VALUES("19","Nursery/Primary","BASIC2","active","7","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:37:32pm","","");
INSERT INTO classgroup_tbl VALUES("20","Nursery/Primary","BASIC3","active","8","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:37:42pm","","");
INSERT INTO classgroup_tbl VALUES("21","Nursery/Primary","BASIC4","active","9","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:37:50pm","","");
INSERT INTO classgroup_tbl VALUES("22","Nursery/Primary","BASIC5","active","10","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:37:59pm","","");
INSERT INTO classgroup_tbl VALUES("23","Nursery/Primary","NURSERY1","active","4","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:39:02pm","","");
INSERT INTO classgroup_tbl VALUES("24","Nursery/Primary","NURSERY2","active","5","ATANSUYI EMMANUEL SEUN","2022-04-19","2022-04-19 04:39:12pm","","");
INSERT INTO classgroup_tbl VALUES("25","","BASIC1-BASIC4","inactive","0","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:41:10pm","","");
INSERT INTO classgroup_tbl VALUES("26","","NUR1-NUR2","inactive","0","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:42:04pm","","");
INSERT INTO classgroup_tbl VALUES("27","Nursery/Primary","Kindergarten","active","2","ATANSUYI EMMANUEL SEUN","2022-07-15","","","");



CREATE TABLE `duration_tbl` (
  `id` int(11) NOT NULL,
  `duration` tinyint(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO duration_tbl VALUES("1","1");



CREATE TABLE `exam_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `class_group` varchar(50) NOT NULL,
  `session` varchar(100) NOT NULL,
  `term` varchar(100) NOT NULL,
  `status` varchar(20) NOT NULL,
  `exam_time` varchar(5) NOT NULL,
  `date_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO exam_category VALUES("1","English","JSS1","2021/2022","3rd Term","active","2","2022-05-30 23:29:00");
INSERT INTO exam_category VALUES("2","Mathematics","JSS1","2021/2022","3rd Term","active","1","2022-05-31 11:26:58");
INSERT INTO exam_category VALUES("3","Home Economics","JSS1","2021/2022","3rd Term","active","1","2022-05-31 12:02:30");



CREATE TABLE `exp_tbl` (
  `exp_id` int(11) NOT NULL AUTO_INCREMENT,
  `expname` varchar(255) NOT NULL,
  `expamount` double(10,2) NOT NULL,
  `mop` varchar(100) NOT NULL,
  `expdesc` varchar(255) NOT NULL,
  `create_by` varchar(100) NOT NULL,
  `creation_date` varchar(255) NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(100) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`exp_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

INSERT INTO exp_tbl VALUES("20","TRANSPORT AND  TRAVELS","700.00","Cash","FARE TO ZENITH BANK AT FAGBA","ATANSUYI JOSHUA","2022-07-15","2022-07-15 11:22:00am","","");



CREATE TABLE `expenses_tbl` (
  `exp_id` int(11) NOT NULL AUTO_INCREMENT,
  `expcode` int(6) NOT NULL,
  `expname` varchar(255) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(255) NOT NULL,
  `creation_date` varchar(255) NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(100) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`exp_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO expenses_tbl VALUES("1","100621","TRANSPORT AND  TRAVELS","active","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 09:29:55am","ATANSUYI EMMANUEL SEUN","2022-03-18 06:42:16am");
INSERT INTO expenses_tbl VALUES("2","100347","SCHOOL UNIFORM","active","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 09:31:37am","","");
INSERT INTO expenses_tbl VALUES("3","100311","SALARY","active","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 09:36:46am","ATANSUYI EMMANUEL SEUN","2022-03-18 06:45:14am");
INSERT INTO expenses_tbl VALUES("4","100895","ELECTRICITY","inactive","ATANSUYI EMMANUEL SEUN","2022-03-18","2022-03-18 05:53:07am","","");
INSERT INTO expenses_tbl VALUES("5","100219","ELECTRICITY","active","ATANSUYI EMMANUEL SEUN","2022-03-18","2022-03-18 07:07:26am","","");
INSERT INTO expenses_tbl VALUES("6","100235","OIL AND FUEL","active","ATANSUYI JOSHUA","2022-07-15","2022-07-15 11:23:24am","","");



CREATE TABLE `fee_category` (
  `fee_id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_category` varchar(200) NOT NULL,
  `session` varchar(200) NOT NULL,
  `term` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `create_by` varchar(200) NOT NULL,
  `update_by` varchar(200) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fee_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

INSERT INTO fee_category VALUES("1","School Uniform","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:47:27pm","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:34:59pm");
INSERT INTO fee_category VALUES("2","Tution Fee","2021/2022","1st Term","inactive","2021-09-22","2021-09-22 08:48:28pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("3","Extra Shirt","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:49:16pm","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:30:38pm");
INSERT INTO fee_category VALUES("4","Extra Trouser","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:49:36pm","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:32:44pm");
INSERT INTO fee_category VALUES("5","P.E. Dress","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:50:26pm","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:35:23pm");
INSERT INTO fee_category VALUES("6","Activities Wear","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:50:38pm","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:36:11pm");
INSERT INTO fee_category VALUES("7","Cardigan","2021/2022","1st Term","active","2021-09-23","2021-09-23 05:08:15am","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:36:39pm");
INSERT INTO fee_category VALUES("8","Report Card","2021/2022","2nd Term","active","2021-09-23","2021-09-23 05:08:38am","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:37:46pm");
INSERT INTO fee_category VALUES("9","Tuition Fee-First Term","2021/2022","1st Term","active","2021-09-23","2021-09-23 05:09:20am","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09 03:39:52pm");
INSERT INTO fee_category VALUES("10","Tuition Fee-Second Term","2021/2022","2nd Term","active","2022-06-09","2022-06-09 03:40:44pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("11","Tuition Fee-Third Term","2021/2022","3rd Term","active","2022-06-09","2022-06-09 03:43:05pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("12","Lesson Fees-First Term","2021/2022","1st Term","active","2022-06-09","2022-06-09 07:26:42pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("13","Lesson Fees-Second Term Term","2021/2022","2nd Term","active","2022-06-09","2022-06-09 07:27:20pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("14","Tuition Fee-Second Term","2021/2022","2nd Term","inactive","2022-06-09","2022-06-09 07:32:01pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("15","Tuition Fee-Second Term","2021/2022","2nd Term","inactive","2022-06-09","2022-06-09 07:38:51pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("16","Uniform","2021/2022","2nd Term","inactive","2022-06-09","2022-06-09 08:07:15pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("17","Lesson Fees-Third Term","2021/2022","3rd Term","active","2022-06-09","2022-06-09 08:10:57pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("18","OTHERS","2021/2022","3rd Term","active","2022-07-04","2022-07-04 10:51:47am","ATANSUYI JOSHUA","","");



CREATE TABLE `fee_structure` (
  `fs_id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_category` varchar(200) DEFAULT NULL,
  `fee_code` varchar(11) NOT NULL,
  `class_group` varchar(200) NOT NULL,
  `session` varchar(100) NOT NULL,
  `term` varchar(100) NOT NULL,
  `amount` double(10,2) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(200) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fs_id`)
) ENGINE=MyISAM AUTO_INCREMENT=131 DEFAULT CHARSET=latin1;

INSERT INTO fee_structure VALUES("122","Tuition Fee-First Term","075840","BASIC1-BASIC4","2021/2022","1st Term","15000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:44:27pm","","");
INSERT INTO fee_structure VALUES("121","Tuition Fee-Third Term","002846","NURSERY1","2021/2022","3rd Term","13500.00","inactive","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:39:50pm","","");
INSERT INTO fee_structure VALUES("120","Tuition Fee-Second Term","222505","NURSERY1","2021/2022","2nd Term","13500.00","inactive","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:38:49pm","","");
INSERT INTO fee_structure VALUES("118","Tuition Fee-Third Term","623219","Creche/Kindergarten","2021/2022","3rd Term","13500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:37:41pm","","");
INSERT INTO fee_structure VALUES("119","Tuition Fee-First Term","817419","NURSERY1","2021/2022","1st Term","13500.00","inactive","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:38:29pm","","");
INSERT INTO fee_structure VALUES("117","Tuition Fee-Second Term","656593","Creche/Kindergarten","2021/2022","2nd Term","13500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:37:22pm","","");
INSERT INTO fee_structure VALUES("116","Tuition Fee-First Term","890505","Creche/Kindergarten","2021/2022","1st Term","13500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:36:11pm","","");
INSERT INTO fee_structure VALUES("115","Tuition Fee-Third Term","599082","SS3","2021/2022","3rd Term","26500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:35:07pm","","");
INSERT INTO fee_structure VALUES("113","Tuition Fee-First Term","671360","SS3","2021/2022","1st Term","26500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:34:32pm","","");
INSERT INTO fee_structure VALUES("114","Tuition Fee-Second Term","892789","SS3","2021/2022","2nd Term","26500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:34:50pm","","");
INSERT INTO fee_structure VALUES("111","Tuition Fee-Second Term","087124","SS2","2021/2022","2nd Term","25500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:33:20pm","","");
INSERT INTO fee_structure VALUES("112","Tuition Fee-Third Term","344360","SS2","2021/2022","3rd Term","25500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:33:57pm","","");
INSERT INTO fee_structure VALUES("110","Tuition Fee-First Term","428062","SS2","2021/2022","1st Term","25500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:33:04pm","","");
INSERT INTO fee_structure VALUES("104","Tuition Fee-First Term","821630","JSS3","2021/2022","1st Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:25:46pm","","");
INSERT INTO fee_structure VALUES("105","Tuition Fee-Second Term","109643","JSS3","2021/2022","2nd Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:26:10pm","","");
INSERT INTO fee_structure VALUES("106","Tuition Fee-Third Term","707862","JSS3","2021/2022","3rd Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:26:29pm","","");
INSERT INTO fee_structure VALUES("107","Tuition Fee-First Term","322152","SS1","2021/2022","1st Term","20500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:27:02pm","ATANSUYI EMMANUEL SEUN","2022-06-10 02:28:42pm");
INSERT INTO fee_structure VALUES("109","Tuition Fee-Third Term","739963","SS1","2021/2022","3rd Term","20500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:27:46pm","ATANSUYI EMMANUEL SEUN","2022-06-10 02:29:21pm");
INSERT INTO fee_structure VALUES("108","Tuition Fee-Second Term","848071","SS1","2021/2022","2nd Term","20500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:27:17pm","ATANSUYI EMMANUEL SEUN","2022-06-10 02:29:02pm");
INSERT INTO fee_structure VALUES("102","Tuition Fee-Second Term","294605","JSS2","2021/2022","2nd Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:24:17pm","","");
INSERT INTO fee_structure VALUES("103","Tuition Fee-Third Term","270003","JSS2","2021/2022","3rd Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:25:26pm","","");
INSERT INTO fee_structure VALUES("101","Tuition Fee-First Term","070792","JSS2","2021/2022","1st Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:23:59pm","","");
INSERT INTO fee_structure VALUES("98","Tuition Fee-First Term","813744","JSS1","2021/2022","1st Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:17:17pm","","");
INSERT INTO fee_structure VALUES("99","Tuition Fee-Second Term","899452","JSS1","2021/2022","2nd Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:22:42pm","","");
INSERT INTO fee_structure VALUES("100","Tuition Fee-Third Term","490577","JSS1","2021/2022","3rd Term","19000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:23:36pm","","");
INSERT INTO fee_structure VALUES("123","Tuition Fee-Second Term","673716","BASIC1-BASIC4","2021/2022","2nd Term","15000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:44:45pm","","");
INSERT INTO fee_structure VALUES("124","Tuition Fee-Third Term","871326","BASIC1-BASIC4","2021/2022","3rd Term","15000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 02:45:14pm","","");
INSERT INTO fee_structure VALUES("125","Tuition Fee-First Term","039888","NUR1-NUR2","2021/2022","1st Term","13500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 03:11:41pm","","");
INSERT INTO fee_structure VALUES("126","Tuition Fee-Second Term","962825","NUR1-NUR2","2021/2022","2nd Term","13500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 03:12:09pm","","");
INSERT INTO fee_structure VALUES("127","Tuition Fee-Third Term","837924","NUR1-NUR2","2021/2022","3rd Term","13500.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 03:12:21pm","","");
INSERT INTO fee_structure VALUES("128","Tuition Fee-First Term","042482","BASIC5","2021/2022","1st Term","16000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 03:12:47pm","","");
INSERT INTO fee_structure VALUES("129","Tuition Fee-Second Term","285663","BASIC5","2021/2022","2nd Term","16000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 03:13:03pm","","");
INSERT INTO fee_structure VALUES("130","Tuition Fee-Third Term","101725","BASIC5","2021/2022","3rd Term","16000.00","active","ATANSUYI EMMANUEL SEUN","2022-06-10","2022-06-10 03:13:21pm","","");



CREATE TABLE `fees_deposit_tbl` (
  `fd_id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `student_name` varchar(200) NOT NULL,
  `pay_ref` varchar(255) NOT NULL,
  `debit` double(10,2) DEFAULT '0.00',
  `credit` double(10,2) NOT NULL DEFAULT '0.00',
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `create_by` varchar(200) NOT NULL,
  `update_by` varchar(200) DEFAULT NULL,
  `update_dt` date DEFAULT NULL,
  PRIMARY KEY (`fd_id`)
) ENGINE=MyISAM AUTO_INCREMENT=88 DEFAULT CHARSET=latin1;

INSERT INTO fees_deposit_tbl VALUES("1","5","Akinsanya Titilope","PI1596820210922","0.00","30000.00","2021-09-22","2021-09-22 06:06:05am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("2","5","Akinsanya Titilope","PI2067320210922","0.00","3000.00","2021-09-22","2021-09-22 06:08:45am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("3","5","Akinsanya Titilope","PI5943920210925","0.00","30000.00","2021-09-25","2021-09-25 10:56:54am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("4","5","Akinsanya Titilope","FP6120211009","0.00","9500.00","2021-10-09","2021-10-09 06:36:02pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("5","5","Akinsanya Titilope","FP7520211009","0.00","5000.00","2021-10-09","2021-10-09 06:41:51pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("6","5","Akinsanya Titilope","FP6420211009","0.00","5000.00","2021-10-09","2021-10-09 06:54:47pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("7","5","Akinsanya Titilope","FP1820211009","0.00","5000.00","2021-10-09","2021-10-09 06:56:54pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("8","5","Akinsanya Titilope","FP8020211009","0.00","5000.00","2021-10-09","2021-10-09 07:21:36pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("9","5","Akinsanya Titilope","FP6220211009","0.00","2000.00","2021-10-09","2021-10-09 07:25:56pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("10","9","AKINADE ELIJAH","FP5220211011","0.00","10000.00","2021-10-11","2021-10-11 09:46:49pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("11","10","OLUPESE PROVIDER","FP3620211019","0.00","10000.00","2021-10-19","2021-10-19 07:11:49pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("12","5","Akinsanya Titilope","FP9820211106","0.00","10000.00","2021-11-06","2021-11-06 06:20:29am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("13","5","Akinsanya Titilope","FP7320211106","0.00","10000.00","2021-11-06","2021-11-06 07:48:25am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("14","4","Ilori Gboyega","FP5120211106","0.00","10000.00","2021-11-06","2021-11-06 07:49:55am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("15","5","Akinsanya Titilope","FP8920211110","0.00","10000.00","2021-11-10","2021-11-10 08:35:41pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("16","4","Ilori Gboyega","FP7220211110","0.00","8000.00","2021-11-10","2021-11-10 08:36:29pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("17","4","Ilori Gboyega","FP0920211113","0.00","5000.00","2021-11-13","2021-11-13 06:09:19pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("18","5","Akinsanya Titilope","FP0920211113","0.00","10000.00","2021-11-13","2021-11-13 06:09:53pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("19","5","Akinsanya Titilope","FP9820211113","0.00","1000.00","2021-11-13","2021-11-13 06:23:28pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("20","9","AKINADE ELIJAH","FP3420211114","0.00","1000.00","2021-11-14","2021-11-14 09:12:09pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("21","4","Ilori Gboyega","FP0020211116","0.00","1000.00","2021-11-16","2021-11-16 07:28:15pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("22","14","ATANSUYI ELISHA","FP9020211123","0.00","4000.00","2021-11-23","2021-11-23 08:10:37pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("23","4","Ilori Gboyega","FP4520211124","0.00","2000.00","2021-11-24","2021-11-24 08:30:24pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("24","5","Akinsanya Titilope","FP4220211127","0.00","2000.00","2021-11-27","2021-11-27 03:01:13pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("25","12","AYANSIBU PRAISE","FP2420211127","0.00","1000.00","2021-11-27","2021-11-27 03:32:00pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("26","15","ANIYIKAYE OMOLARA","FP6320211130","0.00","1000.00","2021-11-30","2021-11-30 05:19:08am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("27","4","Ilori Gboyega","FP6620211217","0.00","2000.00","2021-12-17","2021-12-17 08:31:05pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("28","11","OGUNDIJO SAMUEL","FP9920220227","0.00","1000.00","2022-02-27","2022-02-27 07:38:32pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("29","4","Ilori Gboyega","FP0720220315","0.00","5000.00","2022-03-15","2022-03-15 09:09:20am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("30","15","ANIYIKAYE OMOLARA","FP2120220315","0.00","10000.00","2022-03-15","2022-03-15 09:26:12am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("31","13","OLOJO OLUWATOMIYIN","FP5820220315","0.00","2000.00","2022-03-15","2022-03-15 09:28:14am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("32","12","AYANSIBU PRAISE","FP6620220316","0.00","30000.00","2022-03-16","2022-03-16 06:10:35am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("33","11","OGUNDIJO SAMUEL","FP4620220316","0.00","10000.00","2022-03-16","2022-03-16 08:41:43pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("34","11","OGUNDIJO SAMUEL","FP8720220316","0.00","5000.00","2022-03-16","2022-03-16 08:43:26pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("35","12","AYANSIBU PRAISE","FP0220220316","0.00","30000.00","2022-03-16","2022-03-16 08:48:44pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("36","16","AKINADE JAMES","FP3820220317","0.00","5000.00","2022-03-17","2022-03-17 08:42:40am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("37","16","AKINADE JAMES","FP5120220317","0.00","5000.00","2022-03-17","2022-03-17 09:25:43am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("38","16","AKINADE JAMES","FP6520220317","0.00","1000.00","2022-03-17","2022-03-17 09:34:15am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("39","8","GBENGA ANU","FP0520220317","0.00","5000.00","2022-03-17","2022-03-17 09:35:21am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("40","17","AKINADE MARY","FP6120220403","0.00","20000.00","2022-04-03","2022-04-03 09:39:03pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("41","19","ADEYA SEUN","FP7720220408","0.00","5000.00","2022-04-08","2022-04-08 12:23:59pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("42","19","ADEYA SEUN","FP7220220408","0.00","2000.00","2022-04-08","2022-04-08 12:44:58pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("43","19","ADEYA SEUN","FP4820220412","0.00","2000.00","2022-04-12","2022-04-12 03:23:12pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("44","14","ATANSUYI ELISHA","FP1120220419","0.00","5000.00","2022-04-19","2022-04-19 04:53:56pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("45","18","ADEWALE GAFAR","FP3920220419","0.00","1000.00","2022-04-19","2022-04-19 07:51:27pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("46","19","ADEYA SEUN","FP5520220420","0.00","1000.00","2022-04-20","2022-04-20 03:06:14am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("47","19","ADEYA SEUN","FP7720220420","0.00","1000.00","2022-04-20","2022-04-20 03:37:30am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("48","19","ADEYA SEUN","FP7020220420","0.00","1000.00","2022-04-20","2022-04-20 03:50:13am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("49","18","ADEWALE GAFAR","FP0520220420","0.00","5000.00","2022-04-20","2022-04-20 03:54:50am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("50","19","ADEYA SEUN","FP3120220420","0.00","7000.00","2022-04-20","2022-04-20 04:08:56pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("51","18","ADEWALE GAFAR","FP5020220420","0.00","7000.00","2022-04-20","2022-04-20 04:10:14pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("52","24","ADERIBIBIGBE ADENIYI","FP8520220429","0.00","5000.00","2022-04-29","2022-04-29 10:23:27am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("53","24","ADERIBIBIGBE ADENIYI","FP1920220429","0.00","5000.00","2022-04-29","2022-04-29 10:25:01am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("54","24","ADERIBIBIGBE ADENIYI","FP9620220429","0.00","5000.00","2022-04-29","2022-04-29 10:25:58am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("55","24","ADERIBIBIGBE ADENIYI","FP4620220429","0.00","1500.00","2022-04-29","2022-04-29 10:44:08am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("56","24","ADERIBIBIGBE ADENIYI","FP3120220429","0.00","8000.00","2022-04-29","2022-04-29 03:48:59pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("57","25","KAROUNWI EMMANUEL","FP6620220430","0.00","6000.00","2022-04-30","2022-04-30 10:46:50am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("58","25","KAROUNWI EMMANUEL","FP9120220430","0.00","2000.00","2022-04-30","2022-04-30 10:47:47am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("59","26","TOSIN ADEYA","FP1720220509","0.00","5000.00","2022-05-09","2022-05-09 01:04:25pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("60","55","OMONIYI RACHAEL","FP1320220610","0.00","3000.00","2022-06-10","2022-06-10 03:50:24pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("61","56","SHODAMOLA FATIMO","FP9720220610","0.00","3000.00","2022-06-10","2022-06-10 04:39:16pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("62","55","OMONIYI RACHAEL","FP3020220610","0.00","3000.00","2022-06-10","2022-06-10 04:44:24pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("63","60","AKINOLA GREATNESS","FP8420220611","0.00","3000.00","2022-06-11","2022-06-11 12:44:02pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("64","60","AKINOLA GREATNESS","FP9820220611","0.00","3000.00","2022-06-11","2022-06-11 12:57:37pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("65","58","ABDULSALAM NIMAAT","FP6120220611","0.00","19000.00","2022-06-11","2022-06-11 01:37:03pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("66","60","AKINOLA GREATNESS","FP3220220615","0.00","19000.00","2022-06-15","2022-06-15 02:17:36pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("67","59","BEN AYANRU OLIVIA","FP9420220704","0.00","9500.00","2022-07-04","2022-07-04 11:19:48am","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("68","59","BEN AYANRU OLIVIA","FP2120220704","0.00","9500.00","2022-07-04","2022-07-04 11:21:57am","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("69","59","BEN AYANRU OLIVIA","FP5020220705","0.00","2000.00","2022-07-05","2022-07-05 01:33:43pm","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("70","58","ABDULSALAM NIMAAT","FP2220220705","0.00","9000.00","2022-07-05","2022-07-05 05:11:02pm","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("71","60","AKINOLA GREATNESS","FP1820220706","0.00","8000.00","2022-07-06","2022-07-06 09:55:15am","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("72","60","AKINOLA GREATNESS","FP7920220706","0.00","8000.00","2022-07-06","2022-07-06 10:17:47am","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("73","60","AKINOLA GREATNESS","FP7620220706","0.00","9000.00","2022-07-06","2022-07-06 11:01:36am","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("74","60","AKINOLA GREATNESS","FP7520220706","0.00","9000.00","2022-07-06","2022-07-06 02:17:08pm","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("75","60","AKINOLA GREATNESS","FP5920220706","0.00","1000.00","2022-07-06","2022-07-06 02:19:34pm","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("87","233","ADELABU ISAAC","FP824520220718","0.00","2000.00","2022-07-18","2022-07-18 03:05:56pm","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("86","60","AKINOLA GREATNESS","FP605220220718","0.00","2000.00","2022-07-18","2022-07-18 02:32:42pm","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("85","60","AKINOLA GREATNESS","FP782920220718","0.00","2000.00","2022-07-18","2022-07-18 02:27:53pm","ATANSUYI JOSHUA","","");
INSERT INTO fees_deposit_tbl VALUES("84","60","AKINOLA GREATNESS","FP235820220715","0.00","7500.00","2022-07-15","2022-07-15 10:38:26am","ATANSUYI JOSHUA","","");



CREATE TABLE `fees_tbl` (
  `fees_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_group` varchar(50) NOT NULL,
  `session` varchar(50) NOT NULL,
  `term` varchar(50) NOT NULL,
  `amount` double(10,2) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fees_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO fees_tbl VALUES("1","JSS1","2021/2022","1st Term","50000.00","inactive","JOSHUA","2021-08-28","2021-08-28 04:42:42pm","","");
INSERT INTO fees_tbl VALUES("2","JSS2","2021/2022","1st Term","90000.00","inactive","JOSHUA","2021-08-28","2021-08-28 04:48:46pm","","");
INSERT INTO fees_tbl VALUES("3","JSS3","2021/2022","1st Term","100000.00","inactive","JOSHUA","2021-08-29","2021-08-29 04:56:02pm","","");
INSERT INTO fees_tbl VALUES("4","SS1","2021/2022","1st Term","120000.00","inactive","ATANSUYI EMMANUEL SEUN","2021-09-23","2021-09-23 10:11:04pm","","");
INSERT INTO fees_tbl VALUES("5","SS2","2021/2022","1st Term","140000.00","inactive","ATANSUYI EMMANUEL SEUN","2021-09-23","2021-09-23 10:11:48pm","","");
INSERT INTO fees_tbl VALUES("6","SS3","2021/2022","1st Term","150000.00","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 03:38:01am","","");
INSERT INTO fees_tbl VALUES("7","SS3","2021/2022","1st Term","1000.00","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 03:41:00am","","");
INSERT INTO fees_tbl VALUES("8","JSS3","2021/2022","1st Term","40000.00","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 03:50:55am","","");



CREATE TABLE `link_tbl` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_name` varchar(255) NOT NULL,
  `status` varchar(25) NOT NULL,
  `link_icon` varchar(100) NOT NULL,
  `create_by` varchar(255) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO link_tbl VALUES("1","Dashboard","inactive","fas fa-th-large","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:12am","","");
INSERT INTO link_tbl VALUES("2","Settings","active","fas fa-tools","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:21am","","");
INSERT INTO link_tbl VALUES("3","Students","active","fas fa-user-graduate","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:31am","","");
INSERT INTO link_tbl VALUES("4","Teachers","active","fas fa-chalkboard-teacher","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:38am","","");
INSERT INTO link_tbl VALUES("5","Accounts","active","fas fa-file-invoice-dollar","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:44am","","");
INSERT INTO link_tbl VALUES("6","Reports","active","fas fa-building","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:51am","","");
INSERT INTO link_tbl VALUES("7","Promote Student","active","fas fa-user-graduate","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:02:09am","","");
INSERT INTO link_tbl VALUES("8","logout","inactive","fas fa-sign-out-alt","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:02:19am","","");
INSERT INTO link_tbl VALUES("9","Backup","inactive","fas fa-building","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:02:31am","","");
INSERT INTO link_tbl VALUES("10","Salary Advance","inactive","fas fa-user-graduate","ATANSUYI EMMANUEL SEUN","2022-04-14","2022-04-14 07:37:46pm","","");
INSERT INTO link_tbl VALUES("11","Exam Category","inactive","fas fa-building","ATANSUYI EMMANUEL SEUN","2022-05-30","2022-05-30 10:05:50pm","","");



CREATE TABLE `link_useraccess` (
  `permission_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_id` int(11) NOT NULL,
  `sublink_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_permission` varchar(5) NOT NULL,
  `creation_date` date NOT NULL,
  PRIMARY KEY (`permission_id`)
) ENGINE=MyISAM AUTO_INCREMENT=439 DEFAULT CHARSET=latin1;

INSERT INTO link_useraccess VALUES("99","5","19","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("98","5","18","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("97","5","17","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("96","5","16","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("95","5","15","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("94","4","14","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("93","4","13","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("92","4","12","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("91","3","11","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("90","3","10","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("89","3","9","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("88","2","8","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("87","2","7","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("86","2","6","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("85","2","5","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("437","3","30","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("436","4","29","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("435","4","27","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("434","4","26","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("433","4","25","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("432","7","24","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("431","2","22","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("430","2","21","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("429","6","20","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("428","5","19","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("427","5","18","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("426","5","17","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("425","5","16","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("424","5","15","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("423","4","14","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("422","4","13","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("421","4","12","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("420","3","11","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("419","3","10","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("418","3","9","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("100","6","20","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("84","2","4","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("83","2","3","2","True","2022-04-13");
INSERT INTO link_useraccess VALUES("82","2","2","2","True","2022-04-13");
INSERT INTO link_useraccess VALUES("81","2","1","2","True","2022-04-13");
INSERT INTO link_useraccess VALUES("101","2","1","4","True","2022-04-14");
INSERT INTO link_useraccess VALUES("102","2","2","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("103","2","3","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("104","2","4","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("105","2","5","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("106","2","6","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("107","2","7","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("108","2","8","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("109","3","9","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("110","3","10","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("111","3","11","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("112","4","12","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("113","4","13","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("114","4","14","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("115","5","15","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("116","5","16","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("117","5","17","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("118","5","18","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("119","5","19","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("120","6","20","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("141","2","1","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("142","2","2","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("143","2","3","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("144","2","4","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("145","2","5","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("146","2","6","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("147","2","7","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("148","2","8","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("149","3","9","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("150","3","10","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("151","3","11","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("152","4","12","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("153","4","13","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("154","4","14","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("155","5","15","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("156","5","16","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("157","5","17","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("158","5","18","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("159","5","19","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("160","6","20","9","False","2022-04-21");
INSERT INTO link_useraccess VALUES("417","2","8","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("416","2","7","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("415","2","6","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("414","2","5","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("251","2","1","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("252","2","2","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("253","2","3","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("254","2","4","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("255","2","5","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("256","2","6","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("257","2","7","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("258","2","8","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("259","3","9","20","True","2022-06-13");
INSERT INTO link_useraccess VALUES("260","3","10","20","True","2022-06-13");
INSERT INTO link_useraccess VALUES("261","3","11","20","True","2022-06-13");
INSERT INTO link_useraccess VALUES("262","4","12","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("263","4","13","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("264","4","14","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("265","5","15","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("266","5","16","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("267","5","17","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("268","5","18","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("269","5","19","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("270","6","20","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("271","7","24","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("272","4","25","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("273","4","26","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("274","4","27","20","False","2022-06-13");
INSERT INTO link_useraccess VALUES("413","2","4","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("412","2","3","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("301","2","1","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("302","2","2","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("303","2","3","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("304","2","4","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("305","2","5","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("306","2","6","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("307","2","7","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("308","2","8","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("309","3","9","24","True","2022-06-14");
INSERT INTO link_useraccess VALUES("310","3","10","24","True","2022-06-14");
INSERT INTO link_useraccess VALUES("311","3","11","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("312","4","12","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("313","4","13","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("314","4","14","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("315","5","15","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("316","5","16","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("317","5","17","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("318","5","18","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("319","5","19","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("320","6","20","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("321","2","21","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("322","2","22","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("323","7","24","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("324","4","25","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("325","4","26","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("326","4","27","24","False","2022-06-14");
INSERT INTO link_useraccess VALUES("411","2","2","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("410","2","1","1","True","2022-07-11");
INSERT INTO link_useraccess VALUES("438","4","31","1","True","2022-07-11");



CREATE TABLE `options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question_number` int(11) NOT NULL,
  `is_correct` tinyint(1) NOT NULL DEFAULT '0',
  `options` text NOT NULL,
  `category` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=202 DEFAULT CHARSET=latin1;

INSERT INTO options VALUES("201","11","0","9","Home Economics");
INSERT INTO options VALUES("200","11","0","7","Home Economics");
INSERT INTO options VALUES("199","11","1","6","Home Economics");
INSERT INTO options VALUES("198","11","0","8","Home Economics");
INSERT INTO options VALUES("197","10","0","Move","English");
INSERT INTO options VALUES("196","10","0","Go","English");
INSERT INTO options VALUES("195","10","0","Sit","English");
INSERT INTO options VALUES("194","10","1","Table","English");
INSERT INTO options VALUES("193","9","1","3","Mathematics");
INSERT INTO options VALUES("192","9","0","9","Mathematics");
INSERT INTO options VALUES("191","9","0","1","Mathematics");
INSERT INTO options VALUES("190","9","0","2","Mathematics");
INSERT INTO options VALUES("189","8","0","3","Mathematics");
INSERT INTO options VALUES("188","8","0","2","Mathematics");
INSERT INTO options VALUES("187","8","0","1","Mathematics");
INSERT INTO options VALUES("186","8","1","0","Mathematics");
INSERT INTO options VALUES("185","7","0","9","Mathematics");
INSERT INTO options VALUES("184","7","1","5","Mathematics");
INSERT INTO options VALUES("183","7","0","8","Mathematics");
INSERT INTO options VALUES("182","7","0","2","Mathematics");
INSERT INTO options VALUES("181","6","0","12","");
INSERT INTO options VALUES("180","6","0","52","");
INSERT INTO options VALUES("179","6","1","7","");
INSERT INTO options VALUES("178","6","0","9","");
INSERT INTO options VALUES("177","5","0","23","Mathematics");
INSERT INTO options VALUES("176","5","0","5","Mathematics");
INSERT INTO options VALUES("175","5","0","3","Mathematics");
INSERT INTO options VALUES("174","5","1","2","Mathematics");
INSERT INTO options VALUES("173","4","0","9","");
INSERT INTO options VALUES("172","4","1","7","");
INSERT INTO options VALUES("171","4","0","9","");
INSERT INTO options VALUES("170","4","0","1","");
INSERT INTO options VALUES("169","3","0","2","");
INSERT INTO options VALUES("168","3","1","5","");
INSERT INTO options VALUES("167","3","0","6","");
INSERT INTO options VALUES("166","3","0","7","");
INSERT INTO options VALUES("165","2","0","7","");
INSERT INTO options VALUES("164","2","0","22","");
INSERT INTO options VALUES("163","2","0","20","");
INSERT INTO options VALUES("162","2","1","11","");
INSERT INTO options VALUES("161","1","0","8","Mathematics");
INSERT INTO options VALUES("160","1","0","6","Mathematics");
INSERT INTO options VALUES("159","1","0","3","Mathematics");
INSERT INTO options VALUES("158","1","1","2","Mathematics");



CREATE TABLE `parent_tbl` (
  `par_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(100) NOT NULL,
  `std1` varchar(255) DEFAULT NULL,
  `std2` varchar(255) DEFAULT NULL,
  `std3` varchar(255) DEFAULT NULL,
  `std4` varchar(255) DEFAULT NULL,
  `creation_date` date NOT NULL,
  `created_by` varchar(100) NOT NULL,
  `updated_by` varchar(100) DEFAULT NULL,
  `update_dt` date DEFAULT NULL,
  PRIMARY KEY (`par_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO parent_tbl VALUES("5","adeniyi","adeniyi@gmail.com","123seun","GWS87084","GWS24049","GWS76412","GWS55456","2022-07-12","ATANSUYI JOSHUA","","");
INSERT INTO parent_tbl VALUES("8","joshua","joshua_atansuyi@yahoo.com","joshua123","GWS93073","","","","2022-09-04","ATANSUYI JOSHUA","","");



CREATE TABLE `payment_tbl` (
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) DEFAULT NULL,
  `student_name` varchar(200) DEFAULT NULL,
  `pay_ref` varchar(255) DEFAULT NULL,
  `session` varchar(50) NOT NULL,
  `term` varchar(50) NOT NULL,
  `mop` varchar(100) DEFAULT NULL,
  `fee_code` varchar(11) DEFAULT NULL,
  `debit` double(10,2) NOT NULL,
  `discount` double(10,2) NOT NULL,
  `credit` double(10,2) NOT NULL,
  `payment_category` varchar(100) DEFAULT NULL,
  `class_group` varchar(50) NOT NULL,
  `class_name` varchar(50) DEFAULT NULL,
  `creation_date` date DEFAULT NULL,
  `date_time` varchar(255) DEFAULT NULL,
  `narration` varchar(255) DEFAULT NULL,
  `status1` varchar(20) DEFAULT NULL,
  `status2` varchar(20) DEFAULT NULL,
  `create_by` varchar(50) DEFAULT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`p_id`)
) ENGINE=MyISAM AUTO_INCREMENT=932 DEFAULT CHARSET=latin1;

INSERT INTO payment_tbl VALUES("930","58","ABDULSALAM NIMAAT","FP935620220718","2021/2022","1st Term","Cash","","0.00","0.00","1000.00","Tuition Fee-First Term","JSS1","JSS1A","2022-07-18","2022-07-18 05:28:14pm","payment for tuition fees","","undelete","ATANSUYI JOSHUA","","");
INSERT INTO payment_tbl VALUES("931","60","AKINOLA GREATNESS","FP9020220727","2021/2022","1st Term","","","11500.00","2000.00","0.00","Tuition Fee-First Term","JSS1","JSS1A","2022-07-27","2022-07-27 08:17:09pm","","","undelete","ATANSUYI JOSHUA","","");
INSERT INTO payment_tbl VALUES("928","58","ABDULSALAM NIMAAT","FP8420220718","2021/2022","1st Term","","","10000.00","3500.00","0.00","Tuition Fee-First Term","JSS1","JSS1A","2022-07-18","2022-07-18 05:19:02pm","","","undelete","ATANSUYI JOSHUA","","");



CREATE TABLE `questions` (
  `question_number` int(11) NOT NULL,
  `question_text` text NOT NULL,
  `category` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`question_number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO questions VALUES("11","4+2","Home Economics");
INSERT INTO questions VALUES("10","Example of Noun is ","English");
INSERT INTO questions VALUES("9","5-2","Mathematics");
INSERT INTO questions VALUES("8","2-2=?","Mathematics");
INSERT INTO questions VALUES("7","6-1=?","Mathematics");
INSERT INTO questions VALUES("6","5+2","");
INSERT INTO questions VALUES("5","1+1=?","Mathematics");
INSERT INTO questions VALUES("4","10-3=?","");
INSERT INTO questions VALUES("3","4+1=?","");
INSERT INTO questions VALUES("2","5+6=?","");
INSERT INTO questions VALUES("1","1+1=?","Mathematics");



CREATE TABLE `questions2` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `question_no` varchar(60) NOT NULL,
  `question` varchar(500) NOT NULL,
  `opt1` varchar(100) NOT NULL,
  `opt2` varchar(100) NOT NULL,
  `opt3` varchar(100) NOT NULL,
  `opt4` varchar(100) NOT NULL,
  `answer` varchar(100) NOT NULL,
  `category` varchar(100) NOT NULL,
  `class_group` varchar(100) NOT NULL,
  `session` varchar(100) NOT NULL,
  `term` varchar(100) NOT NULL,
  `active` varchar(25) NOT NULL,
  `date_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;

INSERT INTO questions2 VALUES("78","2","What is a verb?","An action word","A verb is used instead of a noun","A verb is a name of a person","A verb is used instead of an adverb","An action word","English","JSS1","2021/2022","3rd Term","active","2022-06-20 13:16:19");
INSERT INTO questions2 VALUES("77","1","What is a noun?","name of any person, animal, place or thing","an action word","a word used instead of a verb","is a pronoun prefix","name of any person, animal, place or thing","English","JSS1","2021/2022","3rd Term","active","2022-06-20 13:14:17");
INSERT INTO questions2 VALUES("74","1","1+1=?","2","3","4","5","2","Mathematics","JSS1","2021/2022","3rd Term","active","2022-06-01 11:34:31");
INSERT INTO questions2 VALUES("76","3","33+33=?","66","77","88","99","66","Mathematics","JSS1","2021/2022","3rd Term","active","2022-06-17 16:29:01");
INSERT INTO questions2 VALUES("75","2","2+3=?","23","5","8","32","5","Mathematics","JSS1","2021/2022","3rd Term","active","2022-06-01 11:35:06");



CREATE TABLE `school_tbl` (
  `sch_id` int(11) NOT NULL AUTO_INCREMENT,
  `sch_name` varchar(100) NOT NULL,
  `status` varchar(50) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`sch_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO school_tbl VALUES("1","Creche/Kindergaten","inactive","JOSHUA","2021-09-04","2021-09-04 09:17:13pm","","");
INSERT INTO school_tbl VALUES("2","Nursery/Primary","active","JOSHUA","2021-09-04","2021-09-04 09:19:42pm","ATANSUYI EMMANUEL SEUN","2021-09-25 01:53:15pm");
INSERT INTO school_tbl VALUES("3","Secondary","active","JOSHUA","2021-09-04","2021-09-04 09:21:55pm","","");
INSERT INTO school_tbl VALUES("4","University","inactive","ATANSUYI EMMANUEL SEUN","2022-04-08","2022-04-08 12:05:01pm","","");



CREATE TABLE `session_tbl` (
  `se_id` int(11) NOT NULL AUTO_INCREMENT,
  `sch_session` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`se_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO session_tbl VALUES("1","2021/2022","active","JOSHUA","2021-08-27","2021-08-27 05:41:34am","","");
INSERT INTO session_tbl VALUES("2","2022/2023","inactive","ATANSUYI EMMANUEL SEUN","2021-09-17","2021-09-17 08:18:26pm","ATANSUYI EMMANUEL SEUN","2022-04-10 10:08:33pm");



CREATE TABLE `student_tbl` (
  `std_id` int(11) NOT NULL AUTO_INCREMENT,
  `app_number` varchar(255) NOT NULL,
  `firstname` varchar(100) NOT NULL,
  `surname` varchar(100) NOT NULL,
  `othername` varchar(100) NOT NULL,
  `studentid` varchar(100) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `dob` date NOT NULL,
  `school` varchar(100) DEFAULT NULL,
  `def_class_group` varchar(200) NOT NULL,
  `def_class_name` varchar(200) NOT NULL,
  `class_group` varchar(100) NOT NULL,
  `class_name` varchar(10) NOT NULL,
  `religion` varchar(50) NOT NULL,
  `state` varchar(100) DEFAULT NULL,
  `joining_date` date NOT NULL,
  `session` varchar(50) NOT NULL,
  `student_image` varchar(255) NOT NULL,
  `fathername` varchar(50) NOT NULL,
  `fatheroccupation` varchar(100) NOT NULL,
  `fathernumber` varchar(11) NOT NULL,
  `fatheremail` varchar(255) NOT NULL,
  `mothername` varchar(50) NOT NULL,
  `motheroccupation` varchar(100) NOT NULL,
  `mothernumber` varchar(11) NOT NULL,
  `motheremail` varchar(255) NOT NULL,
  `preaddress` varchar(255) NOT NULL,
  `peraddress` varchar(255) NOT NULL,
  `creation_date` date NOT NULL,
  `create_by` varchar(255) DEFAULT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  `fee_status` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`std_id`)
) ENGINE=MyISAM AUTO_INCREMENT=256 DEFAULT CHARSET=latin1;

INSERT INTO student_tbl VALUES("62","GWS87084","OKIKI","ADEBAYO","AYOMIDE","GWS87084","Male","2008-12-18","Secondary","JSS2","JSS2A","JSS2","JSS2A","ISLAM","","2020-01-01","2021/2022","OKIKI ADEBAYO.png","ADEBAYO","TRADING","","","ADEBAYO","TRADING","08133540970","","4, UNITY STR., HSB  BUS STOP, MATOGUN, OGUN STATE.","4, UNITY STR., HSB  BUS STOP, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("63","GWS24049","FAVOUR","EMMANUEL","IKENEBO","GWS24049","Female","2011-06-26","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","2020-09-02","2021/2022","FAVOUR EMMANUEL IKENEBO.png","EMMANUELJONES","BUSINESS","","","BLESSING EMMANUEL","BUSINESS","08109681002","","3, OFF ADELANI HOUSE, MATOGUN, OGUN STATE.","3, OFF ADELANI HOUSE, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("61","GWS76412","OLATUNBOSUN","OGUNJOBI","OLAMILEKAN","GWS76412","Male","2010-05-04","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","0001-01-01","2021/2022","OLATUNBOSUN OGUNJOBI.png","OGUNJOBI","BUSINESS","09163188495","","OGUNJOBI","TRADING","09063133445","","DAMILOLA BLOCK, OFF OSERE ROAD, MATOGUN, OGUN STATE.","DAMILOLA BLOCK, OFF OSERE ROAD, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("60","GWS71802","GREATNESS","AKINOLA","FIYINFOLUWA","GWS71802","Female","0001-01-01","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","2021-09-01","2021/2022","AKINOLA GREATNESS.jpeg","AKINOLA MICHAEL","CIVIL SERVANT","08032004989","AKINOLAMOLL@GMAIL.COM","AKINOLA CHRISTIANAH","BUSINESS","08036802606","","1, IREPODUN STR. OFF GAS LINE, MATOGUN, OGUN STATE.","1, IREPODUN STR. OFF GAS LINE, MATOGUN, OGUN STATE.","2022-06-05","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("59","GWS70309","OLIVIA","BEN AYANRU","OPEMIPOSI","GWS70309","Female","2012-03-21","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","2021-09-01","2021/2022","userimage.png","BENARD AYANRU","BANKER","08023504222","","ABIOLA AYANRU","BUSINESS","08033869235","","51, IRANLOWO OLUWA LANE, OSERE, MATOGUN, OGUN STATE","51, IRANLOWO OLUWA LANE, OSERE, MATOGUN, OGUN STATE","2022-06-05","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("58","GWS93073","NIMAAT","ABDULSALAM","MOTUNRAYO","GWS93073","Female","2012-04-04","Secondary","JSS1","JSS1A","JSS1","JSS1A","ISLAM","","2021-09-01","2021/2022","ABDUSALAM NIMOT.jpeg","ABDULSALAM","PRINTING","","","ABDULSALAM","FASHION DESIGNER","08087855953","","2, IREPODUN STR. OFF GAS LINE, MATOGUN, OGUN STAE","2, IREPODUN STR. OFF GAS LINE, MATOGUN, OGUN STAE","2022-06-05","ATANSUYI EMMANUEL SEUN","ATANSUYI JOSHUA","2022-08-19","applicable");
INSERT INTO student_tbl VALUES("57","GWS34395","SHINAAYOMI","OLOWONYO","MOYINOLUWA","GWS34395","Male","2011-02-19","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","2021-09-13","2021/2022","profile.png","OLOWONYO TEMIDAYO","ENGINEERING","08028329064","TEMIDAYOJOSHUA70@YAHOO.COM","OLOWONYO TOLANI","TEACHING","08084628735","TOLANIOLOWONYO130@GMAIL.COM","3, DELE AKINTOKUN STR. OWOSENI BLOCK, MATOGUN, OGUN STATE","3, DELE AKINTOKUN STR. OWOSENI BLOCK, MATOGUN, OGUN STATE","2022-06-05","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("51","GWS20590","GLORY","NATHANIEL","UDUAKOBONG","GWS20590","Female","2011-05-21","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","2021-09-01","2021/2022","GLORY NATHANIEL.jpeg","UDUAKOBONG NATHANIEL","BUSINESS","08101190629","","BLESSING NATHANIEL","BUSINESS","08106897380","","3, OLUREMI, SABAINAI STR. FOURSQUARE, MATOGUN, OGUN STATE","3, OLUREMI, SABAINAI STR. FOURSQUARE, MATOGUN, OGUN STATE","2022-06-04","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-07-03","applicable");
INSERT INTO student_tbl VALUES("52","GWS75693","TOBILOBA","AIYEYEMI","BENJAMIN","GWS75693","Male","2011-07-05","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","2021-09-01","2021/2022","AIYEYEMI.jpeg","AIYEYEMI TAIWO","BUSINESS","08060426363","","AIYEYEMI ABOSEDE","HAIRDRESSER","08032526319","ABOSEDEAIYEYEMI@GMAIL.COM","16, IREPODUN STR. ADELANI ROAD, MATOGUN, OGUN STATE","16, IREPODUN STR. ADELANI ROAD, MATOGUN, OGUN STATE","2022-06-04","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("53","GWS54774","ZAAD","ALAUSA","OLAYINWOLA","GWS54774","Male","0001-01-01","Secondary","JSS1","JSS1A","JSS1","JSS1A","ISLAM","","2021-09-01","2021/2022","ALAUSA ZAAD.jpeg","MR. ALAUSA","CIVIL SERVANT","07048581510","ALAUSA@YAHOO.COM","MRS. ALAUSA","HAIRDRESSING","08096147115","ALAUSA@YAHOO.COM","18, UNITY STREET, MATOGUN, OGUN STATE.","18, UNITY STREET, MATOGUN, OGUN STATE.","2022-06-04","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("54","GWS88442","ABIGAIL","MOSUDI","TITILAYO","GWS88442","Female","2011-11-03","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","2021-09-01","2021/2022","ABIGAEL.jpeg","MOSUDI ADESEGUN","ACCOUNTANT","08027544731","","MOSUDI","NURSING","08025358169","","17, ALHAJI JAMH STR. OFF SHOLOLA, IJEJA MATOGUN, OGUN STATE.","17, ALHAJI JAMH STR. OFF SHOLOLA, IJEJA MATOGUN, OGUN STATE.","2022-06-05","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-05","applicable");
INSERT INTO student_tbl VALUES("55","GWS21318","RACHAEL","OMONIYI","OMOWUNMI","GWS21318","Female","2011-08-04","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","2021-09-01","2021/2022","RACHAEL.jpeg","OMONIYI GBENGA","ENGINEERING","08038331221","","OMONIYI AJOKE","TEACHING","08026544285","","3, CAC STREET, MATOGUN, OGUN STATE","3, CAC STREET, MATOGUN, OGUN STATE","2022-06-05","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("56","GWS58976","FATIMO","SHODAMOLA","OMOBONIKE","GWS58976","Female","2010-03-28","Secondary","JSS1","JSS1A","JSS1","JSS1A","ISLAM","","2021-09-01","2021/2022","SHODAMOLA PATRICK.jpeg","SHODAMOLA KEHINDE","DRIVING","08024398375","","SHODAMOLA KAFAYAT","BUSINESS","08126063270","","8, AYOFE STR. MATOGUN, OGUN STATE.","8, AYOFE STR. MATOGUN, OGUN STATE.","2022-06-05","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("64","GWS29131","OMOTOLA","ADEPEGBA","ELIZABETH","GWS29131","Female","0001-01-01","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","0001-01-01","2021/2022","ELIZABETH ADEGBEGBA.jpeg","ADEPEGBA KEHINDE JULIUS","TEACHING","08054304924","KEHINDEJULIUSADEPEGBA@GMAIL.COM","ADEPEGBA","FARMING","08038372129","OMOWUNMIOLOWU77@GMAIL.COM","2, ABIOLA OMO-OLORUN STR. MATOGUN, OGUN STATE.","2, ABIOLA OMO-OLORUN STR. MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("65","GWS28898","ITUNU","POPOOLA","OPEYEMI","GWS28898","Female","2010-06-04","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","2020-09-27","2021/2022","POPOOLA ITUNU.jpeg","ADEBAYO POPOOLA","MECHANICAL ENGINEERING","08028416595","","OLABISI POPOOLA","SEAMSTRESS","08099312069","OLABISIPOPOOLA@GMAIL.COM","5, OYINDUN STR.,  OFF GASLINE, MATOGUN, OGUN STATE.","5, OYINDUN STR.,  OFF GASLINE, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("66","GWS76736","SULAIMON","YISA","AYOMIDE","GWS76736","Male","2011-06-15","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","0001-01-01","2021/2022","YISA SULAIMON.jpeg","YISA GANIU","BUSINESS","08168556781","","YISA DESOLA","TRADING","08171731380","","3, RAIWO, ABAYOMI STREET, MATOGUN, OGUN STATE.","3, RAIWO, ABAYOMI STREET, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("67","GWS75816","LILIAN","EZEAMANSOR","N/A","GWS75816","Female","2010-06-15","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","0001-01-01","2021/2022","LILIAN EZE AMANSOR.png","EZEAMANSOR ANTHONY","BUSINESS","08033444467","IFEZDIVINE@GMAIL.COM","EZEAMANSOR JULIET","TEACHING","07033840618","","15, OMOWUNMI STR.,OFF GASLINE ROAD,  MATOGUN, OGUN STATE.","15, OMOWUNMI STR.,OFF GASLINE ROAD,  MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("68","GWS86188","OPEYEMI","ONI","LAWRENCE","GWS86188","Male","2010-07-04","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","2020-09-01","2021/2022","ONI OPEYEMI.jpeg","ONI ADELOYE","BUILDING CONTRACTING","08067523766","ONIADELOYE@GMAIL.COM","ONI BUSAYO","FASHION DESIGNER","09168219565","ONIBUSAYO@GMAIL.COM","21, ADEDOYIN STR., MATOGUN, OGUN STATE.","OLUKE STR., MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("69","GWS55456","BOLUWATIFE","MICHAEL","ADEKUNLE","GWS55456","Male","2009-10-29","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","0001-01-01","2021/2022","ADEKUNLE BOLUWATIFE.jpeg","ADEKUNLE KEHINDE","BUSINESS","08031164098","KENNYMORE44@GMAIL.COM","ADEKUNLE JOKE","TRADING","08020515777","JOSSYISIWAT@GMAIL.COM","12, UNITY STR.,OFF ASB BUS STOP, MATOGUN, OGUN STATE.","12, UNITY STR.,OFF ASB BUS STOP, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("70","GWS15212","JOMILOJU","SANNI","OLORUNWA","GWS15212","Male","2011-07-19","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","0001-01-01","2021/2022","SANNI JOMILOJU.jpeg","SANNI","BUSINESS","","","SANNI","BUSINESS","08062539199","","N/A","N/A","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("71","GWS24786","OPEYEMI","SHODEHINDE","DEBORAH","GWS24786","Female","2010-06-13","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","2021-04-10","2021/2022","OPEYEMI SHODEHINDE.png","SHODEHINDE ANUOLUWAPO, PAUL","FURNITURE","07060920293","SHODEHINDEPAUL@GMAIL.COM","SHODEHINDE OLUWASEUN","HAIRDRESSING AND MAKE UP ARTIST","08065638600","SHODEHINDEOLUWASEUN@GMAIL.COM","7, IREDE STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","7, IREDE STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("72","GWS21777","JOSHUA","ADEBAYO","OPEYEMI","GWS21777","Male","2009-01-22","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","2021-09-02","2021/2022","JOSHUA ADEBAYO.jpeg","ADEBAYO","FURNITURE","08036802835","","ADEBAYO JUSTINA","BULDING MATERIALS SELLER","08068169166","","6, UNITY CLOSE, OFF GASLINE ASB, MATOGUN, OGUN STATE.","6, UNITY CLOSE, OFF GASLINE ASB, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("73","GWS38613","TESTIMONY","OLASUPO","EYITOPE","GWS38613","Female","2010-05-21","Secondary","JSS2","JSS2A","JSS2","JSS2A","CHRISTIANITY","","2020-09-29","2021/2022","TESTIMONY OLASUPO.png","OLASUPO SUNDAY","CLERGY","08033355272","OLASUPOSUNDAY6@GMAIL.COM","OLASUPO VICTORIA","EVANGELISM","","","8, AJAYI CRESCENT, OFF TEMITOPE STR., MATOGUN, OGUN STATE.","8, AJAYI CRESCENT, OFF TEMITOPE STR., MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("74","GWS53949","OLAMIDE","IGE","MARY","GWS53949","Female","2009-06-27","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","0001-01-01","2021/2022","IGE OLAMIDE.jpg","IGE OLUWAFEMI","AIRFORCE","","","IGE MOTUNRAYO","TRADING","08123846736","","5, AYANBI STR., OFF GASLINE, HAVILLAH ESTATE, OGUN STATE.","5, AYANBI STR., OFF GASLINE, HAVILLAH ESTATE, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("75","GWS00950","KARIMOT","TAOHEED","ODUNAYO","GWS00950","Female","2008-11-30","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","2019-01-01","2021/2022","TAOHEED KARIMOT.jpg","TAOHEED AKINADE","","","TAOTECH280@GMAIL.COM","TAOHEED","TRADING","09065234955","","2, IREDE STR., OFF GASLINE, MATOGUN, OGUN STATE.","2, IREDE STR., OFF GASLINE, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("76","GWS17689","CHRISTIAN","EKPO","SAMUEL","GWS17689","Male","2009-06-19","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","0001-01-01","2021/2022","EKPO CHRISTIAN.jpg","FRIDAY REUBEN EKPO","FARMING","08148215543","","EKPO","TRADING","09050449543","","7, AREOLA STR., SURU BLOCK, ADELANI BUS STOP, MATOGUN, OGUN STATE.","7, AREOLA STR., SURU BLOCK, ADELANI BUS STOP, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("77","GWS75476","AYOMIKUN","ADEDOYIN","AMINAT","GWS75476","Female","2010-09-27","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","2019-01-01","2021/2022","AYOMIKUN ADEDOYIN.jpg","ADEDOYIN KAZEEM LAMIDI","ENTREPRENEUR","08100975775","ADEKAZZY2001@YAHOO.COM","ADEDOYIN ADEOLA TAIWO","TRADING","08088813252","ADEOLA-ADEJUMO@YAHOO.COM","28, JAMES AJAYI STR., ISHAGA, MATOGUN, OGUN STATE.","28, JAMES AJAYI STR., ISHAGA, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("78","GWS95119","JAMAL","ALAUSA","OLAWOYIN","GWS95119","Male","2009-10-01","Secondary","JSS3","JSS3A","JSS3","JSS3A","ISLAM","","2018-09-01","2021/2022","ALAUSA JEMAL.jpg","ALAUSA","CIVIL SERVANT","07048581510","ALAUSA@YAHOO.COM","ALAUSA","HAIRDRESSING","08096147115","","18, UNITY STR., MATOGUN, OGUN STATE","18, UNITY STR., MATOGUN, OGUN STATE","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("79","GWS45879","QAWIYY","AFOLARIN","ADEBAYO","GWS45879","Male","2009-10-28","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","2020-09-20","2021/2022","AFOLARIN QUWYY.jpg","AFOLARIN ABIMBOLA","MECHANICAL ENGINEERING","08023897340","","AFOLARIN IYABO","PHOTOGRAPHER","08036165832","","6, SAMUEL AJANI  STR.,  MATOGUN, OGUN STATE.","6, SAMUEL AJANI  STR.,  MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("80","GWS43029","AYOMIDE","RASAK","OLAWALE","GWS43029","Male","2009-03-25","Secondary","JSS3","JSS3A","JSS3","JSS3A","ISLAM","","2011-01-01","2021/2022","RASAK AYOMIDE.jpg","RASAK MUTICE","ENGINEERING","08023687081","","RASAK ABOSEDE","TRADING","08035654072","","14, NEWTON STR., ILAWAGBON CRESCENT, ADELANI BUS STOP, MATOGUN, OGUN STATE.","14, NEWTON STR., ILAWAGBON CRESCENT, ADELANI BUS STOP, MATOGUN, OGUN STATE.","2022-06-06","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("81","GWS02414","DEBRA","BEN-AYANRU","ATINUKE","GWS02414","Female","2010-07-21","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","0001-01-01","2021/2022","DEBRA BEN-AYANRU.png","AYANRU BENARD","BANKER","08023504222","","AYANRU ABIOLA","BUSINESS","08033869235","","51, IRANLOWO OLUWA LANE, OSERE, MATOGUN OGUN STATE.","51, IRANLOWO OLUWA LANE, OSERE, MATOGUN OGUN STATE.","2022-06-07","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("82","GWS82798","ROKIBAT","ISA","OLUWATOYIN","GWS82798","Female","2008-01-22","Secondary","JSS3","JSS3A","JSS3","JSS3A","ISLAM","","2019-09-01","2021/2022","ISA ROKIBAT.jpg","ISA SIKURULAH","BUSINESS","","","ISA AMUDALAT","TRADING","08087594540","","N/A","N/A","2022-06-07","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("83","GWS78064","DEBORAH","ENEMARE","OMOYEME","GWS78064","Female","2009-04-30","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","2019-09-01","2021/2022","ENEMARE DEBORAH.jpg","ENEMARE STEPHEN","WELDERING","08023050509","","ENEMARE STEPHEN","TRADING","09072828419","","N/A","N/A","2022-06-07","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("84","GWS59641","TEMILOLUWA","ADEPEGBA","DEBORAH","GWS59641","Female","2009-07-11","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","2020-09-28","2021/2022","ADEPEGBA TEMILOLUWA.jpg","ADEPEGBA KEHINDE","TEACHING","08054304927","KEHINDEJULIUSADEPEGBA@GMAIL.COM","ADEGBEGBA","FARMING","08038372129","OMOWUNMIOLOWU77@GMAIL.COM","2, DEVOLA OLORUN STR., MATOGUN, OGUN STATE.","2, DEVOLA OLORUN STR., MATOGUN, OGUN STATE.","2022-06-07","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("85","GWS29314","CHRISTIANA","ADESINA","OLUWASEUN","GWS29314","Female","2009-05-13","Secondary","JSS3","JSS3A","JSS3","JSS3A","CHRISTIANITY","","0001-01-01","2021/2022","ADESINA CHRISTIANAH.jpg","ADESINA SOLOMON","CONTRACTOR","07062937227","","RACHAEL ADESINA","TRADING","08064428660","","3, KOFOSI CLOSE, OFF SURU BLOCK, ADELANI HOUSE, MATOGUN, OGUN STATE.","3, KOFOSI CLOSE, OFF SURU BLOCK, ADELANI HOUSE, MATOGUN, OGUN STATE.","2022-06-07","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("86","GWS91837","FARUQ","AKINBODE","OLAMILEKAN","GWS91837","Male","2007-09-01","Secondary","JSS3","JSS3A","JSS3","JSS3A","ISLAM","","0001-01-01","2021/2022","FARUQ AKINBODE.jpg","AKINBODE WASIU","MECHANICAL ENGINEERING","08023169700","","ADEJUWON FATIMO","BUSINESS","09094998844","","2, FADASE LION CASHE STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","2, FADASE LION CASHE STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","2022-06-07","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("87","GWS24170","IBUKUN","AIYEYEMI","SAMUEL","GWS24170","Male","2008-10-06","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2011-01-01","2021/2022","IBUKUN AIYEYEMI.png","AIYEYEMI TAIWO","BUSINESS","08060426363","","AIYEYEMI ABOSEDE","HAIRDRESSING","08032526319","ABOSEDEAIYEYEMI@GMAIL.COM","16, IREPODUN STR., ADELANI RAOD, OFF GASLINE, OGUN STATE.","16, IREPODUN STR., ADELANI RAOD, OFF GASLINE, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("88","GWS61969","PURPOSE","OSAGIE","ESOSA","GWS61969","Female","0001-04-21","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","OSAGIE PURPOSE.jpeg","CHRISTOPHER OSAGIE","AVIATOR","08176690991","","FUNMILAYO OSAGIE","CIVIL SERVANT","07084415182","","3, MARTINS, ONI STR., HAVILAH EST., MATOGUN EXTENSION, VIA OKE-ARO, OGUN STATE","3, MARTINS, ONI STR., HAVILAH EST., MATOGUN EXTENSION, VIA OKE-ARO, OGUN STATE","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("89","GWS53244","EMMANUEL","MOSUDI","TOBILOBA","GWS53244","Male","2008-12-23","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2011-01-01","2021/2022","MOSHOOD.jpeg","MOSUDI ADESEGUN","ACCOUNTANT","08027544731","","MOSUDI ADETAYO","NURSING","08025358169","","17, ALHAJI JAMIU STR., OFF SHOLOLA, IJEJA, MATOGUN, OGUN STATE.","17, ALHAJI JAMIU STR., OFF SHOLOLA, IJEJA, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("90","GWS91347","BALIKIS","YISA","OLUWAFERANMI","GWS91347","Female","2009-04-18","Secondary","SSS1","SSS1A","SSS1","SSS1A","ISLAM","","0001-01-01","2021/2022","BALIKIS YISA FERANMI.png","YISA GANIYU","ENGINEERING","08168556781","","YISA ADESOLA","BUSINESS","08171731380","DESOLAYISAAGBAJE@GMAIL.COM","3, TAIWO ABAYOMI STR., OFF GASLINEE, MATOGUN, OGUN STATE.","3, TAIWO ABAYOMI STR., OFF GASLINEE, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("91","GWS02668","BLESSING","ONI","OLUWAFERANMI","GWS02668","Male","2007-09-09","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","BLESSING ONI.png","ONI ADELOYE","BUILDING CONTRACTING","08067523766","ONIADELOYE@GMAIL.COM","ONI BUSAYO","FASHION DESIGNING","09168219565","ONIBUSAYO@GMAIL.COM","21, ADEDOYIN STR., MATOGUN, OGUN STATE.","21, ADEDOYIN STR., MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("92","GWS66596","RUKAYAT","ALAWIYE","AYOMIDE","GWS66596","Female","2007-10-20","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2021-09-01","2021/2022","RUKAYAT ALAWIYE.png","ALAWIYE YUSUF","CIVIL SERVANT","","","ALAWIYE OLUWATOSIN","07040301857","07040301857","","TWINS OLOPADE, IJEJA ROAD, MATOGUN, OGUN STATE.","TWINS OLOPADE, IJEJA ROAD, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("93","GWS98227","TOHEEB","AKINBODE","KOREDE","GWS98227","Male","0001-01-01","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2020-01-01","2021/2022","AKINBODE TOHEEB.jpeg","AKINBODE SAHEED","DRIVING","08105930416","","AKINBODE OMOWUNMI","TRADING","08137542142","OMOWUNMIAKINBODE3@GMAIL.COM","18, UNITY STR., ASB ADELANI ROAD, OFF GASLINE, MATOGUN, OGUN STATE.","18, UNITY STR., ASB ADELANI ROAD, OFF GASLINE, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("94","GWS26270","CHISOM","IHUNNA","DANIELLA","GWS26270","Female","2007-04-13","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","IHENNA CHISON.jpeg","HYCIENT IHUNNA","CIVIL SERVANT","08069687056","IHENNAHYCIENT@GMAIL.COM","OMOTOLA IHENNA","TRADING","09060706392","OMOTOLA4ALPHA@GMAIL.COM","35, OLORUNSOGO STR., OFF IJEJA ROAD, OSERE MATOGUN, OGUN STATE.","35, OLORUNSOGO STR., OFF IJEJA ROAD, OSERE MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("95","GWS05477","PELUMI","AJETUNMOBI","IFEOLUWA","GWS05477","Female","2008-06-16","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2018-01-01","2021/2022","PELUMI.jpeg","OLUWASEUN AJETUNMOBI","BUSINESS  MAN","08142326541","AJETUNMOBIOLUWASEUN@GMAIL.COM","OLUWATEMITOPE AJETUNMOBI","NURSING","09095510277","","27, ASALU STR., OFF GASLINE, OGUN STATE.","27, ASALU STR., OFF GASLINE, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("96","GWS47787","EJIRO","OLAJIDE","OYINDAMOLA","GWS47787","Female","2007-01-22","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2007-01-22","2021/2022","EJIRO OLAJIDE.png","OLAJIDE BOBOLA","BUSINESS","","","OLAJIDE RACHAEL","CIVIL SERVANT","07055437324","","3, ADEROMU ADELAJA STR., MATOGUN, OGUN STATE.","3, ADEROMU ADELAJA STR., MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("97","GWS77495","ANJOLA","AKINOLA","FAITH","GWS77495","Female","2007-11-01","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2018-01-01","2021/2022","AKINOLA ANJOLA.jpeg","AKINOLA MICHAEL","CIVIL SERVANT","08032004989","AKINOLAMOLL@GMAIL.COM","AKINOLA CHRISTIANAH","TRADING","08036802606","","1, IREPODUN STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","1, IREPODUN STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("98","GWS18042","JOSHUA","ENEMARE","SAMUEL","GWS18042","Male","2006-03-19","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2022-01-01","2021/2022","ENEMARE JOSHUA.jpeg","ENEMARE STEPHEN","ENGINEERING","08023050509","","ENEMARE BLESSING","TRADING","09012828419","","N/A","N/A","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("99","GWS17162","VICTOR","MONDAY","GOODLUCK","GWS17162","Male","2007-11-09","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2021-09-01","2021/2022","VICTOR MONDAY.jpeg","MONDAY DUMABUISE","POLICE MAN(FORCES)","","","MONDAY PEACE","FOOD VENDOR","08159070039","","9, ARAROMI, MATOGUN, OGUN STATE.","9, ARAROMI, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("100","GWS78242","ALIMON","WALIU","MORENIKEJI","GWS78242","Female","2006-03-25","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2022-02-02","2021/2022","WALIU MORENIKEJI.jpeg","WALIU","BRICKLAYER","08054293355","","WALIU OPEYEMI","HAIRDRESSING","07085523645","","9, JAIYEOBA STR. OF ADELANI HOUSE, MATOGUN ROAD, OGUN STATE.","9, JAIYEOBA STR. OF ADELANI HOUSE, MATOGUN ROAD, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("101","GWS25245","OLUWASUNMISOLA","RAJI","ADEOLA","GWS25245","Female","2008-02-13","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2009-01-01","2021/2022","RAJI ADEOLA.png","RAJI OLAJIDE","JOURNALIST","","","RAJI OLADAYO","TRADING","08035714392","","5, SHODUNKE STR., OFF GASLINE, MATOGUN ROAD, OGUN STATE.","5, SHODUNKE STR., OFF GASLINE, MATOGUN ROAD, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("102","GWS34748","GBOLAHAN","FADASE","CHRISTOPHER","GWS34748","Male","2007-04-18","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","FADASE GBOLAHAN.jpeg","FADASE ABIODUN","BUSINESS","08132994601","","FADASE MERCY","BUSINESS","08164105520","","1, FADASE ABIODUN, OFF GASLINE, ADELANI BUS STOP, MATOGUN ROAD, OGUN STATE.","1, FADASE ABIODUN, OFF GASLINE, ADELANI BUS STOP, MATOGUN ROAD, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("103","GWS97477","ALIAT","ABDULSALAM","OMOBOLAJI","GWS97477","Female","2008-12-24","Secondary","SSS1","SSS1A","SSS1","SSS1A","ISLAM","","0001-01-01","2021/2022","ABDUSALAM ALIAT.jpeg","ABDULSALAM","PRINTING","","","ABDULSALAM","FASHION DESIGNING","08087855953","","2, IREPODUN STR., OFF GASLINE, MATOGUN, OGUN STATE.","2, IREPODUN STR., OFF GASLINE, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("104","GWS08479","SAMUEL","ADEBANJO","OLAMILEKAN","GWS08479","Male","2007-07-07","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","2021-09-24","2021/2022","SAMUEL ADEBANJO.jpeg","HASSAN RAHMON","REALTOR","09169121913","RAHMONHASSAN127@HOTMAIL.COM","HASSAN KAFILAT","TRADING","07064507192","KAFILATBIJO28@GMAIL.COM","16, OLAOLUWA STR. OFF GASLINE, MATOGUN ROAD, OKE-ARO, OGUN STATE.","2, HUMANI STR., ONIPANU, SOMOLU LGA, LAGOS STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-09","applicable");
INSERT INTO student_tbl VALUES("105","GWS88403","DAVID","SOLARU","IBUKUN","GWS88403","Male","2007-11-18","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","SOLARU DAVID.jpeg","SOLARU","BUSINESS  MAN","08023114674","OLASOLAADEYEMI@GMAIL.COM","SOLARU","TRADING","08093236277","KENNYSOLARU@GMAIL.COM","8, NEWTON, ILAWAGBON, CRESCENT, OFF GASLINE, ADELANI BUS STOP, OGUN STATE.","8, NEWTON, ILAWAGBON, CRESCENT, OFF GASLINE, ADELANI BUS STOP, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("106","GWS35284","WISDOM","OBIWANNE","CHUKWU EMEKA","GWS35284","Male","2008-04-15","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","WISDOM OBIWANNE.png","OBIWANNE CYRIL","BUSINESS MAN","","","OBIWANNE REGINA","","","","41, IRANLOWO, OSERE, MATOGUN, OGUN STATE.","41, IRANLOWO, OSERE, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("107","GWS51129","DAMILARE","SABIU","N/A","GWS51129","Male","0001-01-01","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","DAMILARE SABIU.png","SABIU","","","","SABIU","","","","N/A","N/A","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("108","GWS43617","ABIGAEL","ADENIJI","OLUWAYEMISI","GWS43617","Female","2007-02-16","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","ABIGAEL ADENIJI.png","ADENIJI","SECURITY OFFICER","08057403044","","ADENIJI","TRADING","08149806052","","22, ANIMAMA STR., IJEJA BUS STOP, MATOGUN, OGUN STATE.","22, ANIMAMA STR., IJEJA BUS STOP, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("109","GWS91054","SUBOMI","OLALEYE","OTUNBA","GWS91054","Male","2007-11-02","Secondary","SSS1","SSS1A","SSS1","SSS1A","CHRISTIANITY","","0001-01-01","2021/2022","SUBOMI OLALEYE.png","OLALEYE","TRANSPORTATION","","","","TAILORING","","","N/A","N/A","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("110","GWS95482","OLAITAN","ADEDOYIN","HABIBAT","GWS95482","Female","2007-10-08","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","2018-01-01","2021/2022","OLAITAN ABIBAT.png","ADEDOYIN KAZEEM LAMIDI","ENTREPRENEUR","08100975775","ADEKAZZY2001@YAHOO.COM","ADEDOYIN ADEOLA TAIWO","TRADING","08068312223","ADEOLA-ADEJUMO@YAHOO.COM","28, AJAYI STR., ISHAGA, OGUN STATE.","28, AJAYI STR., ISHAGA, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("111","GWS15938","MODUPE","ADEWALE","KOLADE","GWS15938","Male","2005-03-21","Secondary","SSS2","SSS2A","SSS2","SSS2A","ISLAM","","2013-04-03","2021/2022","MODUPE ADEWALE.png","ADEWALE ABIOLA","BUSINESS MAN","08160244976","","ADEWALE","","","","19, OLRUNSOGO, ROAD, SURU BLOCK, MATOGUN ROAD, OGUN STATE.","19, OLRUNSOGO, ROAD, SURU BLOCK, MATOGUN ROAD, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("112","GWS15493","EMMANUEL","ADEWARA","ABIODUN","GWS15493","Male","0001-12-30","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","2022-02-23","2021/2022","ADEWARA EMMANUEL.jpeg","ADEWARA BUKOLA","BUSINESS  MAN","08023916446","","ADEWARA","TRADING","08087084662","","9, ALAFIA STR. GASLINE, MATOGUN, OGUN STATET.","9, ALAFIA STR. GASLINE, MATOGUN, OGUN STATET.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("113","GWS10352","OLUWAFERANMI","ADEWARA","IREMIDE","GWS10352","Female","2007-04-07","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","2021-01-01","2021/2022","OLUWAFERANMI ADEWARA.png","ADEWARA ADENIRAN","BUSINESS  MAN","08023916446","","ADEWARA ADEBIMPE","COMPUTER ENGINEERING","08087084662","","9, ALAAFIA STR., GASLINE, MATOGUN, OGUN STATE.","9, ALAAFIA STR., GASLINE, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("114","GWS80157","MAISARAT","MAJENGBASAN","OMOLABAKE","GWS80157","Female","2007-10-01","Secondary","SSS2","SSS2A","SSS2","SSS2A","ISLAM","","2021-01-01","2021/2022","MAISARAT MOYENGBASAN.jpeg","MAJENGBASAN AJISATERA","ENTREPRENEUR","08033499206","MAJENGBASANAJISATERA@GMAIL.COM","MAJENGBASAN OYEWALE ANIKE","BUSINESS WOMAN","08026204369","MAJENGBASANOYEWALENIKE@GMAIL.COM","3, IBIKUNLE STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","3, IBIKUNLE STR., OFF GASLINE ROAD, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("115","GWS73090","VERA","ADEMOLUYI","INUMIDUN","GWS73090","Female","2007-09-09","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","2012-01-01","2021/2022","VERA ADEMOLUYI.png","ADEMOLUYI ADEBUSOLA","BUSINESS  MAN","08084878707","ADEBUSOLAADEMOLUYI@GMAIL.COM","ADEMOLUYI ADESEWA","NURSING","08084878702","OLAYIWOLAADEMOLUYI@GMAIL.COM","5, JOHNSON CLOSE, OKE-ARO, OGUN STATE.","5, JOHNSON CLOSE, OKE-ARO, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("116","GWS07037","OREOLUWA","AKINTOYE","BLESSING","GWS07037","Female","2008-04-22","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","2020-09-01","2021/2022","AKINTOYE OREOLUWA.jpeg","ADENIYI AKINTOYE","BUSINESS  MAN","08055364947","ADENIYIAKINTOYE@GMAIL.COM","ADEBIMPE AKINTOYE","TRADING","08056332257","ADEBIMPEFAUSAT@GMAIL.COM","SANNI ITOPA, MATOGUN, OGUN STATE.","SANNI ITOPA, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("117","GWS05666","ISRAEL","ADEJUWON","ADENIYI","GWS05666","Male","2007-09-12","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","0001-01-01","2021/2022","ADEJUWON ISRAEL.jpeg","ADEJUWON OLUSAYO","ELECTRICAL ENGINEERING","08033462772","SAYOJUWON@YAHOO.COM","ADEJUWON OLUWAKEMI","EVANGELISM","08060468165","OLUWAKEMIADEJUWON7@GMAIL.COM","14, OMOGE CLOSE, MATOGUN, OGUN STATE.","14, OMOGE CLOSE, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("118","GWS59561","EMEKA","AKWOBI","LEONARD","GWS59561","Male","2006-11-08","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","0001-01-01","2021/2022","AKWOBI EMEKA.jpeg","AKWOBI","BUSINESS  MAN","07036395555","","AKWOBI","BUSINESS WOMAN","08142846890","","1, SAMUEL AJANI, ADELANI ROAD, OFF GASLINE ROAD, MATOGUN, OGUN STATE.","1, SAMUEL AJANI, ADELANI ROAD, OFF GASLINE ROAD, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("119","GWS83967","DAVID","MADEINLO","OLUWADAMILARE","GWS83967","Male","2006-10-15","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","0001-01-01","2021/2022","MADEINLO DAVID.jpeg","MADEINLO","","08064884572","","MADEINLO","ENTREPRENEUR","08144479925","","2, JAMES, FASAC CLOSE, ASB, OFF ADELANI ROAD, MATOGUN, OGUN STATE.","2, JAMES, FASAC CLOSE, ASB, OFF ADELANI ROAD, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("120","GWS39663","BRIGHT","ITAMAH","EMMANUEL","GWS39663","Male","2006-05-12","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","0001-01-01","2021/2022","BRIGHT ITAMAH.jpeg","ITAMAH FELIX","BUSINESS  MAN","08188242841","LM7064@GMAIL.COM","ITAMAH ROSE","ENTREPRENEUR","","","19, SEBILI, SODUNKE STR., ADELANI ROAD, OFF GASLINE, MATOGUN, OGUN STATE.","19, SEBILI, SODUNKE STR., ADELANI ROAD, OFF GASLINE, MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("121","GWS85590","YUSUF","ARABODE","AYODEJI","GWS85590","Male","2005-03-06","Secondary","SSS2","SSS2A","SSS2","SSS2A","CHRISTIANITY","","0001-01-01","2021/2022","YUSUF ARABODE.png","ARABODE","ENGINEERING","08023170910","","ARABODE","FASHION DESIGNING","08025305462","","N/A","N/A","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("122","GWS49054","SAMUEL","AKINOLA","TOBILOBA","GWS49054","Male","2010-12-16","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","0001-01-01","2021/2022","AKINOLA SAMUEL.jpeg","AKINOLA ADEOLU","PLUMBING","08136706680","","AKINOLA ODUNOLA","FASHION DESIGNING","","","AKURA, ISHASHA, OGUN STATE","2, IREDE STR., OFF GAS LINE ROAD, MATOGUN OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("123","GWS46528","IKECHUKWU","IHUNNA","GODPOWER","GWS46528","Male","2010-10-10","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","0001-01-01","2021/2022","IHUNNA IKECHUKWU.jpeg","IHUNNA HYCIENT","CIVIL SERVANT","08069687056","IHUNNAHYCIENT@GMAIL.COM","IHUNNA OMOTOLA","TRADING","09060706392","IHUNNAOMOTOLA@GMAIL.COM","35, OLORUNSOGO STR., OFF IJEJA ROAD, OSERE. MATOGUN, OGUN STATE.","35, OLORUNSOGO STR., OFF IJEJA ROAD, OSERE. MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("124","GWS85128","RUTH","IYIOLA","MOJI","GWS85128","Female","2011-06-26","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","0001-01-01","2021/2022","IYIOLA RUTH.jpeg","IYIOLA AJIBOLA","ENGINEERING","08160320784","","IYIOLA MARY","TRADING","","","22, CAC STR., MATOGUN, OGUN STATE.","22, CAC STR., MATOGUN, OGUN STATE.","2022-06-09","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("125","GWS56987","DEBORAH","OLUDAIYE","OMOLARA","GWS56987","Female","2011-09-09","Secondary","JSS1","JSS1A","JSS1","JSS1A","CHRISTIANITY","","0001-01-01","2021/2022","DEBORAH OLUDAIYE.png","OLUDAIYE FELIX","MOPOL","08055615431","","OLUDAIYE EUNICE","TRADING","","","N/A","N/A","2022-06-09","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-07-03","applicable");
INSERT INTO student_tbl VALUES("126","GWS36344","ELIZABETH","POPOOLA","TEMILOLUWA","GWS36344","Female","2012-01-01","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","NIL","Akwa Ibom","2020-09-17","2021/2022","ELIZABETH POPOOLA TEMILOLUWA.jpg","POPOOLA","ENGINEERING","08028724195","GRACEWAY@GMAIL.COM","POPOOLA","SEAMSTRESS","08099312069","OLABISIPOPOOLA@GMAIL.COM","OLAYINDU STR.","NIL","2022-06-29","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("127","GWS58970","GOODNESS","ADEKALE","SAMUEL","GWS58970","Male","2012-03-11","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADEKALE GOODNESS SAMUEL.jpg","ADEKALE OLUSOLA","NA","08170319802","SHOLADE9@GMAIL.COM","ADEKALE","CIVIL SERVANT","09125347730","GRACEWAY@GMAIL.COM","2, OLORUNSOGO, MATOGUN, OGUN STATE","2, OLORUNSOGO, MATOGUN, OGUN STATE","2022-06-29","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("128","GWS08142","ABDULKAREEM","ADISA","OMOGBOLAHAN","GWS08142","Male","2012-12-16","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","NA","Akwa Ibom","0001-01-01","2021/2022","ADISA ABDULKAREEM OMOGBOLAHAN.jpg","ADISA LUQMAN","TECHNICIAN","08028104422","ADISAALANI@YAHOO.COM","ADISA SHAKIRAT","TRADER","07082154791","FADAIRO@GMAIL.COM","33A, IRORUN STREET, IPEJA","33A, IRORUN STREET, IPEJA","2022-06-29","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("129","GWS56175","SOROMTOCHUKWU","AKWOBI","NAOMI","GWS56175","Female","2012-05-21","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","AKWOBI SOROMTOCHUKWU NAOMI.jpg","PATRICK","BUSINESS  MAN","08023535557","GRACEWAY@GMAIL.COM","NGOZI","BUSINESS WOMAN","08142846838","GRACEWAY@GMAIL.COM","NA","NA","2022-06-29","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("130","GWS03475","FAUSTINA","EZEAMANSOR","OLUEBUBECHUKWU","GWS03475","Female","2012-06-28","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","EZEAMANSOR FAUSTINA OLUEBUBECHUKWU.jpg","EZEAMANSOR A.I.","BUSINESS MAN","08033444467","IFEZDIVINE@GMAIL.COM","JULIET","TEACHING","07012151227","NIL@YAHOO.COM","15, OMOWUNMI STR.","15, OMOWUNMI STR.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("131","GWS07005","BASIT","ADEBAYO","OPEYEMI","GWS07005","Male","2012-01-01","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","NIL","Akwa Ibom","2014-01-01","2021/2022","ADEBAYO BASIT OPEYEMI.jpg","SEGUN","TRADER","08138005208","NIL@YAHOO.COM","OLUWATOYIN","TRADER","08133540970","NIL@YAHOO.COM","4, UNITY STR.","4, UNITY STR.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("132","GWS80309","OPEYEMI","AKINBODUN","SAMUEL","GWS80309","Male","2010-05-03","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","CHRISTIANITY","Akwa Ibom","2010-05-03","2021/2022","AKINBODUN OPEYEMI SAMUEL.jpg","GBENGA","ENGINEERING","08023281105","NIL@YAHOO.COM","BOLA","HAIRDRESSER","07036749989","NIL@YAHOO.COM","10, UNITY STR.","10, UNITY STR.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("133","GWS05650","FATHIA","RASAK","IBUKUN","GWS05650","Female","2011-06-29","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","ISLAM","Akwa Ibom","0001-01-01","2021/2022","RASAK FATHIA IBUKUN.jpg","RASAK","ENGINEERING","","MUTIURASA@GMAIL.COM","BOSE RASAK","TRADER","08023687081","BOSERASA@GMAIL.COM","14, NEWTON ILAWAGBON CRESCENT, ADELANI BUS STOP.","14, NEWTON ILAWAGBON CRESCENT, ADELANI BUS STOP.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("134","GWS10605","YUSUF","AFOLARIN","OLAYEMI","GWS10605","Male","2012-01-31","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","NIL","Akwa Ibom","0001-01-01","2021/2022","AFOLARIN YUSUF OLAYEMI.jpg","ABIMBOLA","ENGINEERING","08023897340","NIL@YAHOO.COM","IYABO","PHOTOGRAPHER","08036165832","NIL@YAHOO.COM","6, SAMUEL AJAYI STREET.","6, SAMUEL AJAYI STREET.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("135","GWS28041","DIVINE","IWUCHUKWU","CHISOM, CHIAMAKA","GWS28041","Female","2012-04-03","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","CHRISTIANITY","Akwa Ibom","2013-09-01","2021/2022","IWUCHUKWU DIVINE CHISOM.jpg","IWUCHUKWU","PUBLIC SERVANT","08062206905","THEOELOIS3000@YAHOO.COM","IWUCHUKWU","CHEMIST","08061612206","NIL@YAHOO.COM","11, UNITY CRESCENT, MATOGUN ROAD.","11, UNITY CRESCENT, MATOGUN ROAD.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("136","GWS58865","ABDULAZEEZ","ABDULAZEEZ","AYANFE","GWS58865","Male","2011-08-09","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","ISLAM","Akwa Ibom","0001-01-01","2021/2022","ABDULAZEEZ ABDULAZEEZ  AYANFE.jpg","ABDULAZEEZ RUKAYAT","CLERGY","08023063481","OLAYIWOLA@GMAIL.COM","ABDULAZEEZ RUKAYAT","TRADER","08065289025","RUKAYAT@GMAIL.COM","5, IBUKUNLE STR. OFF ADELANI BUS STOP, MATOGUN, OGUN STATE.","5, IBUKUNLE STR. OFF ADELANI BUS STOP, MATOGUN, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("137","GWS46278","OYELEYE","OYELEYE","DAVID OLUWATOBILOBA","GWS46278","Male","2012-11-29","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","CHRISTIANITY","Akwa Ibom","2013-09-14","2021/2022","OYELEYE OYELEYE DAVID.jpg","OLADELE BENJAMIN","CLERGY","08062222120","NIL@YAHOO.COM","CATHERINE OYELEYE","CLERGY","09132160698","NIL@YAHOO.COM","13, ADERONMU ADELAJA STR., OFF CUSTOM ROAD, MATOGUN ROAD.","13, ADERONMU ADELAJA STR., OFF CUSTOM ROAD, MATOGUN ROAD.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("138","GWS18991","ESTHER","AKINBODE","TOHEEBAT","GWS18991","Female","2012-04-07","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","NIL","Akwa Ibom","0001-01-01","2021/2022","AKINBODE ESTHER TOHEEBAT.jpg","AKINBODE","NIL","08105930416","NIL@YAHOO.COM","AKINBODE OMOWUNMI","TRADING","08137542142","OMOWUNMIAKINBODE3@GMAIL.COM","18, UNITY STREET, ASB BUST STOP, MATOGUN.","18, UNITY STREET, ASB BUST STOP, MATOGUN.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("139","GWS71744","EMMANUELLA","UROKO","ENENU","GWS71744","Female","2013-01-25","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","UROKO EMMANUELLA ENENU.jpg","SUNDAY UROKO","POLICE","07042558573","NIL@YAHOO.COM","JOY UROKO","TRADER","09064717392","NIL@YAHOO.COM","2A, REDEEMPTION STREET, ORUDU OLUWO","2A, REDEEMPTION STREET, ORUDU OLUWO","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("140","GWS66863","HABEEB","AREMU","NA","GWS66863","Male","0001-01-01","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","NIL","Akwa Ibom","0001-01-01","2021/2022","AREMU HABEEB.jpg","NA","NA","NA","NIL@YAHOO.COM","NA","NA","07052322624","NIL@YAHOO.COM","NA","NA","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("141","GWS32557","OPEYEMI","ODEDE","BIDEMI","GWS32557","Male","2012-02-02","Nursery/Primary","BASIC3","BASIC5","BASIC3","BASIC3","NA","Akwa Ibom","0001-01-01","2021/2022","ODEDE OPEYEMI BIDEMI.png","AYOOLA","SECURITY OFFICER","08157403044","NIL@YAHOO.COM","SARAH","HAIRDRESSING","08149806052","NIL@YAHOO.COM","22, ANIMAMA","NA","2022-06-30","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-30","applicable");
INSERT INTO student_tbl VALUES("142","GWS23836","FAITH","OLAYEMI","ODOGBOLU","GWS23836","Female","2012-11-10","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","NA","Akwa Ibom","2022-01-01","2021/2022","OLAYEMI FAITH ALIYAH.jpg","NASIRU","TRADER","09014598373","NIL@YAHOO.COM","TAIBAT","CATEERING","07030452345","NIL@YAHOO.COM","IBUKUN STREET","IBUKUN STREET","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("143","GWS79990","JOEL","NWANKEGO","DAVID","GWS79990","Male","2014-05-20","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","2018-01-01","2021/2022","NWANKEGO JOEL DAVID.jpg","DAVID ECHALE","TRAPORTATION","07019028509","ECHALESHIKED@GMAIL.COM","JULIET ECHALE","TEACHING","08168148252","JULIETECHALE@GMAIL.COM","1, SUNNY OLEYEDE CLOSE, MATOGUN, OGUN STATE.","1, SUNNY OLEYEDE CLOSE, MATOGUN, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("144","GWS01558","MICHAEL","BANWO","IREDE","GWS01558","Male","2014-06-07","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","BANWO MICHAEL IREDE.jpg","AYOMIKUN","TRADER","NA","NIL@YAHOO.COM","YETUNDE","TRADER","08133756067","NIL@YAHOO.COM","4, NEWTON ILAWAGBON CRESCENT, OFF GASLINE, MATOGUN ROAD.","4, NEWTON ILAWAGBON CRESCENT, OFF GASLINE, MATOGUN ROAD.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("145","GWS05914","ANJOLA","OJETOLA","MARY","GWS05914","Female","2014-05-14","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","OJETOLA ANJOLA MARY.jpg","OJETOLA JAMES","POLICE","08023324209","NIL@YAHOO.COM","ADENIJI OLUYEMISI","NURSING","08028158674","NIL@YAHOO.COM","TOLUWALASE CHARITY ESTATE","OSERE","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("146","GWS46244","EMMANUEL","AJIBADE","JESUJOBA","GWS46244","Male","2013-10-14","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","2015-01-01","2021/2022","AJIBADE EMMANUEL JESUJOBA.jpg","AJIBADE OLUSOJI","ARTISAN","08089480895","SONOFJESUS4LIFE@YAHOO.COM","AJIBADE","TEACHING","08133245248","ADEJIGRACE@YAHOO.COM","18, UNITY STREET, ASB, MATOGUN ROAD.","18, UNITY STREET, ASB, MATOGUN ROAD.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("147","GWS90706","SAMUEL","ADEBAYO","DARASIMI","GWS90706","Male","2012-12-01","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","2021-01-01","2021/2022","ADEBAYO SANUEL DARASIMI.jpg","ADEBAYO","CAPENTRY","08036802835","NIL@YAHOO.COM","JUSTINA","TRADE-  BUILDING MATERIALS","09068169160","NIL@YAHOO.COM","6, UNIT STR.","IRORUN STR.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("148","GWS42873","ELIJAH","SHODEHINDE","OGOOLUWA","GWS42873","Male","2012-11-25","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","2021-04-26","2021/2022","SHODEHINDE ELIJAH OGOOLUWA.jpg","PAUL","FURNITURE","NA","SHODEHINDEPAUL@GMAIL.COM","OLUWASEUN","HAIRDRESSING","08065638600","SHODEHINDEOLUWASEUN@GMAIL.COM","7, IREDE CRESCENT, OFF GASLINE, MATOGUN.","7, IREDE CRESCENT, OFF GASLINE, MATOGUN.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("149","GWS57007","NIFEMI","IYIOLA","CHRISTIANA","GWS57007","Female","2017-07-12","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","IYIOLA NIFEMI CHRISTIANA.jpg","IYIOLA","ENGINEERING","08160320184","NIL@YAHOO.COM","IYIOLA","TRADER","TRADER","NIL@YAHOO.COM","22, CAC STREET, MATOGUN, IJEJA, OGUN STATE.","22, CAC STREET, MATOGUN, IJEJA, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("150","GWS61426","FAVOUR","NATHANIEL","UDUAKOBONG","GWS61426","Female","2013-05-26","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","0001-09-01","2021/2022","NATHANIEL FAVOUR UDUAKOBONG.jpg","NATHANIEL UDUAKOBANG","BUSINESS MAN","09018001024","NIL@YAHOO.COM","BLESSING NATHANIEL","BUSINESS WOMAN","08106897380","NIL@YAHOO.COM","8, SABANTH FOURSQUARE, OKE-ARO, OGUN STATE.","8, SABANTH FOURSQUARE, OKE-ARO, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("151","GWS08402","DANIEL","OMONIYI","ODUNAYO","GWS08402","Male","2013-12-20","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","2018-09-01","2021/2022","OMONIYI DANIEL ODUNAYO.jpg","OMONIYI GBENGA","ENGINEERING","08038331221","NIL@YAHOO.COM","NA","TEACHING","08026544285","BISI-AJOKE@YAHOO.COM","3, CAC STREET, OLORUNSOGO, MATOGUN, OGUN STATE.","NA","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("152","GWS74218","DELIGHT","IWUCHUKWU","OLUCHUKWU, CHIAMANDA","GWS74218","Female","2014-02-03","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","2016-01-01","2021/2022","IWUCHUKWU DELIGHT OLUCHUKWU.jpg","IWUCHUKWU","PUBLIC SERVANT","08062206905","THEOELVIS3000@YAHOO.COM","IWUCHUKWU","CHEMIST","08061612206","NIL@YAHOO.COM","11, UNITY CRESCENT, MATOGUN.","11, UNITY CRESCENT, MATOGUN.","2022-06-30","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-06-30","applicable");
INSERT INTO student_tbl VALUES("153","GWS12637","VIVIAN","UCHEH","OYINYECHUKWU","GWS12637","Female","2013-12-24","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","UCHEH VIVIAN OYINYECHUKWU.jpg","UCHE SYLVESTER","LAB ANALYST","08035011593","USYLVESTER77@YAHOO.COM","UCHE MARY ANN","ARTISAN","08063053984","VIVIANDAN77@GMAIL.COM","5, KAFIFELO  STREET, MATOGUN.","5, KAFIFELO  STREET, MATOGUN.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("154","GWS00149","VICTORY","MBATA","ADA","GWS00149","Female","2016-08-24","Nursery/Primary","BASIC3","BASIC3","BASIC3","BASIC3","CHRISTIANITY","Akwa Ibom","2022-01-01","2021/2022","MBATA VICTORY ADA.png","ORJI","LAWYER","NA","NIL@YAHOO.COM","STELLA","HAIRDRESSING","08101420917","NIL@YAHOO.COM","7, WILLIAMS SHOLOLA STR., OFF GASLINE, MATOGUN","7, WILLIAMS SHOLOLA STR., OFF GASLINE, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("155","GWS89408","BASIT","YISA","ADISA","GWS89408","Male","2015-05-20","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","ISLAM","Akwa Ibom","0001-01-01","2021/2022","YISA BASIT ADISA.jpg","YISA GANIYU","ENGINEERING","08168556781","NIL@YAHOO.COM","YISA DESOLA","BUSINESS WOMAN","08171731380","NIL@YAHOO.COM","3, TAIWO ABAYOMI STREET, IJEJA, OGUN STATE.","3, TAIWO ABAYOMI STREET, IJEJA, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("156","GWS77804","GRACE","ADESANYA","TOLUWALASE","GWS77804","Female","2015-05-10","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADESANYA GRACE TOLUWALASE.jpg","OLANIYI ADESANYA","ENGINEERING","08030810571","ADESANYAOLANIYI@GMAIL.COM","NA","TRADER","08025980067","NIL@YAHOO.COM","35B, UNITY IRORUN STREET.","35B, UNITY IRORUN STREET.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("157","GWS83079","EMMANUEL","EZEAMANSOR","IFEANYICHUKWU","GWS83079","Male","2015-04-19","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","EZEAMANSOR EMMANUEL IFEANYICHUKWU.jpg","EZEAMANSOR A.I.","BUSINESS  MAN","08033444467","IFEZDIVINE@GMAIL.COM","JULIET","BUSINESS WOMAN","07012151227","NIL@YAHOO.COM","15, OMOWUNMI STR.","15, OMOWUNMI STR.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("158","GWS34901","ZYDAN","ALAUSA","OLAOTAN","GWS34901","Male","2014-01-22","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","NA","Akwa Ibom","0001-01-01","2021/2022","ALAUSA ZYDAN OLAOTAN.jpg","ALAUSA","CIVIL SERVANT","08024955831","NIL@YAHOO.COM","ALAUSA","HAIRDRESSING","07048581510","NIL@YAHOO.COM","18, UNITY STREET, OFF IJEJA","18, UNITY STREET, OFF IJEJA","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("159","GWS45437","ANUOLUWAPO","JOSEPH","OYIN","GWS45437","Female","2014-03-27","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","JOSEPH ANUOLUWAPO OYIN.jpg","JOSEPH  S.","PASTOR/POLICE","08033719681","NIL@YAHOO.COM","SEYI AKINGARAGI","TRADER","08137415999","NIL@YAHOO.COM","3, AKINGUROYE STR., TOLUWALASE ESTATE, MATOGUN","3, AKINGUROYE STR., TOLUWALASE ESTATE, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("160","GWS89321","SEMILORE","OLOWOYO","OLUWATOFUNMI","GWS89321","Female","2015-02-05","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","NA","Akwa Ibom","0001-01-01","2021/2022","OLOWOYO SEMILORE OLUWATOFUNMI.jpg","TOLULOPE OLOWOYO","FASHION DESIGNER","NA","NIL@YAHOO.COM","OLOWOYO HANNAH","FASHION DESIGNING","08103209764","NIL@YAHOO.COM","3, TAIWO ABAYOMI STR., MATOGUN, OGUN STATE.","3, TAIWO ABAYOMI STR., MATOGUN, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("161","GWS50840","EMMANUEL","AKWOBI","CHIDIEBUBE","GWS50840","Male","2015-05-12","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","AKWOBI EMMANUEL CHIDIEBUBE.jpg","PATRICK","BUSINESS  MAN","07036395555","NIL@YAHOO.COM","NGOZI","BUSINESS WOMAN","08142846838","NIL@YAHOO.COM","1, SAMUEL AJAYI STR. MATOGUN","1, SAMUEL AJAYI STR. MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("162","GWS55276","AYOMIDE","OJUADE","OBALOLUWA","GWS55276","Male","2014-01-25","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","NA","Akwa Ibom","0001-01-01","2021/2022","OJUADE AYOMIDE OBALOLUWA.jpg","EMMANUEL OJUADE","BUSINESS  MAN","08061590866","NIL@YAHOO.COM","OJUADE","TRADER","07035640452","NIL@YAHOO.COM","1, WALE YUSUF, ODUNDOYIN STR. ASB.","1, WALE YUSUF, ODUNDOYIN STR. ASB.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("163","GWS07491","VICTOR","EZIKE","KAMSIYO CHUKWU","GWS07491","Male","2015-07-16","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","EZIKE VICTOR KAMSIYOCHUKWU.jpg","SIMON","BUSINESS  MAN","08033236866","NIL@YAHOO.COM","AUGUSTINE","BUSINESS WOMAN","07031179386","NIL@YAHOO.COM","2, SAMUEL AJAYI STREET, MATOGUN","2, SAMUEL AJAYI STREET, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("164","GWS72905","CHIZARAM","OBI-ODIKA","JOHN","GWS72905","Male","2014-10-18","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","2016-01-01","2021/2022","OBI-ODIKA CHIZARAM JOHN.jpg","OBINNA","TRADING","08023176773","NIL@YAHOO.COM","LILIAN","TRADING","07030927119","LONWUKADIAMOND@GMAIL.COM","7, FADAESE STR., MATOGUN","7, FADAESE STR., MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("165","GWS90750","ISIWAT","HASSAN","ARIKE","GWS90750","Female","2014-09-16","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","ISLAM","Akwa Ibom","2022-01-11","2021/2022","HASSAN ISIWAT ARIKE.jpg","HASSAN","ENGINEERING","08086971765","NIL@YAHOO.COM","HASSAN","TRADER","09163063112","NIL@YAHOO.COM","5, OLOWOLAGBA STR.","5, OLOWOLAGBA STR.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("166","GWS48802","EZEKIEL","MUSUDI","OLUWAGBEMIRO","GWS48802","Male","2014-10-16","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","NA","Akwa Ibom","0001-01-01","2021/2022","MUSUDI EZEKIEL OLUWAGBEMIRO.jpg","SEGUN","ACCOUNTING","08027544731","NIL@YAHOO.COM","ADETAYO","NUSRSING","08025358169","NIL@YAHOO.COM","NA","17, ALHAJI JIMOH STREET, OFF SHOLOLA  IJEJA","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("167","GWS38388","TEPEDE ANU","TEPEDE","GOD HERITAGE","GWS38388","Female","2015-05-19","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","TEPEDE ANU GOD HEERITAGE.png","SHOLA TEPEDE","BUSINESS  MAN","NA","NIL@YAHOO.COM","BIOLA TEPEDE","HAIRDRESSING","NA","NIL@YAHOO.COM","8, OLORODE ADE STREET, MATOGUN, OGUN STATE.","8, OLORODE ADE STREET, MATOGUN, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("168","GWS43127","DANIEL","PACHECO","ERIOLUWA","GWS43127","Male","2014-02-04","Nursery/Primary","BASIC2","BASIC2","BASIC2","BASIC2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","PACHEGO DANIEL ERIOLUWA.png","MICHAEL PACHECO","CLERGY","08169794214","ORK17OCT@YAHOO.COM","JANET PACHECO","TRADING","08184197749","JANOLUSADE@YAHOO.COM","17, SANNI OLOYEDE  CLOSE, CUSTOM BUS STOP, MATOGUN ROAD, OKE-ARO, OGUN STATE.","17, SANNI OLOYEDE  CLOSE, CUSTOM BUS STOP, MATOGUN ROAD, OKE-ARO, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("169","GWS58331","DAVID","IHUNNA","OSINACHI","GWS58331","Male","2015-04-27","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","IHUNNA DAVID OSINACHI.png","HYCIENT IHUNNA","BUSINESS  MAN","NA","NIL@YAHOO.COM","OMOTOLA IHUNNA","TRADING","09060706392","OMOTOLA@YAHOO.COM","35, OLORUNSOGO STREET, IJEJA","35, OLORUNSOGO STREET, IJEJA","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("170","GWS98132","ABDULHAMEEN","ADISA","OLADIMEJI","GWS98132","Male","2015-04-17","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","ISLAM","Akwa Ibom","0001-01-01","2021/2022","ADISA ABDULHAMEEN OLADIMEJI.png","ADISA LUQMAN","TECHNICIAN","08028104422","ADISAALANI@YAHOO.COM","ADISA SHAKIRAT","TRADER","07082154791","FADAIROSHAKIRAT@GMAIL.COM","33A, 1RORUN STREET, IJEJA","33A, 1RORUN STREET, IJEJA","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("171","GWS08007","THEOPHILUS","ADEKALE","DARASIMI","GWS08007","Male","0001-01-01","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADEKALE THEOPHILUS DARASIMI.jpg","ADEKALE OLUSOLA","CIVIL SERVANT","07066286767","NIL@YAHOO.COM","ADEKALE OMOWUNMI","TRADER","09125347730","NIL@YAHOO.COM","OLORUNSOGO STREET","OLORUNSOGO STREET","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("172","GWS58637","ABIGEAL","POPOOLA","FIKAYO","GWS58637","Female","2016-06-18","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","POPOOLA ABIGEAL FIKAYO.jpg","POPOOLA ADEDAYO","MECHANICAL ENGINEERING","NA","NIL@YAHOO.COM","POPOOLA OLABISI","TAILORING","08099312069","NIL@YAHOO.COM","5, OYINDUN STREET, MATOGUN","5, OYINDUN STREET, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("173","GWS44408","GLORY","UZOMA","UCHECHI","GWS44408","Female","2016-06-07","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","UZOMA GLORY UCHECHI.jpg","UZOMA CHARLES","ENGINEERING","09095055688","NIL@YAHOO.COM","UZOMA ELIZABETH","TRADER","07065569173","NIL@YAHOO.COM","3, SEBILI AGBEYANJU STREET, MATOGUN","3, SEBILI AGBEYANJU STREET, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("174","GWS50421","EMMANUEL","AKINLADE","NA","GWS50421","Male","2010-08-21","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","AKINLADE EMMANUEL.jpg","AKINLADE","NA","08033709681","NIL@YAHOO.COM","BUNMI","TRADER","08189892046","NIL@YAHOO.COM","3, AKINGUROYE STR., TOLUWALASE ESTATE, MATOGUN","3, AKINGUROYE STR., TOLUWALASE ESTATE, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("175","GWS37618","DESTINY","NATHANIEL","UDUAKOBONG","GWS37618","Female","2015-02-24","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","NATHANIEL DESTINY UDUAKOBONG.jpg","UDUAKOBONG NATHANIEL","BUSINESS  MAN","09018001024","NIL@YAHOO.COM","BLESSING NATHANIEL","BUSINESS WOMAN","08106897380","NIL@YAHOO.COM","8, OLUREMI SABANAI STREET, OFF FOURSQUARE, OKE-ARO, OGUN STATE.","8, OLUREMI SABANAI STREET, OFF FOURSQUARE, OKE-ARO, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("176","GWS65226","BOLUWATIFERANMI","SANNI","TESTIMONY","GWS65226","Male","2016-05-24","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","SANNI BOLUWATIFERANMI TESTIMONY.jpg","SANNI S.S.","BUSINESS  MAN","07034701609","NIL@YAHOO.COM","SANNI A.M","BUSINESS WOMAN","08062539199","ANUOLUWAPOOLONADE87@GMAIL.COM","UNITY CRESCENT, ABS, MATOGUN, OGUN STATE","UNITY CRESCENT, ABS, MATOGUN, OGUN STATE","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("177","GWS36854","DARASIMI","OGUNJOBI","AKOREDE","GWS36854","Male","2016-01-17","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","NA","Akwa Ibom","2018-09-23","2021/2022","OGUNJOBI DARASIMI AKOREDE.jpg","OGUNJOBI","BUSINESS  MAN","09163188258","BAMIDELEOGUNJOBI82@GMAIL.COM","OGUNJOBI","FASHION DESIGNING","09063133445","THERESAOGUNTUASE708@GMAIL.COM","NA","NA","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("178","GWS73657","DANIEL","UCHEH","CHINONSO","GWS73657","Female","2016-02-05","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","UCHEH DANIEL CHINONSO.jpg","UCHE SYLVESTER","LAB ANALYST","08035011593","USYLVESTER77@YAHOO.COM","UCHE MARY ANN","ARTISAN","08063053984","VIVIANDAN77@GMAIL.COM","5, KAFIFELO STREET, MATOGUN.","5, KAFIFELO STREET, MATOGUN.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("179","GWS03007","MARY","AJIBADE","JESUTOFUNMI","GWS03007","Female","2015-12-26","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","2017-01-01","2021/2022","AJIBADE MARY JESUTOFUNMI.jpg","AJIBADE OLUSOJI","ARTISAN","08089480895","SONOFJESUS4LIFE@YAHOO.COM","AJIBADE G.","TEACHING","08133245248","ADEJIMIGRACE@YAHOO.COM","18, UNITY STREET, ASB, MATOGUN","18, UNITY STREET, ASB, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("180","GWS24300","BRIDGET","BEN AYANRU","GOLD","GWS24300","Female","2015-06-04","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","2020-01-01","2021/2022","BEN-AYANRU BRIDGET GOLD.jpg","BEN AYANRU","BANKER","08023504222","NIL@YAHOO.COM","BENAYANRU","BUSINESS WOMAN","08033869235","NIL@YAHOO.COM","51, IRANLOWO LANE, MATOGUN","51, IRANLOWO LANE, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("181","GWS95359","NELSON","OBINWANNE","CHIBIKE","GWS95359","Male","2015-09-17","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","OBINWANNE NELSON CHIBIKE.jpg","CYRIL","BUSINESS  MAN","08033726711","NIL@YAHOO.COM","NSEOBONG","BUSINESS WOMAN","09162618872","NIL@YAHOO.COM","47, IRANLOWO STREET","47, IRANLOWO STREET","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("182","GWS75272","DANIEL","UROKO","EYI","GWS75272","Male","2015-08-05","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","UROKO DANIEL EYI.jpg","SUNDAY UROKO","POLICE","07042558573","NIL@YAHOO.COM","JOY UROKO","TRADER","09064717392","NIL@YAHOO.COM","2A, REDEMPTION STREET, ORODU OLUWO","2A, REDEMPTION STREET, ORODU OLUWO","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("183","GWS30932","MARTINS","ADEKUNLE","FIKAYO","GWS30932","Male","2015-10-23","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADEKUNLE MARTINS FIKAYOMI.jpg","KEHINDE ADEKUNLE","NA","08023467940","KENNYMORE44@GMAIL.COM","JOKE ADEKUNLE","TRADER","08020515777","JOSSYISIWAT@GMAIL.COM","12, UNITY STREET","12, UNITY STREET","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("184","GWS22522","MARIAM","ABDULSALAM","TEMIDIRE","GWS22522","Female","2016-01-01","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","ISLAM","Akwa Ibom","2021-09-01","2021/2022","ABDUSALM MARIAM TEMIDIRE.jpg","ABDULSALAM","PRINTING","NA","NIL@YAHOO.COM","ABDULSALAM","FASHION DESIGNING","08087855953","NIL@YAHOO.COM","2, IREPODUN STR., ASB, OFF GASLINE, OGUN STATE.","2, IREPODUN STR., ASB, OFF GASLINE, OGUN STATE.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("185","GWS86107","DARASIMI","RASAK","HABEEB","GWS86107","Male","2015-07-07","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","ISLAM","Akwa Ibom","0001-01-01","2021/2022","RASAK DARASIMI HABEEB.jpg","RASAK MUTIU","ENGINEERING","08023687081","MUTIURASA@GMAIL.COM","RASAK ABOSEDE","TRADER","08035654072","BOSERASA@GMAIL.COM","14, NEWTON STREET, ILAWAGBON CRESCENT, ADELANI BUS STOP.","14, NEWTON STREET, ILAWAGBON CRESCENT, ADELANI BUS STOP.","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("186","GWS62639","DAVID","DANIEL-EJIOFOR","CHIEMEKA","GWS62639","Male","2015-08-26","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","DANIEL-EJIOFOR DAVID CHIEMEKA.jpg","SOLOMON EJIOFOR","BUSINESS  MAN","07065001272","ESCHGLOBAL@GMAIL.COM","CHIDINMA EJIOFOR","NURSING","07034272321","CHIDISOLM@GMAIL.COM","5, UNITY CRESCENT BY ASB BUS STOP, GASLINE, MATOGUN","5, UNITY CRESCENT BY ASB BUS STOP, GASLINE, MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("187","GWS61396","SAMUEL","OYELAMI","ADEOGO","GWS61396","Male","2015-11-12","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","OYELAMI SAMUEL ADEOGO.jpg","OYELAMI","BUILDING CONTRACTION","08083252325","NIL@YAHOO.COM","OYELAMI","MINSTER","08124244285","NIL@YAHOO.COM","20, ADELANI STRET, DAMILOLA BLOCK MATOGUN","20, ADELANI STRET, DAMILOLA BLOCK MATOGUN","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("188","GWS40914","ENOCH","OREKOYA","AYANFEOLUWA","GWS40914","Male","2015-09-27","Nursery/Primary","BASIC1","BASIC1","BASIC1","BASIC1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","OREKOYA ENOCH AYANFEOLUWA.jpg","O.A. OREKOYA","ENGINEERING","08023242533","NIL@YAHOO.COM","O.I. OREKOYA","NURSING","08023625721","NIL@YAHOO.COM","13, NEWTON STREET, ILLAWAGBON","13, NEWTON STREET, ILLAWAGBON","2022-06-30","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("189","GWS91333","PACHECO","DESIRE","MOMOREOLUWA","GWS91333","Female","2016-04-08","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","PACHECO DESIRE MOMOREOLUWA.png","MICHAEL PACHECO","BUSINESS  MAN/CLERGY","08169794214","ORK17OCT@YAHOO.COM","JANET PACHECO","TRADING","08184197749","JANOLUSADE@YAHOO.COM","17, SANNI OLOYEDE CLOSE, CUSTOM BUS STOP, MATOGUN ROAD, OKE-ARO, OGUN STATE.","17, SANNI OLOYEDE CLOSE, CUSTOM BUS STOP, MATOGUN ROAD, OKE-ARO, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("190","GWS16959","SHEUTIJANI","MAJENGBASAN","AKANNO","GWS16959","Male","2015-10-21","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","NA","Akwa Ibom","2020-01-01","2021/2022","MAJENGBASAN SHEUTIJANI AKANNO.png","MAJENGBASAN","BUSINESS  MAN","08033206157","NIL@YAHOO.COM","MAJENGBASAN ANIKE","BUSINESS WOMAN","08026204369","NIL@YAHOO.COM","3, IBIKUNLE STREET, MATOGUN OGUN STATE.","3, IBIKUNLE STREET, MATOGUN OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("191","GWS91212","EMMANUELLA","ADEGBITE","DEMILADE","GWS91212","Female","2016-05-03","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","2020-09-23","2021/2022","ADEGBITE EMMANUELLA DEMILADE.png","OWOLABI ADEGBITE","SELF EMPLOYED","08060344184","NIL@YAHOO.COM","PERPETUAL","NA","09036004214","NIL@YAHOO.COM","13, SURU BLOCK","13, SURU BLOCK","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("192","GWS56260","OKIKI","SAMSON","EMMANUEL","GWS56260","Male","2012-11-03","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","SAMSON OKIKI EMMANUEL.png","SAMSON","PROPHET","NA","NIL@YAHOO.COM","OPEYEMI","PROPHETESS","07085523645","NIL@YAHOO.COM","MATOGUN","NA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("193","GWS81268","DANIEL","ITAMAH","EMMANUEL","GWS81268","Male","2015-07-10","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ITAMAH DANIEL EMMANUEL.png","ITAMAH FELIX","TRANSPORTATION","08188242841","NIL@YAHOO.COM","ITAMAH MARY","BUSINESS WOMAN","08086964240","NIL@YAHOO.COM","19, SEBILI  SODUNKE STREET","19, SEBILI  SODUNKE STREET","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("194","GWS84650","INI","AKINOLA","OLUWASEYI","GWS84650","Male","2016-06-08","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","NA","Akwa Ibom","0001-01-01","2021/2022","AKINOLA INI OLUWASEYI.png","AKINOLA","PLUMBING","08136706680","NIL@YAHOO.COM","DEBORAH","TAILORING","08161605808","NIL@YAHOO.COM","IREDE COMMUNITY","NA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("195","GWS34294","LYDIA","MADEINLO","OLUWASEMILORE","GWS34294","Female","2017-03-08","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","2019-01-01","2021/2022","MADEINLO LYDIA OLUWASEMILORE.png","MADEINLO","ENGINEERING","NA","MADEINLORACHEAL123@GMAIL.COM","MADEINLO","ENTREPRENEUR","08144479925","NIL@YAHOO.COM","2, JAMES FASAC CLOSE","2, JAMES FASAC CLOSE","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("196","GWS29496","TOBILOBA","SABIU","ADEKOLA","GWS29496","Male","2016-08-14","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","NA","Akwa Ibom","2019-01-01","2021/2022","SABIU TOBILOBA ADEKOLA.png","SABIU","TRADER","08180820330","NIL@YAHOO.COM","SABIU","TRADER","08180820330","NIL@YAHOO.COM","6, OLASHEA STREET","6, OLASHEA STREET","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("197","GWS84956","ISAIAH","ADEBAYO","ADEDAYO","GWS84956","Male","2017-04-07","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADEBAYO ISAIAH ADEDAYO.jpg","ADEBAYO OMOTAYO","MECHANICAL ENGINEERING","08028357401","NIL@YAHOO.COM","ADEBAYO MARIAM","TRADER","09058806324","ADEBAYOMARIAM@GMAIL.COM","10, CAC STREET, MATOGUN, OGUN STATE.","10, CAC STREET, MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("198","GWS81610","MAFUZAH","YEKINI","IREMIDE","GWS81610","Female","2017-04-06","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","ISLAM","Akwa Ibom","2018-10-01","2021/2022","YEKINI MAFUZAH IREMIDE.jpg","OLAWALE","BUSINESS MAN","07066055086","NIL@YAHOO.COM","TAIWO","TRADING","09068117973","TAYETAKAN534@GMAIL.COM","22, TONY ENYI CRESCENT MATOGUN, OGUN STATE.","22, TONY ENYI CRESCENT MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("199","GWS12466","QUHAR","AFOLARIN","ENIOLA","GWS12466","Male","2015-10-06","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","ISLAM","Akwa Ibom","0001-01-01","2021/2022","AFOLARIN QUAHAR ENIOLA.jpg","ABIMBOLA","MECHANICAL ENGINEERING","08023897340","NIL@YAHOO.COM","IYABO","PHOTOGRAPHER","08036165832","NIL@YAHOO.COM","6, SAMUEL AJANI STREET, ADELANI BUS STOP, MATOGUN, OGUN STATE.","6, SAMUEL AJANI STREET, ADELANI BUS STOP, MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("200","GWS30527","AJAYI","AJAYI","DORCAS ABIMBOLA","GWS30527","Female","2016-02-02","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","NA","Akwa Ibom","0001-01-01","2021/2022","AJAYI DORCAS ABIMBOLA.jpg","OLUWOLE","MECH-ENGINEER","08056041160","ZIONDEMAESTRO@GMAIL.COM","NA","NA","09160703319","ELIZABETHJ7@GMAIL.COM","7, WILLIAMS SHOLOLA STR., MATOGUN, GAS LINE.","7, WILLIAMS SHOLOLA STR., MATOGUN, GAS LINE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("201","GWS38242","ELIZABETH","AKINLADE","ENIOLA","GWS38242","Female","0001-09-29","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","AKINLADE ELIZABETH ENIOLA.jpg","ANU AKINLADE","SELF EMPLOYED","08033719681","NIL@YAHOO.COM","BUNMI","TRADER","08137415999","NIL@YAHOO.COM","3, AKINGUROYE STR., TOLUWALASE ESTATE, MATOGUN","3, AKINGUROYE STR., TOLUWALASE ESTATE, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("202","GWS17755","MIRABEL","BANWO","OLUWANIFEMI","GWS17755","Female","2017-03-24","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","BANWO MIRABEL OLUWANIFEMI.jpg","BANWO ABBEY","SELF EMPLOYED","08133756067","NIL@YAHOO.COM","BANWO YETUNDE","SELF EMPLOYED","08133756067","NIL@YAHOO.COM","11, NEWTON STR., DELANI, MATOGUN","11, NEWTON STR., DELANI, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("203","GWS32370","FAUSAT","SHODAMOLA","DEBORAH","GWS32370","Female","0001-10-20","Nursery/Primary","NURSERY2","NURSERY2","NURSERY2","NURSERY2","NA","Akwa Ibom","2008-01-01","2021/2022","SHODAMOLA FAUSAT DEBORAH.jpg","SHODAMOLA JUBRIL","DRIVING","08024398375","NIL@YAHOO.COM","SHODAMOLA KAFAYAT","BUSINESS WOMAN","08126063270","NIL@YAHOO.COM","8, AJOFE STREET.","8, AJOFE STREET.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("204","GWS22873","ANJOLA","OYEDELE","CLARA","GWS22873","Female","2015-11-01","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","NA","Akwa Ibom","0001-01-01","2021/2022","OYEDELE ANJOLAOLUWA CLARA.png","OLATUNBOSUN","ENGINEERING","09166080372","NIL@YAHOO.COM","KEHINDE","BUSINESS WOMAN","08045867061","NIL@YAHOO.COM","5, OLOWOLAGA","5, OLOWOLAGA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("205","GWS89236","OLUWASHINDARA","AIYEYEMI","ELIZABETH","GWS89236","Female","2017-12-11","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","AIYEYEMI OLUWASHINDARA ELIZABETH.jpg","AIYEYEMI TAIWO","PUBLIC SERVANT","08060426363","NIL@YAHOO.COM","AIYEYEMI A. M.","PUBLIC SERVANT","08170657974","ABOSEDEAIYEYEMI@GMAIL.COM","ADELANI OFFICE, GASLINE ROAD, MATOGUN","ADELANI OFFICE, GASLINE ROAD, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("206","GWS79911","JOSEPH","ONIYITAN","NA","GWS79911","Male","2017-04-30","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ONIYITAN JOSEPH.jpg","ONIYITAN","NA","NA","NIL@YAHOO.COM","ONIYITAN","TRADER","08023549102","NIL@YAHOO.COM","NA","NA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("207","GWS65018","ELIJAH","IYIOLA","PRAISE","GWS65018","Male","2017-07-12","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","IYIOLA ELIJAH PRAISE.jpg","IYIOLA","ENGINEERING","08160320784","NIL@YAHOO.COM","IYIOLA","TRADER","08166847831","NIL@YAHOO.COM","22, CAC STREET, MATOGUN, IJEJA","22, CAC STREET, MATOGUN, IJEJA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("208","GWS51110","AYOMIDE","JOSEPH","SEGUN","GWS51110","Male","2017-04-04","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","JOSEPH AYOMIDE SEGUN.jpg","SEYI","POLICE/PASTOR","08033719681","NIL@YAHOO.COM","SEGUN AKINPORUYI","TRADER","08137415999","NIL@YAHOO.COM","3, AKINGUNROYE STR., TOLUWALASE ESTATE, MATOGUN.","3, AKINGUNROYE STR., TOLUWALASE ESTATE, MATOGUN.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("209","GWS63687","ZAHIR","ALAUSA","OKIKIOLA","GWS63687","Male","2017-04-01","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","NA","Akwa Ibom","0001-01-01","2021/2022","ALAUSA ZAHIR OKIKIOLA.jpg","ALAUSA","CIVIL SERVANT","08024955831","NIL@YAHOO.COM","ALAUSA","HAIRDRESSING","07048581510","NIL@YAHOO.COM","18, UNITY STR., OFF IJEJA","18, UNITY STR., OFF IJEJA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("210","GWS73057","ALIAYAT","OLAKANLU","ANIKE","GWS73057","Male","2016-04-13","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","NA","Akwa Ibom","2021-01-01","2021/2022","OLAKANLU ALIAYAT ANIKE.jpg","OLAKANLU AKEEM","BUSINESS  MAN","08051919700","NIL@YAHOO.COM","OLAKANLU FOLASHADE","BUSINESS WOMAN","07047273726","NIL@YAHOO.COM","4, JEGEDE STR. MATOGUN","4, JEGEDE STR. MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("211","GWS47393","DAVID","POPOOLA","ALEX","GWS47393","Male","2018-03-01","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","2020-01-01","2021/2022","POPOOLA DAVID ALEX.jpg","POPOOLA","ENGINEERING","08028724195","NIL@YAHOO.COM","POPOOLA","FASHION DESIGNING","08099312069","OLABISIPOPOOLA@GMAIL.COM","5, OGUNDUN STR. MATOGUN, OGUN STATE.","5, OGUNDUN STR. MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("212","GWS28114","CHIZIFEREM","OBI-ODIKA","MEDIATRIX","GWS28114","Male","2017-01-24","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","2018-09-01","2021/2022","OBI-ODIKA CHITEREM MEDIATRIX.jpg","OBINNA ODIKA","TRADING","08023176773","NIL@YAHOO.COM","LILIAN","TRADING","07030927119","NIL@YAHOO.COM","7, FADAESE STR., MATOGUN","7, FADAESE STR., MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("213","GWS28893","PRECIOUS","OKONOFUA","UYIOSA","GWS28893","Male","2018-02-06","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","2019-09-01","2021/2022","OKONOFUA PRECIOUS UYIOSA.jpg","OKONOFUA AMOS","ENGINEERING","08026412309","NIL@YAHOO.COM","OKONOFUA E.","TEACHING","07067080573","AWOYEMIESTHER200@GMAIL.COM","2, AKINFOLA AVENUE, OFF COMMUNITY STREET, MATOGUN","2, AKINFOLA AVENUE, OFF COMMUNITY STREET, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("214","GWS39758","HASSAN","ADEYEMO","ABIODUN","GWS39758","Male","2015-12-15","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","NA","Akwa Ibom","0001-01-01","2021/2022","ADEYEMO HASSAN ABIODUN.jpg","ADEYEMO","NA","NA","NIL@YAHOO.COM","ADEYEMO","TRADING","08035858433","NIL@YAHOO.COM","3, AIYEOLA STREET, MATOGUN, OGUN STATE.","3, AIYEOLA STREET, MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("215","GWS25393","JONES","EMMANUEL","PROSPER","GWS25393","Male","2017-05-02","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","EMMANUEL JONES PROSPER.jpg","EMMANUEL","NA","NA","NIL@YAHOO.COM","NA","BUSINESS WOMAN","08037049670","NIL@YAHOO.COM","1, OFF ADELANI STREET, MATOGUN, OGUN STATE.","1, OFF ADELANI STREET, MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("216","GWS46953","JOHN","EMMANUEL","PRAISE","GWS46953","Male","2017-05-02","Nursery/Primary","NURSERY1","NURSERY1","NURSERY1","NURSERY1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","EMMANUEL JOHN PRAISE.jpg","EMMANUEL","NA","NA","NIL@YAHOO.COM","NA","BUSINESS WOMAN","08037049670","NIL@YAHOO.COM","1, OFF ADELANI STREET, MATOGUN, OGUN STATE.","1, OFF ADELANI STREET, MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("217","GWS60905","SAMUEL","DANIEL-EJIOFOR","CHIBUIKE","GWS60905","Male","2018-05-11","Nursery/Primary","Kindergarten","KG2","Kindergarten","KG2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","DANIEL-EJIFOR SAMUEL CHIBUIKE.jpg","SOLOMON EJIOFOR","BUSINESS  MAN","07065001272","ESCHGLOBAL@GMAIL.COM","CHIDINMA EJIOFOR","NURSING","07034272321","CHIDISOLM@GMAIL.COM","5, UNITY CRESCENT BY ASB B/STOP, GASLINE, MATOGUN","5, UNITY CRESCENT BY ASB B/STOP, GASLINE, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("218","GWS94272","TOLUWALASE","ABOLADE","ESTHER","GWS94272","Female","2017-11-15","Nursery/Primary","Kindergarten","KG2","Kindergarten","KG2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","","ABOLADE OLUWASEUN","BANKING","08123500157","SEUN4REAL@GMAIL.COM","ABOLADE OMOSHALEWA","BUSINESS WOMAN","08026935193","OMOSHALEWAABOLADE@GMAIL.COM","5, GODS TIME STR., OFF DELANI HOUSE, MATOGUN, OGUN STATE.","5, GODS TIME STR., OFF DELANI HOUSE, MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","ATANSUYI JOSHUA","2022-07-19","applicable");
INSERT INTO student_tbl VALUES("219","GWS92727","HAZEEMAT","HASSAN","AJOKE","GWS92727","Male","2018-08-04","Nursery/Primary","Kindergarten","KG2","Kindergarten","KG2","ISLAM","Akwa Ibom","0001-01-01","2021/2022","HASSAN HAZEEMAT AJOKE.jpg","HASSAN","ENGINEERING","08086971765","NIL@YAHOO.COM","HASSAN","TRADER","09163063112","NIL@YAHOO.COM","5, OLOWOLAGBA","5, OLOWOLAGBA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("220","GWS17072","QOHHAR","YINUSA","AYOMIKUN","GWS17072","Male","2018-07-30","Nursery/Primary","Kindergarten","KG2","Kindergarten","KG2","ISLAM","Akwa Ibom","2020-01-01","2021/2022","YINUSA QOHHAR AYOMIKUN.jpg","YINUSA SAHEED","LOGISTIC","07037365399","YINUSA-SAHEED@YAHOO.COM","YINUSA KAFAYAT","NURSING","08068082866","OHMOLARA1992@GMAIL.COM","24, LEYE-KOFO STR., MATOGUN","24, LEYE-KOFO STR., MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("221","GWS06141","MARIAM","ISA","ADURAGBEMI","GWS06141","Female","2018-04-10","Nursery/Primary","Kindergarten","KG2","Kindergarten","KG2","NA","Akwa Ibom","0001-01-01","2021/2022","ISA MARIAM ADURAGBEMI.jpg","ISA SIKURU","NA","09065729956","NIL@YAHOO.COM","ABOSEDE","TRADER","08087594540","NIL@YAHOO.COM","28, OLORUNSOGO","28, OLORUNSOGO","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("222","GWS05873","EMMANUEL","ANYANKA","DANIEL","GWS05873","Male","2017-02-10","Nursery/Primary","Kindergarten","KG2","Kindergarten","KG2","CHRISTIANITY","Akwa Ibom","2021-01-03","2021/2022","ANYAKA EMMANUEL DANIEL.png","LUCKY","BUSINESS  MAN","09135911070","NIL@YAHOO.COM","IFEYINWA","BUSINESS WOMAN","08108229645","NIL@YAHOO.COM","13, OLORUNSOGO ROAD, MATOGUN","13, OLORUNSOGO ROAD, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("223","GWS66284","JOSEPH","ADENIJI","OYEWUNMI","GWS66284","Male","2018-04-13","Nursery/Primary","Kindergarten","KG1","Kindergarten","KG1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADENIJI JOSEPH OYEWUNMI.png","ADENIJI","NA","09079751449","NIL@YAHOO.COM","NA","NA","08023143399","NIL@YAHOO.COM","NA","NA","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("224","GWS07012","DAVID","OJOMO","ADEMOLA","GWS07012","Male","2019-03-27","Nursery/Primary","Kindergarten","KG1","Kindergarten","KG1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","OJOMO DAVID ADEMOLA.jpg","OJOMO OLARENWAJU","ENGINEERING","08037224177","NIL@YAHOO.COM","OJOMO JULIET","BUSINESS WOMAN","09060734919","NIL@YAHOO.COM","6, OLUOMOTAYO STR., OFF CUSTOM ROAD MATOGUN, OGUN STATE.","6, OLUOMOTAYO STR., OFF CUSTOM ROAD MATOGUN, OGUN STATE.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("225","GWS22686","YUSUF","TIAMIYU","DARASIMI","GWS22686","Male","2018-06-20","Nursery/Primary","Kindergarten","KG1","Kindergarten","KG1","ISLAM","Akwa Ibom","2019-09-01","2021/2022","TIAMIYU YUSUF DARASIMI.jpg","TIAMIYU SULAIMON","ARTISAN","08020408132","SULAIMONTIAMIYU11@GMAIL.COM","NA","HAIR STYLIST","07026348496","SULAIMONTIAMIYU11@GMAIL.COM","5, OMOWUNMI  SAWMILL, GASLINE, OGUN STATE","5, OMOWUNMI  SAWMILL, GASLINE, OGUN STATE","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("226","GWS10039","MIMONIOLUWA","SHOBUKOLA","OLUEBUBE","GWS10039","Female","2019-08-17","Nursery/Primary","Kindergarten","KG1","Kindergarten","KG1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","SHOBUKOLA MIMONIOLUWA OLUEBUBE.jpg","SHOBUKOLA ABIODUN","BUSINESS  MAN","08066794044","SHOSHO123@GMAIL.COM","SHOBUKOLA BLESSING","BUSINESS WOMAN","08086884444","SHOBUKOLABLESSING@GMAIL.COM","13, WUNMI OSHO STREET, OFF CUSTOM ROAD, AROLAMBO INSIDE","13, WUNMI OSHO STREET, OFF CUSTOM ROAD, AROLAMBO INSIDE","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("227","GWS84810","MICHAEL","UROKO","ONDUJUN","GWS84810","Male","2019-06-13","Nursery/Primary","Kindergarten","KG1","Kindergarten","KG1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","UROKO MICHAEL ONDUJUN.jpg","SUNDAY UROKO","POLICE","07042558573","NIL@YAHOO.COM","JOY UROKO","TRADER","09064717392","NIL@YAHOO.COM","2A, REDEMPTION STREET ORUDU OLUWO","2A, REDEMPTION STREET ORUDU OLUWO","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("228","GWS66318","HARRY","EVEWERO","OGHENERO","GWS66318","Male","2019-11-11","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","EVEWERO HARRY OGHENERO.jpg","AGALABRI OKE","DATA ANALYST","08127318989","OKEAGALABRI@GMAIL.COM","AGALABRI ROSEMARY","TRADER","09017337692","ROSEMARY.AGALABRI@GMAIL.COM","3, OGEH CLOSE, JOINT MIND ESTATE, ABISAGBO.","3, OGEH CLOSE, JOINT MIND ESTATE, ABISAGBO.","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("229","GWS69482","MATTIAS","BANWO","OMOTOYOSI","GWS69482","Male","2020-05-08","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","BANWO MATTIAS OMOTOYOSI.jpg","BANWO ABBEY","SELF EMPLOYED","08133756067","NIL@YAHOO.COM","BANWO YETUNDE","SELF EMPLOYED","08133756067","NIL@YAHOO.COM","11, NEWTON STREET, DELANI, MATOGUN","11, NEWTON STREET, DELANI, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("230","GWS50191","MOHAMMED","OLAKANLU","AJANI","GWS50191","Male","2019-04-23","Nursery/Primary","Creche","Creche","Creche","Creche","ISLAM","Akwa Ibom","2021-01-01","2021/2022","OLAKANLU MOHAMMED AJANI.jpg","OLAKANLU AKEEM","BUSINESS  MAN","08051919700","NIL@YAHOO.COM","OLAKANLU FOLASHADE","BUSINESS WOMAN","07047273726","NIL@YAHOO.COM","4, JEGEDE STR. MATOGUN","4, JEGEDE STR. MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("231","GWS27639","CHICHETARAM","OBI-ODIAKA","ANNUNCIATA","GWS27639","Male","2020-01-14","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","2022-01-01","2021/2022","OBI-ODIKA CHICHETARAM ANNUNCIATA.jpg","OBINNA ODIKA","NA","08023176773","NIL@YAHOO.COM","LILIAN","TRADING","07030927119","NIL@YAHOO.COM","7, FADAESE STREET, MATOGUN","7, FADAESE STREET, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("232","GWS01051","OLAWUNMI","ADENIJI","ANIKE ADE","GWS01051","Female","2019-10-23","Nursery/Primary","Creche","Creche","Creche","Creche","NA","Akwa Ibom","0001-01-01","2021/2022","ADENIJI OLAWUNMI ANIKE ADE.jpg","ADURAMIGBA ADENIJI","SECURITY GUARD","08057403044","NIL@YAHOO.COM","OMOTAYO","TRADING","07026150404","NIL@YAHOO.COM","5, IFEDAPO STREET","9, ANIMAMA STREET","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("233","GWS84767","ISAAC","ADELABU","SHINA-AYOMI","GWS84767","Male","2019-11-09","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","2022-02-07","2021/2022","ADELABU ISAAC SHINA-AYOMI.jpg","TEMIDAYO","DRIVING","08184634764","NIL@YAHOO.COM","ADEYINKA","NURSING","09055786434","NIL@YAHOO.COM","7, UNITY STREET, MATOGUN","7, UNITY STREET, MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","ATANSUYI JOSHUA","2022-07-19","applicable");
INSERT INTO student_tbl VALUES("234","GWS43205","PRECIOUS PERFECT","IWUCHUKWU","MUNACHI KELECHUKWU","GWS43205","Male","2019-07-02","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","2021-09-01","2021/2022","IWUCHUKWU PRECIOUS PERFECT MUNACHI.jpg","IWUCHUKWU","PUBLIC SERVANT","08062206905","THEOELVIS3000@YAHOO.COM","IWUCHUKWU","NURSING","08061612206","NIL@YAHOO.COM","11, UNITY CRESCENT","11, UNITY CRESCENT","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("235","GWS35562","ELIZABETH","JOSEPH","GIFT","GWS35562","Female","2020-04-09","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","JOSEPH ELIZABETH GIFT.jpg","SEYI JOSEPH","POLICE","08033719681","NIL@YAHOO.COM","SEYI JOSEPH","TRADER","08137415999","NIL@YAHOO.COM","3, AKINGUROYE STR., TOLUWALASE ESTATE. MATOGUN","3, AKINGUROYE STR., TOLUWALASE ESTATE. MATOGUN","2022-07-01","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("236","GWS71708","DESIRE","ADENIJI","CHRISTIANA","GWS71708","Female","2020-01-06","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","2021-09-20","2021/2022","ADENIJI DESIRE CHRISTIANA.jpg","OMOLADE CALEB","MECHANICAL ENGINEERING","08090737003","OMOLADECALEB@YAHOO.COM","SARAH","FASHION DESIGNING","08022445070","NIL@YAHOO.COM","5, ADEDOKUN STREET, OFF SUCCESS BLOCK","5, ADEDOKUN STREET, OFF SUCCESS BLOCK","2022-07-01","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-07-02","applicable");
INSERT INTO student_tbl VALUES("238","GWS91882","ABDULKAREEM","SONEYE","TOLUWALOPE","GWS91882","Male","2013-11-09","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","ISLAM","Akwa Ibom","0001-01-01","2021/2022","ABDULKAREEM SONEYE TOLUWALOPE.png","SONEYE","CIVIL SERVANT","08039470410","NIL@YAHOO.COM","SONEYE","CIVIL SERVANT","08138544257","SEKINATAYOMIDE@GMAIL.COM","2, OGUNWALE STR., ADIYAN GAS LINE, MATOGUN, OGUN STATE.","2, OGUNWALE STR., ADIYAN GAS LINE, MATOGUN, OGUN STATE.","2022-07-08","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("239","GWS49468","REBECCA","ADEYEMI","OLAIDE","GWS49468","Female","2012-05-26","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADEYEMI REBECCA OLAIDE.png","ADEYEMI","NA","NA","NIL@YAHOO.COM","ADEYEMI","NA","07066997015","NIL@YAHOO.COM","NA","NA","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("240","GWS15101","OLASHILE","PHILIP","DANIEL","GWS15101","Male","2012-01-23","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","OLASHILE PHILIP DANIEL.jpg","PHILIP","NA","NA","NIL@YAHOO.COM","MRS PHILIP","POLICE","NA","NIL@YAHOO.COM","NA","NA","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("241","GWS46148","MARVELOUS","AKINOLA","OLUWASEUN","GWS46148","Female","2012-08-20","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","NA","Akwa Ibom","0001-01-01","2021/2022","AKINOLA MARVELOUS OLUWASEUN.jpg","AKINOLA","PLUMBING","08136706680","NIL@YAHOO.COM","DEBORAH","TAILORING","08161605808","NIL@YAHOO.COM","ADELANI IREDE COMMUNITY","ADELANI IREDE COMMUNITY","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("242","GWS18402","HAPPINESS","ENEMARE","HARMONY","GWS18402","Female","2013-09-27","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ENEMARE HAPPINESS HARMONY.jpg","ENEMARE STEPHEN","ENGINEERING","08023050509","NIL@YAHOO.COM","ENEMARE BLESSING","TRADER","09012828419","NIL@YAHOO.COM","7, RAINBOW CLOSE","7, RAINBOW CLOSE","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("243","GWS37406","IDERA","AZEEZ","OLAMIPOSI","GWS37406","Female","2013-08-27","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","NA","Akwa Ibom","0001-01-01","2021/2022","AZEEZ IDERA OLAMIPOSI.jpg","OLAMILEKAN AZEEZ","ENGINEERING","NA","NIL@YAHOO.COM","OYINDAMOLA  AZEEZ","BUSINESS WOMAN","09068216613","NIL@YAHOO.COM","4, SURU BLOCK","4, SURU BLOCK","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("244","GWS23708","HANNAH","ADESANYA","ENIRAPADA","GWS23708","Female","2013-05-10","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","ADESANYA HANNAH ENIRAPADA.jpg","OLANIYI ADESANYA","ENGINEERING","08030810571","ADESANYAOLANIYI@GMAIL.COM","KHADIJAT ADESANYA","TRADER","08025980067","NIL@YAHOO.COM","35B, UNITY IRORUN STREET","35B, UNITY IRORUN STREET","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("245","GWS56170","SAMUEL","OGUNYINKA","ADISA","GWS56170","Male","2013-02-12","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","CHRISTIANITY","Akwa Ibom","2018-01-01","2021/2022","OGUNYINKA SAMUEL ADISA.jpg","AKIN OGUNYINKA","BUSINESS  MAN","07064333810","NIL@YAHOO.COM","FOLASHADE","BUSINESS WOMAN","07047273726","NIL@YAHOO.COM","4, JEGEDE STR., MATOGUN","4, JEGEDE STR., MATOGUN","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("246","GWS60665","MARIAM","BABAJIDE","SHILE","GWS60665","Female","0001-05-25","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","NA","Akwa Ibom","0001-01-01","2021/2022","BABAJIDE MARIAM SHILE.jpg","WAIDI","DRIVER","07060753714","NIL@YAHOO.COM","NA","TRADER","08075529499","NIL@YAHOO.COM","7, TOLUWALASE ESTATE","7, TOLUWALASE ESTATE","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("247","GWS34792","MORDIYAH","YEKINI","JADESOLA","GWS34792","Female","2013-10-13","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","NA","Akwa Ibom","2018-01-01","2021/2022","YEKINI MORDIYAH JADESOLA.jpg","OLAWALE","BUSINESS  MAN","07066055086","NIL@YAHOO.COM","TAIWO","BUSINESS WOMAN","09068117973","NIL@YAHOO.COM","22, TONY ENYI CRESCENT, MATOGUN","22, TONY ENYI CRESCENT, MATOGUN","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("248","GWS02452","SOLOMON","UZOMA","CHISOM","GWS02452","Male","2012-02-02","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","CHRISTIANITY","Akwa Ibom","2017-01-01","2021/2022","UZOMA SOLOMON CHISOM.jpg","UZOMA CHARLES","ENGINEERING","09095055688","NIL@YAHOO.COM","UZOMA ELIZABETH","TRADER","07065569173","NIL@YAHOO.COM","3, SEBILI AGBEYANGI STREET, MATOGUN","3, SEBILI AGBEYANGI STREET, MATOGUN","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("249","GWS13802","GIDEON","OREKOYA","OREOFEOLUWA","GWS13802","Male","2013-09-25","Nursery/Primary","BASIC4","BASIC4","BASIC4","BASIC4","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","OREKOYA GIDEON OREOFEOLUWA.jpg","O.A. OREKOYA","ENGINEERING","08023242533","NIL@YAHOO.COM","O.I. OREKOYA","NURSING","08023625721","NIL@YAHOO.COM","13, NEWTON STREET, ILLAWAGBON, DELANI, MATOGUN","13, NEWTON STREET, ILLAWAGBON, DELANI, MATOGUN","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("250","GWS32764","IGBALA","OLUWADAMILARE","OLUWADUNMININU","GWS32764","Male","2020-06-13","Nursery/Primary","Creche","Creche","Creche","Creche","CHRISTIANITY","Akwa Ibom","2022-01-01","2021/2022","OLUWADAMILARE IGBALA OLUWADUNMININU.png","OLUWADAMILARE","CLERGY","08030547960","NIL@YAHOO.COM","A.O. OLUWADAMILARE","TEACHING","08167667133","NIL@YAHOO.COM","37, ADELANI ROAD","37, ADELANI ROAD","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("251","GWS92720","ENIOLA","ALESHINLOYE","PRECIOUS","GWS92720","Female","2020-07-13","Nursery/Primary","Creche","Creche","Creche","Creche","NA","Akwa Ibom","0001-01-01","2021/2022","ALESHINLOYE ENIOLA PRECIOUS.png","ALESHINLOYE M.S.","TEACHING","07069492999","ALESHINLOYE@GMAIL.COM","OMOWUNMI ALESHINLOYE","CATEERING","08034122537","REJOICEWUNMI@GMAIL.COM","4, TOLUWALASHE ESTATE","7, ORIKE STREET, ASHIN- EKITI","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("252","GWS23135","JEJE","MOJOLAOLUWA","PREVAIL","GWS23135","Female","2019-08-24","Nursery/Primary","Kindergarten","KG1","Kindergarten","KG1","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","JEJE MOJOLAOLUWA PREVAIL.jpg","A.O. JEJE","NA","08135272810","NIL@YAHOO.COM","O.S. JEJE","TEACHING","08162436528","NIL@YAHOO.COM","3, OMOTAYO, CUSTOM ROAD, MATOGUN","PEACE ESTATE IBOGUN IFO","2022-07-10","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("253","GWS83607","JOSHUA","BABATUNDE","OLUWATOBILOBA","GWS83607","Male","0001-01-01","Nursery/Primary","Kindergarten","KG2","Kindergarten","KG2","CHRISTIANITY","Akwa Ibom","0001-01-01","2021/2022","JOSHUA BABATUNDE OLUWATOBILOBA.jpg","BABATUNDE","NA","NA","NIL@YAHOO.COM","ISRAEL LYDIA","TEACHING","09061548274","LYDIABIMBOLAO92@GMAIL.COM","8, SELIBI CLOSE, AJUMOBI HOTEEL","8, SELIBI CLOSE, AJUMOBI HOTEEL","2022-07-14","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("254","GWS59025","LIAM","ADEWALE","RICHARD","GWS59025","Male","2019-02-21","Nursery/Primary","Creche","Creche","Creche","Creche","NA","Akwa Ibom","0001-01-01","2021/2022","ADEWALE LIAM RICHARD.jpeg","OYINDAMOLA","ELECTRICIAN","07069353772","OYINDAMOLARICHARD@GMAIL.COM","DEMILADE","HAIRDRESSING","09018977634","ADEWALEDEMILADEE@GMAIL.COM","4, SURUBLOCK, MATOGUN, OGUN STATE","4, SURUBLOCK, MATOGUN, OGUN STATE","2022-07-14","ATANSUYI JOSHUA","","","applicable");
INSERT INTO student_tbl VALUES("255","GWS64130","HABEEB","IBRAHIM","OLAMILEKAN","GWS64130","Male","2012-02-28","Nursery/Primary","BASIC5","BASIC5","BASIC5","BASIC5","ISLAM","Akwa Ibom","0001-01-01","2021/2022","IBRAHIM HABEEB OLAMILEKAN.jpg","IBRAHIM","TRADING","NA","NIL@YAHOO.COM","IBRAHIM","NA","NA","NIL@YAHOO.COM","10, OLADAPO TAYLOR STR., OFF GASLINE, ADIYAN, OGUN STATE.","10, OLADAPO TAYLOR STR., OFF GASLINE, ADIYAN, OGUN STATE.","2022-07-14","ATANSUYI JOSHUA","","","applicable");



CREATE TABLE `sublink_tbl` (
  `sublink_id` int(11) NOT NULL AUTO_INCREMENT,
  `sublink_name` varchar(255) NOT NULL,
  `link_id` int(11) NOT NULL,
  `status` varchar(20) NOT NULL,
  `sublink_url` varchar(255) NOT NULL,
  `create_by` varchar(255) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`sublink_id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

INSERT INTO sublink_tbl VALUES("1","Add School","2","active","school.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:52:34pm","","");
INSERT INTO sublink_tbl VALUES("2","Add Class Group","2","active","class_group.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:53:58pm","","");
INSERT INTO sublink_tbl VALUES("3","Add Class","2","active","class.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:54:22pm","","");
INSERT INTO sublink_tbl VALUES("4","Add Session","2","active","session.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:54:39pm","","");
INSERT INTO sublink_tbl VALUES("5","Add Term","2","active","term.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:54:46pm","","");
INSERT INTO sublink_tbl VALUES("6","Fee Category","2","active","fee_category.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:55:08pm","","");
INSERT INTO sublink_tbl VALUES("7","Fee Structure","2","active","fee_structure.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:55:22pm","","");
INSERT INTO sublink_tbl VALUES("8","Expenses Setup","2","active","expenses.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:55:39pm","","");
INSERT INTO sublink_tbl VALUES("9","Add Student","3","active","add_student.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:56:19pm","","");
INSERT INTO sublink_tbl VALUES("10","Students List","3","active","students.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:56:34pm","","");
INSERT INTO sublink_tbl VALUES("11","Manage Student","3","active","manage_students.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:56:52pm","","");
INSERT INTO sublink_tbl VALUES("12","Add Teacher","4","active","add_teacher.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:57:11pm","","");
INSERT INTO sublink_tbl VALUES("13","Teachers List","4","active","teachers.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:57:29pm","","");
INSERT INTO sublink_tbl VALUES("14","Manager Teacher","4","active","manage_teachers.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:57:46pm","","");
INSERT INTO sublink_tbl VALUES("15","Individual Fee Upload","5","active","addfee.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:58:33pm","","");
INSERT INTO sublink_tbl VALUES("16","Student Fee Status","5","active","feestatus.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:58:51pm","","");
INSERT INTO sublink_tbl VALUES("17","Make Expense","5","active","addexpense.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:01pm","","");
INSERT INTO sublink_tbl VALUES("18","Make Payment","5","active","student_payment.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:14pm","","");
INSERT INTO sublink_tbl VALUES("19","Manage Payment","5","active","payment_list.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:28pm","","");
INSERT INTO sublink_tbl VALUES("20","View Reports","6","active","view_reports.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:45pm","","");
INSERT INTO sublink_tbl VALUES("21","Add Link","2","active","add_link.php","ATANSUYI EMMANUEL","2022-04-14","2022-04-14 5:28PM","","");
INSERT INTO sublink_tbl VALUES("22","Add Sub Link","2","active","add_sublink.php","ATANSUYI JOSHUA","2022-04-14","2022-04-14 5:31PM","","");
INSERT INTO sublink_tbl VALUES("23","General Reports","6","inactive","generalreports.php","ATANSUYI EMMANUEL SEUN","2022-04-14","2022-04-14 04:37:57pm","","");
INSERT INTO sublink_tbl VALUES("24","By Class Name","7","active","studentpromotion.php","ATANSUYI EMMANUEL SEUN","2022-04-26","2022-04-26 10:45:47am","","");
INSERT INTO sublink_tbl VALUES("25","Add Questions","4","active","question.php","ATANSUYI EMMANUEL SEUN","2022-05-12","2022-05-12 12:41:39pm","","");
INSERT INTO sublink_tbl VALUES("26","Exam Category","4","active","exam_category.php","ATANSUYI EMMANUEL SEUN","2022-05-30","2022-05-30 10:07:47pm","","");
INSERT INTO sublink_tbl VALUES("27","Add &amp; Edit Question","4","active","add_edit_question.php","ATANSUYI EMMANUEL SEUN","2022-05-31","2022-05-31 11:59:44am","","");
INSERT INTO sublink_tbl VALUES("28","Batch Fee Upload","5","inactive","batchfee_upload.php","ATANSUYI EMMANUEL SEUN","2022-06-15","2022-06-15 03:29:40pm","","");
INSERT INTO sublink_tbl VALUES("29","Add Exam Question","4","active","add_edit_question.php","ATANSUYI EMMANUEL SEUN","2022-06-25","2022-06-25 03:56:41pm","","");
INSERT INTO sublink_tbl VALUES("30","Add Student Fees","3","active","add_student_fees.php","ATANSUYI JOSHUA","2022-07-06","2022-07-06 04:59:27pm","","");
INSERT INTO sublink_tbl VALUES("31","Add Parents","4","active","add_parent.php","ATANSUYI JOSHUA","2022-07-11","2022-07-11 01:57:21pm","","");



CREATE TABLE `teacher_tbl` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) NOT NULL,
  `teacher_name` varchar(200) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `dob` date NOT NULL,
  `pno` varchar(11) NOT NULL,
  `joining_date` date NOT NULL,
  `qualification` varchar(255) NOT NULL,
  `experience` varchar(255) NOT NULL,
  `username` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `pwd` varchar(100) NOT NULL,
  `r_pwd` varchar(100) NOT NULL,
  `address` varchar(255) NOT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `create_by` varchar(100) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

INSERT INTO teacher_tbl VALUES("1","TEA/123456","ATANSUYI JOSHUA","Male","2022-03-18","08065138173","2022-03-18","HND, AGRIC EXTENTION","BETHSADA NUT/PRY. GODS POWER INTL SCHOOL","emmanuel","emman@yahoo.co","seun123","seun123","ALADURA BUS STOP, MATOGUN ROAD, IFO, OGUN STATE","AGBADO","OGUN","NIGERIA","JOSHUA","2021-09-05","2021-09-05 07:09:55pm","ATANSUYI EMMANUEL SEUN","2022-07-04");



CREATE TABLE `term_tbl` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `sch_term` varchar(100) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO term_tbl VALUES("1","1st Term","active","JOSHUA","2021-08-28","2021-08-28 03:13:32pm","","");
INSERT INTO term_tbl VALUES("2","2nd Term","active","JOSHUA","2021-08-28","2021-08-28 03:19:30pm","","");
INSERT INTO term_tbl VALUES("3","3rd Term","active","JOSHUA","2021-08-28","2021-08-28 03:20:04pm","","");



CREATE TABLE `testing_tbl` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `fee_category` varchar(200) DEFAULT NULL,
  `class_group` varchar(50) NOT NULL,
  `session` varchar(50) NOT NULL,
  `term` varchar(50) NOT NULL,
  `debit` double(10,2) NOT NULL,
  `credit` double(10,2) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO testing_tbl VALUES("7","0","school fee","JSS1","2021/2022","1st Term","30000.00","0.00","2021-09-25","2021-09-25 04:45:39am");
INSERT INTO testing_tbl VALUES("8","0","","JSS1","2021/2022","1st Term","5000.00","0.00","2021-09-25","2021-09-25 04:55:04am");
INSERT INTO testing_tbl VALUES("9","0","","JSS1","2021/2022","1st Term","3000.00","0.00","2021-09-25","2021-09-25 10:00:41am");
INSERT INTO testing_tbl VALUES("10","5","School Fee","JSS1","2021/2022","1st Term","0.00","30000.00","2021-09-25","2021-09-25 10:56:54am");

