

CREATE TABLE `class_tbl` (
  `c_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_group` varchar(50) NOT NULL,
  `class_name` varchar(50) NOT NULL,
  `status` varchar(50) DEFAULT NULL,
  `create_by` varchar(50) DEFAULT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`c_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

INSERT INTO class_tbl VALUES("1","JSS1-3","JSS1A","active","JOSHUA","2021-08-22","2021-08-22 06:05:34pm","","");
INSERT INTO class_tbl VALUES("2","JSS1-3","JSS1B","active","JOSHUA","2021-08-22","2021-08-22 06:06:39pm","","");
INSERT INTO class_tbl VALUES("3","JSS1-3","JSS1C","active","JOSHUA","2021-08-22","2021-08-22 06:17:53pm","","");
INSERT INTO class_tbl VALUES("4","JSS1-3","JSS1D","active","JOSHUA","2021-08-22","2021-08-22 06:24:07pm","","");
INSERT INTO class_tbl VALUES("5","JSS1-3","JSS1E","active","JOSHUA","2021-08-22","2021-08-22 06:26:12pm","","");
INSERT INTO class_tbl VALUES("6","JSS1-3","JSS1F","active","JOSHUA","2021-08-22","2021-08-22 06:33:53pm","","");
INSERT INTO class_tbl VALUES("7","JSS1-3","JSS1G","inactive","JOSHUA","2021-08-22","2021-08-22 06:36:28pm","","");
INSERT INTO class_tbl VALUES("8","JSS1-3","JSS1H","inactive","JOSHUA","2021-08-22","2021-08-22 06:39:16pm","","");
INSERT INTO class_tbl VALUES("9","JSS1-3","JSS2A","active","JOSHUA","2021-08-24","2021-08-24 05:28:11am","","");
INSERT INTO class_tbl VALUES("10","Primary","Basic 1","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:19pm","","");
INSERT INTO class_tbl VALUES("11","Primary","Basic 2","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:32pm","","");
INSERT INTO class_tbl VALUES("12","Primary","Basic 3","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:44pm","","");
INSERT INTO class_tbl VALUES("13","Primary","Basic 4","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:55:54pm","","");
INSERT INTO class_tbl VALUES("14","Primary","Basic 5","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:56:05pm","","");
INSERT INTO class_tbl VALUES("15","Primary","Basic 6","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:56:14pm","","");
INSERT INTO class_tbl VALUES("16","Nursery","Nursery 1","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:09:16pm","","");
INSERT INTO class_tbl VALUES("17","Nursery","Nursery 2","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:09:27pm","","");
INSERT INTO class_tbl VALUES("18","Creche/Kindergarten","Creche/Kindergarten","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:13:17pm","","");
INSERT INTO class_tbl VALUES("19","JSS1-3","SS1A","active","ATANSUYI EMMANUEL SEUN","2021-10-11","2021-10-11 07:24:44pm","","");



CREATE TABLE `classgroup_tbl` (
  `cg_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_group` varchar(25) NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `create_by` varchar(255) DEFAULT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cg_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO classgroup_tbl VALUES("1","JSS1-3","active","JOSHUA","2021-08-19","2021-08-19 09:04:58pm","ATANSUYI EMMANUEL SEUN","2021-10-09 05:08:13pm");
INSERT INTO classgroup_tbl VALUES("2","JSS2","inactive","JOSHUA","2021-08-19","2021-08-19 09:09:34pm","","");
INSERT INTO classgroup_tbl VALUES("3","JSS3","inactive","JOSHUA","2021-08-19","2021-08-19 09:10:13pm","","");
INSERT INTO classgroup_tbl VALUES("4","SS1-3","active","JOSHUA","2021-08-19","2021-08-19 09:17:39pm","ATANSUYI EMMANUEL SEUN","2021-10-09 05:08:01pm");
INSERT INTO classgroup_tbl VALUES("5","SS2","inactive","JOSHUA","2021-08-21","2021-08-21 10:06:14am","","");
INSERT INTO classgroup_tbl VALUES("6","SS3","inactive","JOSHUA","2021-08-21","2021-08-21 02:20:48pm","","");
INSERT INTO classgroup_tbl VALUES("7","ss10","inactive","JOSHUA","2021-08-21","2021-08-21 08:37:42pm","ATANSUYI EMMANUEL SEUN","2021-09-17 07:45:06pm");
INSERT INTO classgroup_tbl VALUES("8","ss4","inactive","JOSHUA","2021-08-21","2021-08-21 08:42:49pm","","");
INSERT INTO classgroup_tbl VALUES("9","ss5","inactive","JOSHUA","2021-08-22","2021-08-22 07:33:34am","","");
INSERT INTO classgroup_tbl VALUES("10","ss6","inactive","JOSHUA","2021-08-22","2021-08-22 05:15:52pm","","");
INSERT INTO classgroup_tbl VALUES("11","Primary","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:44:45pm","","");
INSERT INTO classgroup_tbl VALUES("12","Nursery","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 01:53:50pm","","");
INSERT INTO classgroup_tbl VALUES("13","Creche/Kindergarten","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 02:12:05pm","","");
INSERT INTO classgroup_tbl VALUES("14","JSS1-2","active","ATANSUYI EMMANUEL SEUN","2022-04-10","2022-04-10 07:16:37pm","ATANSUYI EMMANUEL SEUN","2022-04-10 07:23:10pm");
INSERT INTO classgroup_tbl VALUES("15","SS1-2","active","ATANSUYI EMMANUEL SEUN","2022-04-10","2022-04-10 09:34:40pm","","");



CREATE TABLE `exp_tbl` (
  `exp_id` int(11) NOT NULL AUTO_INCREMENT,
  `expname` varchar(255) NOT NULL,
  `expamount` double(10,2) NOT NULL,
  `expdesc` varchar(255) NOT NULL,
  `create_by` varchar(100) NOT NULL,
  `creation_date` varchar(255) NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(100) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`exp_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO exp_tbl VALUES("1","SALARY","30000.00","Mr. Damilare Salary","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 03:40:45pm","","");
INSERT INTO exp_tbl VALUES("2","SALARY","20000.00","Mrs. Queen","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 03:41:49pm","","");
INSERT INTO exp_tbl VALUES("3","SALARY","14000.00","Mr. Emmanuel Salary","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 03:58:54pm","","");
INSERT INTO exp_tbl VALUES("4","TRANSPORT AND TRAVELS","300.00","Transport To Landgold","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 06:17:45pm","","");
INSERT INTO exp_tbl VALUES("5","SCHOOL UNIFORM","20000.00","PURCHASE OF 20 UNIFORM FROM LOGO DESIGNER","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 06:21:39pm","","");
INSERT INTO exp_tbl VALUES("6","SCHOOL UNIFORM","20000.00","PURCHASE OF 20 UNIFORM FROM LOGO DESIGNER","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 06:43:49pm","","");
INSERT INTO exp_tbl VALUES("7","ELECTRICITY","1000.00","PHCN TOKEN PURCHASE","ATANSUYI EMMANUEL SEUN","2022-03-18","2022-03-18 05:54:16am","","");
INSERT INTO exp_tbl VALUES("8","TRANSPORT AND  TRAVELS","6000.00","TRANSPORT ALLOWANCE FOR MR. JOSEPH","ATANSUYI EMMANUEL SEUN","2022-04-08","2022-04-08 12:30:08pm","","");



CREATE TABLE `expenses_tbl` (
  `exp_id` int(11) NOT NULL AUTO_INCREMENT,
  `expcode` int(6) NOT NULL,
  `expname` varchar(255) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(255) NOT NULL,
  `creation_date` varchar(255) NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(100) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`exp_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO expenses_tbl VALUES("1","100621","TRANSPORT AND  TRAVELS","active","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 09:29:55am","ATANSUYI EMMANUEL SEUN","2022-03-18 06:42:16am");
INSERT INTO expenses_tbl VALUES("2","100347","SCHOOL UNIFORM","active","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 09:31:37am","","");
INSERT INTO expenses_tbl VALUES("3","100311","SALARY","active","ATANSUYI EMMANUEL SEUN","2022-03-14","2022-03-14 09:36:46am","ATANSUYI EMMANUEL SEUN","2022-03-18 06:45:14am");
INSERT INTO expenses_tbl VALUES("4","100895","ELECTRICITY","inactive","ATANSUYI EMMANUEL SEUN","2022-03-18","2022-03-18 05:53:07am","","");
INSERT INTO expenses_tbl VALUES("5","100219","ELECTRICITY","active","ATANSUYI EMMANUEL SEUN","2022-03-18","2022-03-18 07:07:26am","","");



CREATE TABLE `fee_category` (
  `fee_id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_category` varchar(200) NOT NULL,
  `session` varchar(200) NOT NULL,
  `term` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `create_by` varchar(200) NOT NULL,
  `update_by` varchar(200) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fee_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO fee_category VALUES("1","Cardigan","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:47:27pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("2","Tution Fee","2021/2022","1st Term","inactive","2021-09-22","2021-09-22 08:48:28pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("3","Textbook","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:49:16pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("4","Uniform","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:49:36pm","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2021-09-23 08:33:27pm");
INSERT INTO fee_category VALUES("5","Notebook","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:50:26pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("6","Games Wear","2021/2022","1st Term","active","2021-09-22","2021-09-22 08:50:38pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fee_category VALUES("7","Tuition Fee-First Term","2021/2022","1st Term","active","2021-09-23","2021-09-23 05:08:15am","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2021-09-23 05:51:27am");
INSERT INTO fee_category VALUES("8","Tuition Fee-Second Term","2021/2022","2nd Term","active","2021-09-23","2021-09-23 05:08:38am","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2021-09-23 05:52:35am");
INSERT INTO fee_category VALUES("9","Tuition Fee-Third Term","2021/2022","3rd Term","active","2021-09-23","2021-09-23 05:09:20am","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2021-09-23 05:53:29am");



CREATE TABLE `fee_structure` (
  `fs_id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_category` varchar(200) DEFAULT NULL,
  `fee_code` varchar(11) NOT NULL,
  `class_group` varchar(200) NOT NULL,
  `session` varchar(100) NOT NULL,
  `term` varchar(100) NOT NULL,
  `amount` double(10,2) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(200) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fs_id`)
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=latin1;

INSERT INTO fee_structure VALUES("44","Cardigan","339273","JSS1-3","2021/2022","1st Term","1500.00","active","ATANSUYI EMMANUEL SEUN","2021-11-13","2021-11-13 06:07:01pm","ATANSUYI EMMANUEL SEUN","2022-04-12 02:37:55pm");
INSERT INTO fee_structure VALUES("45","Tuition Fee-First Term","887477","SS1-3","2021/2022","1st Term","10000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-14","2021-11-14 09:08:01pm","ATANSUYI EMMANUEL SEUN","2022-04-12 02:57:10pm");
INSERT INTO fee_structure VALUES("49","Textbook","702083","SS1-3","2021/2022","1st Term","3000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-14","2021-11-14 09:09:05pm","","");
INSERT INTO fee_structure VALUES("48","Uniform","873887","SS1-3","2021/2022","1st Term","4000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-14","2021-11-14 09:08:53pm","","");
INSERT INTO fee_structure VALUES("47","Notebook","758891","SS1-3","2021/2022","1st Term","3000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-14","2021-11-14 09:08:38pm","","");
INSERT INTO fee_structure VALUES("46","Games Wear","074380","SS1-3","2021/2022","1st Term","2000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-14","2021-11-14 09:08:18pm","","");
INSERT INTO fee_structure VALUES("43","Textbook","144951","JSS1-3","2021/2022","1st Term","2000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-13","2021-11-13 06:06:51pm","","");
INSERT INTO fee_structure VALUES("42","Uniform","856364","JSS1-3","2021/2022","1st Term","5000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-13","2021-11-13 06:06:27pm","","");
INSERT INTO fee_structure VALUES("39","Tuition Fee-First Term","324059","JSS1-3","2021/2022","1st Term","10000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-13","2021-11-13 06:05:40pm","","");
INSERT INTO fee_structure VALUES("41","Notebook","656025","JSS1-3","2021/2022","1st Term","2000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-13","2021-11-13 06:06:12pm","","");
INSERT INTO fee_structure VALUES("40","Games Wear","384429","JSS1-3","2021/2022","1st Term","1000.00","active","ATANSUYI EMMANUEL SEUN","2021-11-13","2021-11-13 06:05:53pm","","");
INSERT INTO fee_structure VALUES("50","Cardigan","016789","SS1-3","2021/2022","1st Term","2500.00","active","ATANSUYI EMMANUEL SEUN","2021-11-14","2021-11-14 09:09:18pm","","");
INSERT INTO fee_structure VALUES("51","Tuition Fee-Second Term","392775","JSS1-3","2021/2022","2nd Term","5000.00","active","ATANSUYI EMMANUEL SEUN","2022-04-12","2022-04-12 02:59:52pm","","");
INSERT INTO fee_structure VALUES("52","Tuition Fee-Third Term","245338","JSS1-3","2021/2022","3rd Term","5000.00","active","ATANSUYI EMMANUEL SEUN","2022-04-12","2022-04-12 03:02:09pm","","");



CREATE TABLE `fees_deposit_tbl` (
  `fd_id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `student_name` varchar(200) NOT NULL,
  `pay_ref` varchar(255) NOT NULL,
  `debit` double(10,2) DEFAULT '0.00',
  `credit` double(10,2) NOT NULL DEFAULT '0.00',
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `create_by` varchar(200) NOT NULL,
  `update_by` varchar(200) DEFAULT NULL,
  `update_dt` date DEFAULT NULL,
  PRIMARY KEY (`fd_id`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;

INSERT INTO fees_deposit_tbl VALUES("1","5","Akinsanya Titilope","PI1596820210922","0.00","30000.00","2021-09-22","2021-09-22 06:06:05am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("2","5","Akinsanya Titilope","PI2067320210922","0.00","3000.00","2021-09-22","2021-09-22 06:08:45am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("3","5","Akinsanya Titilope","PI5943920210925","0.00","30000.00","2021-09-25","2021-09-25 10:56:54am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("4","5","Akinsanya Titilope","FP6120211009","0.00","9500.00","2021-10-09","2021-10-09 06:36:02pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("5","5","Akinsanya Titilope","FP7520211009","0.00","5000.00","2021-10-09","2021-10-09 06:41:51pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("6","5","Akinsanya Titilope","FP6420211009","0.00","5000.00","2021-10-09","2021-10-09 06:54:47pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("7","5","Akinsanya Titilope","FP1820211009","0.00","5000.00","2021-10-09","2021-10-09 06:56:54pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("8","5","Akinsanya Titilope","FP8020211009","0.00","5000.00","2021-10-09","2021-10-09 07:21:36pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("9","5","Akinsanya Titilope","FP6220211009","0.00","2000.00","2021-10-09","2021-10-09 07:25:56pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("10","9","AKINADE ELIJAH","FP5220211011","0.00","10000.00","2021-10-11","2021-10-11 09:46:49pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("11","10","OLUPESE PROVIDER","FP3620211019","0.00","10000.00","2021-10-19","2021-10-19 07:11:49pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("12","5","Akinsanya Titilope","FP9820211106","0.00","10000.00","2021-11-06","2021-11-06 06:20:29am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("13","5","Akinsanya Titilope","FP7320211106","0.00","10000.00","2021-11-06","2021-11-06 07:48:25am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("14","4","Ilori Gboyega","FP5120211106","0.00","10000.00","2021-11-06","2021-11-06 07:49:55am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("15","5","Akinsanya Titilope","FP8920211110","0.00","10000.00","2021-11-10","2021-11-10 08:35:41pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("16","4","Ilori Gboyega","FP7220211110","0.00","8000.00","2021-11-10","2021-11-10 08:36:29pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("17","4","Ilori Gboyega","FP0920211113","0.00","5000.00","2021-11-13","2021-11-13 06:09:19pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("18","5","Akinsanya Titilope","FP0920211113","0.00","10000.00","2021-11-13","2021-11-13 06:09:53pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("19","5","Akinsanya Titilope","FP9820211113","0.00","1000.00","2021-11-13","2021-11-13 06:23:28pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("20","9","AKINADE ELIJAH","FP3420211114","0.00","1000.00","2021-11-14","2021-11-14 09:12:09pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("21","4","Ilori Gboyega","FP0020211116","0.00","1000.00","2021-11-16","2021-11-16 07:28:15pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("22","14","ATANSUYI ELISHA","FP9020211123","0.00","4000.00","2021-11-23","2021-11-23 08:10:37pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("23","4","Ilori Gboyega","FP4520211124","0.00","2000.00","2021-11-24","2021-11-24 08:30:24pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("24","5","Akinsanya Titilope","FP4220211127","0.00","2000.00","2021-11-27","2021-11-27 03:01:13pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("25","12","AYANSIBU PRAISE","FP2420211127","0.00","1000.00","2021-11-27","2021-11-27 03:32:00pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("26","15","ANIYIKAYE OMOLARA","FP6320211130","0.00","1000.00","2021-11-30","2021-11-30 05:19:08am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("27","4","Ilori Gboyega","FP6620211217","0.00","2000.00","2021-12-17","2021-12-17 08:31:05pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("28","11","OGUNDIJO SAMUEL","FP9920220227","0.00","1000.00","2022-02-27","2022-02-27 07:38:32pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("29","4","Ilori Gboyega","FP0720220315","0.00","5000.00","2022-03-15","2022-03-15 09:09:20am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("30","15","ANIYIKAYE OMOLARA","FP2120220315","0.00","10000.00","2022-03-15","2022-03-15 09:26:12am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("31","13","OLOJO OLUWATOMIYIN","FP5820220315","0.00","2000.00","2022-03-15","2022-03-15 09:28:14am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("32","12","AYANSIBU PRAISE","FP6620220316","0.00","30000.00","2022-03-16","2022-03-16 06:10:35am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("33","11","OGUNDIJO SAMUEL","FP4620220316","0.00","10000.00","2022-03-16","2022-03-16 08:41:43pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("34","11","OGUNDIJO SAMUEL","FP8720220316","0.00","5000.00","2022-03-16","2022-03-16 08:43:26pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("35","12","AYANSIBU PRAISE","FP0220220316","0.00","30000.00","2022-03-16","2022-03-16 08:48:44pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("36","16","AKINADE JAMES","FP3820220317","0.00","5000.00","2022-03-17","2022-03-17 08:42:40am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("37","16","AKINADE JAMES","FP5120220317","0.00","5000.00","2022-03-17","2022-03-17 09:25:43am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("38","16","AKINADE JAMES","FP6520220317","0.00","1000.00","2022-03-17","2022-03-17 09:34:15am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("39","8","GBENGA ANU","FP0520220317","0.00","5000.00","2022-03-17","2022-03-17 09:35:21am","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("40","17","AKINADE MARY","FP6120220403","0.00","20000.00","2022-04-03","2022-04-03 09:39:03pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("41","19","ADEYA SEUN","FP7720220408","0.00","5000.00","2022-04-08","2022-04-08 12:23:59pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("42","19","ADEYA SEUN","FP7220220408","0.00","2000.00","2022-04-08","2022-04-08 12:44:58pm","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO fees_deposit_tbl VALUES("43","19","ADEYA SEUN","FP4820220412","0.00","2000.00","2022-04-12","2022-04-12 03:23:12pm","ATANSUYI EMMANUEL SEUN","","");



CREATE TABLE `fees_tbl` (
  `fees_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_group` varchar(50) NOT NULL,
  `session` varchar(50) NOT NULL,
  `term` varchar(50) NOT NULL,
  `amount` double(10,2) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fees_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO fees_tbl VALUES("1","JSS1","2021/2022","1st Term","50000.00","active","JOSHUA","2021-08-28","2021-08-28 04:42:42pm","","");
INSERT INTO fees_tbl VALUES("2","JSS2","2021/2022","1st Term","90000.00","active","JOSHUA","2021-08-28","2021-08-28 04:48:46pm","","");
INSERT INTO fees_tbl VALUES("3","JSS3","2021/2022","1st Term","100000.00","active","JOSHUA","2021-08-29","2021-08-29 04:56:02pm","","");
INSERT INTO fees_tbl VALUES("4","SS1","2021/2022","1st Term","120000.00","active","ATANSUYI EMMANUEL SEUN","2021-09-23","2021-09-23 10:11:04pm","","");
INSERT INTO fees_tbl VALUES("5","SS2","2021/2022","1st Term","140000.00","active","ATANSUYI EMMANUEL SEUN","2021-09-23","2021-09-23 10:11:48pm","","");
INSERT INTO fees_tbl VALUES("6","SS3","2021/2022","1st Term","150000.00","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 03:38:01am","","");
INSERT INTO fees_tbl VALUES("7","SS3","2021/2022","1st Term","1000.00","inactive","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 03:41:00am","","");
INSERT INTO fees_tbl VALUES("8","JSS3","2021/2022","1st Term","40000.00","active","ATANSUYI EMMANUEL SEUN","2021-09-25","2021-09-25 03:50:55am","","");



CREATE TABLE `link_tbl` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_name` varchar(255) NOT NULL,
  `status` varchar(25) NOT NULL,
  `link_icon` varchar(100) NOT NULL,
  `create_by` varchar(255) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO link_tbl VALUES("1","Dashboard","inactive","fas fa-th-large","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:12am","","");
INSERT INTO link_tbl VALUES("2","Settings","active","fas fa-tools","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:21am","","");
INSERT INTO link_tbl VALUES("3","Students","active","fas fa-user-graduate","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:31am","","");
INSERT INTO link_tbl VALUES("4","Teachers","active","fas fa-chalkboard-teacher","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:38am","","");
INSERT INTO link_tbl VALUES("5","Accounts","active","fas fa-file-invoice-dollar","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:44am","","");
INSERT INTO link_tbl VALUES("6","Reports","active","fas fa-building","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:01:51am","","");
INSERT INTO link_tbl VALUES("7","Promote Student","inactive","fas fa-user-graduate","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:02:09am","","");
INSERT INTO link_tbl VALUES("8","logout","inactive","fas fa-sign-out-alt","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:02:19am","","");
INSERT INTO link_tbl VALUES("9","Backup","inactive","fas fa-building","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 07:02:31am","","");
INSERT INTO link_tbl VALUES("10","Salary Advance","inactive","fas fa-user-graduate","ATANSUYI EMMANUEL SEUN","2022-04-14","2022-04-14 07:37:46pm","","");



CREATE TABLE `link_useraccess` (
  `permission_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_id` int(11) NOT NULL,
  `sublink_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_permission` varchar(5) NOT NULL,
  `creation_date` date NOT NULL,
  PRIMARY KEY (`permission_id`)
) ENGINE=MyISAM AUTO_INCREMENT=141 DEFAULT CHARSET=latin1;

INSERT INTO link_useraccess VALUES("99","5","19","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("98","5","18","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("97","5","17","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("96","5","16","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("95","5","15","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("94","4","14","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("93","4","13","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("92","4","12","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("91","3","11","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("90","3","10","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("89","3","9","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("88","2","8","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("87","2","7","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("86","2","6","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("85","2","5","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("140","6","20","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("139","5","19","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("138","5","18","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("137","5","17","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("136","5","16","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("135","5","15","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("134","4","14","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("133","4","13","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("132","4","12","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("131","3","11","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("130","3","10","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("129","3","9","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("128","2","8","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("127","2","7","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("126","2","6","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("125","2","5","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("124","2","4","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("123","2","3","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("122","2","2","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("121","2","1","1","True","2022-04-18");
INSERT INTO link_useraccess VALUES("100","6","20","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("84","2","4","2","False","2022-04-13");
INSERT INTO link_useraccess VALUES("83","2","3","2","True","2022-04-13");
INSERT INTO link_useraccess VALUES("82","2","2","2","True","2022-04-13");
INSERT INTO link_useraccess VALUES("81","2","1","2","True","2022-04-13");
INSERT INTO link_useraccess VALUES("101","2","1","4","True","2022-04-14");
INSERT INTO link_useraccess VALUES("102","2","2","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("103","2","3","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("104","2","4","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("105","2","5","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("106","2","6","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("107","2","7","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("108","2","8","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("109","3","9","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("110","3","10","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("111","3","11","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("112","4","12","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("113","4","13","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("114","4","14","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("115","5","15","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("116","5","16","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("117","5","17","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("118","5","18","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("119","5","19","4","False","2022-04-14");
INSERT INTO link_useraccess VALUES("120","6","20","4","False","2022-04-14");



CREATE TABLE `payment_tbl` (
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) DEFAULT NULL,
  `student_name` varchar(200) DEFAULT NULL,
  `pay_ref` varchar(255) DEFAULT NULL,
  `session` varchar(50) NOT NULL,
  `term` varchar(50) NOT NULL,
  `mop` varchar(100) DEFAULT NULL,
  `fee_code` varchar(11) DEFAULT NULL,
  `debit` double(10,2) NOT NULL,
  `credit` double(10,2) NOT NULL DEFAULT '0.00',
  `payment_category` varchar(100) DEFAULT NULL,
  `class_group` varchar(50) NOT NULL,
  `class_name` varchar(50) DEFAULT NULL,
  `creation_date` date DEFAULT NULL,
  `date_time` varchar(255) DEFAULT NULL,
  `narration` varchar(255) DEFAULT NULL,
  `status1` varchar(20) DEFAULT NULL,
  `status2` varchar(20) DEFAULT NULL,
  `create_by` varchar(50) DEFAULT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`p_id`)
) ENGINE=MyISAM AUTO_INCREMENT=273 DEFAULT CHARSET=latin1;

INSERT INTO payment_tbl VALUES("169","7","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:53:12pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("168","6","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:48:30pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("167","6","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:48:30pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("166","6","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:48:30pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("165","6","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:48:30pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("164","6","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:48:30pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("163","6","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:48:30pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("162","5","Akinsanya Titilope","FP9820211113","2021/2022","1st Term","Cash","","0.00","2000.00","Uniform","JSS1-3","JSS1A","2021-11-13","2021-11-13 06:23:28pm","for uniform","","undelete","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2021-11-25 09:00:04pm");
INSERT INTO payment_tbl VALUES("161","5","Akinsanya Titilope","FP0920211113","2021/2022","1st Term","Cash","","0.00","10000.00","Tuition Fee-First Term","JSS1-3","JSS1A","2021-11-13","2021-11-13 06:09:53pm","school fee pay","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("160","4","Ilori Gboyega","FP0920211113","2021/2022","1st Term","Cash","","0.00","5000.00","Tuition Fee-First Term","JSS1-3","JSS1A","2021-11-13","2021-11-13 06:09:19pm","school fee pay.","","delete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("158","5","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:08:02pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("159","5","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:08:02pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("157","5","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:08:02pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("156","5","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:08:02pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("155","5","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:08:02pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("154","5","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:08:02pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("151","4","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:07:12pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("152","4","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:07:12pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("153","4","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:07:12pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("150","4","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:07:12pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("149","4","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:07:12pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("148","4","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-13","2021-11-13 06:07:12pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("147","","","","2021/2022","1st Term","","339273","2000.00","0.00","Cardigan","JSS1-3","","2021-11-13","2021-11-13 06:07:01pm","Cardigan","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("146","","","","2021/2022","1st Term","","144951","2000.00","0.00","Textbook","JSS1-3","","2021-11-13","2021-11-13 06:06:51pm","Textbook","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("145","","","","2021/2022","1st Term","","856364","5000.00","0.00","Uniform","JSS1-3","","2021-11-13","2021-11-13 06:06:27pm","Uniform","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("144","","","","2021/2022","1st Term","","656025","2000.00","0.00","Notebook","JSS1-3","","2021-11-13","2021-11-13 06:06:12pm","Notebook","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("142","","","","2021/2022","1st Term","","324059","10000.00","0.00","Tuition Fee-First Term","JSS1-3","","2021-11-13","2021-11-13 06:05:40pm","Tuition Fee-First Term","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("143","","","","2021/2022","1st Term","","384429","1000.00","0.00","Games Wear","JSS1-3","","2021-11-13","2021-11-13 06:05:53pm","Games Wear","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("170","7","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:53:12pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("171","7","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:53:12pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("172","7","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:53:12pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("173","7","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:53:12pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("174","7","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 05:53:12pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("175","8","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:43:03pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("176","8","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:43:03pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("177","8","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:43:03pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("178","8","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:43:03pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("179","8","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:43:03pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("180","8","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:43:03pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("181","11","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:47:39pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("182","11","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:47:39pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("183","11","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:47:39pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("184","11","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:47:39pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("185","11","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:47:39pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("186","11","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 08:47:39pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("187","","","","2021/2022","1st Term","","887477","15000.00","0.00","Tuition Fee-First Term","SS1-3","","2021-11-14","2021-11-14 09:08:01pm","Tuition Fee-First Term","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("188","","","","2021/2022","1st Term","","074380","2000.00","0.00","Games Wear","SS1-3","","2021-11-14","2021-11-14 09:08:18pm","Games Wear","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("189","","","","2021/2022","1st Term","","758891","3000.00","0.00","Notebook","SS1-3","","2021-11-14","2021-11-14 09:08:38pm","Notebook","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("190","","","","2021/2022","1st Term","","873887","4000.00","0.00","Uniform","SS1-3","","2021-11-14","2021-11-14 09:08:53pm","Uniform","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("191","","","","2021/2022","1st Term","","702083","3000.00","0.00","Textbook","SS1-3","","2021-11-14","2021-11-14 09:09:05pm","Textbook","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("192","","","","2021/2022","1st Term","","016789","2500.00","0.00","Cardigan","SS1-3","","2021-11-14","2021-11-14 09:09:18pm","Cardigan","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("193","9","","","2020/2021","1st Term","","","15000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:09:30pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("194","9","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:09:30pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("195","9","","","2020/2021","1st Term","","","4000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:09:30pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("196","9","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:09:30pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("197","9","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:09:30pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("198","9","","","2020/2021","1st Term","","","2500.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:09:30pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("199","10","","","2020/2021","1st Term","","","15000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:10:36pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("200","10","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:10:36pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("201","10","","","2020/2021","1st Term","","","4000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:10:36pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("202","10","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:10:36pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("203","10","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:10:36pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("204","10","","","2020/2021","1st Term","","","2500.00","0.00","","JSS1-3","JSS1","2021-11-14","2021-11-14 09:10:36pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("205","9","AKINADE ELIJAH","FP3420211114","2021/2022","1st Term","Cash","","0.00","1000.00","Cardigan","SS1-3","SS1A","2021-11-14","2021-11-14 09:12:09pm","cardigan fees","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("206","4","Ilori Gboyega","FP0020211116","2021/2022","1st Term","Cash","","0.00","1000.00","Games Wear","JSS1-3","JSS1A","2021-11-16","2021-11-16 07:28:15pm","games wear fees","","delete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("207","12","","","2020/2021","1st Term","","","15000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:49:59am","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("208","12","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:49:59am","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("209","12","","","2020/2021","1st Term","","","4000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:49:59am","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("210","12","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:49:59am","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("211","12","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:49:59am","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("212","12","","","2020/2021","1st Term","","","2500.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:49:59am","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("213","13","","","2020/2021","1st Term","","","15000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:50:32am","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("214","13","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:50:32am","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("215","13","","","2020/2021","1st Term","","","4000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:50:32am","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("216","13","","","2020/2021","1st Term","","","3000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:50:32am","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("217","13","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:50:32am","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("218","13","","","2020/2021","1st Term","","","2500.00","0.00","","JSS1-3","JSS1","2021-11-17","2021-11-17 05:50:32am","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("219","14","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-23","2021-11-23 08:09:00pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("220","14","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-23","2021-11-23 08:09:00pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("221","14","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2021-11-23","2021-11-23 08:09:00pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("222","14","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2021-11-23","2021-11-23 08:09:00pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("223","14","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2021-11-23","2021-11-23 08:09:00pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("224","14","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2021-11-23","2021-11-23 08:09:00pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("225","14","ATANSUYI ELISHA","FP9020211123","2021/2022","1st Term","Cash","","0.00","4000.00","Tuition Fee-First Term","JSS1-3","JSS1B","2021-11-23","2021-11-23 08:10:37pm","PAYMENT FOR TUITION FEE","","delete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("226","4","Ilori Gboyega","FP4520211124","2021/2022","1st Term","Cash","","0.00","2000.00","Cardigan","JSS1-3","JSS1A","2021-11-24","2021-11-24 08:30:24pm","payment for cardigan","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("227","5","Akinsanya Titilope","FP4220211127","2021/2022","1st Term","Bank Transfer","","0.00","2000.00","Tuition Fee-First Term","JSS1-3","JSS1A","2021-11-27","2021-11-27 03:01:13pm","payment for school fee","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("228","12","AYANSIBU PRAISE","FP2420211127","2021/2022","1st Term","Cash","","0.00","1000.00","Textbook","SS1-3","SS1A","2021-11-27","2021-11-27 03:32:00pm","payment for textbook","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("229","15","ANIYIKAYE OMOLARA","FP6320211130","2021/2022","1st Term","Cash","","0.00","1500.00","Cardigan","SS1-3","SS1A","2021-11-30","2021-11-30 05:19:08am","payment for cardigan","","undelete","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2021-11-30 05:19:34am");
INSERT INTO payment_tbl VALUES("230","4","Ilori Gboyega","FP6620211217","2021/2022","1st Term","Cash","","0.00","2000.00","Tuition Fee-First Term","JSS1-3","JSS1A","2021-12-17","2021-12-17 08:31:05pm","school fees","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("231","11","OGUNDIJO SAMUEL","FP9920220227","2021/2022","2nd Term","Cash","","0.00","1000.00","Uniform","JSS1-3","JSS1A","2022-02-27","2022-02-27 07:38:32pm","payment for uniform","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("232","4","Ilori Gboyega","FP0720220315","2021/2022","2nd Term","Cash","","0.00","5000.00","Tuition Fee-Second Term","JSS1-3","JSS1A","2022-03-15","2022-03-15 09:09:20am","school fee","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("233","15","ANIYIKAYE OMOLARA","FP2120220315","2021/2022","2nd Term","Bank Transfer","","0.00","10000.00","Tuition Fee-Second Term","SS1-3","SS1A","2022-03-15","2022-03-15 09:26:12am","Elijah School Fees","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("234","13","OLOJO OLUWATOMIYIN","FP5820220315","2021/2022","2nd Term","Cash","","0.00","2000.00","Uniform","SS1-3","SS1A","2022-03-15","2022-03-15 09:28:14am","Elijah Uniform","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("235","12","AYANSIBU PRAISE","FP6620220316","2021/2022","2nd Term","Cash","","0.00","30000.00","Tuition Fee-Second Term","SS1-3","SS1A","2022-03-16","2022-03-16 06:10:35am","Second Term School","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("236","11","OGUNDIJO SAMUEL","FP4620220316","2021/2022","2nd Term","Cash","","0.00","10000.00","Tuition Fee-Second Term","JSS1-3","JSS1A","2022-03-16","2022-03-16 08:41:43pm","ogundijo school fees","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("237","11","OGUNDIJO SAMUEL","FP8720220316","2021/2022","2nd Term","Bank Transfer","","0.00","3000.00","Textbook","JSS1-3","JSS1A","2022-03-16","2022-03-16 08:43:26pm","ogundijo textbook","","undelete","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-03-17 09:20:26am");
INSERT INTO payment_tbl VALUES("238","12","AYANSIBU PRAISE","FP0220220316","2021/2022","2nd Term","Bank Transfer","","0.00","30000.00","Tuition Fee-Second Term","SS1-3","SS1A","2022-03-16","2022-03-16 08:48:44pm","Praise school fees","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("239","16","","","2020/2021","1st Term","","","2000.00","0.00","CARDIGAN","JSS1-3","JSS1","2022-03-17","2022-03-17 08:40:05am","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("240","16","","","2020/2021","1st Term","","","2000.00","0.00","TEXTBOOK","JSS1-3","JSS1","2022-03-17","2022-03-17 08:40:05am","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("241","16","","","2020/2021","1st Term","","","5000.00","0.00","UNIFORM","JSS1-3","JSS1","2022-03-17","2022-03-17 08:40:05am","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("242","16","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2022-03-17","2022-03-17 08:40:05am","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("243","16","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-03-17","2022-03-17 08:40:05am","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("244","16","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2022-03-17","2022-03-17 08:40:05am","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("245","16","AKINADE JAMES","FP3820220317","2021/2022","2nd Term","Bank Transfer","","0.00","0.00","Tuition Fee-Second Term","JSS1-3","JSS1A","2022-03-17","2022-03-17 08:42:40am","payment for school fees","","delete","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-03-17 08:46:57am");
INSERT INTO payment_tbl VALUES("246","16","AKINADE JAMES","FP5120220317","2021/2022","2nd Term","Bank Transfer","","0.00","0.00","Tuition Fee-Second Term","JSS1-3","JSS1A","2022-03-17","2022-03-17 09:25:43am","james school fees","","undelete","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2022-03-17 09:30:40am");
INSERT INTO payment_tbl VALUES("247","16","AKINADE JAMES","FP6520220317","2021/2022","2nd Term","Cash","","0.00","1000.00","Cardigan","JSS1-3","JSS1A","2022-03-17","2022-03-17 09:34:15am","PAYMENT FOR CARDIGAN","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("248","8","GBENGA ANU","FP0520220317","2021/2022","2nd Term","Cash","","0.00","5000.00","Tuition Fee-Second Term","JSS1-3","JSS1B","2022-03-17","2022-03-17 09:35:21am","FOR SCH. FEES","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("249","11","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:31:36pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("250","11","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:31:36pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("251","11","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:31:36pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("252","11","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:31:36pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("253","11","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:31:36pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("254","11","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:31:36pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("255","17","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:32:08pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("256","17","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:32:08pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("257","17","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:32:08pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("258","17","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:32:08pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("259","17","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:32:08pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("260","17","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2022-04-03","2022-04-03 09:32:08pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("261","17","AKINADE MARY","FP6120220403","2021/2022","2nd Term","Cash","","0.00","20000.00","Textbook","JSS1-3","JSS1A","2022-04-03","2022-04-03 09:39:03pm","school fees payment","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("262","19","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-08","2022-04-08 12:21:39pm","Cardigan","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("263","19","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-08","2022-04-08 12:21:39pm","Textbook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("264","19","","","2020/2021","1st Term","","","5000.00","0.00","","JSS1-3","JSS1","2022-04-08","2022-04-08 12:21:39pm","Uniform","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("265","19","","","2020/2021","1st Term","","","10000.00","0.00","","JSS1-3","JSS1","2022-04-08","2022-04-08 12:21:39pm","Tuition Fee-First Term","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("266","19","","","2020/2021","1st Term","","","2000.00","0.00","","JSS1-3","JSS1","2022-04-08","2022-04-08 12:21:39pm","Notebook","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("267","19","","","2020/2021","1st Term","","","1000.00","0.00","","JSS1-3","JSS1","2022-04-08","2022-04-08 12:21:39pm","Games Wear","active","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("268","19","ADEYA SEUN","FP7720220408","2021/2022","2nd Term","Cash","","0.00","5000.00","Tuition Fee-Second Term","JSS1-3","JSS1A","2022-04-08","2022-04-08 12:23:59pm","Sch. Fees  Part payment for Adeya Seun","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("269","19","ADEYA SEUN","FP7220220408","2021/2022","2nd Term","Cash","","0.00","2000.00","Cardigan","JSS1-3","JSS1A","2022-04-08","2022-04-08 12:44:58pm","refund- cardigan","","undelete","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("270","","","","2021/2022","2nd Term","","392775","5000.00","0.00","Tuition Fee-Second Term","JSS1-3","","2022-04-12","2022-04-12 02:59:52pm","Tuition Fee-Second Term","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("271","","","","2021/2022","3rd Term","","245338","5000.00","0.00","Tuition Fee-Third Term","JSS1-3","","2022-04-12","2022-04-12 03:02:09pm","Tuition Fee-Third Term","","","ATANSUYI EMMANUEL SEUN","","");
INSERT INTO payment_tbl VALUES("272","19","ADEYA SEUN","FP4820220412","2021/2022","1st Term","Cash","","2000.00","0.00","Cardigan","JSS1-3","JSS1A","2022-04-12","2022-04-12 03:23:12pm","payment for cardigan","","undelete","ATANSUYI EMMANUEL SEUN","","");



CREATE TABLE `school_tbl` (
  `sch_id` int(11) NOT NULL AUTO_INCREMENT,
  `sch_name` varchar(100) NOT NULL,
  `status` varchar(50) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`sch_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO school_tbl VALUES("1","Creche/Kindergaten","active","JOSHUA","2021-09-04","2021-09-04 09:17:13pm","","");
INSERT INTO school_tbl VALUES("2","Nursery/Primary","active","JOSHUA","2021-09-04","2021-09-04 09:19:42pm","ATANSUYI EMMANUEL SEUN","2021-09-25 01:53:15pm");
INSERT INTO school_tbl VALUES("3","Secondary","active","JOSHUA","2021-09-04","2021-09-04 09:21:55pm","","");
INSERT INTO school_tbl VALUES("4","University","inactive","ATANSUYI EMMANUEL SEUN","2022-04-08","2022-04-08 12:05:01pm","","");



CREATE TABLE `session_tbl` (
  `se_id` int(11) NOT NULL AUTO_INCREMENT,
  `sch_session` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`se_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO session_tbl VALUES("1","2021/2022","active","JOSHUA","2021-08-27","2021-08-27 05:41:34am","","");
INSERT INTO session_tbl VALUES("2","2022/2023","active","ATANSUYI EMMANUEL SEUN","2021-09-17","2021-09-17 08:18:26pm","ATANSUYI EMMANUEL SEUN","2022-04-10 10:08:33pm");



CREATE TABLE `student_tbl` (
  `std_id` int(11) NOT NULL AUTO_INCREMENT,
  `app_number` varchar(255) NOT NULL,
  `firstname` varchar(100) NOT NULL,
  `surname` varchar(100) NOT NULL,
  `othername` varchar(100) NOT NULL,
  `studentid` varchar(100) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `dob` date NOT NULL,
  `class_group` varchar(10) NOT NULL,
  `class_name` varchar(10) NOT NULL,
  `religion` varchar(50) NOT NULL,
  `joining_date` date NOT NULL,
  `session` varchar(50) NOT NULL,
  `student_image` varchar(255) NOT NULL,
  `fathername` varchar(50) NOT NULL,
  `fatheroccupation` varchar(100) NOT NULL,
  `fathernumber` varchar(11) NOT NULL,
  `fatheremail` varchar(255) NOT NULL,
  `mothername` varchar(50) NOT NULL,
  `motheroccupation` varchar(100) NOT NULL,
  `mothernumber` varchar(11) NOT NULL,
  `motheremail` varchar(255) NOT NULL,
  `preaddress` varchar(255) NOT NULL,
  `peraddress` varchar(255) NOT NULL,
  `creation_date` date NOT NULL,
  `create_by` varchar(255) DEFAULT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  `fee_status` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`std_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

INSERT INTO student_tbl VALUES("19","SMS151520220408","SEUN","ADEYA","OLAMIPO","SMS105220220408","Female","2022-04-05","JSS1-3","JSS1A","CHRISTIAN","2022-04-08","2021/2022","software to build your website.jpg","ADEYA GBENGA","BUILDER","09009090909","gbenga@gmai.com","ABIGEAL SEUN","TRADER","08087878787","seun@yahoo.com","ADELANI MATOGUN ROAD","ADELANI MATOGUN ROAD","2022-04-08","ATANSUYI EMMANUEL SEUN","","","added");
INSERT INTO student_tbl VALUES("11","SMS200020211017","SAMUEL","OGUNDIJO","SEGUN","SMS200020211017","Female","2001-02-03","JSS1-3","JSS1A","$religion","2021-02-02","2021/2022","breaking-news.jpg","MR. OGUNDIJO","CIVIL SERVANT","08029993994","ogundijo@yahoo.com","Mrs. ogundijo","TRADER","08029993343","mrsogund@gmail.com","IJOKO IFO OGUN STATE","IJOKO IFO OGUN STATE","2021-10-17","ATANSUYI EMMANUEL SEUN","ATANSUYI EMMANUEL SEUN","2021-11-28","added");
INSERT INTO student_tbl VALUES("12","SMS611720211017","PRAISE","AYANSIBU","ENIKANOSELU","SMS836420211017","Female","1988-10-28","SS1-3","SS1A","CHRISTIAN","2019-10-28","2021/2022","purpose driven.jpg","AYANDIBU GBOLAHAN","PASTOR","08099090909","ayandibu@yahoo.com","AYANDIBU FUNMI","FOOD SELLER","08099888787","fun@yahoo.com","Aladura B/Stop, Matogun Road, Ogun State.","Aladura B/Stop, Matogun Road, Ogun State.","2021-10-17","ATANSUYI EMMANUEL SEUN","","","added");
INSERT INTO student_tbl VALUES("15","SMS698720211128","OMOLARA","ANIYIKAYE","ADURA","SMS606220211128","Female","2000-10-28","SS1-3","SS1A","CHRISTIAN","2021-11-30","2021/2022","jobastech logo update.jpg","ANIYIKAYE ISRAEL","CARPENTER","08992399999","aniyikaye@yahoo.com","IYA PAMILERIN","TRADER","08023242342","iyapemilerin@gmail.com","IDI OSAN MATOGUN ROAD","IDI OSAN MATOGUN ROAD","2021-11-28","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("18","SMS785320220319","GAFAR","ADEWALE","SUNNY","GWS12345","Male","2010-05-03","JSS1-3","Basic 1","CHRISTIAN","2022-03-19","2021/2022","jesus-christ-shivkumar-menon.jpg","GAFAR SENI","BARBER","07023454534","SENI@Y.COM","GAFAR FLORENCE","FOOD SELLER","09028982948","florence@gmail.com","ABESAN IYANA IPAJA, ALIMOSHO, LAGOS STATE","ABESAN IYANA IPAJA, ALIMOSHO, LAGOS STATE","2022-03-19","ATANSUYI EMMANUEL SEUN","","","applicable");
INSERT INTO student_tbl VALUES("17","SMS744120220318","MARY","AKINADE","FOLAKE","SMS876220220318","Female","2017-06-05","JSS1-3","JSS1A","CHRISTIAN","2022-01-03","2021/2022","NIKE PIX.png","AKINADE JAMES","MECHANIC","07026787888","akinade@yahoo.com","AKINADE MODUPE","TRADER","08028934938","modupe@yahoo.com","Idi Osan Inside, Matogun, Ogun State","Idi Osan Inside, Matogun, Ogun State","2022-03-18","ATANSUYI EMMANUEL SEUN","","","added");
INSERT INTO student_tbl VALUES("13","SMS490120211117","OLUWATOMIYIN","OLOJO","HANNAH","SMS913720211117","Female","2007-06-06","SS1-3","SS1A","CHRISTIAN","2020-10-14","2021/2022","ilori.jpg","OLOJO JOSHUA","CIVIL SERVANT","08033445566","olojo@yahoo.com","MRS. OLOJO","TRADER","08029934993","mrsolojo@gmail.com","ABULE OSHO MATOGUN, IFO OGUN STATE","ABULE OSHO MATOGUN, IFO OGUN STATE","2021-11-17","ATANSUYI EMMANUEL SEUN","","","added");
INSERT INTO student_tbl VALUES("14","SMS020520211123","ELISHA","ATANSUYI","BABAMI","SMS774620211123","Male","2017-09-30","JSS1-3","JSS1B","CHRISTIAN","2020-10-28","2021/2022","WhatsApp Image 2020-12-14 at 7.03.25 PM (1).jpeg","ATANSUYI EMMAUEL","TEACHER","08065138173","emmanuel@yahoo.com","ATANSUYI ABOSEDE","TRADER","08098928392","abatans@gmai.com","ALADURA BUS STOP MATOGUN ROAD, VIA OKE-ARO, IFO, OGUN STATE","ALADURA BUS STOP MATOGUN ROAD, VIA OKE-ARO, IFO, OGUN STATE","2021-11-23","ATANSUYI EMMANUEL SEUN","","","added");
INSERT INTO student_tbl VALUES("16","SMS393820220317","JAMES","AKINADE","OLANIPEKUN","SMS592420220317","Male","2007-02-17","JSS1-3","JSS1A","CHRISTIAN","2022-03-14","2021/2022","supr img 3.jpg","AKINADE BABARINSA","FARMER","08023456778","babarinsa@gmail.com","AKINADE MODUPE","TRADER","08123894949","modupe@yahoo.com","2, AJAYI BUS STOP, MATOGUN ROAD, IFO, OGUN STATE","2, AJAYI BUS STOP, MATOGUN ROAD, IFO, OGUN STATE","2022-03-17","ATANSUYI EMMANUEL SEUN","","","added");



CREATE TABLE `sublink_tbl` (
  `sublink_id` int(11) NOT NULL AUTO_INCREMENT,
  `sublink_name` varchar(255) NOT NULL,
  `link_id` int(11) NOT NULL,
  `status` varchar(20) NOT NULL,
  `sublink_url` varchar(255) NOT NULL,
  `create_by` varchar(255) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`sublink_id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;

INSERT INTO sublink_tbl VALUES("1","Add School","2","active","school.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:52:34pm","","");
INSERT INTO sublink_tbl VALUES("2","Add Class Group","2","active","class_group.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:53:58pm","","");
INSERT INTO sublink_tbl VALUES("3","Add Class","2","active","class.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:54:22pm","","");
INSERT INTO sublink_tbl VALUES("4","Add Session","2","active","session.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:54:39pm","","");
INSERT INTO sublink_tbl VALUES("5","Add Term","2","active","term.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:54:46pm","","");
INSERT INTO sublink_tbl VALUES("6","Fee Category","2","active","fee_category.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:55:08pm","","");
INSERT INTO sublink_tbl VALUES("7","Fee Structure","2","active","fee_structure.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:55:22pm","","");
INSERT INTO sublink_tbl VALUES("8","Expenses Setup","2","active","expenses.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:55:39pm","","");
INSERT INTO sublink_tbl VALUES("9","Add Student","3","active","add_student.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:56:19pm","","");
INSERT INTO sublink_tbl VALUES("10","Students List","3","active","students.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:56:34pm","","");
INSERT INTO sublink_tbl VALUES("11","Manage Student","3","active","manage_students.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:56:52pm","","");
INSERT INTO sublink_tbl VALUES("12","Add Teacher","4","active","add_teacher.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:57:11pm","","");
INSERT INTO sublink_tbl VALUES("13","Teachers List","4","active","teachers.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:57:29pm","","");
INSERT INTO sublink_tbl VALUES("14","Manager Teacher","4","active","manage_teachers.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:57:46pm","","");
INSERT INTO sublink_tbl VALUES("15","Add Student Fee","5","active","addfee.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:58:33pm","","");
INSERT INTO sublink_tbl VALUES("16","Student Fee Status","5","active","feestatus.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:58:51pm","","");
INSERT INTO sublink_tbl VALUES("17","Make Expense","5","active","addexpense.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:01pm","","");
INSERT INTO sublink_tbl VALUES("18","Make Payment","5","active","student_payment.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:14pm","","");
INSERT INTO sublink_tbl VALUES("19","Manage Payment","5","active","payment_list.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:28pm","","");
INSERT INTO sublink_tbl VALUES("20","View Reports","6","active","view_reports.php","ATANSUYI EMMANUEL SEUN","2022-04-13","2022-04-13 12:59:45pm","","");
INSERT INTO sublink_tbl VALUES("21","Add Link","2","inactive","add_link.php","ATANSUYI EMMANUEL","2022-04-14","2022-04-14 5:28PM","","");
INSERT INTO sublink_tbl VALUES("22","Add Sub Link","2","inactive","add_sublink.php","ATANSUYI JOSHUA","2022-04-14","2022-04-14 5:31PM","","");
INSERT INTO sublink_tbl VALUES("23","General Reports","6","inactive","generalreports.php","ATANSUYI EMMANUEL SEUN","2022-04-14","2022-04-14 04:37:57pm","","");



CREATE TABLE `teacher_tbl` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) NOT NULL,
  `teacher_name` varchar(200) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `dob` date NOT NULL,
  `pno` varchar(11) NOT NULL,
  `joining_date` date NOT NULL,
  `qualification` varchar(255) NOT NULL,
  `experience` varchar(255) NOT NULL,
  `username` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `pwd` varchar(100) NOT NULL,
  `r_pwd` varchar(100) NOT NULL,
  `address` varchar(255) NOT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `create_by` varchar(100) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO teacher_tbl VALUES("1","TEA/123456","ATANSUYI EMMANUEL SEUN","Male","2022-03-18","08065138173","2022-03-18","HND, AGRIC EXTENTION","BETHSADA NUT/PRY. GODS POWER INTL SCHOOL","emmanuel","emman@yahoo.co","123ab","123ab","ALADURA BUS STOP, MATOGUN ROAD, IFO, OGUN STATE","AGBADO","OGUN","NIGERIA","JOSHUA","2021-09-05","2021-09-05 07:09:55pm","ATANSUYI EMMANUEL SEUN","2022-03-19");
INSERT INTO teacher_tbl VALUES("4","TEA/123456","ATANSUYI ABOSEDE","Female","2020-07-05","08065138173","2019-08-05","HND, AGRIC EXTENTION","BETHSADA NUT/PRY, GODS POWER INTL SCHOOL","oreoluwa","emman@yahoo.co","123ab","123ab","ALADURA BUS STOP, MATOGUN ROAD, IFO, OGUN STATE","AGBADO","OGUN","NIGERIA","JOSHUA","2021-09-06","2021-09-06 07:09:09am","","");
INSERT INTO teacher_tbl VALUES("9","TE48441","ADENIYI SEUN ADERIBIGBE","Male","2021-11-18","08027580601","2021-11-24","BUSINESS ADMIN","5 YEARS","emmanuel","adniyiseun@yahoo.com","123cd","123cd","Aladura B/Stop, Matogun Road, Ogun State.","Agbado","Ogun","Nigeria","ATANSUYI EMMANUEL SEUN","2021-11-28","2021-11-28 08:11:01pm","ATANSUYI EMMANUEL SEUN","2021-11-30");
INSERT INTO teacher_tbl VALUES("10","TE89702","OGUNDIJO SAMUEL","Male","2004-01-16","09067897665","2006-01-17","BSC.","2 YEARS","ogundijo","segdijo@gmail.com","seg123","seg123","ijoko ota, tao block, ifo, ogun state","ijoko ota","ogun state","nigeria","ATANSUYI EMMANUEL SEUN","2022-03-17","2022-03-17 08:03:18am","","");



CREATE TABLE `term_tbl` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `sch_term` varchar(100) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_by` varchar(50) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  `update_by` varchar(255) DEFAULT NULL,
  `update_dt` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO term_tbl VALUES("1","1st Term","active","JOSHUA","2021-08-28","2021-08-28 03:13:32pm","","");
INSERT INTO term_tbl VALUES("2","2nd Term","active","JOSHUA","2021-08-28","2021-08-28 03:19:30pm","","");
INSERT INTO term_tbl VALUES("3","3rd Term","active","JOSHUA","2021-08-28","2021-08-28 03:20:04pm","","");



CREATE TABLE `testing_tbl` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `fee_category` varchar(200) DEFAULT NULL,
  `class_group` varchar(50) NOT NULL,
  `session` varchar(50) NOT NULL,
  `term` varchar(50) NOT NULL,
  `debit` double(10,2) NOT NULL,
  `credit` double(10,2) NOT NULL,
  `creation_date` date NOT NULL,
  `date_time` varchar(255) NOT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO testing_tbl VALUES("7","0","school fee","JSS1","2021/2022","1st Term","30000.00","0.00","2021-09-25","2021-09-25 04:45:39am");
INSERT INTO testing_tbl VALUES("8","0","","JSS1","2021/2022","1st Term","5000.00","0.00","2021-09-25","2021-09-25 04:55:04am");
INSERT INTO testing_tbl VALUES("9","0","","JSS1","2021/2022","1st Term","3000.00","0.00","2021-09-25","2021-09-25 10:00:41am");
INSERT INTO testing_tbl VALUES("10","5","School Fee","JSS1","2021/2022","1st Term","0.00","30000.00","2021-09-25","2021-09-25 10:56:54am");

