<?php
session_start();
include "db_config.php";
require "smtp_config.php";

error_reporting(E_ALL);
ini_set('display_errors', 1);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'includes/PHPMailer/src/Exception.php';
require 'includes/PHPMailer/src/PHPMailer.php';
require 'includes/PHPMailer/src/SMTP.php';

$email = trim($_POST['email']);
$otp = rand(100000, 999999);

// Check if email exists
$sql = "SELECT * FROM teacher_tbl WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $_SESSION['reset_otp'] = $otp;
    $_SESSION['reset_email'] = $email;

    // Set up PHPMailer
    $mail = new PHPMailer(true);

    try {
        // SMTP settings
        $mail->isSMTP();
        $mail->SMTPDebug = 0; // ✅ turn off for production
        $mail->Host = 'mail.jobastech.com.ng';
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USER;
        $mail->Password = SMTP_PASS;
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;
        //$mail->SMTPDebug = 2; // Use 2 or 3 for detailed output
        $mail->Debugoutput = 'html';


        // Email content
        $mail->setFrom('noreply@jobastech.com.ng', 'Graceway - Password Reset');
        $mail->addReplyTo('noreply@jobastech.com.ng');
        $mail->addAddress($email);
        $mail->Subject = 'Password Reset Code';
        $mail->isHTML(true);
        $mail->Body = "
        <div style='
            background-color: #003366;
            padding: 20px;
            color: white;
            font-family: Arial, sans-serif;
            line-height: 1.6;
            max-width: 600px;
            margin: 0 auto;
            border-radius: 8px;
        '>
            <div style='
                text-align: center;
                font-size: 22px;
                font-weight: bold;
                margin-bottom: 20px;
                color:white;
            '>
                GRACEWAY SCHOOL <br><span style='font-size: 14px; color:white; font-weight: normal;'>(JSMS V.1.0)</span>
            </div>

            <p style='color:white;'>Hello,</p>

            <p>Your password reset code is: 
                <span style='
                    display: inline-block;
                    background-color: #ffffff;
                    color: #003366;
                    padding: 8px 12px;
                    font-weight: bold;
                    border-radius: 4px;
                    font-size: 18px;
                '>$otp</span>
            </p>

            <p style='color:white;'>Please use this code to proceed with resetting your password.</p>

            <p style='margin-top: 40px; color:white; font-size: 12px; text-align: center;'>
                &copy; JSMS " . date('Y') . "
            </p>
        </div>";

        $mail->AltBody = "Your password reset code is: $otp";


        $mail->send();

        $_SESSION['reset_msg'] = "Reset code sent to your email.";
        header("Location: verify_code.php");
        exit();
    } catch (Exception $e) {
        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
} else {
    echo "<div style='
    background-color: #28a745;
    color: white;
    padding: 15px;
    border-radius: 5px;
    margin-top: 20px;
    font-family: Arial, sans-serif;
'>
    ✅ Email not found. 
    <a href='forgot-password.php' style='color: #fff; text-decoration: underline; font-weight: bold;'>Try Again</a>
</div>";
}
