<?php

$connection = mysqli_connect(
    "localhost",
    "momcscom_jobastech",
    "qofP~6VSYk~T6d*h",
    "momcscom_school_mgmt_db"
);

if (!$connection) {
    die("Database connection failed: " . mysqli_connect_error());
}

// ✅ Ensure school_code is available
if (!isset($_SESSION['school_code'])) {
    die("No school code found in session.");
}

// Get school code
$school_code = $_SESSION['school_code'];

// ✅ Determine your base URL dynamically
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443)
    ? "https://" : "http://";
$base_url = $protocol . $_SERVER['HTTP_HOST'] . "/"; // e.g. https://jobastech.com.ng/

// Fetch school settings
$school_sql = "SELECT school_name, school_logo, school_stamp, school_signature 
               FROM school_settings_tbl 
               WHERE school_code = ?";
$stmt = $connection->prepare($school_sql);

if (!$stmt) {
    die("Prepare failed: " . $connection->error);
}

$stmt->bind_param('s', $school_code);
$stmt->execute();

$sch_result = $stmt->get_result();
$sch_data = $sch_result->fetch_assoc();

// ✅ Convert all image paths into full URLs
$school_name = !empty($sch_data['school_name']) ? $sch_data['school_name'] : "JOBASTECH";

$school_logo = !empty($sch_data['school_logo']) 
    ? $base_url . "jsms/admin/assets/images/school/" . $sch_data['school_logo']
    : $base_url . "jsms/admin/assets/images/school/default_logo.png";

$school_stamp = !empty($sch_data['school_stamp']) 
    ? $base_url . "jsms/admin/assets/images/school/" . $sch_data['school_stamp']
    : $base_url . "jsms/admin/assets/images/school/default_logo.png";

$school_signature = !empty($sch_data['school_signature']) 
    ? $base_url . "jsms/admin/assets/images/school/" . $sch_data['school_signature']
    : $base_url . "jsms/admin/assets/images/school/default_logo.png";
?>
