<?php
session_start();

if (!isset($_SESSION['reset_otp']) || !isset($_POST['otp'])) {
    die("OTP session expired or not submitted. <a href='verify_code.php'>Try again</a>");
}

// DEBUG TEST
// echo "Session OTP: " . ($_SESSION['reset_otp'] ?? 'NULL') . "<br>";
// echo "Posted OTP: " . ($_POST['otp'] ?? 'NULL') . "<br>";

// Sanitize user input
$entered_otp = trim($_POST['otp']);
$expected_otp = $_SESSION['reset_otp'];

if ($entered_otp != $expected_otp) {
    die("Invalid OTP. <a href='verify_code.php'>Try again</a>");
}

// OTP is valid. Proceed to password reset form
?>

<!-- Show password reset form -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Reset Your Password</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Bootstrap 4 CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    
    <style>
        body {
            background: #003366;
            color: #fff;
            font-family: 'Segoe UI', sans-serif;
        }
        .reset-box {
            margin-top: 100px;
            background: #fff;
            color: #333;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.3);
        }
        .reset-box h4 {
            font-weight: bold;
            text-align: center;
            margin-bottom: 30px;
            color: #003366;
        }
        .btn-primary {
            background-color: #003366;
            border: none;
        }
        .footer {
            text-align: center;
            margin-top: 50px;
            color: #ccc;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="reset-box">
                <h4>Reset Your Password</h4>
                <form method="post" action="update_password.php">
                    <div class="form-group">
                        <label for="new_password">New Password:</label>
                        <input type="password" class="form-control" name="new_password" id="new_password" required>
                    </div>
                    <div class="form-group">
                        <label for="confirm_password">Confirm Password:</label>
                        <input type="password" class="form-control" name="confirm_password" id="confirm_password" required>
                    </div>
                    <button type="submit" class="btn btn-primary btn-block">Update Password</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="footer">
    &copy; <?= date("Y"); ?> JOBASTECH SCHOOL MGT. SYSTEM (JSMS V.1.0)
</div>

<!-- Optional Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
