<?php
include "db_config.php";
include "auth.php";



function getSessionTermById($conn, $table, $table_id, $id) {
    $sql = "SELECT * FROM $table WHERE $table_id = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param('i', $id);
    $stmt->execute();

    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    } else {
        return null; // No session found
    }
}



if(isset($_POST['reportcard'])){

	$stdid = $_POST['stdid'];
	$classgroupid = $_POST['classgroupid'];
	$session_id = $_POST['session'];
	$term_id = $_POST['term'];

	$session_row = getSessionTermById($conn, 'session_tbl', 'se_id', $session_id);
	$term_row = getSessionTermById($conn, 'term_tbl', 't_id', $term_id);
	if($session_row){
		$session_name = $session_row['sch_session'];
	}else{
		echo 'Session Not Found';
	}
	if($session_row){
		$term_name = $term_row['sch_term'];
	}else{
		echo 'Term Not Found';
	}

	$sql1 = "SELECT s.*, cg.class_group, c.class_name, sc.sch_name
		FROM student_tbl s JOIN school_tbl sc ON s.school = sc.sch_id 
		JOIN classgroup_tbl cg ON s.class_group = cg.cg_id
		JOIN class_tbl c ON c.classgroup_id = cg.cg_id WHERE s.std_id = '".$stdid."'";

		$query1  =  mysqli_query($conn,$sql1)  or die($sql1);
		$rs1 = mysqli_fetch_assoc($query1);

		$studentid= $rs1['student_id'];
		$firstname = $rs1['firstname'];
		$surname = $rs1['surname'];
		$othername =$rs1['othername'];
		$gender = $rs1['gender'];
		$img  = $rs1['student_image'];
		$fullname = $surname. " ". $firstname. " ". $othername;
		//$classgroup= $rs1['class_group'];
		$classname= $rs1['class_name'];
		$classgroup = $rs1['class_group'];
		$school = $rs1['school'];
		$dob= $rs1['dob'];
		$religion= $rs1['religion'];
		$fathername = $rs1['fathername'];$fatheroccupation = $rs1['fatheroccupation'];
		$fathernumber = $rs1['fathernumber'];$fatheremail = $rs1['fatheremail'];
		$mothername = $rs1['mothername'];$motheroccupation = $rs1['motheroccupation'];
		$mothernumber = $rs1['mothernumber'];$motheremail = $rs1['motheremail'];
		$peraddress = $rs1['peraddress'];
		$preaddress = $rs1['preaddress'];

}



?>



<!DOCTYPE html>
<html>
<head>
	
	<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>Fees- Report Card</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

		<!-- Datatables CSS -->
		<link rel="stylesheet" href="assets/plugins/datatables/datatables.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

</head>
<body>
	<div class="container">
		<?php include "reportheader.php"; ?>
		<?php
			function getGrade($score) {
			if ($score >= 70) return 'A';
			elseif ($score >= 60) return 'B';
			elseif ($score >= 50) return 'C';
			elseif ($score >= 45) return 'D';
			elseif ($score >= 40) return 'E';
			else return 'F';
		}

		function getRemark($grade) {
			switch ($grade) {
				case 'A': return 'Excellent';
				case 'B': return 'Very Good';
				case 'C': return 'Good';
				case 'D': return 'Fair';
				case 'E': return 'Poor';
				case 'F': return 'Fail';
			}
		}

		?>

		<?php
			$subjects = [];

			$sql = "SELECT ss.subject_id, ss.subject_name, te.test_score, te.exam_score
					FROM subject_tbl s
					JOIN school_subject ss ON s.subject_name = ss.subject_id
					LEFT JOIN test_exam_tbl te ON te.subject_name = s.sub_id 
					AND te.std_id = ? AND te.session = ? AND te.term = ?
					WHERE s.class_group = ?";

			$stmt = $conn->prepare($sql);
			$stmt->bind_param("iiii", $stdid, $session_id, $term_id, $classgroupid);
			$stmt->execute();
			$result = $stmt->get_result();

			while ($row = $result->fetch_assoc()) {
				$subjects[] = [
					'id' => $row['subject_id'],
					'name' => ucwords($row['subject_name']),
					'test_score' => $row['test_score'] ?? 0,
					'exam_score' => $row['exam_score'] ?? 0
				];
			}
		?>

		<div class="container mt-4 p-4 shadow bg-white rounded">
			<div class="text-center mb-4">
				<h4>JOBASTECH INTERNATIONAL SCHOOL</h4>
				<h5>Report Card</h5>
				<p>Session: <?= $session_name ?> | Term: <?= $term_name ?></p>
				<p>Student Name: <?= $fullname ?> | Class: <?= $classname ?></p>
			</div>

			<table class="table table-bordered text-center">
				<thead class="table-light">
				<tr>
					<th>Subject</th>
					<th>Test Score (40)</th>
					<th>Exam Score (60)</th>
					<th>Total (100)</th>
					<th>Grade</th>
					<th>Remark</th>
				</tr>
				</thead>
				<tbody>
				<?php foreach ($subjects as $subject): 
					$total = $subject['test_score'] + $subject['exam_score'];
					$grade = getGrade($total); // Helper function
					$remark = getRemark($grade); // Helper function
				?>
				<tr>
					<td><?= $subject['name'] ?></td>
					<td><?= $subject['test_score'] ?></td>
					<td><?= $subject['exam_score'] ?></td>
					<td><?= $total ?></td>
					<td><?= $grade ?></td>
					<td><?= $remark ?></td>
				</tr>
				<?php endforeach; ?>
				</tbody>
			</table>

			<div class="text-end mt-4">
				<a href="generate_pdf.php?student_id=<?= $stdid ?>&session=<?= $session_id ?>&term=<?= $term_id ?>" class="btn btn-success">Download PDF</a>
			</div>
		</div>


		<button style="margin-top: 15px;margin-bottom:15px" type="button" class="btn btn-info" onclick="window.print()">Print</button>
	</div>						 
</body>
</html>
 




							 