<?php
include "db_config.php";
include "auth.php";
include "school_settings.php";

function getSessionTermById($conn, $table, $table_id, $id) {
    $sql = "SELECT * FROM $table WHERE $table_id = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param('i', $id);
    $stmt->execute();

    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    } else {
        return null; // No session found
    }
}


if(isset($_POST['reportcard'])){

	$stdid = $_POST['stdid'];
	$classgroupid = $_POST['classgroupid'];
	$session_id = $_POST['session'];
	$term_id = $_POST['term'];

	$session_row = getSessionTermById($conn, 'session_tbl', 'se_id', $session_id);
	$term_row = getSessionTermById($conn, 'term_tbl', 't_id', $term_id);
	if($session_row){
		$session_name = $session_row['sch_session'];
	}else{
		echo 'Session Not Found';
	}
	if($session_row){
		$term_name = $term_row['sch_term'];
	}else{
		echo 'Term Not Found';
	}

	$sql1 = "SELECT s.*, cg.class_group, c.class_name, sc.sch_name
		FROM student_tbl s JOIN school_tbl sc ON s.school = sc.sch_id 
		JOIN classgroup_tbl cg ON s.class_group = cg.cg_id
		JOIN class_tbl c ON c.classgroup_id = cg.cg_id WHERE s.std_id = '".$stdid."'";

		$query1  =  mysqli_query($conn,$sql1)  or die($sql1);
		$rs1 = mysqli_fetch_assoc($query1);

		$studentid= $rs1['student_id'];
		$firstname = $rs1['firstname'];
		$surname = $rs1['surname'];
		$othername =$rs1['othername'];
		$gender = $rs1['gender'];
		$img  = $rs1['student_image'];
		$fullname = $surname. " ". $firstname. " ". $othername;
		//$classgroup= $rs1['class_group'];
		$classname= $rs1['class_name'];
		$classgroup = $rs1['class_group'];
		$school = $rs1['school'];
		$dob= $rs1['dob'];
		$religion= $rs1['religion'];
		$fathername = $rs1['fathername'];$fatheroccupation = $rs1['fatheroccupation'];
		$fathernumber = $rs1['fathernumber'];$fatheremail = $rs1['fatheremail'];
		$mothername = $rs1['mothername'];$motheroccupation = $rs1['motheroccupation'];
		$mothernumber = $rs1['mothernumber'];$motheremail = $rs1['motheremail'];
		$peraddress = $rs1['peraddress'];
		$preaddress = $rs1['preaddress'];
}

?>

<!DOCTYPE html>
<html>
<head>
	
	<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS- Report Card</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

		<!-- Datatables CSS -->
		<link rel="stylesheet" href="assets/plugins/datatables/datatables.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

</head>
<body>
<div class="container" id="reportCard">
	<?php include "reportheader.php"; ?>

	<?php
	function getGrade($score) {
			if ($score >= 70) return 'A';
			elseif ($score >= 60) return 'B';
			elseif ($score >= 50) return 'C';
			elseif ($score >= 45) return 'D';
			elseif ($score >= 40) return 'E';
			else return 'F';
		}

		function getRemark($grade) {
			switch ($grade) {
				case 'A': return 'Excellent';
				case 'B': return 'Very Good';
				case 'C': return 'Good';
				case 'D': return 'Fair';
				case 'E': return 'Poor';
				case 'F': return 'Fail';
			}
		}

	$subjects = [];
	$total_score = 0;
	$total_subjects = 0;

	$sql = "SELECT ss.subject_id, ss.subject_name, te.test_score, te.exam_score
        FROM school_subject ss JOIN subject_tbl s ON ss.subject_id = s.subject_id
        LEFT JOIN test_exam_tbl te 
            ON te.subject_id = ss.subject_id 
            AND te.std_id = ? 
            AND te.session = ? 
            AND te.term = ?
        WHERE s.class_group = ? AND te.approval_status='approved'";


	// $sql = "SELECT ss.subject_id, ss.subject_name, te.test_score, te.exam_score
	// 		FROM subject_tbl s
	// 		JOIN school_subject ss ON s.subject_id = ss.subject_id
	// 		LEFT JOIN test_exam_tbl te ON te.subject_id = s.sub_id 
	// 		AND te.std_id = ? AND te.session = ? AND te.term = ?
	// 		WHERE s.class_group = ?";

	$stmt = $conn->prepare($sql);
	$stmt->bind_param("iiii", $stdid, $session_id, $term_id, $classgroupid);
	$stmt->execute();
	$result = $stmt->get_result();

	while ($row = $result->fetch_assoc()) {
		$test = $row['test_score'] ?? 0;
		$exam = $row['exam_score'] ?? 0;
		$subjects[] = [
			'name' => ucwords($row['subject_name']),
			'test_score' => $test,
			'exam_score' => $exam,
			'total' => $test + $exam
		];
		$total_score += ($test + $exam);
		$total_subjects++;
	}

	//Student Average is the total score in all subjects divide by number of subject of a single student
	$average = $total_subjects > 0 ? round($total_score / $total_subjects, 2) : 0;

	// Get class average
	$class_avg_sql = "SELECT AVG(test_score + exam_score) as class_avg 
					FROM test_exam_tbl 
					WHERE session = ? AND term = ? AND class_group = ? AND approval_status ='approved'";
	$class_avg_stmt = $conn->prepare($class_avg_sql);
	$class_avg_stmt->bind_param("iii", $session_id, $term_id, $classgroupid);
	$class_avg_stmt->execute();
	$class_avg_result = $class_avg_stmt->get_result()->fetch_assoc();
	$class_average = round($class_avg_result['class_avg'] ?? 0, 2);

	// Get student total scores for ranking
	$rank_sql = "SELECT std_id, SUM(test_score + exam_score) as total_score 
				FROM test_exam_tbl 
				WHERE session = ? AND term = ? AND class_group = ?
				GROUP BY std_id 
				ORDER BY total_score DESC";
	$rank_stmt = $conn->prepare($rank_sql);
	$rank_stmt->bind_param("iii", $session_id, $term_id, $classgroupid);
	$rank_stmt->execute();
	$rank_result = $rank_stmt->get_result();

	// $rank = 0 ;
	// $last_score = null;
	// $position = 0;
	// $found = false;

	// $positions = [];

	// while($row = $rank_result->fetch_assoc()){
	// 	$rank++;

	// 	//if same score as last student, same position
	// 	if ($last_score!== null && $row[total_score] == $last_score) {

	// 		// code...
	// 	}else{
	// 		$position = $rank;
	// 	}

	// 	if($row['std_id'] == $stdid){
	// 		$found = true;
	// 		break; //stop loop once we find the student
	// 	}

	// 	// $positions[] = [
	// 	// 	'student_id' => $row['std_id'],
	// 	// 	'total_score' => $row['total_score'],
	// 	// 	'position' => $position
	// 	// ];

	// 	$last_score = $row['total_score'];
	// } 

	$position = 0;
	$counter = 0;
	while ($row = $rank_result->fetch_assoc()) {
		$counter++;
		if ($row['std_id'] == $stdid) {
			$position = $counter;
			break;
		}
	}

	// Get remarks from report_remark_tbl
	$remark_stmt = $conn->prepare("SELECT teacher_remark, principal_remark FROM report_remark_tbl WHERE std_id = ? AND session = ? AND term = ?");
	$remark_stmt->bind_param("iii", $stdid, $session_id, $term_id);
	$remark_stmt->execute();
	$remark_data = $remark_stmt->get_result()->fetch_assoc();
	$teacher_remark = $remark_data['teacher_remark'] ?? '';
	$principal_remark = $remark_data['principal_remark'] ?? '';
	?>

	<div class="container mt-4 p-4 shadow bg-white rounded">
		<div class="text-center mb-4">
			<?php if (!empty($school_logo)): ?>
        		<img src="<?= $school_logo; ?>" alt="School Logo" style="width:100px; height:auto; margin-bottom:10px;">
    		<?php endif; ?>
			<h4><?php echo $school_name;?></h4>
			<h5>Report Card</h5>
			<p>Session: <?= $session_name ?> | Term: <?= $term_name ?></p>
			<p>Student Name: <?= $fullname ?> | Class: <?= $classname ?></p>
		</div>

		<table class="table table-bordered text-center">
			<thead class="table-light">
			<tr>
				<th>Subject</th>
				<th>Test Score (40)</th>
				<th>Exam Score (60)</th>
				<th>Total (100)</th>
				<th>Grade</th>
				<th>Remark</th>
			</tr>
			</thead>
			<tbody>
			<?php foreach ($subjects as $subject): 
				$grade = getGrade($subject['total']);
				$remark = getRemark($grade);
			?>
			<tr>
				<td><?= $subject['name'] ?></td>
				<td><?= $subject['test_score'] ?></td>
				<td><?= $subject['exam_score'] ?></td>
				<td><?= $subject['total'] ?></td>
				<td><?= $grade ?></td>
				<td><?= $remark ?></td>
			</tr>
			<?php endforeach; ?>
			</tbody>
		</table>

		<!-- Summary -->
		<div class="mt-4">
			<p><strong>Student Average:</strong> <?= $average ?>%</p>
			<p><strong>Class Average:</strong> <?= $class_average ?>%</p>
			<p><strong>Position in Class:</strong> <?= ordinalSuffix($position) ?></p>
		</div>

		<!-- Remarks -->
		<div class="mt-4">
			<p><strong>Teacher's Remark:</strong> <?= nl2br(htmlspecialchars($teacher_remark)) ?></p>
			<p><strong>Principal's Remark:</strong> <?= nl2br(htmlspecialchars($principal_remark)) ?></p>
		</div>

		<!-- Stamp & Signature Section -->
		<div class="row mt-5">
			<div class="col-md-6 text-start">
				<p><strong>Principal's Signature:</strong></p>
				<?php if (!empty($school_signature)): ?>
					<img src="<?= $school_signature ?>" alt="Teacher Signature" style="width:120px; height:auto;">
				<?php endif; ?>
			</div>
			<div class="col-md-6 text-end">
				<p><strong>School Stamp:</strong></p>
				<?php if (!empty($school_stamp)): ?>
					<img src="<?= $school_stamp ?>" alt="School Stamp" style="width:120px; height:auto; opacity:0.8;">
				<?php endif; ?>
			</div>
		</div>

		<!-- <div class="text-end mt-4">
			<a href="generate_pdf.php?student_id=<?= $stdid ?>&session=<?= $session_id ?>&term=<?= $term_id ?>" class="btn btn-success">Download PDF</a>
		</div> -->
	</div>
	<button onclick="downloadPDF()" class="btn btn-success">Download PDF</button>
	<button style="margin-top: 15px;margin-bottom:15px" type="button" class="btn btn-info" onclick="window.print()">Print</button>
</div>

<?php
function ordinalSuffix($num) {
	$ends = ['th','st','nd','rd','th','th','th','th','th','th'];
	if ((($num % 100) >= 11) && (($num % 100) <= 13))
		return $num . 'th';
	else
		return $num . $ends[$num % 10];
}
?>


	</div>	
	<!-- jsPDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<!-- html2canvas -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<!-- To generate QR code -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>


<script>
  async function downloadPDF() {
    const { jsPDF } = window.jspdf;

    const element = document.getElementById("reportCard");

    // Use html2canvas to capture the element
    const canvas = await html2canvas(element, {
      scale: 2,
      useCORS: true
    });

    const imgData = canvas.toDataURL("image/png");
    const pdf = new jsPDF("p", "mm", "a4");

    const imgProps = pdf.getImageProperties(imgData);
    const pdfWidth = pdf.internal.pageSize.getWidth();
    const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

    pdf.addImage(imgData, "PNG", 0, 0, pdfWidth, pdfHeight);
    pdf.save("report-card.pdf");
  }
</script>

					 
</body>
</html>
 




							 