<?php

include  "db_config.php";


?>


<!DOCTYPE html>
<html>
<head>
	<title>Profit and Loss</title>

	<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

	<!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="../admin/assets/css/buttons.dataTables.min.css">
</head>
<body>
<div class="container">
	<?php include "reportheader.php"; ?>
	<h4 style="margin-top: 15px;">PROFIT AND LOSS REPORT</h4>
	<form method="POST" action="profitandloss.php">

	<div class="row" style="margin-top: 15px;">
		


			<div class="col-md-3">
				<div class="form-group">
					<label>Date From:</label>
					<input type="date" name="datefrom" class="form-control" required>
				</div>
			</div>
			<div class="col-md-3">
				<div class="form-group">
					<label>Date To:</label>
					<input type="date" name="dateto" class="form-control" required>
				</div>
			</div>
			<div class="col-md-3">
				<div class="form-group">
					<label>Session</label>
					<select name="session" class="form-control" required>
						<option value="">--Select Session--</option>
						<?php 
						$termquery = mysqli_query($conn,"SELECT * FROM session_tbl WHERE status='active'");
						while($termdata  = mysqli_fetch_assoc($termquery)){
							$dbsession = $termdata['sch_session'];
							$se_id = $termdata['se_id']; 
						?>
						<option value="<?php echo $se_id;?>"><?php echo $dbsession;?></option>
						<?php }?>
					</select>
				</div>
			</div>
			<div class="col-md-3">
				<div class="form-group">
					<label>Term</label>
					<select name="term" class="form-control" required>
						<option value="">--Select Term--</option>
						<?php 
						$termquery = mysqli_query($conn,"SELECT * FROM term_tbl WHERE status='active'");
						while($termdata  = mysqli_fetch_assoc($termquery)){
							$dbterm = $termdata['sch_term'];
							$t_id = $termdata['t_id']; 
						?>
						<option value="<?php echo $t_id;?>"><?php echo $dbterm;?></option>
						<?php }?>
					</select>
				</div>
			</div>
			<div class="col-md-3" style="margin-top: 30px;">
				<div class="form-group">
					<label></label>
					<button type="submit" name="submit" class="btn btn-primary">View Report</button>
				</div>
			</div>
			
		</div>
		<div style="margin-top: 50px;width: 100%">
		<table id='example' class="table table-bordered" style="width:100%">
		        <thead>
		            <tr>
						<th>SN</th>
		               <th>Items</th>
		            	<th>Amount</th>
		            </tr>
		        </thead>
		        <tbody>
					<?php
					$i = 1;
		        	if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
					$datefrom = $_POST['datefrom'];
					$dateto = $_POST['dateto'];
					$session = $_POST['session'];
					$term = $_POST['term'];

					// Total income
					$income_sql = "SELECT SUM(p.credit) AS total_income FROM payment_tbl p
								WHERE p.trans_date BETWEEN '$datefrom' AND '$dateto'
								AND p.session_id = '$session' AND p.term_id = '$term'
								AND p.trans_type = 15";
					$income_result = mysqli_query($conn, $income_sql);
					$income_data = mysqli_fetch_assoc($income_result);
					$total_income = $income_data['total_income'] ?? 0;
						
					 echo "<tr>
                    <td>" . $i++ . "</td>
                    <td>Total Income</td>
                    <td>" . number_format($total_income, 2) . "</td>
                  	</tr>";

					// Total expenses
					$expense_sql = "SELECT SUM(expamount) AS total_expenses FROM exp_tbl
									WHERE creation_date BETWEEN '$datefrom' AND '$dateto'";
					$expense_result = mysqli_query($conn, $expense_sql);
					$expense_data = mysqli_fetch_assoc($expense_result);
					$total_expenses = $expense_data['total_expenses'] ?? 0;

					echo "<tr>
                    <td>" . $i++ . "</td>
                    <td>Total Expenses</td>
                    <td>" . number_format($total_expenses, 2) . "</td>
                  	</tr>";
					// Net profit/loss
					$net_income = $total_income - $total_expenses;
					$net_label = $net_income >= 0 ? "Net Profit" : "Net Loss";
				}?>
				</tbody>
					<?php if (isset($net_label) && isset($net_income)): ?>
					<tfoot>
						<tr>
							<th colspan="2"><?= $net_label; ?></th>
							<th><?= number_format($net_income, 2); ?></th>
						</tr>
					</tfoot>
					<?php endif; ?>
		    </table>
		   </div>
		</form>
</div>
<!-- jQuery -->
<script src="assets/js/jquery-3.5.1.min.js"></script>

<!-- Datatables JS -->
<script src="assets/plugins/datatables/datatables.min.js"></script>
<script src="../assets/js/jquery-3.5.1.js"></script>
<script src="../admin/assets/js/jquery.dataTables.min.js"></script>
<script src="../admin/assets/js/dataTables.buttons.min.js"></script>
<script src="../admin/assets/js/jszip.min.js"></script> 
<script src="../admin/assets/js/pdfmake.min.js"></script>
<script src="../admin/assets/js/vfs_fonts.js"></script>
<script src="../admin/assets/js/buttons.html5.min.js"></script>
<script src="../admin/assets/js/buttons.print.min.js"></script>

<!-- Datatable init js -->
<script src="../admin/assets/js/datatables.init.js"></script>
        
		
<!-- Custom JS -->
<script src="assets/js/script.js"></script>

<script>
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
} );
</script>
</body>
</html>