<?php
include "db_config.php";
include "auth.php";

function test_input($data){
    return htmlspecialchars(stripslashes(trim($data)));
}

$id = "";

// Get ID from POST or GET
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['stdid'])) {
    $id = test_input($_POST['stdid']);
} elseif (isset($_GET['id'])) {
    $id = test_input($_GET['id']);
}

$firstname = $surname = $othername = $fullname = $classgroup = $classname = "";
$dbstdid = $dbfullname = $dbclassgroup = $dbclassname = $cg_id = "";
$errors = [];

if (!empty($id)) {
    $student_sql = "SELECT s.*, s.class_group AS cg_id, sc.sch_name, cg.class_group, cl.class_name 
        FROM student_tbl s 
        JOIN school_tbl sc ON sc.sch_id = s.school 
        JOIN class_tbl cl ON s.class_name = cl.c_id 
        JOIN classgroup_tbl cg ON s.class_group = cg.cg_id 
        WHERE s.std_id = ? ORDER BY s.surname";
    $student_stmt = $conn->prepare($student_sql);
    $student_stmt->bind_param('i', $id);
    $student_stmt->execute();
    $rw = $student_stmt->get_result()->fetch_assoc();

    if ($rw) {
        $dbstdid = $rw['std_id'];
        $firstname = $rw['firstname'];
        $surname = $rw['surname'];
        $othername = $rw['othername'];
        $dbfullname = $surname . " " . $firstname;
        $cg_id = $rw['cg_id'];
        $dbclassgroup = $rw['class_group'];
        $dbclassname = $rw['class_name'];
    } else {
        $errors[] = "Student not found or invalid ID provided.";
    }
} else {
    $errors[] = "No student ID provided.";
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    $trans_id = rand(100,999).date('Ymd');
    $payref = "FP".rand(1000,9999).date('Ymd');

    $session = test_input($_POST['session'] ?? '');
    $term = test_input($_POST['term'] ?? '');
    $mop = test_input($_POST['mop'] ?? '');
    $amount = test_input($_POST['amount'] ?? '');
    $pc = test_input($_POST['pc'] ?? '');
	$trans_type = test_input($_POST['transtype'] ?? '');
    $narration = test_input($_POST['narration'] ?? '');
    $entrytype = $_POST['entrytype'] ?? 'Dr';

    // Validate inputs
    if ($session == '...Select Session...') $errors[] = "Please select a session.";
    if ($term == '...Select Term...') $errors[] = "Please select a term.";
    if ($mop == '...Mode of Payment...') $errors[] = "Please select a mode of payment.";
    if ($pc == '...Payment Category...') $errors[] = "Please select a payment category.";
    if (empty($amount)) $errors[] = "Amount is required.";
    if (empty($narration)) $errors[] = "Narration is required.";

    date_default_timezone_set('Africa/Lagos');
    $creation_date = date('Y-m-d'); 
    $dt = date('Y-m-d h:i:sa');

    $debit = ($entrytype == 'Dr') ? $amount : 0;
    $credit = ($entrytype == 'Cr') ? $amount : 0;

    if (empty($errors)) {
        $insert_sql = "INSERT INTO payment_tbl (
            p_id, trans_id, trans_type, student_id, pay_ref, 
            classgroup_id, session_id, term_id, mode_of_payment, 
            debit, credit, payment_category, 
            trans_date, date_time, narration, status, posted_by, updated_by, update_dt
        ) VALUES (
            NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'confirmed', ?, NULL, NULL
        )";

        $stmt = $conn->prepare($insert_sql);
        $stmt->bind_param(
            'siisiiiiddissss',
            $trans_id, $trans_type, $dbstdid, $payref,
            $cg_id, $session, $term, $mop,
            $debit, $credit, $pc,
            $creation_date, $dt, $narration, $admin_name
        );

        if ($stmt->execute()) {
            // echo "<script>alert('Transaction Successfully Made'); window.location.href='payment_info.php?id=$dbstdid';</script>";
			echo "<script>alert('Transaction Successfully Made'); window.location.href='student_payment.php';</script>";
            exit;
        } else {
            $errors[] = "Database error: " . $conn->error;
        }
    }
}
?>



<!DOCTYPE html>
<html lang="en">   
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>SMS - Add Class</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- Header -->
            <div class="header">
			
				<!-- Logo -->
                <div class="header-left">
                    <a href="index.html" class="logo">
						<img src="assets/img/logo.png" alt="Logo">
					</a>
					<a href="index.html" class="logo logo-small">
						<img src="assets/img/logo-small.png" alt="Logo" width="30" height="30">
					</a>
                </div>
				<!-- /Logo -->
				
				<a href="javascript:void(0);" id="toggle_btn">
					<i class="fas fa-align-left"></i>
				</a>
				
				<!-- Search Bar -->
				<div class="top-nav-search">
					<form>
						<input type="text" class="form-control" placeholder="Search here">
						<button class="btn" type="submit"><i class="fas fa-search"></i></button>
					</form>
				</div>
				<!-- /Search Bar -->
				
				<!-- Mobile Menu Toggle -->
				<a class="mobile_btn" id="mobile_btn">
					<i class="fas fa-bars"></i>
				</a>
				<!-- /Mobile Menu Toggle -->
				
				<!-- Header Right Menu -->
				<ul class="nav user-menu">

					<!-- Notifications -->
					<li class="nav-item dropdown noti-dropdown">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<i class="far fa-bell"></i> <span class="badge badge-pill">3</span>
						</a>
						<div class="dropdown-menu notifications">
							<div class="topnav-dropdown-header">
								<span class="notification-title">Notifications</span>
								<a href="javascript:void(0)" class="clear-noti"> Clear All </a>
							</div>
							<div class="noti-content">
								<ul class="notification-list">
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-02.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Carlson Tech</span> has approved <span class="noti-title">your estimate</span></p>
													<p class="noti-time"><span class="notification-time">4 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-11.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">International Software Inc</span> has sent you a invoice in the amount of <span class="noti-title">$218</span></p>
													<p class="noti-time"><span class="notification-time">6 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-17.jpg">
												</span>
												<div class="media-body">
												<p class="noti-details"><span class="noti-title">John Hendry</span> sent a cancellation request <span class="noti-title">Apple iPhone XR</span></p>
												<p class="noti-time"><span class="notification-time">8 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-13.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Mercury Software Inc</span> added a new product <span class="noti-title">Apple MacBook Pro</span></p>
													<p class="noti-time"><span class="notification-time">12 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
								</ul>
							</div>
							<div class="topnav-dropdown-footer">
								<a href="#">View all Notifications</a>
							</div>
						</div>
					</li>
					<!-- /Notifications -->
					
					<!-- User Menu -->
					<li class="nav-item dropdown has-arrow">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<span class="user-img"><img class="rounded-circle" src="assets/img/profiles/avatar-01.jpg" width="31" alt="Ryan Taylor"></span>
						</a>
						<div class="dropdown-menu">
							<div class="user-header">
								<div class="avatar avatar-sm">
									<img src="assets/img/profiles/avatar-01.jpg" alt="User Image" class="avatar-img rounded-circle">
								</div>
								<div class="user-text">
									<h6>Ryan Taylor</h6>
									<p class="text-muted mb-0">Administrator</p>
								</div>
							</div>
							<a class="dropdown-item" href="profile.html">My Profile</a>
							<a class="dropdown-item" href="inbox.html">Inbox</a>
							<a class="dropdown-item" href="login.html">Logout</a>
						</div>
					</li>
					<!-- /User Menu -->
					
				</ul>
				<!-- /Header Right Menu -->
				
            </div>
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Transaction Dashboard</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
									<li class="breadcrumb-item active">Transaction</li>
								</ul>
								<label>Name: <?php echo $dbfullname;?></label><br/>
								<label>Classgroup: <?php echo $dbclassgroup;?></label>
								<label>Classname: <?php echo $dbclassname;?></label>
								
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
							

							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>

							<!-- Start of Transaction Form -->
							<div class="card">
								<div class="card-body">
									<form autocomplete="off" method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Transaction Details</span></h5>
											</div>

											<!-- Session -->
											<div class="col-12 col-sm-3">
												<label>Session</label>
												<select required name="session" class="form-control">
													<option value="" disabled selected>-- Select Session --</option>
													<?php
													$sql = "SELECT * FROM session_tbl WHERE status='active'";
													$result = mysqli_query($conn, $sql);
													while ($row = mysqli_fetch_assoc($result)) {
														echo "<option value='{$row['se_id']}'>{$row['sch_session']}</option>";
													}
													?>
												</select>
											</div>

											<!-- Term -->
											<div class="col-12 col-sm-3">
												<label>Term</label>
												<select required name="term" class="form-control">
													<option value="" disabled selected>-- Select Term --</option>
													<?php
													$sql = "SELECT * FROM term_tbl WHERE status='active'";
													$result = mysqli_query($conn, $sql);
													while ($row = mysqli_fetch_assoc($result)) {
														echo "<option value='{$row['sch_term']}'>{$row['sch_term']}</option>";
													}
													?>
												</select>
											</div>

											<!-- Mode of Payment -->
											<div class="col-12 col-sm-3">
												<label>Mode of Payment</label>
												<select required name="mop" class="form-control">
													<option value="" disabled selected>-- Select Mode of Payment --</option>
													<?php
													$sql = "SELECT * FROM mode_of_payment_tbl WHERE status='active'";
													$result = mysqli_query($conn, $sql);
													while ($row = mysqli_fetch_assoc($result)) {
														echo "<option value='{$row['mop_id']}'>{$row['mode_of_payment']}</option>";
													}
													?>
												</select>
											</div>

											<!-- Payment Category -->
											<div class="col-12 col-sm-3">
												<label>Payment Category</label>
												<select required name="pc" class="form-control">
													<option value="" disabled selected>-- Select Payment Category --</option>
													<?php
													$sql = "SELECT * FROM fee_category WHERE status='active'";
													$result = mysqli_query($conn, $sql);
													while ($row = mysqli_fetch_assoc($result)) {
														echo "<option value='{$row['fee_id']}'>{$row['payment_category']}</option>";
													}
													?>
												</select>
											</div>

											<!-- Amount -->
											<div class="col-12 col-sm-3">
												<label>Amount</label>
												<input name="amount" type="number" step="0.01" min="0" class="form-control" required>
											</div>

											<!-- Transaction Type -->
											<div class="col-12 col-sm-3">
												<label>Trans Type</label>
												<select required name="transtype" class="form-control">
													<option value="" disabled>-- Select Trans Type --</option>
													<?php
													$sql = "SELECT * FROM transaction_type_tbl WHERE status='active'";
													$result = mysqli_query($conn, $sql);
													while ($row = mysqli_fetch_assoc($result)) {
														$selected = ($row['transaction_type'] === 'Normal') ? 'selected' : '';
														echo "<option value='{$row['tt_id']}' $selected>{$row['transaction_type']}</option>";
													}
													?>
												</select>
											</div>

											<!-- Entry Type -->
											<div class="col-12 col-sm-3">
												<label>Entry Type</label>
												<select name="entrytype" class="form-control" required>
													<option value="Dr">Debit (Dr)</option>
													<option value="Cr" selected>Credit (Cr)</option>
												</select>
											</div>


											<!-- Narration -->
											<div class="col-12 col-sm-3">
												<div class="form-group">
													<label>Narration</label>
													<textarea name="narration" rows="3" class="form-control" placeholder="Enter narration here" required></textarea>
												</div>
											</div>

											<!-- Hidden Fields -->
											<input type="hidden" name="stdname" value="<?php echo htmlspecialchars($dbfullname); ?>">
											<input type="hidden" name="stdid" value="<?php echo htmlspecialchars($dbstdid); ?>">
											<input type="hidden" name="classgroup" value="<?php echo isset($cg_id) ? htmlspecialchars($cg_id) : ''; ?>">
											<input type="hidden" name="classname" value="<?php echo htmlspecialchars($dbclassname); ?>">

											<!-- Submit Button -->
											<div class="col-12 mt-3">
												<button type="submit" name="submit" class="btn btn-primary">Post</button>
											</div>
										</div>
									</form>
								</div>
							</div>
							<!-- End of Transaction Form -->
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
    </body>


</html>