<?php

include "db_config.php";
include "auth.php";

$stdid=$fullname=$dob=$classgroup=$preaddress="";

?>

<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>SMS - Students</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

        <!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
	
			<!-- /Header -->
			<?php //include "hrm.php";?>
			<?php //include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Manage Students</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
									<li class="breadcrumb-item active">Manage Students</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
							

							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>

							<div class="card">
								<div class="card-body">
									<form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>View Student</span></h5>
											</div>
											<div class="col-12 col-sm-3">  
												<select name="classgroup" class="form-control">
													<option>--Select Class Group--</option>
													<?php
													$sql = "SELECT * FROM classgroup_tbl WHERE status='active' ORDER BY position";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														$cg = $row['class_group'];
														$cg_id = $row['cg_id']; ?>
													<option value="<?php echo $cg_id;?>"><?php echo $cg;?></option><?php }?>
												</select>
											</div>
											
											<div style="margin-top: 15px;" class="col-12">
												<button type="submit" name="submit" class="btn btn-primary">View</button>
											</div>
										</div>
										<div style="margin-top: 10px;" class="row">
						<div class="col-sm-12">
						
							<div class="card card-table">
								<div class="card-body">
									<div class="table-responsive">
										<table id="example" class="display" style="width:100%">
											<thead>
												<tr>
													<th>ID</th>
													<th>Name</th>
												
													<th class="text-right">Action</th>
												</tr>
											</thead>
											<tbody>
												<?php 
												$i = 1;
												if(isset($_POST['classgroup'])){
													if(isset($_POST['submit'])){
														$classgroup = $_POST['classgroup'];				
													}
												}
												$query = mysqli_query($conn,"SELECT * FROM student_tbl WHERE class_group='".$classgroup."' ORDER BY surname");
												while($row = mysqli_fetch_assoc($query)){
													$stdid = $row['std_id'];
													$firstname = $row['firstname'];
													$surname = $row['surname'];
													$fullname = $surname. " ".$firstname;
													$classgroup = $row['class_group'];
												
													
												
												 ?>
												<tr>
													<td><?php echo $i;?></td>
													<td><?php echo $fullname;?></td>
													
												
												
													<td class="text-right">
														<div class="actions">
															<a href="edit_student.php?sid=<?php echo $stdid;?>" class="btn btn-sm bg-success-light mr-2">
																<i class="fas fa-pen"></i>
															</a>
															<a href="student_details.php?sid=<?php echo $stdid;?>" class="btn btn-sm bg-success-light mr-2">
																Details
															</a>
															<a href="javascript:deletestudent(<?php echo $stdid;?>)" class="btn btn-sm bg-danger-light">
																<i class="fas fa-trash"></i>
															</a>
														</div>
													</td>
												</tr><?php $i++; }?>			
											</tbody>
										</table>

									</div>
								</div>
							</div>							
						</div>					
					</div>	
									</form>

								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>

			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>

        <!-- Datatables JS -->
		<script src="assets/plugins/datatables/datatables.min.js"></script>
		<script src="../admin/assets/js/jquery.dataTables.min.js"></script> 

		<!-- Datatable init js -->
		<script src="../admin/assets/js/datatables.init.js"></script>
        
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
		<script>
			function deletestudent(id){
				if(confirm("Are You Sure You Want to Delete Student?")){
					window.location.href = 'delete_student.php?id='+id;
				}
			}
		</script>
		<script>
			$(document).ready(function() {
			    $('#example').DataTable();
			} );
		</script>
    </body>


</html>