<?php
include "db_config.php"; // your DB connection file

// Optional: filters
$class_id = $_GET['class_id'] ?? '';
$subject_id = $_GET['subject_id'] ?? '';

// Build query
$sql = "
    SELECT h.title, h.created_at, c.class_name, ss.subject_name, t.teacher_name AS teacher_name
    FROM homework_tbl h
    JOIN class_tbl c ON h.classgroup_id = c.c_id
    JOIN school_subject ss ON h.subject_id = ss.subject_id
    JOIN teacher_tbl t ON h.teacher_id = t.t_id
    -- JOIN homework_email_log_tbl el ON h.id = el.homework_id
";

// Optional filters
if ($class_id || $subject_id) {
    $sql .= " WHERE ";
    $conditions = [];
    if ($class_id) $conditions[] = "h.class_id = '$class_id'";
    if ($subject_id) $conditions[] = "h.subject_id = '$subject_id'";
    $sql .= implode(" AND ", $conditions);
}

$sql .= " ORDER BY el.sent_at DESC";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Homework Sent Report</title>
    <style>
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
        th { background: #f4f4f4; }
        .success { color: green; }
        .failed { color: red; }
    </style>
</head>
<body>
    <h2>📋 Homework Sent Report</h2>

    <table>
        <thead>
            <tr>
                <th>Title</th>
                <th>Class</th>
                <th>Subject</th>
                <th>Teacher</th>
                <th>Parent Email</th>
                <th>Status</th>
                <th>Sent At</th>
            </tr>
        </thead>
        <tbody>
        <?php if ($result && $result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['title']) ?></td>
                    <td><?= htmlspecialchars($row['class_name']) ?></td>
                    <td><?= htmlspecialchars($row['subject_name']) ?></td>
                    <td><?= htmlspecialchars($row['teacher_name']) ?></td>
                    <td><?= htmlspecialchars($row['parent_email']) ?></td>
                    <td class="<?= strtolower($row['email_status']) ?>">
                        <?= htmlspecialchars($row['email_status']) ?>
                    </td>
                    <td><?= date("d M Y, h:i A", strtotime($row['sent_at'])) ?></td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr><td colspan="7">No records found.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
