<?php

include "db_config.php";
include "auth.php";

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if($_SERVER["REQUEST_METHOD"]=="POST"){
	if(isset($_POST['submit'])){

$from_class_id = $_POST['from_class_id'];
$to_class_id = $_POST['to_class_id'];
$session = $_POST['session'];
$term = $_POST['term'];
$promoted_by = $admin_name; // logged-in admin

$alert = '';

if ($from_class_id == $to_class_id) {
    $msg = "Cannot promote to the same class.";
	$alerttype = "danger";
} else {
    // Fetch level orders for comparison
    $stmt = $conn->prepare("SELECT c_id, classgroup_id, level_order FROM class_tbl WHERE c_id IN (?, ?) AND is_deleted!=1");
    $stmt->bind_param("ii", $from_class_id, $to_class_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $class_data = [];
    while ($row = $result->fetch_assoc()) {
        $class_data[$row['c_id']] = ['level_order' => $row['level_order'], 'classgroup_id' => $row['classgroup_id']];
    }

	$from_level = $class_data[$from_class_id]['level_order'];
	$to_level = $class_data[$to_class_id]['level_order'];
	$from_classgroup_id = $class_data[$from_class_id]['classgroup_id'];
	$to_classgroup_id = $class_data[$to_class_id]['classgroup_id'];
	
    // Check if promoting to lower class
    if ($to_level <= $from_level) {
        $msg = 'Cannot promote to a lower or same class level.';
		$alerttype = "danger";
    } else {
        
		// Get eligible students
		$students = [];
        $query = "SELECT std_id, student_id FROM student_tbl WHERE class_name = ? AND status= 'active'";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $from_class_id);
        $stmt->execute();
        $results = $stmt->get_result();

		while($row = $results->fetch_assoc()){
			$students[] = $row;
		}
		
		if(count($students)===0){
			$msg = "No eligible students found in this class for promotion";
			$alerttype = "danger";
		}

		//process each student
		$promoted = 0;
		foreach($students as $student){
			$std_id = $student['std_id'];
		
			// Check for duplicate promotion
            $check = $conn->prepare("SELECT * FROM promotion_tbl WHERE student_id = ? 
			AND from_class_name_id = ? AND session = ? AND term = ?");
            $check->bind_param("iiii", $std_id, $from_class_id, $session, $term);
            $check->execute();
            $dup = $check->get_result();

            if ($dup->num_rows > 0) continue;

            // Insert promotion record
            $insert = $conn->prepare("INSERT INTO promotion_tbl (student_id, from_class_name_id, to_class_name_id, from_classgroup_id, to_classgroup_id, session, term, promoted_by, promoted_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())");
            $insert->bind_param("iiiiisss", $std_id, $from_class_id, $to_class_id, $from_classgroup_id, $to_classgroup_id, $session, $term, $promoted_by);
            $insert->execute();

            // Update student current class
            // $update = $conn->prepare("UPDATE student_tbl SET class_group = ?, class_name = ? WHERE std_id = ?");
            // $update->bind_param("iii", $to_classgroup_id, $to_class_id, $std_id);
			$update = $conn->prepare("UPDATE student_tbl SET status = 'graduated' WHERE std_id = ?");
            $update->bind_param("i",$std_id);
            $update->execute();

            $promoted++;
		
		}

        $msg = $promoted . ' students promoted successfully.';
		$alerttype = "success";
    }
}

	}
}

?>


<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Students</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

        <!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper"> 
            
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center"> 
							<div class="col">
								<h3 class="page-title">Student Promotion</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
									<li class="breadcrumb-item active">Student Promotion</li>
							
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">

							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>

							<div class="card">
								<div class="card-body">
									<form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
										<div class="row">
											
											<h5 class="form-title"><span>Student Promotion</span></h5>
											
											<div class="col-12 col-sm-3"> 
												<label>Previous Class</label>
												<select name="from_class_id" class="form-control" required>
													<option value="">--Select Class Name--</option>
													<?php
													$sql = "SELECT DISTINCT c_id, class_name FROM class_tbl where status='active' ORDER BY class_name ASC";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														$cn = $row['class_name'];
														$cn_id = $row['c_id']; ?>
													<option value="<?php echo $cn_id;?>"><?php echo $cn;?></option><?php }?>
												</select>
											</div>
									
											<div class="col-12 col-sm-3">
												<label>Promoted Class:</label>
												<select name="to_class_id" class="form-control" required>
													<option value="">--Select Class Name--</option>
													<?php
													$sql = "SELECT DISTINCT c_id, class_name FROM class_tbl WHERE status='active' ORDER BY class_name ASC";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														$cn = $row['class_name'];
														$cn_id = $row['c_id']; ?>
													<option value="<?php echo $cn_id;?>"><?php echo $cn;?></option><?php }?>
												</select>
											</div>
										
										<div class="col-12 col-sm-3">
											<label>Session:</label>
											<select name="session" class="form-control" required>
												<option value="">Select Session</option>
												<?php
												$session_q = mysqli_query($conn, "SELECT * FROM session_tbl WHERE status='active'");
												while ($s = mysqli_fetch_assoc($session_q)) {
													echo "<option value='{$s['se_id']}'>{$s['sch_session']}</option>";
												}
												?>
											</select>
										</div>
										<div class="col-12 col-sm-3">
											<label>Term:</label>
											<select name="term" class="form-control" required>
												<option value="">Select Term</option>
												<?php
												$term_q = mysqli_query($conn, "SELECT * FROM term_tbl WHERE status='active'");
												while ($t = mysqli_fetch_assoc($term_q)) {
													echo "<option value='{$t['t_id']}'>{$t['sch_term']}</option>";
												}
												?>
											</select>
										</div>
									</div>		
										<div style="margin-top: 15px;" class="col-12">
											<button type="submit" name="submit" class="btn btn-primary">Promote</button>
										</div>
					
									</form>

								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>

			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>

        <!-- Datatables JS -->
		<script src="assets/plugins/datatables/datatables.min.js"></script>
		<script src="../admin/assets/js/jquery.dataTables.min.js"></script> 

		<!-- Datatable init js -->
		<script src="../admin/assets/js/datatables.init.js"></script>
        
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>

		<script>
			$(document).ready(function() {
			    $('#example').DataTable();
			} );
		</script>
    </body>


</html>