<?php
include "db_config.php";
include "auth.php";
include "school_settings.php";


if (isset($_GET['pid'])) {
    $payment_id = $_GET['pid'];

    $sql = "SELECT 
                p.p_id,
                CONCAT_WS(' ', s.surname, s.firstname, s.othername) AS student_name,
                s.student_id,
                cg.class_group,
                sess.sch_session,
                t.sch_term,
                p.narration,
                p.credit,
                p.trans_date
            FROM payment_tbl p
            JOIN student_tbl s ON p.student_id = s.std_id
            JOIN classgroup_tbl cg ON p.classgroup_id = cg.cg_id
            JOIN session_tbl sess ON p.session_id = sess.se_id
            JOIN term_tbl t ON p.term_id = t.t_id
            WHERE p.p_id = ?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $payment_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
?>
<!DOCTYPE html>
<html>
<head>
    
    <title>Payment Receipt</title>
    <style>
        body { font-family: Arial; }
        .receipt-container {
            width: 600px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #999;
            box-shadow: 0 0 5px #aaa;
        }
        h2, h3 { text-align: center; margin: 0; }
        .receipt-details {
            margin-top: 20px;
        }
        .receipt-details table {
            width: 100%;
            border-collapse: collapse;
        }
        .receipt-details th, .receipt-details td {
            padding: 8px;
            border-bottom: 1px solid #ddd;
        }
        .total {
            text-align: right;
            font-weight: bold;
            margin-top: 20px;
        }
        .print-btn {
            text-align: center;
            margin-top: 20px;
        }
        .print-btn button {
            padding: 10px 20px;
        }
        .stamp-print-row {
            display: flex;
            align-items: center;  /* vertically align stamp and button */
            justify-content: center; /* keep them close together */
            margin-top: 20px;
            gap: 10px; /* spacing between stamp and button */
        }
        .stamp {
            text-align: left;
        }
        .print-btn {
            text-align: right;
        }
        .date-printed {
            font-size:16px;
            text-align: center;
            margin-top: 10px;
            font-style: italic;
            color: #555;
        }

    </style>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body>

<div class="receipt-container">
    <div style="text-align:center;">
        <?php if (!empty($school_logo)): ?>
        		<img src="<?= $school_logo; ?>" alt="School Logo" style="width:100px; height:auto; margin-bottom:10px;">
        <?php endif; ?>
	    <h4><?php echo $school_name;?></h4>
    </div>
    
    <h3>Payment Receipt</h3>
    <div class="receipt-details">
        <table>
            <tr>
                <th>Student Name:</th>
                <td><?= strtoupper($row['student_name']) ?></td>
            </tr>
            <tr>
                <th>Student ID:</th>
                <td><?= $row['student_id'] ?></td>
            </tr>
            <tr>
                <th>Class Group:</th>
                <td><?= $row['class_group'] ?></td>
            </tr>
            <tr>
                <th>Session:</th>
                <td><?= $row['sch_session'] ?></td>
            </tr>
            <tr>
                <th>Term:</th>
                <td><?= $row['sch_term'] ?></td>
            </tr>
            <tr>
                <th>Payment For:</th>
                <td><?= $row['narration'] ?></td>
            </tr>
            <tr>
                <th>Amount Paid:</th>
                <td><strong>₦<?= number_format($row['credit'], 2) ?></strong></td>
            </tr>
            <tr>
                <th>Transaction Date:</th>
                <td><?= date("d M, Y", strtotime($row['trans_date'])) ?></td>
            </tr>
        </table>
    </div>
    <div class="stamp-print-row">
        <div class="print-btn">
            <button onclick="window.print()">Print Receipt</button>
        </div>
         <div class="stamp">
            <?php if (!empty($school_stamp)): ?>
            <img src="<?= $school_stamp ?>" alt="School Stamp" style="width:120px; height:auto; opacity:0.8;">
            <?php endif; ?>
	    </div>
    </div>
   <div class="date-printed" id="printDate"></div>

</div>
<script>
function setPrintDate() {
    const now = new Date();
    const options = { year: 'numeric', month: 'short', day: 'numeric', 
                      hour: '2-digit', minute: '2-digit', hour12: true };
    document.getElementById("printDate").textContent =
        "Date Printed: " + now.toLocaleString('en-US', options);
}
window.onload = setPrintDate;
</script>

</body>
</html>
<?php
    } else {
        echo "Receipt not found.";
    }
} else {
    echo "Invalid request.";
}
?>




							