<?php
include "db_config.php"; // database connection
include "auth.php";      // authentication

$transaction_type = $tt_id = $transactionType = $ttid = "";
$errors = "";
$alerttype = "";
$msg = "";

// Fetch record by ID
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    $sql = "SELECT * FROM transaction_type_tbl WHERE tt_id = '$id'";
    $result = mysqli_query($conn, $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        $transaction_type = $row['transaction_type'];
        $tt_id = $row['tt_id'];
    }
}

$dt = date('Y-m-d h:i:s');

// Handle update
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update'])) {
    $transactionType = trim($_POST['transactionType']);
    $ttid = $_POST['ttid'];

    // Check for duplicate excluding current record
    $sql = "SELECT transaction_type FROM transaction_type_tbl WHERE transaction_type = '$transactionType' AND tt_id != '$ttid'";
    $result = mysqli_query($conn, $sql);
    $numrow = mysqli_num_rows($result);

    if ($numrow > 0) {
        $errors = "Mode of Payment already exists.";
        $alerttype = 'danger';
    }

    if (!empty($errors)) {
        $msg = $errors;
        $alerttype = 'danger';
    } else {
        $sql2 = "UPDATE transaction_type_tbl 
                 SET transaction_type = '$transactionType', updated_by = '$admin_name', updated_dt = '$dt' 
                 WHERE tt_id = '$ttid'";

        $result2 = mysqli_query($conn, $sql2);

        if ($result2) {
            echo "<script>
                alert('Transaction Type Successfully Updated');
                window.location.href= 'transaction_type.php';
            </script>";
        } else {
            $msg = "Update failed: " . mysqli_error($conn);
            $alerttype = 'danger';
        }
    }

    // mysqli_close($conn);
}
?>


<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Edit Mode of Payment</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Edit Transaction Type</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="mode_of_payment.php">Transaction Type</a></li>
									<li class="breadcrumb-item active">Edit Transaction Type</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>

							<div class="card">
								<div class="card-body">
									<form method="POST" action="edit_transaction_type.php">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Transaction Type</span></h5>
											</div>
											<div class="col-12 col-sm-6">  
												<div class="form-group">
													<label>Transaction Type</label>
													<input required name="transactionType" value="<?php echo $transaction_type;?>" type="text" class="form-control">
                                                    <input hidden required name="ttid" value="<?php echo $tt_id;?>" type="text" class="form-control">
												</div>
											</div>
											
											<div class="col-12">
												<button type="submit" name="update" class="btn btn-primary">Update</button>
											</div>
										</div>
									</form>
								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
    </body>


</html>