<?php

include "db_config.php"; // Using database connection file here
include "auth.php";

if(isset($_GET['id'])){
$id = $_GET['id'];
} // get id through query string

$sql = "SELECT c.*, cg.class_group, t.teacher_name 
        FROM class_tbl c 
        JOIN classgroup_tbl cg ON cg.cg_id = c.classgroup_id
        LEFT JOIN teacher_tbl t ON t.t_id = c.teacher_id
        WHERE c.is_deleted = 0 AND c.c_id = '".$id."'
        ORDER BY c.class_name";

$result = mysqli_query($conn,$sql);
$row = mysqli_fetch_assoc($result);

$cg_id = $row['classgroup_id'];
$classgroup = $row['class_group'];
$dbclassname = $row['class_name'];
$dbclassid = $row['c_id'];
$dbteacher_id = $row['teacher_id'];
$dbteacher_name = $row['teacher_name'];

?>

<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Edit Class Group</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
            
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Edit Class</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="class.php">Classes</a></li>
									<li class="breadcrumb-item active">Edit Class</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
							

							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>

							<div class="card">
								<div class="card-body">
									<form method="POST" action="cupdate.php?id=<?php echo $id;?>">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Class Group Information</span></h5>
											</div>
											<div class="col-12 col-sm-4">
												<div class="form-group">
													<label>Class Group</label>
													<select name="classgroup" class="form-control" disabled>
														<option selected value="<?php echo $cg_id;?>"><?php echo $classgroup;?></option>
														<?php
														$sq = "SELECT * FROM classgroup_tbl WHERE status='active'";
														$rs = mysqli_query($conn,$sq);
														while($rw = mysqli_fetch_assoc($rs)){
														$dbclassgroup = $rw['class_group'];
														$dbclassgroup_id = $rw['cg_id'];
														?>
														<option value="<?php echo $dbclassgroup_id;?>"><?php echo $dbclassgroup;?></option><?php } ?>
													</select>
												</div>
											</div>
											<!-- Hidden field to submit the ID -->
											<input type="hidden" name="classgroup" value="<?php echo $cg_id;?>">

											<div class="col-12 col-sm-4">  
												<div class="form-group">
													<label>Class Arms</label>
													<input readonly required="" name="classname" value="<?php echo $dbclassname;?>" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-3">
												<label>Assign Teacher</label>
												<select name="teacher_id" class="form-control">
													<option selected value="<?php echo $dbteacher_id;?>"><?php echo $dbteacher_name;?></option>
													<?php
													$sql = "SELECT t_id, teacher_name FROM teacher_tbl ORDER BY teacher_name";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														echo '<option value="'.$row['t_id'].'">'.$row['teacher_name'].'</option>';
													}
													?>
												</select>
											</div>
											<div class="col-12 col-sm-4">  
												<div class="form-group">
													<label for="status">Status</label>
													<?php 
														$statusOptions = ['active', 'inactive'];
														$statusQuery = mysqli_query($conn, "SELECT status FROM class_tbl WHERE c_id = '$id'");
														$statusRow = mysqli_fetch_assoc($statusQuery);
														$dbStatus = $statusRow['status'];
													?>
													<select name="status" id="status" class="form-control">
														<?php foreach ($statusOptions as $option): ?>
															<option value="<?= $option; ?>" <?= ($dbStatus == $option) ? 'selected' : ''; ?>>
																<?= ucfirst($option); ?>
															</option>
														<?php endforeach; ?>
													</select>
												</div>
											</div>
											
											<div class="col-12">
												<button type="submit" name="update" class="btn btn-primary">Update</button>
											</div>
										</div>
									</form>
								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
    </body>


</html>