<?php

include  "db_config.php";


?>


<!DOCTYPE html>
<html>
<head>
	<title>Report By Term and Category</title>

	<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

	<!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="../admin/assets/css/buttons.dataTables.min.css">
</head>
<body>
<div class="container">
	<form method="POST" action="daily_payment_report.php">
		<?php include "reportheader.php";?>
	<div class="row" style="margin-top: 15px;">
		
			<div class="col-md-3">
				<div class="form-group">
					<label>Date From:</label>
					<input type="date" name="datefrom" class="form-control">
				</div>
			</div>
			<div class="col-md-3">
				<div class="form-group">
					<label>Date To:</label>
					<input type="date" name="dateto" class="form-control">
				</div>
            </div>
			
			<div class="col-md-3" style="margin-top: 30px;">
				<div class="form-group">
					<label></label>
					<button type="submit" name="submit" class="btn btn-primary">View Report</button>
				</div>
			</div>
			
		</div>
		<div class="table-responsive" style="margin-left: 20px;">
		<table id="example" class="display nowrap" style="width:100%;margin-left: 20px;">
		        <thead>
		            <tr> 
		               	<th>S/N</th>
                        <th>Trans. Date</th>
                        <th>Student Name</th>
                        <th>Class Group</th>
                        <th>Session</th>
                        <th>Term</th>
                        <th>Narration</th>
                        <!-- <th>Debit</th> -->
                        <th>Value</th>
                        <!-- <th>Status</th> -->
                         <th>Action</th>
		            </tr>
		        </thead>
		        <tbody>
		        	<?php
		        	$i = 1;
                    $total_credit = 0;
		        		if($_SERVER["REQUEST_METHOD"] == "POST"){
	  						if(isset($_POST['submit'])){
	  						
	  							$from_date = $_POST['datefrom'];
	  							$to_date = $_POST['dateto'];
                                $trans_type = 15; 
	  							
	  							// $sql= "SELECT p_id, student_name, class_group, SUM(debit) AS TOTALDEBIT, SUM(credit) AS TOTALCREDIT, SUM(discount) AS DISCOUNT, SUM(DEBIT)-SUM(credit) AS BALANCE, debit, discount,narration FROM payment_tbl WHERE creation_date BETWEEN '$datefrom' AND '$dateto' AND term='$term' AND payment_category='$paycat' GROUP BY std_id ORDER BY class_group";

                                $sql = "SELECT 
                                    p.p_id, s.std_id,
                                    CONCAT_WS(' ', s.surname, s.firstname, s.othername) AS student_name,
                                    cg.class_group,
                                    sess.sch_session,
                                    t.sch_term,
                                    p.narration,
                                    p.debit,
                                    p.credit,
                                    p.trans_date,
                                    p.status
                                FROM payment_tbl p
                                JOIN student_tbl s ON p.student_id = s.std_id
                                JOIN classgroup_tbl cg ON p.classgroup_id = cg.cg_id
                                JOIN session_tbl sess ON p.session_id = sess.se_id
                                JOIN term_tbl t ON p.term_id = t.t_id
                                JOIN transaction_type_tbl tt ON p.trans_type = tt.tt_id
                                WHERE p.trans_type = ?
                                AND p.trans_date BETWEEN ? AND ?
                                AND p.status = 'confirmed'
                                ORDER BY p.trans_date ASC";

                        $stmt = $conn->prepare($sql);
                        $stmt->bind_param("iss", $trans_type, $from_date, $to_date);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        
	  					while($row = $result->fetch_assoc()){
                            $pid = $row['p_id'];
                            $sid = $row['std_id'];
                            $total_credit += $row['credit'];?>
		            <tr>
                        <td><?= $i++; ?></td>
                        <td><?= $row['trans_date'] ?></td>
                        <td><?= strtoupper(htmlspecialchars($row['student_name'])) ?></td>
                        <td><?= $row['class_group'] ?></td>
                        <td><?= $row['sch_session'] ?></td>
                        <td><?= $row['sch_term'] ?></td>
                        <td><?= $row['narration'] ?></td>
                        <!-- <td><?= number_format($row['debit'], 2) ?></td> -->
                        <td><?= number_format($row['credit'], 2) ?></td>
                        <!-- <td><?= ucfirst($row['status']) ?></td> -->
                        <td><a target="_blank" href="feesreceipt.php?pid=<?php echo $pid;?>" class="btn btn-sm bg-success-light mr-2">Receipt</a></td>
                    </tr>
		           <?php
		       			$i++;}
		       			}}?>
		        </tbody>
		        <tfoot>
		            <tr>
						<th colspan="7" style="text-align:right;">Total Credit:</th>
                        <th colspan="1"><?= number_format($total_credit, 2); ?></th>
                        <th colspan="3"></th>
		            </tr>
		        </tfoot>
		    </table>
		   </div>
		</form>
</div>
<!-- jQuery -->
<script src="assets/js/jquery-3.5.1.min.js"></script>

<!-- Datatables JS -->
<script src="assets/plugins/datatables/datatables.min.js"></script>
<script src="../assets/js/jquery-3.5.1.js"></script>
<script src="../admin/assets/js/jquery.dataTables.min.js"></script>
<script src="../admin/assets/js/dataTables.buttons.min.js"></script>
<script src="../admin/assets/js/jszip.min.js"></script> 
<script src="../admin/assets/js/pdfmake.min.js"></script>
<script src="../admin/assets/js/vfs_fonts.js"></script>
<script src="../admin/assets/js/buttons.html5.min.js"></script>
<script src="../admin/assets/js/buttons.print.min.js"></script>

<!-- Datatable init js -->
<script src="../admin/assets/js/datatables.init.js"></script>
        
		
<!-- Custom JS -->
<script src="assets/js/script.js"></script>

<script>
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
} );
</script>
</body>
</html>