<?php
include "db_config.php";
include "auth.php"; // sets $_SESSION['teacher_id']

function test_input($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

$msg = "";
$alerttype = "";

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {

    $oldpassword = test_input($_POST['oldpassword']);
    $newpassword = test_input($_POST['newpassword']);
    $confirmpassword = test_input($_POST['confirmpassword']);

    if (empty($oldpassword) || empty($newpassword) || empty($confirmpassword)) {
        $msg = "All fields are required.";
        $alerttype = "danger";
    } elseif ($newpassword !== $confirmpassword) {
        $msg = "New password and confirm password do not match.";
        $alerttype = "danger";
    } else {
        $teacherId = $_SESSION['teacher_id'];

        // Step 1: Get current hashed password
        $stmt = $conn->prepare("SELECT pwd FROM teacher_tbl WHERE t_id = ?");
        $stmt->bind_param("s", $teacherId);
        $stmt->execute();
        $stmt->bind_result($hashedPwd);

        if ($stmt->fetch()) {
            $stmt->close(); // ✅ close only once, after fetching
            if (password_verify($oldpassword, $hashedPwd)) {
                // Step 2: Update new password
                $newHashedPassword = password_hash($newpassword, PASSWORD_DEFAULT);

                $update = $conn->prepare("UPDATE teacher_tbl SET pwd = ? WHERE t_id = ?");
                $update->bind_param("ss", $newHashedPassword, $teacherId);
                if ($update->execute()) {
                    $msg = "Password updated successfully.";
                    $alerttype = "success";
                } else {
                    $msg = "Failed to update password.";
                    $alerttype = "danger";
                }
                $update->close();
            } else {
                $msg = "Incorrect old password.";
                $alerttype = "danger";
            }
        } else {
            $msg = "Teacher not found.";
            $alerttype = "danger";
            $stmt->close(); // only close if fetch() failed
        }
    }
}
?>



<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Change Password</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			<!-- /Header -->
			
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Change Password</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
									<li class="breadcrumb-item active">Change Password</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
							

							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>

							<div class="card">
								<div class="card-body">
									<form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Change Password</span></h5>
											</div>
											
											<div class="col-12 col-sm-3">  
												<div class="form-group">
													<label>Old Password</label>
													<input name="oldpassword" type="password" class="form-control" required>
												</div>
											</div>
											<div class="col-12 col-sm-3">  
												<div class="form-group">
													<label>New Password</label>
													<input name="newpassword" type="password" class="form-control" required>
												</div>
											</div>
											<div class="col-12 col-sm-3">  
												<div class="form-group">
													<label>Confirm New Password</label>
													<input name="confirmpassword" type="password" class="form-control" required>
												</div>
											</div>
											
											<div class="col-12">
												<button type="submit" name="submit" class="btn btn-primary">Change Password</button>
											</div>
										</div>
									</form>
								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
    </body>


</html>