<?php

include "db_config.php"; // Using database connection file here
include  "auth.php";

if (isset($_GET['id'])) {
    $cgid = $_GET['id']; // Get ID from query string
}

$dt = date('Y-m-d h:i:sa', time()); // Current datetime

// Update Class Group table
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update'])) {

    $school = trim($_POST['school']);
    $classgroup = trim($_POST['classgroup']);
    $status = trim($_POST['status']);

    // Check if classgroup already exists for another record
    $checkSql = "SELECT class_group FROM classgroup_tbl WHERE class_group = ? AND cg_id != ?";
    $stmt = mysqli_prepare($conn, $checkSql);
    mysqli_stmt_bind_param($stmt, "si", $classgroup, $cgid);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);

    if (mysqli_stmt_num_rows($stmt) > 0) {
        echo '<script>alert("Class Group already exists.");
        window.location.href = "class_group.php";</script>';
    } else {
        // Update record
        $updateSql = "UPDATE classgroup_tbl SET school_id = ?, class_group = ?, status = ?, update_by = ?, update_dt = ? WHERE cg_id = ?";
        $stmt2 = mysqli_prepare($conn, $updateSql);
        mysqli_stmt_bind_param($stmt2, "issssi", $school, $classgroup, $status, $admin_name, $dt, $cgid);

        if (mysqli_stmt_execute($stmt2)) {
            echo "<script>
                alert('Class Group Successfully Updated');
                window.location.href = 'class_group.php';
            </script>";
        } else {
            echo "<script>alert('Update failed.');</script>";
        }

        mysqli_stmt_close($stmt2);
    }

    mysqli_stmt_close($stmt);
    mysqli_close($conn); // Close connection
}
?>