<?php

include  "db_config.php";


?>


<!DOCTYPE html>
<html>
<head>
	<title>JSMS- Report By Student Balance</title>

	<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

	<!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="../admin/assets/css/buttons.dataTables.min.css">
</head>
<body>
<div class="container">
	
	<div class="row" style="margin-top: 15px;">
			<?php include "reportheader.php"; ?>
		</div>
    <form method="POST" action='balance_by_cg_se_te.php'>
        <div class="row">
            <div class="col-12 col-sm-3">
                <label>Class Group:</label>
                <select name="classgroup" required class="form-control">
                    <option value="">Select Class Group</option>
                    <?php
                    $cg_q = mysqli_query($conn, "SELECT * FROM classgroup_tbl WHERE status='active'");
                    while ($cg = mysqli_fetch_assoc($cg_q)) {
                        echo "<option value='{$cg['cg_id']}'>{$cg['class_group']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col-12 col-sm-3">
                <label>Session:</label>
                <select name="session" class="form-control" required>
                    <option value="">Select Session</option>
                    <?php
                    $session_q = mysqli_query($conn, "SELECT * FROM session_tbl WHERE status='active'");
                    while ($s = mysqli_fetch_assoc($session_q)) {
                        echo "<option value='{$s['se_id']}'>{$s['sch_session']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col-12 col-sm-3">
                <label>Term:</label>
                <select name="term" class="form-control" required>
                    <option value="">Select Term</option>
                    <?php
                    $term_q = mysqli_query($conn, "SELECT * FROM term_tbl WHERE status='active'");
                    while ($t = mysqli_fetch_assoc($term_q)) {
                        echo "<option value='{$t['t_id']}'>{$t['sch_term']}</option>";
                    }
                    ?>
                </select>
            </div>
        <div>
            <button style="margin-top:30px;" type="submit" name="view_report" class="btn btn-primary">View Report</button>
        </div>
        
    </div>

    </form>

		<div style="margin-top: 50px;width: 100%">
		<table id="example" class="display nowrap" style="width:100%">
		        <thead>
		            <tr>
		                <th>S/N</th>
						<th>Student Name</th>
						<th>Class Group</th>
						<th>Total Fee</th>
						<th>Discount</th>
						<th>Amount Payable</th>
						<th>Total Paid</th>
						<th>Balance</th>
						<th>
							Fee Status
						</th>
		            </tr>
		        </thead>
		        <tbody>
		        	<?php
						$total_discount = 0;
		        		$total_amount_payable = 0;
						$total_payment = 0;
						$total_balance = 0;

                            if (isset($_POST['view_report'])) {
                                $classgroup_id = $_POST['classgroup'];
                                $session_id = $_POST['session'];
                                $term_id = $_POST['term'];
                                $i = 1;

	  							$sql= "SELECT 
										CONCAT_WS(' ', s.surname, s.firstname, s.othername) AS student_name,
										cg.class_group, p.p_id,

										-- Total Fee
										SUM(CASE 
											WHEN p.debit > 0 AND tt.tt_id = 15 AND pct.is_academic_fee = 'yes'
											THEN p.debit ELSE 0 
										END) AS total_fee,

										-- Discount
										SUM(CASE 
											WHEN p.debit > 0 AND tt.tt_id = 16 AND pct.is_academic_fee = 'yes'
											THEN p.debit ELSE 0 
										END) AS discount,

										-- Amount Payable
										(
											SUM(CASE 
												WHEN p.debit > 0 AND tt.tt_id = 15 AND pct.is_academic_fee = 'yes'
												THEN p.debit ELSE 0 
											END) -
											SUM(CASE 
												WHEN p.debit > 0 AND tt.tt_id = 16 AND pct.is_academic_fee = 'yes'
												THEN p.debit ELSE 0 
											END)
										) AS amount_payable,

										-- Total Paid
										SUM(p.credit) AS total_paid,

										-- Balance
										(
											(
												SUM(CASE 
													WHEN p.debit > 0 AND tt.tt_id = 15 AND pct.is_academic_fee = 'yes'
													THEN p.debit ELSE 0 
												END) -
												SUM(CASE 
													WHEN p.debit > 0 AND tt.tt_id = 16 AND pct.is_academic_fee = 'yes'
													THEN p.debit ELSE 0 
												END)
											) - SUM(p.credit)
										) AS balance,

										-- Fee Status
										CASE 
											WHEN (
												(
													SUM(CASE 
														WHEN p.debit > 0 AND tt.tt_id = 15 AND pct.is_academic_fee = 'yes'
														THEN p.debit ELSE 0 
													END) -
													SUM(CASE 
														WHEN p.debit > 0 AND tt.tt_id = 16 AND pct.is_academic_fee = 'yes'
														THEN p.debit ELSE 0 
													END)
												) - SUM(p.credit)
											) = 0 THEN 'Paid'
											ELSE 'Not Paid'
										END AS fee_status

									FROM 
										payment_tbl p
									JOIN 
										student_tbl s ON p.student_id = s.std_id
									JOIN 
										classgroup_tbl cg ON p.classgroup_id = cg.cg_id
									JOIN 
										transaction_type_tbl tt ON p.trans_type = tt.tt_id
									JOIN 
										fee_category pct ON p.payment_category = pct.fee_id
                                    
                                    WHERE p.classgroup_id = $classgroup_id 
                                    AND p.session_id = $session_id AND p.term_id = $term_id

									GROUP BY 
										p.student_id, p.classgroup_id
									ORDER BY student_name;

									";

	  							$query = mysqli_query($conn,$sql);
	  							while ($row=mysqli_fetch_assoc($query)){
	  									
	  									$p_id = $row['p_id'];
	  									$student_name= $row['student_name'];
	  									$classgroup = $row['class_group'];
	  									$total_fee = $row['total_fee'];
										$discount = $row['discount'];
	  									$amount_payable = $row['amount_payable'];
	  									$total_paid = $row['total_paid'];
										$balance = $row['balance'];
	  									$fee_status = $row['fee_status'];
										$total_discount+= $discount;
										$total_amount_payable+= $amount_payable;
										$total_payment+= $total_paid;
										$total_balance+= $balance;
	  								?>
		            <tr>
		            	<td><?php echo $i;?></td>
		                <td><?php echo htmlspecialchars($student_name);?></td>
		                <td><?php echo htmlspecialchars($classgroup);?></td>
		                <td><?php echo number_format($total_fee,2);?></td>
		                <td><?php echo number_format($discount,2);?></td>
		                <td><?php echo number_format($amount_payable,2);?></td>
		                <td><?php echo number_format($total_paid,2);?></td>
		                <td><?php echo number_format($balance,2);?></td>
		                <td><?php echo $fee_status;?></td>
		            </tr>
		           <?php 
		       			$i++;}}
		       			?>
		        </tbody>
		        <tfoot>
		            <tr>
		                <th colspan='4' style=text-align:right>Total:</th>
						<th><?= number_format($total_discount,2); ?></th>
						<th><?= number_format($total_amount_payable,2); ?></th>
						<th><?= number_format($total_payment,2); ?></th>
						<th><?= number_format($total_balance,2); ?></th>
						<th></th>
		            </tr>
		        </tfoot>
		    </table>
		   </div>
		</form>
</div>
<!-- jQuery -->
<script src="assets/js/jquery-3.5.1.min.js"></script>

<!-- Datatables JS -->
<script src="assets/plugins/datatables/datatables.min.js"></script>
<script src="../assets/js/jquery-3.5.1.js"></script>
<script src="../admin/assets/js/jquery.dataTables.min.js"></script>
<script src="../admin/assets/js/dataTables.buttons.min.js"></script>
<script src="../admin/assets/js/jszip.min.js"></script> 
<script src="../admin/assets/js/pdfmake.min.js"></script>
<script src="../admin/assets/js/vfs_fonts.js"></script>
<script src="../admin/assets/js/buttons.html5.min.js"></script>
<script src="../admin/assets/js/buttons.print.min.js"></script>

<!-- Datatable init js -->
<script src="../admin/assets/js/datatables.init.js"></script>
        
		
<!-- Custom JS -->
<script src="assets/js/script.js"></script>

<script>
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
} );
</script>
</body>
</html>