<?php

include "db_config.php";
include "auth.php";

if (isset($_GET['session_id'], $_GET['term_id'], $_GET['class_id'])) {
    $session_id = $_GET['session_id'];
    $term_id = $_GET['term_id'];
    $class_id = $_GET['class_id'];
    $attendance_date = $_GET['attendance_date'] ?? null;

    $sql = "SELECT a.id, s.student_id, CONCAT(s.surname, ' ', s.firstname, ' ', s.othername) AS fullname,
                   a.status, a.attendance_date
            FROM attendance_tbl a
            JOIN student_tbl s ON a.student_id = s.std_id
            WHERE a.session_id = ? AND a.term_id = ? AND s.class_name = ?";

    if ($attendance_date) {
        $sql .= " AND a.attendance_date = ?";
    }

    $stmt = $conn->prepare($sql);

    if ($attendance_date) {
        $stmt->bind_param("iiis", $session_id, $term_id, $class_id, $attendance_date);
    } else {
        $stmt->bind_param("iii", $session_id, $term_id, $class_id);
    }

    $stmt->execute();
    $result = $stmt->get_result();

    if (isset($result)) {
    if ($result->num_rows > 0) {
        echo "<div class='table-responsive'><table class='table table-bordered table-striped'>";
        echo "<thead class='table-dark'>
                <tr>
                  <th>#</th>
                  <th>Student ID</th>
                  <th>Full Name</th>
                  <th>Status</th>
                  <th>Date</th>
                </tr>
              </thead><tbody>";
        $i = 1;
        while ($row = $result->fetch_assoc()) {
            echo "<tr>
                    <td>{$i}</td>
                    <td>{$row['student_id']}</td>
                    <td>" . ucwords(strtolower($row['fullname'])) . "</td>
                    <td>" . ucfirst($row['status']) . "</td>
                    <td>{$row['attendance_date']}</td>
                  </tr>";
            $i++;
        }
        echo "</tbody></table></div>";
    } else {
        echo "<div class='alert alert-warning'>No attendance records found.</div>";
    }
}

}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<form method="GET" class="row g-3 mb-4 p-3 bg-light rounded shadow-sm">
  <!-- Session -->
  <div class="col-md-3">
    <label for="session" class="form-label">Session</label>
    <select name="session_id" id="session" class="form-select" required>
      <option value="">Select Session</option>
      <?php
      $sess = $conn->query("SELECT se_id, sch_session FROM session_tbl WHERE status='active'");
      while ($row = $sess->fetch_assoc()) {
        $selected = (isset($_GET['session_id']) && $_GET['session_id'] == $row['se_id']) ? 'selected' : '';
        echo "<option value='{$row['se_id']}' $selected>{$row['sch_session']}</option>";
      }
      ?>
    </select>
  </div>

  <!-- Term -->
  <div class="col-md-3">
    <label for="term" class="form-label">Term</label>
    <select name="term_id" id="term" class="form-select" required>
      <option value="">Select Term</option>
      <?php
      $terms = $conn->query("SELECT t_id, sch_term FROM term_tbl WHERE status='active'");
      while ($row = $terms->fetch_assoc()) {
        $selected = (isset($_GET['term_id']) && $_GET['term_id'] == $row['t_id']) ? 'selected' : '';
        echo "<option value='{$row['t_id']}' $selected>{$row['sch_term']}</option>";
      }
      ?>
    </select>
  </div>

  <!-- Class -->
  <div class="col-md-3">
    <label for="class" class="form-label">Class</label>
    <select name="class_id" id="class" class="form-select" required>
      <option value="">Select Class</option>
      <?php
      $classes = $conn->query("SELECT c_id, class_name FROM class_tbl");
      while ($row = $classes->fetch_assoc()) {
        $selected = (isset($_GET['class_id']) && $_GET['class_id'] == $row['c_id']) ? 'selected' : '';
        echo "<option value='{$row['c_id']}' $selected>{$row['class_name']}</option>";
      }
      ?>
    </select>
  </div>

  <!-- Date -->
  <div class="col-md-3">
    <label for="date" class="form-label">Date (Optional)</label>
    <input type="date" name="attendance_date" id="date" class="form-control"
      value="<?= $_GET['attendance_date'] ?? '' ?>" max="<?= date('Y-m-d') ?>">
  </div>

  <!-- Submit -->
  <div class="col-12 text-end">
    <button type="submit" class="btn btn-primary">View Report</button>
  </div>
</form>

