<?php
include "db_config.php";
include "auth.php";

$class_group = $_POST['class_group'] ?? '';
$subject_id = $_POST['subject_id'] ?? '';
$term_id = $_POST['term_id'] ?? $_SESSION['term_id'];
$session_id = $_POST['session_id'] ?? $_SESSION['session_id'];
?>

<!DOCTYPE html>
<html>
<head>
  <title>Approve Test/Exam Scores</title>
  <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
  <script src="assets/js/jquery-3.5.1.min.js"></script>
</head>
<body>
<div class="container mt-4">
  <p><a href="index.php">Back to Dashboard</a></p>
  <h4>Approve Test & Exam Scores</h4>

  <form method="POST" class="row g-3 mb-4">
    <div class="col-md-3">
      <label>Class Group</label>
      <select name="class_group" class="form-control" required>
        <option value="">Select Class Group</option>
        <?php
        $groups = mysqli_query($conn, "SELECT * FROM classgroup_tbl");
        while ($g = mysqli_fetch_assoc($groups)) {
          echo "<option value='{$g['cg_id']}' " . ($class_group == $g['cg_id'] ? 'selected' : '') . ">{$g['class_group']}</option>";
        }
        ?>
      </select>
    </div>

    <div class="col-md-3">
      <label>Subject</label>
      <select name="subject_id" class="form-control" required>
        <option value="">Select Subject</option>
        <?php
        $subs = mysqli_query($conn, "SELECT * FROM school_subject");
        while ($s = mysqli_fetch_assoc($subs)) {
          echo "<option value='{$s['subject_id']}' " . ($subject_id == $s['subject_id'] ? 'selected' : '') . ">{$s['subject_name']}</option>";
        }
        ?>
      </select>
    </div>

    <div class="col-md-3 mt-4">
      <button type="submit" class="btn btn-primary mt-2">Filter</button>
    </div>
  </form>

  <?php
  if ($class_group && $subject_id) {
    $q = "SELECT t.*, s.surname, s.firstname, c.class_name 
          FROM test_exam_tbl t 
          JOIN student_tbl s ON t.std_id = s.std_id 
          JOIN class_tbl c ON c.c_id = s.class_name
          WHERE t.class_group='$class_group' AND t.subject_id='$subject_id' 
          AND t.session='$session_id' AND t.term='$term_id'";

    $res = mysqli_query($conn, $q);

    if (mysqli_num_rows($res)) {
      echo "<form method='POST' action='submit_approval.php'>";
      echo "<input type='hidden' name='subject_id' value='$subject_id'>
            <input type='hidden' name='class_group' value='$class_group'>
            <input type='hidden' name='session_id' value='$session_id'>
            <input type='hidden' name='term_id' value='$term_id'>";

      echo "<table class='table table-bordered mt-3'>
              <thead>
                <tr>
                  <th><input type='checkbox' id='checkAll'></th>
                  <th>Student</th>
                  <th>Test</th>
                  <th>Exam</th>
                  <th>Total</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>";

      while ($r = mysqli_fetch_assoc($res)) {
        $id = $r['test_exam_id'];
        $fullname = $r['surname'] . " " . $r['firstname'];
        $total = $r['test_score'] + $r['exam_score'];
        $status = ucfirst($r['approval_status']);
        $statusColor = $status == 'Approved' ? 'success' : ($status == 'Rejected' ? 'danger' : 'secondary');

        echo "<tr>
                <td>";
        if ($r['approval_status'] != 'approved') {
          echo "<input type='checkbox' name='approve_ids[]' value='$id'>";
        } else {
          echo "-";
        }
        echo "</td>
              <td>$fullname</td>
              <td>{$r['test_score']}</td>
              <td>{$r['exam_score']}</td>
              <td>$total</td>
              <td><span class='badge bg-$statusColor'>$status</span></td>
              <td>";

        if ($r['approval_status'] != 'approved') {
          ?>
            <form method='POST' action='submit_approval.php' style='display:inline-block;'>
              <input type='hidden' name='approve_single' value='<?= $id ?>'>
              <button type='submit' class='btn btn-success btn-sm'>Approve</button>
            </form>

            <form method='POST' action='submit_approval.php' style='display:inline-block; margin-left:5px;'>
              <input type='hidden' name='reject_single' value='<?= $id ?>'>
              <button type='submit' class='btn btn-danger btn-sm'>Reject</button>
            </form>
          <?php
        } else {
          echo "<span class='badge bg-success'>Approved</span>";
        }

        echo "</td>
            </tr>";
      }

      echo "</tbody></table>
            <button type='submit' name='approve_selected' class='btn btn-success'>Approve Selected</button>
            <button type='submit' name='reject_selected' class='btn btn-danger'>Reject Selected</button>
            </form>";
    } else {
      echo "<div class='alert alert-warning mt-4'>No scores found for the selected class group and subject.</div>";
    }
  }
  ?>
</div>

<script>
  $('#checkAll').click(function () {
    $('input[name="approve_ids[]"]').prop('checked', this.checked);
  });
</script>
</body>
</html>
