<?php

include  "db_config.php";


?>


<!DOCTYPE html>
<html>
<head>
	<title>JSMS- Report By Student Balance</title>

	<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

	<!--Datatable CSS -->
        <link rel="stylesheet" href="../admin/assets/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="../admin/assets/css/buttons.dataTables.min.css">
</head>
<body>
<div class="container">
	<form method="POST" action="fee_structure_report.php">
	<div class="row" style="margin-top: 15px;">
			<?php include "reportheader.php"; ?>
		</div>
		<div style="margin-top: 50px;width: 100%">
		<table id="example" class="display nowrap" style="width:100%">
		        <thead>
		            <tr>
		                <th>S/N</th>
						<th>Student Name</th>
						<th>Class Group</th>
						<th>Class Name</th>
						<th>Total Fee</th>
						<th>Discount</th>
						<th>Amount Payable</th>
						<th>Total Paid</th>
						<th>Balance</th>
						<th>
							Fee Status
						</th>
		            </tr>
		        </thead>
		        <tbody>
		        	<?php
		        		$i = 1;
		        		

	  							$sql= "SELECT p_id, class_group,class_name,SUM(amount_rev) AS reversal, SUM(debit) AS TOTALFEE, SUM(debit)-SUM(amount_rev) AS AMOUNTPAYABLE, SUM(credit) AS TOTALCREDIT, SUM(DEBIT)-SUM(credit) AS BALANCE,SUM(paymentrev) as paymentreversal FROM payment_tbl GROUP BY std_id ORDER BY class_group";

	  							$query = mysqli_query($conn,$sql);
	  							while ($row=mysqli_fetch_assoc($query)){
	  									
	  									$dbfsid = $row['p_id'];
	  									$dbstdname= $row['student_name'];
	  									$dbclassgroup = $row['class_group'];
	  									$dbclassname = $row['class_name'];
	  									$dbreversal = $row['reversal'];
	  									$dbpaymentreversal = $row['paymentreversal'];
	  									$dbtotalfee = $row['TOTALFEE']-$dbpaymentreversal;
	  									$dbamountpayable = $row['AMOUNTPAYABLE']-$dbpaymentreversal;
	  									$dbtotalcredit = $row['TOTALCREDIT']-$dbreversal-$dbpaymentreversal;
	  									// $dbtotalcredit = $row['TOTALCREDIT'];
	  									$dbbalance = $row['BALANCE'];
	  									if($dbbalance==0){
	  										$feestatus = "Balanced";
	  									}else{
	  										$feestatus = "Owing";
	  									}
	  									// $dbbalance = $dbamountpayable - $dbtotalcredit;
	  								?>
		            <tr>
		            	<td><?php echo $i;?></td>
		                <td><?php echo $dbstdname;?></td>
		                <td><?php echo $dbclassgroup;?></td>
		                <td><?php echo $dbclassname;?></td>
		                <td><?php echo number_format($dbtotalfee,2);?></td>
		                <td><?php echo number_format($dbreversal,2);?></td>
		                <td><?php echo number_format($dbamountpayable,2);?></td>
		                <td><?php echo number_format($dbtotalcredit,2);?></td>
		                <td><?php echo number_format($dbbalance,2);?></td>
		                <td><?php echo $feestatus;?></td>
		            </tr>
		           <?php 
		       			$i++;}
		       			?>
		        </tbody>
		        <tfoot>
		            <tr>
		                <th>S/N</th>
						<th>Student Name</th>
						<th>Class Group</th>
						<th>Class Name</th>
						<th>Total Fee</th>
						<th>Discount</th>
						<th>Amount Payable</th>
						<th>Total Paid</th>
						<th>Balance</th>
						<th>Fee Status</th>
		            </tr>
		        </tfoot>
		    </table>
		   </div>
		</form>
</div>
<!-- jQuery -->
<script src="assets/js/jquery-3.5.1.min.js"></script>

<!-- Datatables JS -->
<script src="assets/plugins/datatables/datatables.min.js"></script>
<script src="../assets/js/jquery-3.5.1.js"></script>
<script src="../admin/assets/js/jquery.dataTables.min.js"></script>
<script src="../admin/assets/js/dataTables.buttons.min.js"></script>
<script src="../admin/assets/js/jszip.min.js"></script> 
<script src="../admin/assets/js/pdfmake.min.js"></script>
<script src="../admin/assets/js/vfs_fonts.js"></script>
<script src="../admin/assets/js/buttons.html5.min.js"></script>
<script src="../admin/assets/js/buttons.print.min.js"></script>

<!-- Datatable init js -->
<script src="../admin/assets/js/datatables.init.js"></script>
        
		
<!-- Custom JS -->
<script src="assets/js/script.js"></script>

<script>
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
} );
</script>
</body>
</html>