<?php
include "db_config.php";
include "auth.php";

// Handle form submission
if (isset($_POST['submit_remark'])) {
    $std_id = $_POST['stdid'];
    $session_id = $_POST['session'];
    $term_id = $_POST['term'];
    $teacher_remark = $_POST['teacher_remark'];
    $principal_remark = $_POST['principal_remark'];

    // Check if a record already exists
    $check = $conn->prepare("SELECT * FROM report_remark_tbl WHERE std_id = ? AND session = ? AND term = ?");
    $check->bind_param("iii", $std_id, $session_id, $term_id);
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
        // Update existing record
        $update = $conn->prepare("UPDATE report_remark_tbl SET teacher_remark = ?, principal_remark = ? WHERE std_id = ? AND session = ? AND term = ?");
        $update->bind_param("ssiii", $teacher_remark, $principal_remark, $std_id, $session_id, $term_id);
        $update->execute();
        $msg = "Remark updated successfully.";
    } else {
        // Insert new record
        $insert = $conn->prepare("INSERT INTO report_remark_tbl (std_id, session, term, teacher_remark, principal_remark) VALUES (?, ?, ?, ?, ?)");
        $insert->bind_param("iiiss", $std_id, $session_id, $term_id, $teacher_remark, $principal_remark);
        $insert->execute();
        $msg = "Remark added successfully.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin - Add/Edit Remarks</title>
    <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
</head>
<body class="container mt-5">
    <p><a href="index.php">Back to Dashboard</a></p>
    <h2 class="mb-4">Add / Edit Student Remarks</h2>

    <?php if (!empty($msg)) { echo "<div class='alert alert-success'>$msg</div>"; } ?>

    <form method="POST" action="">
        <div class="mb-3">
            <label for="student-search" class="form-label">Search Student</label>
            <select id="student-search" class="form-control" style="width:100%" required></select>
            <input type="hidden" name="stdid" id="student-id">
        </div>

        <div class="mb-3">
            <label for="session" class="form-label">Session</label>
            <select name="session" id="session" class="form-control" required>
                <option value="">Select Session</option>
                <?php
                $res = mysqli_query($conn, "SELECT se_id, sch_session FROM session_tbl WHERE status='active'");
                while ($row = mysqli_fetch_assoc($res)) {
                    echo "<option value='" . $row['se_id'] . "'>" . $row['sch_session'] . "</option>";
                }
                ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="term" class="form-label">Term</label>
            <select name="term" id="term" class="form-control" required>
                <option value="">Select Term</option>
                <?php
                $res = mysqli_query($conn, "SELECT t_id, sch_term FROM term_tbl WHERE status='active'");
                while ($row = mysqli_fetch_assoc($res)) {
                    echo "<option value='" . $row['t_id'] . "'>" . $row['sch_term'] . "</option>";
                }
                ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="teacher_remark" class="form-label">Teacher Remark</label>
            <textarea name="teacher_remark" id="teacher_remark" rows="3" class="form-control" required></textarea>
        </div>

        <div class="mb-3">
            <label for="principal_remark" class="form-label">Principal Remark</label>
            <textarea name="principal_remark" id="principal_remark" rows="3" class="form-control" required></textarea>
        </div>

        <button type="submit" name="submit_remark" class="btn btn-primary">Save Remark</button>
    </form>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $('#student-search').select2({
            placeholder: 'Search for a student',
            ajax: {
                url: 'search_students.php',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        query: params.term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });

        $('#student-search').on('select2:select', function (e) {
            var data = e.params.data;
            $('#student-id').val(data.id);
        });
    </script>
</body>
</html>
