<?php
include "db_config.php";
include "auth.php";

date_default_timezone_set('Africa/Lagos');
$creation_date = date('Y-m-d'); 
$dt = date('Y-m-d h:i:sa');

// Get student ID and classgroup from URL
if (isset($_GET['sid'])) {
    $sid = $_GET['sid'];
} 
if (isset($_GET['cg'])) {
    $cg = $_GET['cg'];
} 

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upload_individual_fee'])) {
    $std_id = $_POST['std_id'];
    $cg_id = $_POST['classgroup'];
    $session_id = $_POST['session'];
    $term_id = $_POST['term'];

    // Get student info
    $std_sql = "SELECT std_id, CONCAT(firstname, ' ', surname, ' ', othername) AS student_name, class_group, class_name 
                FROM student_tbl 
                WHERE std_id = ? AND status = 'Active'";
    $std_stmt = $conn->prepare($std_sql);
    $std_stmt->bind_param("i", $std_id);
    $std_stmt->execute();
    $student = $std_stmt->get_result()->fetch_assoc();
    $std_stmt->close();

    if (!$student) {
        $_SESSION['msg'] = "Student not found or inactive.";
        $_SESSION['alerttype'] = "danger";
        header("Location: addfeeprocessing.php?sid=$std_id&cg=$cg_id");
        exit();
    }

    // Check if fees already uploaded
    $check_sql = "SELECT COUNT(*) FROM payment_tbl WHERE student_id = ? AND classgroup_id = ? AND session_id = ? AND term_id = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("iiii", $std_id, $cg_id, $session_id, $term_id);
    $check_stmt->execute();
    $check_stmt->bind_result($exists);
    $check_stmt->fetch();
    $check_stmt->close();

    if ($exists > 0) {
        $_SESSION['msg'] = "Fees already uploaded for this student for selected session and term.";
        $_SESSION['alerttype'] = "danger";
        header("Location: addfeeprocessing.php?sid=$std_id&cg=$cg_id");
        exit();
    }

    // Get applicable fees from fee_structure
    $fee_sql = "SELECT fee_code, amount, fee_category_id FROM fee_structure WHERE class_group_id = ? AND session_id = ?";
    $fee_stmt = $conn->prepare($fee_sql);
    $fee_stmt->bind_param("ii", $cg_id, $session_id);
    $fee_stmt->execute();
    $fee_result = $fee_stmt->get_result();

    $fees = [];
    while ($row = $fee_result->fetch_assoc()) {
        $fees[] = $row;
    }
    $fee_stmt->close();

	// ✅ Add this check immediately after populating $fees
	if (count($fees) == 0) {
		$_SESSION['msg'] = "No fees found in the fee structure for this class group and session.";
		$_SESSION['alerttype'] = "warning";
		header("Location: addfeeprocessing.php?sid=$std_id&cg=$cg_id");
		exit();
	}

	$trans_type_name = 'Normal'; // or 'Discount', etc.

	// Fetch the tt_id based on name
	$type_sql = "SELECT tt_id FROM transaction_type_tbl WHERE transaction_type = ?";
	$type_stmt = $conn->prepare($type_sql);
	$type_stmt->bind_param("s", $trans_type_name);
	$type_stmt->execute();
	$type_result = $type_stmt->get_result();

	if ($type_row = $type_result->fetch_assoc()) {
		$trans_type = $type_row['tt_id'];
	} else {
		$_SESSION['msg'] = "Transaction type '$trans_type_name' not found.";
		$_SESSION['alerttype'] = "danger";
		header("Location: addfeeprocessing.php?sid=$std_id&cg=$cg_id");
		exit();
	}

	$type_stmt->close();

	$term_name_sql = "SELECT sch_term FROM term_tbl WHERE t_id = ?";
	$term_stmt = $conn->prepare($term_name_sql);
	$term_stmt->bind_param("i", $term_id);
	$term_stmt->execute();
	$term_result = $term_stmt->get_result();
	$term_name = $term_result->fetch_assoc()['sch_term'];
	$term_stmt->close();

    // Insert into payment_tbl
	$date_time = date("Y-m-d h:i:s");
	$narration = $term_name." Fee Upload";
    $insert_sql = "INSERT INTO payment_tbl (trans_type, student_id, classgroup_id, session_id, term_id, debit, payment_category, trans_date, date_time, narration) 
                   VALUES (?, ?, ?, ?, ?, ?, ?, CURDATE(), ?, ?)";
    $insert_stmt = $conn->prepare($insert_sql);

    $inserted = 0;
    foreach ($fees as $fee) {
        $insert_stmt->bind_param(
            "iiiiidiss",
			$trans_type,
            $std_id,
            $cg_id,
            $session_id,
            $term_id,
            $fee['amount'],
            $fee['fee_category_id'],
			$date_time,
			$narration
        );
        $insert_stmt->execute();
        $inserted++;
    }

    $insert_stmt->close();

    $_SESSION['msg'] = "$inserted fee records uploaded successfully for the student.";
    $_SESSION['alerttype'] = "success";
    header("Location: addfeeprocessing.php?sid=$std_id&cg=$cg_id");
    exit();
}
?>


<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Individual Fee Upload</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- Header -->
            <div class="header">
			
				<!-- Logo -->
                <div class="header-left">
                    <a href="index.html" class="logo">
						<img src="assets/img/logo.png" alt="Logo">
					</a>
					<a href="index.html" class="logo logo-small">
						<img src="assets/img/logo-small.png" alt="Logo" width="30" height="30">
					</a>
                </div>
				<!-- /Logo -->
				
				<a href="javascript:void(0);" id="toggle_btn">
					<i class="fas fa-align-left"></i>
				</a>
				
				<!-- Search Bar -->
				<div class="top-nav-search">
					<form>
						<input type="text" class="form-control" placeholder="Search here">
						<button class="btn" type="submit"><i class="fas fa-search"></i></button>
					</form>
				</div>
				<!-- /Search Bar -->
				
				<!-- Mobile Menu Toggle -->
				<a class="mobile_btn" id="mobile_btn">
					<i class="fas fa-bars"></i>
				</a>
				<!-- /Mobile Menu Toggle -->
				
				<!-- Header Right Menu -->
				<ul class="nav user-menu">

					<!-- Notifications -->
					<li class="nav-item dropdown noti-dropdown">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<i class="far fa-bell"></i> <span class="badge badge-pill">3</span>
						</a>
						<div class="dropdown-menu notifications">
							<div class="topnav-dropdown-header">
								<span class="notification-title">Notifications</span>
								<a href="javascript:void(0)" class="clear-noti"> Clear All </a>
							</div>
							<div class="noti-content">
								<ul class="notification-list">
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-02.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Carlson Tech</span> has approved <span class="noti-title">your estimate</span></p>
													<p class="noti-time"><span class="notification-time">4 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-11.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">International Software Inc</span> has sent you a invoice in the amount of <span class="noti-title">$218</span></p>
													<p class="noti-time"><span class="notification-time">6 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-17.jpg">
												</span>
												<div class="media-body">
												<p class="noti-details"><span class="noti-title">John Hendry</span> sent a cancellation request <span class="noti-title">Apple iPhone XR</span></p>
												<p class="noti-time"><span class="notification-time">8 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-13.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Mercury Software Inc</span> added a new product <span class="noti-title">Apple MacBook Pro</span></p>
													<p class="noti-time"><span class="notification-time">12 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
								</ul>
							</div>
							<div class="topnav-dropdown-footer">
								<a href="#">View all Notifications</a>
							</div>
						</div>
					</li>
					<!-- /Notifications -->
					
					<!-- User Menu -->
					<li class="nav-item dropdown has-arrow">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<span class="user-img"><img class="rounded-circle" src="assets/img/profiles/avatar-01.jpg" width="31" alt="Ryan Taylor"></span>
						</a>
						<div class="dropdown-menu">
							<div class="user-header">
								<div class="avatar avatar-sm">
									<img src="assets/img/profiles/avatar-01.jpg" alt="User Image" class="avatar-img rounded-circle">
								</div>
								<div class="user-text">
									<h6>Ryan Taylor</h6>
									<p class="text-muted mb-0">Administrator</p>
								</div>
							</div>
							<a class="dropdown-item" href="profile.html">My Profile</a>
							<a class="dropdown-item" href="inbox.html">Inbox</a>
							<a class="dropdown-item" href="login.html">Logout</a>
						</div>
					</li>
					<!-- /User Menu -->
					
				</ul>
				<!-- /Header Right Menu -->
				
            </div>
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Individual Fee Upload</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
									<li class="breadcrumb-item active">Individual Fee Upload</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
						<?php
							if (isset($_SESSION['msg'])) {
								$alerttype = $_SESSION['alerttype'];
								$msg = $_SESSION['msg'];
								echo "<div class='alert alert-$alerttype alert-dismissible fade show' role='alert'>
										<a href='#' class='alert-link'>$msg</a>
										<button type='button' class='close' data-dismiss='alert' aria-label='Close'>
											<span aria-hidden='true'>&times;</span>
										</button>
									</div>";
								unset($_SESSION['msg']);
								unset($_SESSION['alerttype']);
							}
							?>

							<div class="card">
								<div class="card-body">
									<form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
										<div class="row">
												
													<h5 class="form-title"><span>Make Selection</span></h5>
													<input type="hidden" name="std_id" value="<?php echo $sid; ?>">
													<input type="hidden" name="classgroup" value="<?php echo $cg; ?>">
													<!-- <div class="col-12 col-sm-3">  
															<select name="classgroup" class="form-control" id="classgroup" onchange="manageSelection()">
																<option value="--Select Class Group--">--Select Class Group--</option>
																	<?php
																	$sql = "SELECT * FROM classgroup_tbl WHERE status='active' ORDER BY position";
																	$result = mysqli_query($conn,$sql);
																	while($row = mysqli_fetch_assoc($result)){
																	$cg = $row['class_group'];
																	$cg_id = $row['cg_id']; ?>
																<option value="<?php echo $cg_id;?>"><?php echo $cg;?></option><?php }?>
															</select>
													</div>						 -->
													
													
													<div class="col-12 col-sm-3">
														<select name="session" class="form-control" id="session" onChange="manageSelection()">
															<option>--Select Session--</option>
															<?php
															$sql = "SELECT * FROM session_tbl WHERE status='active'";
															$result = mysqli_query($conn,$sql);
															while($row = mysqli_fetch_assoc($result)){
																$sch_session = $row['sch_session'];
																$se_id = $row['se_id']; ?>
															<option value="<?php echo $se_id;?>"><?php echo $sch_session;?></option>
															<?php }?>
														</select>
													</div>
											
													<div class="col-12 col-sm-3">
														<select name="term" class="form-control">
															<option>--Select Term--</option>
															<?php
															$sql = "SELECT * FROM term_tbl WHERE status='active'";
															$result = mysqli_query($conn,$sql);
															while($row = mysqli_fetch_assoc($result)){
																$sch_term = $row['sch_term'];
																$t_id = $row['t_id']; ?>
															<option value="<?php echo $t_id;?>"><?php echo $sch_term;?></option>
															<?php }?>
														</select>
													</div>
											
													<div style="margin-top: 15px;" class="col-12">
														<button type="submit" name="upload_individual_fee" class="btn btn-primary" id="btn" disabled>Batch Fee Upload</button>
													</div>						
												</div>
										</div>
									</form>
									
								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>

		<!--Javascript Script to Disable and Enable Submit Button-->
		<script>
			function manageSelection(){
				var btn = document.getElementById('btn');
				var sel = document.getElementById('session');

				if(sel.value=='--Select Session--'){
					btn.disabled = true;
				}else{
					btn.disabled = false;
				}
			}
		</script>
    </body>
</html>