<?php
include "db_config.php";
include  "auth.php";


function test_input($data){
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

$teacherid = "TE".rand(0,9).rand(0,9).rand(0,9).rand(0,9).rand(0,9);

        
//$alerttype="";
$tid=$name=$gender=$dob=$pno=$jod=$qualification=$experience=$username=$email=$pwd=$rpwd=$address=$city="";
//$state=$country="";
if($_SERVER["REQUEST_METHOD"] == "POST"){
  if(isset($_POST['submit'])){
            
       /*Student Details*/
      
        if(empty($_POST['tid'])) {
        	$tid = $teacherid;
        }else{
        	$tid = test_input($_POST['tid']);
        }

        if(empty($_POST['name'])){
        	$errors= "Enter your name";
        }else{
        	$name = test_input($_POST['name']);
        }
        
        $gender = test_input($_POST['gender']);
        if($_POST['dob']==''){
        	$errors = "Select Date of Birth";
        }else{
        	$dob = test_input($_POST['dob']);
        }
        
        $pno = test_input($_POST['pno']);
        if($_POST['jod']==''){
        	$errors = "Date Join is required";
        }else{
        	$jod = test_input($_POST['jod']);
        }
        if(empty($_POST['qualification'])){
        	$errors = "Qualification is required";
        }else{
        	$qualification = test_input($_POST['qualification']);
        }
        if(empty($_POST['experience'])){
        	$errors = "Experience is required";
        }else{
        	$experience = test_input($_POST['experience']);
        }
        if(empty($_POST['username'])){
        	$errors = "Username is required";
        }else{
        	$username = test_input($_POST['username']);
        }
        if(empty($_POST['email'])){
        	$errors = "Email is required";
        }else{
        	$email = test_input($_POST['email']);
        }
        if(empty($_POST['pwd'])){
        	$errors = "Password is required";
        }else{
        	$pwd = test_input($_POST['pwd']);	
        }
     	if(empty($_POST['rpwd'])){
     		$errors = "Please Confirm Password";
     	}else{
     		$rpwd = test_input($_POST['rpwd']);
     	}
        if(empty($_POST['address'])){
        	$errors = "Address is required";
        }else{
        	$address = test_input($_POST['address']);
        }
        if(empty($_POST['city'])){
        	$errors = "City is required";
        }else{
        	$city = test_input($_POST['city']);
        }
        if(empty($_POST['state'])){
        	$errors = "State is required";
        }else{
        	$state = test_input($_POST['state']);
        }
        if(empty($_POST['country'])){
        	$errors = "Country is required";
        }else{
        	$country = test_input($_POST['country']);
        }
                
		date_default_timezone_set('Africa/Lagos');
        
        $creation_date = date('Y-m-d'); 
        $dt = date('Y-m-d h:m:sa',time());

        if($pwd!==$rpwd){
        	$errors = "Password Mismatch";
        	$alerttype = "danger";
        }

        $sq=  "SELECT username FROM teacher_tbl WHERE username='".$username."'";
        $rs = mysqli_query($conn,$sq);
        $numrow = mysqli_num_rows($rs);
        if($numrow > 0){
        	$errors = "Username Already Existed";
        	$alerttype = "danger";
        }else{
        	$username = test_input($_POST['username']);
        }

        if(isset($errors)){
            $msg = $errors;
            $alerttype = "danger";
        }else{
        
        	$hashedPwd = password_hash($pwd, PASSWORD_DEFAULT); // Now hash it

            $sql= "INSERT INTO teacher_tbl(t_id,teacher_id,teacher_name,gender,dob,pno,joining_date,qualification,experience,username,email,pwd,address,city,state,country,create_by,creation_date,date_time,update_by,update_dt) VALUES (null,'$tid','$name','$gender','$dob','$pno','$jod','$qualification','$experience','$username','$email','$hashedPwd','$address','$city','$state','$country','$admin_name','$creation_date','$dt',NULL,NULL);";


            $query = mysqli_query($conn,$sql) or die($sql);
            if($query){
            	// echo '<script>alert("Registration Successful. Your Teacher ID");
            	// 	window.location="index.php";
            	// </script>';
            	
                $alerttype="success";
                $msg = "Teacher Registration Successful. Your registration ID is $teacherid";
            }else{
            	
            	// echo '<script>alert("Registration Not Successul")</script>';
                $msg = mysqli_error($conn);
            }
        
        }
        

    }
}


?>

<!DOCTYPE html>
<html lang="en">
    

<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Teachers</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- Header -->
            <div class="header">
			
				<!-- Logo -->
                <div class="header-left">
                    <a href="index.html" class="logo">
						<img src="assets/img/logo.png" alt="Logo">
					</a>
					<a href="index.html" class="logo logo-small">
						<img src="assets/img/logo-small.png" alt="Logo" width="30" height="30">
					</a>
                </div>
				<!-- /Logo -->
				
				<a href="javascript:void(0);" id="toggle_btn">
					<i class="fas fa-align-left"></i>
				</a>
				
				<!-- Search Bar -->
				<div class="top-nav-search">
					<form>
						<input type="text" class="form-control" placeholder="Search here">
						<button class="btn" type="submit"><i class="fas fa-search"></i></button>
					</form>
				</div>
				<!-- /Search Bar -->
				
				<!-- Mobile Menu Toggle -->
				<a class="mobile_btn" id="mobile_btn">
					<i class="fas fa-bars"></i>
				</a>
				<!-- /Mobile Menu Toggle -->
				
				<!-- Header Right Menu -->
				<ul class="nav user-menu">

					<!-- Notifications -->
					<li class="nav-item dropdown noti-dropdown">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<i class="far fa-bell"></i> <span class="badge badge-pill">3</span>
						</a>
						<div class="dropdown-menu notifications">
							<div class="topnav-dropdown-header">
								<span class="notification-title">Notifications</span>
								<a href="javascript:void(0)" class="clear-noti"> Clear All </a>
							</div>
							<div class="noti-content">
								<ul class="notification-list">
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-02.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Carlson Tech</span> has approved <span class="noti-title">your estimate</span></p>
													<p class="noti-time"><span class="notification-time">4 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-11.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">International Software Inc</span> has sent you a invoice in the amount of <span class="noti-title">$218</span></p>
													<p class="noti-time"><span class="notification-time">6 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-17.jpg">
												</span>
												<div class="media-body">
												<p class="noti-details"><span class="noti-title">John Hendry</span> sent a cancellation request <span class="noti-title">Apple iPhone XR</span></p>
												<p class="noti-time"><span class="notification-time">8 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-13.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Mercury Software Inc</span> added a new product <span class="noti-title">Apple MacBook Pro</span></p>
													<p class="noti-time"><span class="notification-time">12 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
								</ul>
							</div>
							<div class="topnav-dropdown-footer">
								<a href="#">View all Notifications</a>
							</div>
						</div>
					</li>
					<!-- /Notifications -->
					
					<!-- User Menu -->
					<li class="nav-item dropdown has-arrow">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<span class="user-img"><img class="rounded-circle" src="assets/img/profiles/avatar-01.jpg" width="31" alt="Ryan Taylor"></span>
						</a>
						<div class="dropdown-menu">
							<div class="user-header">
								<div class="avatar avatar-sm">
									<img src="assets/img/profiles/avatar-01.jpg" alt="User Image" class="avatar-img rounded-circle">
								</div>
								<div class="user-text">
									<h6>Ryan Taylor</h6>
									<p class="text-muted mb-0">Administrator</p>
								</div>
							</div>
							<a class="dropdown-item" href="profile.html">My Profile</a>
							<a class="dropdown-item" href="inbox.html">Inbox</a>
							<a class="dropdown-item" href="login.html">Logout</a>
						</div>
					</li>
					<!-- /User Menu -->
					
				</ul>
				<!-- /Header Right Menu -->
				
            </div>
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Add Teachers</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="teachers.php">Teachers</a></li>
									<li class="breadcrumb-item active">Add Teachers</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->
				
					<div class="row">
						<div class="col-sm-12">
							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
							<a href="#" class="alert-link"><?php echo $msg;?></a>.
							<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
							</button>
						</div><?php } mysqli_close($conn);?>
						
							<div class="card">
								<div class="card-body">
									<form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Basic Details</span></h5>
											</div>
											<div class="col-12 col-sm-12">  
												<div class="form-group">
													<label hidden>Teacher ID</label>
													<input hidden readonly name="tid" type="text" value="<?php echo $teacherid; ?>" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Name</label>
													<input name="name" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Gender</label>
													<select name="gender" class="form-control">
														<option value="Male">Male</option>
														<option value="Female">Female</option>
													</select>
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Date of Birth</label>
													<input name="dob" type="date" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Phone No.</label>
													<input maxlength="11" name="pno" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Joining Date</label>
													<input name="jod" type="date" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Qualification</label>
													<input name="qualification" class="form-control" type="text">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Experience</label>
													<input name="experience" class="form-control" type="text">
												</div>
											</div>
											<div class="col-12">
												<h5 class="form-title"><span>Login Details</span></h5>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Username</label>
													<input name="username" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Email ID</label>
													<input name="email" type="email" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Password</label>
													<input name="pwd" type="password" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Repeat Password</label>
													<input  name="rpwd" type="password" class="form-control">
												</div>
											</div>
											<div class="col-12">
												<h5 class="form-title"><span>Address</span></h5>
											</div>
											<div class="col-12">
												<div class="form-group">
												<label>Address</label>
													<input name="address" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>City</label>
													<input name="city" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>State</label>
													<input name="state" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Country</label>
													<input name="country" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12">
												<button name="submit" type="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</form>
								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>		
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
    </body>


</html>