<?php
include "db_config.php";
include "auth.php";

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ==================
// Helper function
// ==================
function errorRedirect($msg) {
    $_SESSION['msg'] = $msg;
    $_SESSION['alerttype'] = "danger";
    header("Location: add_student.php");
    exit();
}

function test_input($data){
    return htmlspecialchars(stripslashes(trim($data)));
}

// Function to check if studentid already exists
function studentidExists($conn, $studentid) {
    $stmt = $conn->prepare("SELECT COUNT(*) FROM student_tbl WHERE student_id = ?");
    $stmt->bind_param("s", $studentid);
    $stmt->execute();
    $stmt->bind_result($exists);
    $stmt->fetch();
    $stmt->close();
    return $exists > 0;
}

// Function to generate a unique studentid
function generateStudentID($conn) {
    do {
        $studentid = "GWS" . rand(10000, 99999);
    } while (studentidExists($conn, $studentid));
    return $studentid;
}

$msg = $alerttype = $firstname = $surname = $othername = $studentid = $gender = $dob = $school = $classgroup = $classname = $religion = $joiningdate = $session = $fathername = $fathernumber = $fatheremail = $fatherocc = $mothername = $motheremail = $mothernumber = $motherocc = $preaddress = $peraddress = $contactnumber = "";


if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {

    // ======== Student ID =========
    if (!empty($_POST['studentid'])) {
        $studentid = test_input($_POST['studentid']);
        if (studentidExists($conn, $studentid)) {
            errorRedirect("Student ID '$studentid' already exists. Please enter a different one.");
        }
    } else {
        $studentid = generateStudentID($conn);
    }

    // ======== Student Details =========
    $firstname = test_input($_POST['firstname']);
    $surname = test_input($_POST['surname']);
    $othername = test_input($_POST['othername']);
    $gender = test_input($_POST['gender']);
    $dob = test_input($_POST['dob']);
    $school = test_input($_POST['school']);
    $classgroup = test_input($_POST['classgroup']);
    $classname = test_input($_POST['classname']);
    $religion = test_input($_POST['religion']);
    $joiningdate = test_input($_POST['joiningdate']);
    $session = test_input($_POST['session']);
    $fathername = test_input($_POST['fathername']);
    $fatherocc = test_input($_POST['fatherocc']);
    $fathernumber = test_input($_POST['fathernumber']);
    $fatheremail = test_input($_POST['fatheremail']);
    $mothername = test_input($_POST['mothername']);
    $motherocc = test_input($_POST['motherocc']);
    $mothernumber = test_input($_POST['mothernumber']);
    $motheremail = test_input($_POST['motheremail']);
    $preaddress = test_input($_POST['preaddress']);
    $peraddress = test_input($_POST['peraddress']);
    date_default_timezone_set('Africa/Lagos');
    $upd = date('Y-m-d');

    // ======== Image Upload =========
  // Check if image is uploaded at all
	if (empty($_FILES["studentimage"]["tmp_name"]) || !is_uploaded_file($_FILES["studentimage"]["tmp_name"])) {
		errorRedirect("No image file selected. Please upload a student image.");
	}
        
        $target_dir = "assets/images/student/";
        $imageFileType = strtolower(pathinfo($_FILES["studentimage"]["name"], PATHINFO_EXTENSION));
        $picture = uniqid("student_", true) . "." . $imageFileType;
        $target_file = $target_dir . $picture;

        $allowedExt  = ["jpg", "jpeg", "png", "gif"];
        $allowedMime = ["image/jpeg", "image/png", "image/gif"];

        // 1. Extension check
        if (!in_array($imageFileType, $allowedExt)) {
            errorRedirect("Only JPG, JPEG, PNG, and GIF extensions are allowed.");
        }

        // 2. MIME check
        if (!in_array($_FILES["studentimage"]["type"], $allowedMime)) {
            errorRedirect("Invalid MIME type. Please upload a valid image file.");
        }

        // 3. Real image check
        if (getimagesize($_FILES["studentimage"]["tmp_name"]) === false) {
            errorRedirect("The file is not a real image.");
        }

        // 4. Size check
        if ($_FILES["studentimage"]["size"] > 2000000) { // 2MB
            errorRedirect("Image file is too large. Maximum allowed size is 2MB.");
        }

        // ======== Insert into DB =========
        $sql = "INSERT INTO student_tbl (
            student_id, firstname, surname, othername, gender, dob, school,
            def_class_group, def_class_name, class_group, class_name, religion,
            joining_date, session, student_image, fathername,
            fatheroccupation, fathernumber, fatheremail, mothername, motheroccupation,
            mothernumber, motheremail, preaddress, peraddress, creation_date,
            create_by, `status`
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Active'
        )";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssssssssssssssssssssssssss",
            $studentid, $firstname, $surname, $othername, $gender, $dob, $school,
            $classgroup, $classname, $classgroup, $classname, $religion,
            $joiningdate, $session, $picture, $fathername,
            $fatherocc, $fathernumber, $fatheremail, $mothername, $motherocc,
            $mothernumber, $motheremail, $preaddress, $peraddress, $upd,
            $admin_name
        );

        if ($stmt->execute()) {
            move_uploaded_file($_FILES["studentimage"]["tmp_name"], $target_file);
            $_SESSION['msg'] = "Registration Successful. Your Student ID is " . htmlspecialchars($studentid);
            $_SESSION['alerttype'] = "success";
            header("Location: add_student.php");
            exit();
        } else {
            errorRedirect("Database Error: " . $stmt->error);
        }
        $stmt->close();

    
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Add Students</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
		<style>
		#preview {
		margin-top: 10px;
		max-width: 200px;
		max-height: 200px;
		display: none; /* hidden until image selected */
		border: 1px solid #ccc;
		border-radius: 5px;
		}
		</style>

    </head>
    <body>
    	<?php include "loader_include.php"; ?>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- /Header -->
			<?php //include "hrm.php";?>
			<?php //include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Add Students</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="students.php">Students</a></li>
									<li class="breadcrumb-item active">Add Students</li>
									
								</ul>
							</div>
						</div><!--<br/>
						<div class="col-sm-6">
							<button onclick="location.reload();" type="button" class="btn btn-success">
							<label class="fas fa-sync-alt"><span> Refresh</span>
						</div>
					</div>
					<!-- /Page Header -->
				
					<div class="row">
						<div class="col-sm-12">
							
                        	<?php
							if (isset($_SESSION['msg'])) {
								$alerttype = $_SESSION['alerttype'];
								$msg = $_SESSION['msg'];
								echo "<div class='alert alert-$alerttype alert-dismissible fade show' role='alert'>
										<a href='#' class='alert-link'>$msg</a>
										<button type='button' class='close' data-dismiss='alert' aria-label='Close'>
											<span aria-hidden='true'>&times;</span>
										</button>
									</div>";
								unset($_SESSION['msg']);
								unset($_SESSION['alerttype']);
							}
							?>
							<div class="card">
								<div class="card-body">
									<form onsubmit="return validateForm()" id="stdreg" method="POST" enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" required>
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Student Information</span></h5>
											</div>
											<!-- <div class="col-12 col-sm-6">  
												<div class="form-group">
													<label hidden>APPLICATION NUMBER</label>
													<input hidden name="appnumber" readonly value="<?php echo $studentid;?>" type="text" class="form-control" required>
												</div>
											</div> -->
											<div class="col-12 col-sm-12">  
												<div class="form-group">
													<label>Student ID</label>
													<input 
														style="width: 250px;" 
														name="studentid" 
														value="<?php echo htmlspecialchars($studentid); ?>"
														type="text" 
														class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">  
												<div class="form-group">
													<label>First Name</label>
													<input name="firstname" value="<?php echo $firstname;?>" type="text" class="form-control" required>
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Surname</label>
													<input name="surname" value="<?php echo $surname;?>" type="text" class="form-control" required>
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Other Name</label>
													<input name="othername" value="<?php echo $othername;?>" type="text" class="form-control">
												</div>
											</div>
											
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Gender</label>
													<select required name="gender" id="gender" value="<?php echo $gender;?>" class="form-control">
														<option value="">--Select Gender--</option>
														<option value="Male">Male</option>
														<option value="Female">Female</option>
													  </select>
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Date of Birth</label>
													<div>
														<input name="dob" id="dob" value="<?php echo $dob;?>" type="date" class="form-control" required>
													</div>
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<label>School</label>
												<select required name="school" id="school" value="<?php echo $school;?>" class="form-control">
													<option value="">--Select School--</option>
													<?php
													$sql = "SELECT * FROM school_tbl WHERE status='active'";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														$sch = $row['sch_name'];
														$sch_id = $row['sch_id']; ?>
													<option value="<?php echo $sch_id;?>"><?php echo $sch;?></option><?php }?>
												</select>
											</div>
											<div class="col-12 col-sm-6">
												<label>Class Group</label>
												<select required name="classgroup" id="classgroup" value="<?php echo $classgroup;?>" class="form-control">
													<option value="">--Select Class Group--</option>	
												</select>
											</div>
											<div class="col-12 col-sm-6">
												<label>Class Arms</label>
												<select required name="classname" id="classname" value="<?php echo $classname;?>" class="form-control">
													<option value="">--Select Class Arms--</option>
												</select>
											</div>
											
											<div class="col-12 col-sm-6">
													<label>Religion</label>
													<select required name="religion" id="religion" value="<?php echo $religion;?>" class="form-control">
														<option value="">--Select Religion--</option>
														<option value="cHRISTIANITY">CHRISTIANITY</option>
														<option value="ISLAM">ISLAM</option>
													  </select>
											</div><br/>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Joining Date</label>
													<div>
														<input name="joiningdate" id="joiningdate" value="<?php echo $joiningdate;?>" type="date" class="form-control" required>
													</div>
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<label>Session</label>
												<select required="" name="session" id="session" value="<?php echo $session;?>" class="form-control" required>
													<option value="">--Select Session--</option>
													<?php
													$sql = "SELECT * FROM session_tbl WHERE status='active'";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														$sch_session = $row['sch_session']; ?>
													<option value="<?php echo $sch_session;?>"><?php echo $sch_session;?></option>
													<?php } mysqli_close($conn);?>
												</select>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Student Image  (Max. 2MB)</label>
													<input name="studentimage" id="studentimage" type="file" accept=".jpg,.jpeg,.png" class="form-control" required>
													<img id="preview" alt="Image Preview">
												</div>
											</div>
											<!-- <div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Contact/Portal Number</label>
													<input name="contactnumber" value="<?php echo $contactnumber;?>" type="text"  maxlength="11" class="form-control">
												</div>
											</div> -->
											
											<div class="col-12">
												<h5 class="form-title"><span>Parent Information</span></h5>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Father's Name</label>
													<input name="fathername" value="<?php echo $fathername;?>" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Father's Occupation</label>
													<input name="fatherocc" value="<?php echo $fatherocc;?>" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Father's Mobile</label>
													<input name="fathernumber" id="fnumber" inputmode="numeric" value="<?php echo $fathernumber;?>" type="text"  maxlength="11" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Father's Email</label>
													<input name="fatheremail" value="<?php echo $fatheremail;?>" type="email" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Mother's Name</label>
													<input name="mothername" value="<?php echo $mothername;?>" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Mother's Occupation</label>
													<input name="motherocc" value="<?php echo $motherocc;?>" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Mother's Mobile</label>
													<input name="mothernumber" id="mnumber" inputmode="numeric" value="<?php echo $mothernumber;?>" maxlength="11" type="text" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Mother's Email</label>
													<input name="motheremail" value="<?php echo $motheremail;?>" type="email" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Present Address</label>
													<textarea name="preaddress" value="<?php echo $preaddress;?>" class="form-control" required></textarea>
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Permanent Address</label>
													<textarea name="peraddress" value="<?php echo $peraddress;?>" class="form-control" required></textarea>
												</div>
											</div>
											<div class="col-12">
												<button type="submit" name="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</form>
								</div>
							</div>							
						</div>					
					</div>					
				</div>				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
		<script>
			document.getElementById("fnumber").addEventListener("input", function(){
				this.value = this.value.replace(/[^0-9]/g, "");
			})
		</script>
		<script>
			document.getElementById("mnumber").addEventListener("input", function(){
				this.value = this.value.replace(/[^0-9]/g, "");
			})
		</script>

		<script>
			document.getElementById("studentimage").addEventListener("change", function(event) {
				const file = event.target.files[0]; // get the file
				if (file) {
					const reader = new FileReader();

					reader.onload = function(e) {
						const preview = document.getElementById("preview");
						preview.src = e.target.result; // set image source
						preview.style.display = "block"; // show the preview
					};

					reader.readAsDataURL(file); // read file as base64 string
				}
			});
		</script>

		<script>
        $(document).ready(function() {
            $('#school').change(function() {
                var schoolId = $(this).val();
                $('#classgroup').html('<option>--Select Class Group--</option>');
                
                if (schoolId !== '') {
                    $.ajax({
                        url: 'fetch_classgroup.php',
                        type: 'POST',
                        data: { school_id: schoolId },
                        success: function(response) {
                            $('#classgroup').html(response);
                        }
                    });
                } else {
                    $('#classgroup').html('<option value="">--Select Class Group--</option>');
                }
            });
        });

		$(document).ready(function() {
            $('#classgroup').change(function() {
                var classgroupId = $(this).val();
                $('#classname').html('<option>--Select Class Arms--</option>');
                
                if (classgroupId !== '') {
                    $.ajax({
                        url: 'fetch_classname.php',
                        type: 'POST',
                        data: { classgroup_id: classgroupId },
                        success: function(response) {
                            $('#classname').html(response);
                        }
                    });
                } else {
                    $('#classname').html('<option value="">--Select Class Arms--</option>');
                }
            });
        });
    	</script>

		<script>
			// Get today's date in YYYY-MM-DD format
			let today = new Date().toISOString().split('T')[0];

			// Set the default value and max attribute to today's date
			let dateInput = document.getElementById("dob");
			dateInput.setAttribute("max", today);
    	</script>
		
		<script>
			// Get today's date in YYYY-MM-DD format
			let today2 = new Date().toISOString().split('T')[0];

			// Set the default value and max attribute to today's date
			let dateInput2 = document.getElementById("joiningdate");
			dateInput2.setAttribute("max", today2);
    	</script>
		<?php if ($alerttype === "success"): ?>
		<script>
		// Wait for the page to load
		document.addEventListener("DOMContentLoaded", function() {
			// Reset the form
			const form = document.querySelector("#stdreg");
			if (form) {
			form.reset();

			// Optional: scroll to top or alert
			// window.scrollTo({ top: 0, behavior: 'smooth' });
			}
		});
		</script>
		<?php endif; ?>
		
    </body>

</html>