<?php
include "db_config.php";
include "auth.php";
include "send_sms.php";   // SMS sending function
include "send_email.php"; // Email sending function

function test_input($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

$msg = $alerttype = "";

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    $phone_number = test_input($_POST['phone_number']);

    if (empty($phone_number)) {
        $msg = "Phone number is required";
        $alerttype = "danger";
    } elseif (!preg_match('/^\d{11}$/', $phone_number)) {
        $msg = "Phone number must be 11 digits";
        $alerttype = "danger";
    } else {
        // Check if the phone number exists as father or mother number in student_tbl
        $exists_query = "SELECT COUNT(*) AS count FROM student_tbl WHERE fathernumber = ? OR mothernumber = ?";
        $stmt_check = $conn->prepare($exists_query);
        $stmt_check->bind_param("ss", $phone_number, $phone_number);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();
        $row_check = $result_check->fetch_assoc();

        if ($row_check['count'] == 0) {
            $msg = "The phone number is not found in student records as a parent contact.";
            $alerttype = "danger";
        } else {
            // Check if already registered
            $check = mysqli_query($conn, "SELECT * FROM parent_tbl WHERE username = '$phone_number'");
            if (mysqli_num_rows($check) > 0) {
                $msg = "Parent already registered";
                $alerttype = "danger";
            } else {
                // Generate password
                $plain_password = substr(str_shuffle("ABCDEFGHJKLMNPQRSTUVWXYZ23456789"), 0, 6);
                $hashed_password = password_hash($plain_password, PASSWORD_DEFAULT);

                // Insert into parent_tbl
                $sql = "INSERT INTO parent_tbl (username, password, creation_date, created_by)
                        VALUES (?, ?, NOW(), ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sss", $phone_number, $hashed_password, $admin_name);

                if ($stmt->execute()) {
                    // Fetch parent contacts from student_tbl
                    $query = "SELECT DISTINCT fathernumber, fatheremail, mothernumber, motheremail 
                              FROM student_tbl 
                              WHERE fathernumber=? OR mothernumber=? LIMIT 1";
                    $stmt_contacts = $conn->prepare($query);
                    $stmt_contacts->bind_param("ss", $phone_number, $phone_number);
                    $stmt_contacts->execute();
                    $res = $stmt_contacts->get_result();

                    $father = $mother = $father_email = $mother_email = "";
                    if ($row = $res->fetch_assoc()) {
                        $father = $row['fathernumber'];
                        $mother = $row['mothernumber'];
                        $father_email = $row['fatheremail'];
                        $mother_email = $row['motheremail'];
                    }

                    // Compose message and email body
                    $login_link = "https://jobastech.com.ng/jsms/parent/login.php";
                    $message = "JSMS Parent Portal:\nUsername: $phone_number\nPassword: $plain_password\nLogin: $login_link";
                    $email_subject = "Your JSMS Parent Portal Login Details";
                    $email_body = "
                        <p>Dear Parent,</p>
                        <p>Your login credentials for the JSMS Parent Portal are below:</p>
                        <ul>
                            <li><strong>Username:</strong> $phone_number</li>
                            <li><strong>Password:</strong> $plain_password</li>
                        </ul>
                        <p><a href='$login_link'>Click here to login</a></p>
                        <p>Thank you.</p>";

                    // // Send SMS
                    // if (!empty($father)) send_sms($father, $message);
                    // if (!empty($mother) && $mother !== $father) send_sms($mother, $message);

                    // Send Emails
                    if (!empty($father_email)) send_email($father_email, $email_subject, $email_body);
                    if (!empty($mother_email) && $mother_email !== $father_email) send_email($mother_email, $email_subject, $email_body);

                    $msg = "Parent registered successfully. Login details sent to"
                         . ((!empty($father_email) || !empty($mother_email)) ? " your Email." : ".");
                    $alerttype = "success";
                } else {
                    $msg = "Error: " . $conn->error;
                    $alerttype = "danger";
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Add Parents</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Add Parents</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
									<li class="breadcrumb-item active">Add Parents</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->
				
					<div class="row">
						<div class="col-sm-12">
							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
							<a href="#" class="alert-link"><?php echo $msg;?></a>.
							<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
							</button>
						</div><?php } mysqli_close($conn);?>
						
							<div class="card">
								<div class="card-body">
									<form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Parent Onboarding</span></h5>
											</div>
											
											<div class="col-12">
												<h5 class="form-title"><span>Onboarding Details</span></h5>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
											        <label>Parent Phone Number (Username)</label>
											        <input name="phone_number" type="text" class="form-control" required placeholder="e.g. 08012345678">
											    </div>
											</div>
											
											<!-- <div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Password</label>
													<input name="pwd" type="password" class="form-control">
												</div>
											</div>
											<div class="col-12 col-sm-6">
												<div class="form-group">
													<label>Repeat Password</label>
													<input  name="rpwd" type="password" class="form-control">
												</div>
											</div> -->
											
											<div class="col-12">
												<button name="submit" type="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</form>
								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>		
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
    </body>


</html>