<?php

include "db_config.php";
include  "auth.php";

function test_input($data){
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

$classname=$classgroup="";
if($_SERVER["REQUEST_METHOD"] == "POST"){
  if(isset($_POST['submit'])){

 if(isset($_POST['classgroup'])){
 	if($_POST['classgroup']=='--Select Class Group--'){
 		$errors = "Please Select a Class Group";
 	}
 else{
 	$classgroup = test_input($_POST['classgroup']); 
 }
}

/*Select Class group level order */
$stmt = $conn->prepare("SELECT level_order FROM classgroup_tbl WHERE cg_id = ? AND status = 'active'");
$stmt->bind_param("i", $classgroup);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $cg_level_order = $row['level_order'];
}
$stmt->close();

/*
if(empty($_POST['classgroup'])){
	$classgroup = test_input($_POST['classgroup']);      
    }else{
    $errors = "Please Select a Class Group";
   }
*/
if(empty($_POST['classname'])){
          $errors = "Class Name is empty";
    }else{
            $classname = test_input($_POST['classname']);
  }

  if(empty($_POST['teacher_id'])){
          $errors = "Teacher name is empty";
    }else{
            $teacher_id = test_input($_POST['teacher_id']);
  }

  		date_default_timezone_set('Africa/Lagos');
        
		$creation_date = date('Y-m-d'); 
		$dt= date('Y-m-d h:i:sa');

   //Query to check if classgroup does not exist before
        $sql= "SELECT class_name FROM class_tbl WHERE class_name='".$classname."' AND is_deleted = 0";
        $result = mysqli_query($conn,$sql);
        $numrow= mysqli_num_rows($result);
        if($numrow > 0){
        	$errors = "Class Existed Already";
        	$alerttype='danger';
        }
        if(isset($errors)){
        	$msg = $errors;
        	$alerttype='danger';
        }else{
        	$result2 = mysqli_query($conn,"INSERT INTO class_tbl(c_id,classgroup_id,class_name,teacher_id,status,create_by,creation_date,date_time,update_by,update_dt,level_order)
			VALUES(NULL,'$classgroup','$classname','$teacher_id','active','$admin_name','$creation_date','$dt',NULL,NULL,'$cg_level_order')");
        	if($result2){
        		$msg = "Class Name Created Successfully";
        		$alerttype = 'success';
        	}
        }

  }
}

?>

<!DOCTYPE html>
<html lang="en">
    
<head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
        <title>JSMS - Add Class</title>
		
		<!-- Favicon -->
        <link rel="shortcut icon" href="assets/img/favicon.png">
	
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,500;0,600;0,700;1,400&amp;display=swap">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="assets/plugins/bootstrap/css/bootstrap.min.css">
		
		<!-- Fontawesome CSS -->
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
		
		<!-- Main CSS -->
        <link rel="stylesheet" href="assets/css/style.css">
    </head>
    <body>
		
		<!-- Main Wrapper -->
        <div class="main-wrapper">
		
			<!-- Header -->
            <div class="header">
			
				<!-- Logo -->
                <div class="header-left">
                    <a href="index.html" class="logo">
						<img src="assets/img/logo.png" alt="Logo">
					</a>
					<a href="index.html" class="logo logo-small">
						<img src="assets/img/logo-small.png" alt="Logo" width="30" height="30">
					</a>
                </div>
				<!-- /Logo -->
				
				<a href="javascript:void(0);" id="toggle_btn">
					<i class="fas fa-align-left"></i>
				</a>
				
				<!-- Search Bar -->
				<div class="top-nav-search">
					<form>
						<input type="text" class="form-control" placeholder="Search here">
						<button class="btn" type="submit"><i class="fas fa-search"></i></button>
					</form>
				</div>
				<!-- /Search Bar -->
				
				<!-- Mobile Menu Toggle -->
				<a class="mobile_btn" id="mobile_btn">
					<i class="fas fa-bars"></i>
				</a>
				<!-- /Mobile Menu Toggle -->
				
				<!-- Header Right Menu -->
				<ul class="nav user-menu">

					<!-- Notifications -->
					<li class="nav-item dropdown noti-dropdown">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<i class="far fa-bell"></i> <span class="badge badge-pill">3</span>
						</a>
						<div class="dropdown-menu notifications">
							<div class="topnav-dropdown-header">
								<span class="notification-title">Notifications</span>
								<a href="javascript:void(0)" class="clear-noti"> Clear All </a>
							</div>
							<div class="noti-content">
								<ul class="notification-list">
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-02.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Carlson Tech</span> has approved <span class="noti-title">your estimate</span></p>
													<p class="noti-time"><span class="notification-time">4 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-11.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">International Software Inc</span> has sent you a invoice in the amount of <span class="noti-title">$218</span></p>
													<p class="noti-time"><span class="notification-time">6 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-17.jpg">
												</span>
												<div class="media-body">
												<p class="noti-details"><span class="noti-title">John Hendry</span> sent a cancellation request <span class="noti-title">Apple iPhone XR</span></p>
												<p class="noti-time"><span class="notification-time">8 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
									<li class="notification-message">
										<a href="#">
											<div class="media">
												<span class="avatar avatar-sm">
													<img class="avatar-img rounded-circle" alt="User Image" src="assets/img/profiles/avatar-13.jpg">
												</span>
												<div class="media-body">
													<p class="noti-details"><span class="noti-title">Mercury Software Inc</span> added a new product <span class="noti-title">Apple MacBook Pro</span></p>
													<p class="noti-time"><span class="notification-time">12 mins ago</span></p>
												</div>
											</div>
										</a>
									</li>
								</ul>
							</div>
							<div class="topnav-dropdown-footer">
								<a href="#">View all Notifications</a>
							</div>
						</div>
					</li>
					<!-- /Notifications -->
					
					<!-- User Menu -->
					<li class="nav-item dropdown has-arrow">
						<a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
							<span class="user-img"><img class="rounded-circle" src="assets/img/profiles/avatar-01.jpg" width="31" alt="Ryan Taylor"></span>
						</a>
						<div class="dropdown-menu">
							<div class="user-header">
								<div class="avatar avatar-sm">
									<img src="assets/img/profiles/avatar-01.jpg" alt="User Image" class="avatar-img rounded-circle">
								</div>
								<div class="user-text">
									<h6>Ryan Taylor</h6>
									<p class="text-muted mb-0">Administrator</p>
								</div>
							</div>
							<a class="dropdown-item" href="profile.html">My Profile</a>
							<a class="dropdown-item" href="inbox.html">Inbox</a>
							<a class="dropdown-item" href="login.html">Logout</a>
						</div>
					</li>
					<!-- /User Menu -->
					
				</ul>
				<!-- /Header Right Menu -->
				
            </div>
			<!-- /Header -->
			<?php include "hrm.php";?>
			<?php include "navigation.php";?>
			
			<!-- Page Wrapper -->
            <div class="page-wrapper">
                <div class="content container-fluid">
				
					<!-- Page Header -->
					<div class="page-header">
						<div class="row align-items-center">
							<div class="col">
								<h3 class="page-title">Add Class</h3>
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="class.php">Classes</a></li>
									<li class="breadcrumb-item active">Add Class</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->

					<div class="row">
						<div class="col-sm-12">
							

							<?php if(isset($msg)){?><div class="alert alert-<?php echo $alerttype;?> alert-dismissible fade show" role="alert">
                                                <?php echo $msg; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div><?php } ?>

							<div class="card">
								<div class="card-body">
									<form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
										<div class="row">
											<div class="col-12">
												<h5 class="form-title"><span>Class Information</span></h5>
											</div>
											
											<div class="col-12 col-sm-3">
												<label>Class Group</label>
												<select name="classgroup" class="form-control">
													<option>--Select Class Group--</option>
													<?php
													$sql = "SELECT * FROM classgroup_tbl WHERE status='active' ORDER BY class_group";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														$cg = $row['class_group'];
														$cg_id = $row['cg_id'];
														?>
													<option value="<?php echo $cg_id;?>"><?php echo $cg;?></option>
													<?php }?>
												</select>
											</div>
											<!--
											<label class="col-form-label col-md-2">Default Select</label>
											<div class="col-md-10">
												<select name="classgroup" class="form-control">
													<option>-- Select --</option>
													<option value="JSS1">JSS1</option>
													<option value="JSS2">JSS2</option>
													<option value="JSS3">JSS3</option>
													<option value="SS1">SS1</option>
													<option value="SS1">SS2</option>
													<option value="SS1">SS3</option>
												</select>
											</div>-->

											<div class="col-12 col-sm-3">  
												<div class="form-group">
													<label>Class Arms</label>
													<input name="classname" type="text" class="form-control" required>
												</div>
											</div>
											
											<div class="col-12 col-sm-3">
												<label>Assign Teacher</label>
												<select name="teacher_id" class="form-control" required>
													<option value="">-- Select Teacher --</option>
													<?php
													$sql = "SELECT t_id, teacher_name FROM teacher_tbl ORDER BY teacher_name";
													$result = mysqli_query($conn,$sql);
													while($row = mysqli_fetch_assoc($result)){
														echo '<option value="'.$row['t_id'].'">'.$row['teacher_name'].'</option>';
													}
													?>
												</select>
											</div>

											<div class="col-12">
												<button type="submit" name="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</form>
								</div>
							</div>
							
						</div>					
					</div>					
				</div>
				
			</div>
			<!-- /Page Wrapper -->
			
        </div>
		<!-- /Main Wrapper -->
		
		<!-- jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		
		<!-- Slimscroll JS -->
        <script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>
    </body>


</html>